/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.backup;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class RestorePathDialog
extends GWDialog {
    private JTextField tfFilePath = new OrientableTextField();
    private JPasswordField tfPassword = new JPasswordField();

    public RestorePathDialog(String string) {
        super((JFrame)null, true);
        this.tfPassword.enableInputMethods(true);
        this.setTitle(StringResources.GROUPWISE_RESTORE_PATH);
        this.buildUI();
        this.tfFilePath.setColumns(25);
        this.tfFilePath.setText(string);
        if (GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).isOnlineDataStore()) {
            this.tfPassword.setEnabled(false);
            this.tfPassword.setEditable(false);
        }
    }

    public String getPassword() {
        return new String(this.tfPassword.getPassword());
    }

    public String getFilePath() {
        return this.tfFilePath.getText();
    }

    private void buildUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)new JMnemonicLabel(StringResources.RESTORE_FROM_C, this.tfFilePath), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.tfFilePath, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 0;
        ToolBarButton toolBarButton = new ToolBarButton(new SelectFolderAction());
        GWToolBar gWToolBar = new GWToolBar();
        gWToolBar.add(toolBarButton);
        gWToolBar.setBorder(null);
        jPanel.add((Component)gWToolBar, gridBagConstraints);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)new JMnemonicLabel(StringResources.PASSWORD_C, this.tfPassword), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.tfPassword, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this.buildButtonsPane(), gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private Container buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.add(this.btnOK);
        orientablePanel.add(this.btnCancel);
        return orientablePanel;
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_FOLDER);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OS.isMacOS()) {
                File file;
                boolean bl;
                String string = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(RestorePathDialog.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser gWMacFileChooser = new GWMacFileChooser(frame, string, null, 0);
                gWMacFileChooser.setVisible(true);
                String string2 = gWMacFileChooser.getFile();
                String string3 = gWMacFileChooser.getDirectory();
                if (string2 != null && (bl = (file = new File(string3 + string2)).isDirectory())) {
                    RestorePathDialog.this.tfFilePath.setText(file.getPath());
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                GWFileChooser gWFileChooser = new GWFileChooser(RestorePathDialog.this, StringResources.OPEN, null, 1, 0, false);
                gWFileChooser.setVisible(true);
                String[] stringArray = gWFileChooser.getResult();
                if (stringArray != null) {
                    File file = gWFileChooser.getChooser().getSelectedFile();
                    RestorePathDialog.this.tfFilePath.setText(file.getPath());
                }
            }
        }
    }
}

