/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.datedifference;

import com.appframework.components.DigitDocument;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class DateDifferenceDialog
extends GWDialog
implements DateValueChangeListener {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$datedifference$DateDifferenceDialog == null ? (class$com$novell$gw$jclient$application$dialogs$datedifference$DateDifferenceDialog = DateDifferenceDialog.class$("com.novell.gw.jclient.application.dialogs.datedifference.DateDifferenceDialog")) : class$com$novell$gw$jclient$application$dialogs$datedifference$DateDifferenceDialog));
    private Dimension dimDialogSize = new Dimension(460, 400);
    private JTextField tfDaysDifferent;
    private int daysDifferent = 0;
    private Dimension dimDays = new Dimension(60, 20);
    private MonthlyCalendar startDayCalendar;
    private JTextField tfStartDate;
    private GregorianCalendar gcStartDate;
    private JButton btnStartToday;
    private JButton btnCalculateStart;
    private MonthlyCalendar endDayCalendar;
    private JTextField tfEndDate;
    private GregorianCalendar gcEndDate;
    private JButton btnEndToday;
    private JButton btnCalculateEnd;
    private JButton btnClose;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$datedifference$DateDifferenceDialog;

    public DateDifferenceDialog(JFrame jFrame) {
        super(jFrame);
        this.buildUI();
        this.refreshUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.DATE_DIFFERENCE);
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new GridBagLayout());
        this.btnClose = new OrientableButton(new BtnCloseAction(StringResources.CLOSE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(3));
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.NUMBER_OF_DAYS_DIFFERENT_C);
        orientablePanel.add(orientableLabel);
        this.tfDaysDifferent = new OrientableTextField();
        this.tfDaysDifferent.setDocument(new DigitDocument());
        this.tfDaysDifferent.getDocument().addDocumentListener(new TfDaysDifferent());
        this.tfDaysDifferent.setColumns(2);
        orientablePanel.add(this.tfDaysDifferent);
        orientablePanel.add(new OrientableLabel(StringResources.L_DAY_S));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)orientablePanel, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.buildStartDayPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 1;
        this.getContentPane().add((Component)this.buildEndDayPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.btnClose, gridBagConstraints);
        this.setDefaultButton(this.btnClose);
        this.setCancelButton(this.btnClose);
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private JPanel buildStartDayPanel() {
        this.startDayCalendar = new MonthlyCalendar(GWCalendarUtils.getToday(), true, false);
        this.startDayCalendar.addValueChangeListener(this);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(0);
        orientablePanel.setBorder(BorderFactory.createTitledBorder(border, StringResources.START_DATE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tfStartDate = new OrientableTextField();
        this.tfStartDate.setEditable(false);
        this.gcStartDate = this.startDayCalendar.getDate();
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.tfStartDate, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        orientablePanel.add((Component)this.startDayCalendar, gridBagConstraints);
        this.btnStartToday = new JButton(StringResources.GO_TO_TODAY);
        this.btnStartToday.addActionListener(new BtnStartTodayAction());
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        orientablePanel.add((Component)this.btnStartToday, gridBagConstraints);
        this.btnCalculateStart = new JButton(StringResources.CALCULATE_START_DATE);
        this.btnCalculateStart.addActionListener(new BtnCalculateStart());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        orientablePanel.add((Component)this.btnCalculateStart, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel buildEndDayPanel() {
        this.endDayCalendar = new MonthlyCalendar(GWCalendarUtils.getToday(), true, false);
        this.endDayCalendar.addValueChangeListener(this);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(0);
        orientablePanel.setBorder(BorderFactory.createTitledBorder(border, StringResources.END_DATE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tfEndDate = new OrientableTextField();
        this.tfEndDate.setEditable(false);
        this.gcEndDate = this.endDayCalendar.getDate();
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.tfEndDate, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        orientablePanel.add((Component)this.endDayCalendar, gridBagConstraints);
        this.btnEndToday = new JButton(StringResources.GO_TO_TODAY);
        this.btnEndToday.addActionListener(new BtnEndTodayAction());
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        orientablePanel.add((Component)this.btnEndToday, gridBagConstraints);
        this.btnCalculateEnd = new JButton(StringResources.CALCULATE_END_DATE);
        this.btnCalculateEnd.addActionListener(new BtnCalculateEnd());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        orientablePanel.add((Component)this.btnCalculateEnd, gridBagConstraints);
        return orientablePanel;
    }

    private void refreshUI() {
        this.tfStartDate.setText(GWCalendarUtils.getDateFormat().format(this.gcStartDate.getTime()));
        this.tfEndDate.setText(GWCalendarUtils.getDateFormat().format(this.gcEndDate.getTime()));
        long l = this.gcEndDate.getTimeInMillis() / 86400000L;
        long l2 = this.gcStartDate.getTimeInMillis() / 86400000L;
        this.daysDifferent = (int)Math.abs(l - l2);
        this.tfDaysDifferent.setText(Integer.toString(this.daysDifferent));
    }

    public void valueChanged(DateChangeEvent dateChangeEvent) {
        GregorianCalendar gregorianCalendar = dateChangeEvent.getDate();
        Object object = dateChangeEvent.getSource();
        if (object == this.startDayCalendar) {
            this.gcStartDate.set(1, gregorianCalendar.get(1));
            this.gcStartDate.set(2, gregorianCalendar.get(2));
            this.gcStartDate.set(5, gregorianCalendar.get(5));
        } else {
            this.gcEndDate.set(1, gregorianCalendar.get(1));
            this.gcEndDate.set(2, gregorianCalendar.get(2));
            this.gcEndDate.set(5, gregorianCalendar.get(5));
        }
        this.refreshUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TfDaysDifferent
    implements DocumentListener {
        private TfDaysDifferent() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.parseDoc();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.parseDoc();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.parseDoc();
        }

        private void parseDoc() {
            if (DateDifferenceDialog.this.tfDaysDifferent.getText().length() == 0) {
                DateDifferenceDialog.this.daysDifferent = 0;
                return;
            }
            int n = 0;
            try {
                n = Integer.parseInt(DateDifferenceDialog.this.tfDaysDifferent.getText());
                DateDifferenceDialog.this.daysDifferent = n;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Please, insert an integer value!");
            }
        }
    }

    private class BtnCalculateEnd
    extends AbstractAction {
        private BtnCalculateEnd() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DateDifferenceDialog dateDifferenceDialog = DateDifferenceDialog.this;
            dateDifferenceDialog.gcEndDate = (GregorianCalendar)dateDifferenceDialog.gcStartDate.clone();
            dateDifferenceDialog.gcEndDate.add(5, dateDifferenceDialog.daysDifferent);
            dateDifferenceDialog.endDayCalendar.setDate(dateDifferenceDialog.gcEndDate);
            dateDifferenceDialog.refreshUI();
        }
    }

    private class BtnCalculateStart
    extends AbstractAction {
        private BtnCalculateStart() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DateDifferenceDialog dateDifferenceDialog = DateDifferenceDialog.this;
            dateDifferenceDialog.gcStartDate = (GregorianCalendar)dateDifferenceDialog.gcEndDate.clone();
            dateDifferenceDialog.gcStartDate.add(5, -dateDifferenceDialog.daysDifferent);
            dateDifferenceDialog.startDayCalendar.setDate(dateDifferenceDialog.gcStartDate);
            dateDifferenceDialog.refreshUI();
        }
    }

    private class BtnEndTodayAction
    extends AbstractAction {
        private BtnEndTodayAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DateDifferenceDialog dateDifferenceDialog = DateDifferenceDialog.this;
            dateDifferenceDialog.endDayCalendar.gotoToday();
            dateDifferenceDialog.gcEndDate = dateDifferenceDialog.endDayCalendar.getDate();
            dateDifferenceDialog.refreshUI();
        }
    }

    private class BtnStartTodayAction
    extends AbstractAction {
        private BtnStartTodayAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DateDifferenceDialog dateDifferenceDialog = DateDifferenceDialog.this;
            dateDifferenceDialog.startDayCalendar.gotoToday();
            dateDifferenceDialog.gcStartDate = dateDifferenceDialog.startDayCalendar.getDate();
            dateDifferenceDialog.refreshUI();
        }
    }

    private class BtnCloseAction
    extends AbstractAction {
        public BtnCloseAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DateDifferenceDialog.this.dispose();
        }
    }
}

