/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.error;

import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.dialogs.error.ExErrorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ErrorDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$error$ErrorDialog == null ? (class$com$novell$gw$jclient$application$dialogs$error$ErrorDialog = ErrorDialog.class$("com.novell.gw.jclient.application.dialogs.error.ErrorDialog")) : class$com$novell$gw$jclient$application$dialogs$error$ErrorDialog));
    private static boolean testMode = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$error$ErrorDialog;

    public static void processGWException(GWException gWException) {
        ErrorDialog.processGWException(gWException, null);
    }

    private static Window getTopParentForComponent(Component component) {
        if (component != null) {
            if (component instanceof Dialog || component instanceof Frame) {
                return (Window)component;
            }
            return ErrorDialog.getTopParentForComponent(component.getParent());
        }
        return null;
    }

    public static void processEngineException(EngineException engineException, Component component) {
        if (testMode) {
            return;
        }
        int n = engineException.getErrorCode();
        String string = StringResources.GROUPWISE_ERROR + " [" + Integer.toHexString(engineException.getErrorCode()).toUpperCase() + "]";
        String string2 = EngineException.getErrorString((int)n);
        String string3 = ErrorDialog.getStackTrace(engineException);
        if (string2.equals("")) {
            string2 = StringResources.UNEXPECTED_EXCEPTION;
        }
        Dialog dialog = null;
        if ((component = ErrorDialog.getTopParentForComponent(component)) != null) {
            if (component instanceof Frame) {
                dialog = new ExErrorDialog(string, string2, string3, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Frame)component);
            } else if (component instanceof Dialog) {
                dialog = new ExErrorDialog(string, string2, string3, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Dialog)component);
            }
        }
        if (dialog == null) {
            dialog = new ExErrorDialog(string, string2, string3, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"));
        }
        UIUtils.centerWindow(dialog, component);
        dialog.setVisible(true);
    }

    public static void processGWException(GWException gWException, Component component) {
        if (testMode) {
            return;
        }
        String string = ErrorDialog.getStackTrace(gWException);
        Dialog dialog = null;
        if ((component = ErrorDialog.getTopParentForComponent(component)) != null) {
            if (component instanceof Frame) {
                dialog = new ExErrorDialog(StringResources.ERROR + " ...", gWException.getExplanation(), string, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Frame)component);
            } else if (component instanceof Dialog) {
                dialog = new ExErrorDialog(StringResources.ERROR + " ...", gWException.getExplanation(), string, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Dialog)component);
            }
        }
        if (dialog == null) {
            dialog = new ExErrorDialog(StringResources.ERROR + " ...", gWException.getExplanation(), string, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"));
        }
        UIUtils.centerWindow(dialog, component);
        dialog.setVisible(true);
    }

    public static void processThrowable(Throwable throwable) {
        ErrorDialog.processThrowable(throwable, null);
    }

    public static void processThrowable(Throwable throwable, Component component) {
        if (testMode) {
            return;
        }
        if (throwable instanceof GWException) {
            ErrorDialog.processGWException((GWException)throwable, component);
        } else if (throwable instanceof EngineException) {
            ErrorDialog.processEngineException((EngineException)throwable, component);
        } else {
            String string = ErrorDialog.getStackTrace(throwable);
            Dialog dialog = null;
            if ((component = ErrorDialog.getTopParentForComponent(component)) != null) {
                if (component instanceof Frame) {
                    dialog = new ExErrorDialog(StringResources.ERROR + " ...", StringResources.UNEXPECTED_EXCEPTION, string, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Frame)component);
                } else if (component instanceof Dialog) {
                    dialog = new ExErrorDialog(StringResources.ERROR + " ...", StringResources.UNEXPECTED_EXCEPTION, string, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"), (Dialog)component);
                }
            }
            if (dialog == null) {
                dialog = new ExErrorDialog(StringResources.ERROR + " ...", StringResources.UNEXPECTED_EXCEPTION, string, (Icon)UIManager.getDefaults().get("OptionPane.warningIcon"));
            }
            UIUtils.centerWindow(dialog, component);
            dialog.setVisible(true);
        }
    }

    private static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        String string = new String(byteArrayOutputStream.toByteArray());
        return string;
    }

    public static void setTestMode(boolean bl) {
        testMode = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

