/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.error;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class ExErrorDialog
extends JDialog {
    private final int DEFAULT_WIDTH = 570;
    private final int DETAILS_HEIGHT = 250;
    private final int TOP = 10;
    private final int LEFT = 10;
    private final int RIGHT = 10;
    private final int BOTTOM = 10;
    private final String GO_LEFT = " <<<";
    private final String GO_RIGHT = " >>>";
    private JScrollPane scrollExplanation;
    private JPanel panelMessage;
    Window parentWindow;
    JLabel lbImage = new JLabel();
    JTextArea taMessage = new JTextArea();
    JTextArea taDetails;
    JButton btnDetails;
    JButton btnClose = new JMnemonicButton(new CloseAction());
    String message;
    String explanation;
    Icon icon;
    private boolean detailsVisible;
    private int unexpandedWidth;
    private int unexpandedHeight;
    private int expandedWidth;
    private int expandedHeight;
    private JPanel pnlButtons;

    public ExErrorDialog(String string, String string2, String string3, Icon icon, Dialog dialog) {
        super(dialog);
        this.init(string, string2, string3, icon);
    }

    public ExErrorDialog(String string, String string2, String string3, Icon icon, Frame frame) {
        super(frame);
        this.init(string, string2, string3, icon);
    }

    public ExErrorDialog(String string, String string2, String string3, Icon icon) {
        this.init(string, string2, string3, icon);
    }

    private void init(String string, String string2, String string3, Icon icon) {
        this.setTitle(string);
        this.message = string2;
        this.explanation = string3;
        this.icon = icon;
        this.build();
    }

    private void build() {
        this.lbImage.setIcon(this.icon);
        this.taMessage.setText(this.message);
        this.taMessage.setBorder(null);
        this.taMessage.setBackground(this.getBackground());
        this.taMessage.setAlignmentY(0.0f);
        this.taMessage.setEditable(false);
        this.taMessage.setFocusable(false);
        this.taMessage.setWrapStyleWord(true);
        this.taMessage.setLineWrap(true);
        this.panelMessage = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelMessage.add((Component)this.lbImage, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelMessage.add((Component)this.taMessage, gridBagConstraints);
        if (this.explanation != null && this.explanation.length() > 0) {
            this.btnDetails = new JMnemonicButton(new DetailsAction());
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 17, 10);
        this.pnlButtons = this.createButtonsPanel();
        this.panelMessage.add((Component)this.pnlButtons, gridBagConstraints);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.panelMessage);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ExErrorDialog.this.updateSizes();
            }
        });
        this.pack();
        this.setSize(570, this.getHeight());
        this.updateSizes();
        this.setResizable(false);
        UIUtils.centerWindowOnScreen(this);
    }

    private void updateSizes() {
        if (this.detailsVisible) {
            this.expandedWidth = this.getWidth();
            this.expandedHeight = this.getHeight();
            this.unexpandedWidth = this.expandedWidth;
        } else {
            this.unexpandedHeight = this.getHeight();
            this.expandedWidth = this.unexpandedWidth = this.getWidth();
            this.expandedHeight = this.unexpandedHeight + 250;
        }
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel();
        if (this.btnDetails != null) {
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.btnClose);
            jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
            jPanel.add(this.btnDetails);
            UIUtils.setFocusTraversalKeys(this.btnClose);
            UIUtils.setFocusTraversalKeys(this.btnDetails);
            this.updateHandleButton();
        } else {
            jPanel.add(this.btnClose);
        }
        this.getRootPane().setDefaultButton(this.btnClose);
        return jPanel;
    }

    private void switchDetailsVisibility() {
        if (this.detailsVisible) {
            this.getContentPane().remove(this.getDetailsComponent());
            this.setSize(this.unexpandedWidth, this.unexpandedHeight);
        } else {
            this.getContentPane().add(this.getDetailsComponent());
            this.setSize(this.expandedWidth, this.expandedHeight);
        }
        this.detailsVisible = !this.detailsVisible;
        this.updateHandleButton();
    }

    private Component getDetailsComponent() {
        if (this.taDetails == null) {
            this.taDetails = new JTextArea();
            this.taDetails.setText(this.explanation);
            this.taDetails.setEditable(false);
            this.taDetails.setBackground(this.getBackground());
            this.scrollExplanation = new OrientableScrollPane(this.taDetails);
            Border border = BorderFactory.createEmptyBorder(0, 10, 10, 10);
            Border border2 = BorderFactory.createLineBorder(Color.GRAY);
            this.scrollExplanation.setBorder(BorderFactory.createCompoundBorder(border, border2));
        }
        return this.scrollExplanation;
    }

    private void updateHandleButton() {
        this.btnDetails.setText(this.detailsVisible ? StringResources.DETAILS + " <<<" : StringResources.DETAILS + " >>>");
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExErrorDialog.this.dispose();
        }
    }

    private class DetailsAction
    extends AbstractAction {
        public DetailsAction() {
            super(StringResources.ACTION_DETAILS);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExErrorDialog.this.switchDetailsVisibility();
        }
    }
}

