/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ColumnsDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$folderproperties$ColumnsDialog == null ? (class$com$novell$gw$jclient$application$dialogs$folderproperties$ColumnsDialog = ColumnsDialog.class$("com.novell.gw.jclient.application.dialogs.folderproperties.ColumnsDialog")) : class$com$novell$gw$jclient$application$dialogs$folderproperties$ColumnsDialog));
    private JList listAvail = new OrientableList();
    private JList listCurrent = new OrientableList();
    private JMnemonicButton buttonAdd;
    private JMnemonicButton buttonRemove;
    private JMnemonicButton buttonUp;
    private JMnemonicButton buttonDown;
    private JButton btnSuperSmaller;
    private JButton btnSmaller;
    private JButton btnLarger;
    private JButton btnSuperLarger;
    private JLabel testColumn;
    private JPanel columnPanel;
    private ColumnInfos selectedInfos;
    private ColumnInfos availableInfos;
    private static final int MINIMUN_COLUMN_SIZE = 20;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$folderproperties$ColumnsDialog;

    public ColumnsDialog(JDialog jDialog, ColumnInfos columnInfos, ColumnInfos columnInfos2) {
        super(jDialog);
        this.init(columnInfos, columnInfos2);
    }

    public ColumnsDialog(JFrame jFrame, ColumnInfos columnInfos, ColumnInfos columnInfos2) {
        super(jFrame);
        this.init(columnInfos, columnInfos2);
    }

    private void init(ColumnInfos columnInfos, ColumnInfos columnInfos2) {
        if (columnInfos == null || columnInfos2 == null) {
            throw new IllegalArgumentException("Input parameter can not be NULL");
        }
        this.selectedInfos = columnInfos;
        this.availableInfos = columnInfos2;
        this.buildUI();
        this.pack();
        this.setModal(true);
    }

    private void buildUI() {
        this.setTitle(StringResources.SELECT_COLUMNS);
        this.initModels();
        this.buttonAdd = new JMnemonicButton(StringResources.ADD);
        this.buttonRemove = new JMnemonicButton(StringResources.REMOVE);
        this.buttonUp = new JMnemonicButton(StringResources.UP);
        this.buttonDown = new JMnemonicButton(StringResources.DOWN);
        this.btnSuperSmaller = new OrientableButton(StringResources.LL);
        this.btnSmaller = new OrientableButton(StringResources.L_SMALLER);
        this.btnLarger = new OrientableButton(StringResources.LARGER_R);
        this.btnSuperLarger = new OrientableButton(StringResources.RR);
        PositionListener positionListener = new PositionListener();
        this.buttonAdd.addActionListener(positionListener);
        this.buttonRemove.addActionListener(positionListener);
        this.buttonUp.addActionListener(positionListener);
        this.buttonDown.addActionListener(positionListener);
        WidthListener widthListener = new WidthListener();
        this.btnSuperSmaller.addActionListener(widthListener);
        this.btnSmaller.addActionListener(widthListener);
        this.btnLarger.addActionListener(widthListener);
        this.btnSuperLarger.addActionListener(widthListener);
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            this.btnSuperSmaller.setText(StringResources.RR);
            this.btnSuperLarger.setText(StringResources.LL);
        }
        this.listAvail.setSelectionMode(0);
        this.listCurrent.setSelectionMode(0);
        this.listAvail.addListSelectionListener(new ListSelectionListenerImpl());
        this.listCurrent.addListSelectionListener(new ListSelectionListenerImpl());
        this.listAvail.addMouseListener(new AddItemListener());
        this.listCurrent.addMouseListener(new RemoveItemListener());
        this.columnPanel = new OrientablePanel();
        this.testColumn = new OrientableLabel();
        this.testColumn.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnPanel.add(this.testColumn);
        this.changeAvailListButtons();
        this.changeCurrentListButtons();
        this.initSelection(this.listAvail);
        this.initSelection(this.listCurrent);
        GridBagLayout gridBagLayout = new GridBagLayout();
        OrientablePanel orientablePanel = new OrientablePanel(gridBagLayout);
        orientablePanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 100.0;
        JMnemonicLabel jMnemonicLabel = new JMnemonicLabel(StringResources.AVAILABLE_COLUMNS_C, this.listAvail);
        orientablePanel.add((Component)jMnemonicLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        JMnemonicLabel jMnemonicLabel2 = new JMnemonicLabel(StringResources.SELECTED_COLUMNS_C, this.listCurrent);
        orientablePanel.add((Component)jMnemonicLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.listAvail, 22, 32);
        orientableScrollPane.setPreferredSize(new Dimension(150, orientableScrollPane.getPreferredSize().height));
        orientablePanel.add((Component)orientableScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridheight = 1;
        OrientableScrollPane orientableScrollPane2 = new OrientableScrollPane(this.listCurrent, 22, 32);
        orientableScrollPane2.setPreferredSize(new Dimension(150, orientableScrollPane2.getPreferredSize().height));
        orientablePanel.add((Component)orientableScrollPane2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        OrientablePanel orientablePanel2 = new OrientablePanel(gridBagLayout);
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        orientablePanel2.add((Component)this.buttonAdd, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        orientablePanel2.add((Component)this.buttonRemove, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        OrientablePanel orientablePanel3 = new OrientablePanel(new GridLayout(1, 2, 5, 0));
        orientablePanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.COLUMN_POSITION), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        orientablePanel.add((Component)orientablePanel3, gridBagConstraints);
        orientablePanel3.add(this.buttonUp);
        orientablePanel3.add(this.buttonDown);
        OrientablePanel orientablePanel4 = new OrientablePanel(new BorderLayout());
        orientablePanel4.setBorder(BorderFactory.createTitledBorder(StringResources.COLUMN_WIDTH));
        OrientablePanel orientablePanel5 = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        orientablePanel5.add((Component)this.btnSuperSmaller, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        orientablePanel5.add((Component)this.btnSmaller, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        orientablePanel5.add((Component)this.btnLarger, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        orientablePanel5.add((Component)this.btnSuperLarger, gridBagConstraints2);
        orientablePanel4.add((Component)orientablePanel5, "North");
        orientablePanel4.add((Component)this.columnPanel, "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        orientablePanel.add((Component)orientablePanel4, gridBagConstraints);
        this.panCenterPanel.add((Component)orientablePanel, "Center");
        this.panCenterPanel.add((Component)this.buildButtonsPane(), "After");
        this.setDefaultButton(this.btnOK);
    }

    private ColumnInfo getSelectedColumnInfo() {
        if (this.listCurrent.getModel().getSize() > 0) {
            return (ColumnInfo)this.listCurrent.getSelectedValue();
        }
        return null;
    }

    private void updateTestColumn() {
        String string = "";
        int n = 0;
        ColumnInfo columnInfo = this.getSelectedColumnInfo();
        if (columnInfo != null) {
            string = columnInfo.getName();
            n = columnInfo.getWidth();
        }
        Dimension dimension = new Dimension(n, PLAFChanger.getFontSize() + 8);
        this.testColumn.setText(string);
        this.testColumn.setPreferredSize(dimension);
    }

    private JPanel buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(orientablePanel);
        gridBagAdapter.setColumnCount(1);
        this.btnOK = new OrientableButton(new OkAction());
        gridBagAdapter.addComponent(this.btnOK);
        gridBagAdapter.addComponent(this.btnCancel);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)orientablePanel, "North");
        return orientablePanel2;
    }

    private void initModels() {
        this.listAvail.setModel(new ColumnListModel(this.availableInfos));
        this.listCurrent.setModel(new ColumnListModel(this.selectedInfos));
    }

    private void initSelection(JList jList) {
        if (jList.getModel().getSize() > 0) {
            jList.setSelectedIndex(0);
        }
    }

    private void setSelectedIndex(JList jList, int n) {
        if (n >= 0) {
            if (n < jList.getModel().getSize()) {
                jList.setSelectedIndex(n);
            } else {
                this.setSelectedIndex(jList, --n);
            }
        }
    }

    private void changeAvailListButtons() {
        boolean bl = this.listAvail.getModel().getSize() > 0 && this.listAvail.getSelectedIndex() >= 0;
        this.buttonAdd.setEnabled(bl);
    }

    private void changeCurrentListButtons() {
        int n = this.listCurrent.getSelectedIndex();
        int n2 = this.listCurrent.getModel().getSize();
        this.buttonUp.setEnabled(n > 0 && n2 > 1);
        this.buttonDown.setEnabled(n >= 0 && n2 > 1 && n < n2 - 1);
        this.buttonRemove.setEnabled(n >= 0 && n2 > 1);
        boolean bl = n >= 0 && n2 > 0;
        this.btnSuperSmaller.setEnabled(bl);
        this.btnSmaller.setEnabled(bl);
        this.btnSuperLarger.setEnabled(bl);
        this.btnLarger.setEnabled(bl);
    }

    private void moveItem(boolean bl) {
        int n = this.listCurrent.getSelectedIndex();
        ColumnInfo columnInfo = (ColumnInfo)this.listCurrent.getModel().getElementAt(n);
        ((ColumnListModel)this.listCurrent.getModel()).removeElementAt(n);
        ((ColumnListModel)this.listCurrent.getModel()).insertElementAt(columnInfo, bl ? --n : ++n);
        this.setSelectedIndex(this.listCurrent, n);
    }

    private void addItem() {
        int n = this.listAvail.getSelectedIndex();
        int n2 = this.listCurrent.getSelectedIndex();
        boolean bl = false;
        if (n2 < 0) {
            n2 = 0;
            bl = true;
        }
        ColumnInfo columnInfo = (ColumnInfo)this.listAvail.getModel().getElementAt(n);
        ((ColumnListModel)this.listCurrent.getModel()).addElement(columnInfo);
        if (columnInfo != null) {
            ((ColumnListModel)this.listAvail.getModel()).removeElementAt(n);
        }
        this.setSelectedIndex(this.listAvail, n);
        if (bl) {
            this.setSelectedIndex(this.listCurrent, 0);
        }
    }

    private void removeItem() {
        ColumnInfo columnInfo;
        int n = this.listCurrent.getSelectedIndex();
        int n2 = this.listAvail.getSelectedIndex();
        boolean bl = false;
        if (n2 < 0) {
            n2 = 0;
            bl = true;
        }
        if ((columnInfo = (ColumnInfo)this.listCurrent.getModel().getElementAt(n)) != null) {
            ((ColumnListModel)this.listAvail.getModel()).insertElementAt(columnInfo, n2);
        }
        ((ColumnListModel)this.listCurrent.getModel()).removeElementAt(n);
        this.setSelectedIndex(this.listCurrent, n);
        if (bl) {
            this.setSelectedIndex(this.listAvail, 0);
        }
    }

    private void moveItemUp() {
        this.moveItem(true);
    }

    private void moveItemDown() {
        this.moveItem(false);
    }

    private void changeWidth(int n) {
        int n2 = this.testColumn.getHeight();
        int n3 = this.testColumn.getWidth();
        int n4 = n3 + n;
        if (n4 < 20 && n < 0) {
            n4 = 20;
        } else if (n4 >= this.columnPanel.getWidth() - 10) {
            n4 = this.columnPanel.getWidth() - 10;
        }
        this.testColumn.setMaximumSize(new Dimension(n4, n2));
        this.testColumn.setMinimumSize(new Dimension(n4, n2));
        this.testColumn.setPreferredSize(new Dimension(n4, n2));
        this.columnPanel.updateUI();
        ColumnInfo columnInfo = this.getSelectedColumnInfo();
        if (columnInfo != null) {
            columnInfo.setWidth(n4);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class WidthListener
    implements ActionListener {
        private WidthListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (ColumnsDialog.this.btnSuperSmaller.equals(object)) {
                ColumnsDialog.this.changeWidth(-20);
            } else if (ColumnsDialog.this.btnSmaller.equals(object)) {
                ColumnsDialog.this.changeWidth(-5);
            } else if (ColumnsDialog.this.btnLarger.equals(object)) {
                ColumnsDialog.this.changeWidth(5);
            } else if (ColumnsDialog.this.btnSuperLarger.equals(object)) {
                ColumnsDialog.this.changeWidth(20);
            }
        }
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object = listSelectionEvent.getSource();
            if (ColumnsDialog.this.listAvail.equals(object)) {
                ColumnsDialog.this.changeAvailListButtons();
            } else if (ColumnsDialog.this.listCurrent.equals(object)) {
                ColumnsDialog.this.changeCurrentListButtons();
                ColumnsDialog.this.updateTestColumn();
            }
        }
    }

    private class PositionListener
    implements ActionListener {
        private PositionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (ColumnsDialog.this.buttonAdd.equals(object)) {
                ColumnsDialog.this.addItem();
            } else if (ColumnsDialog.this.buttonRemove.equals(object)) {
                ColumnsDialog.this.removeItem();
            } else if (ColumnsDialog.this.buttonUp.equals(object)) {
                ColumnsDialog.this.moveItemUp();
            } else if (ColumnsDialog.this.buttonDown.equals(object)) {
                ColumnsDialog.this.moveItemDown();
            }
            ColumnsDialog.this.changeAvailListButtons();
            ColumnsDialog.this.changeCurrentListButtons();
            ColumnsDialog.this.updateTestColumn();
        }
    }

    private class RemoveItemListener
    extends MouseAdapter {
        private RemoveItemListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                ColumnsDialog.this.removeItem();
            }
        }
    }

    private class AddItemListener
    extends MouseAdapter {
        private AddItemListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                ColumnsDialog.this.addItem();
            }
        }
    }

    private class ColumnListModel
    extends AbstractListModel {
        private ColumnInfos columnInfos;

        public ColumnListModel(ColumnInfos columnInfos) {
            this.columnInfos = columnInfos;
        }

        public int getSize() {
            return this.columnInfos.size();
        }

        public Object getElementAt(int n) {
            return this.columnInfos.get(n);
        }

        public void insertElementAt(Object object, int n) {
            this.columnInfos.add(n, (ColumnInfo)object);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void removeElementAt(int n) {
            this.columnInfos.remove(n);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void addElement(Object object) {
            this.columnInfos.add((ColumnInfo)object);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void removeElement(Object object) {
            this.columnInfos.remove((ColumnInfo)object);
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsDialog.this.setActionCompleteSuccessfully(true);
            GWDialog.disposeDialog(ColumnsDialog.this);
        }
    }
}

