/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.appframework.utils.OS;
import com.novell.gw.engine.JunkMailList;
import com.novell.gw.jclient.application.OrientableTable;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.dialogs.junkmail.AddNewEntryDialog;
import com.novell.gw.jclient.application.dialogs.junkmail.HTMLLabel;
import com.novell.gw.jclient.application.dialogs.junkmail.JunkTableModel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

abstract class AddressesListPane
extends OrientablePanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$junkmail$AddressesListPane == null ? (class$com$novell$gw$jclient$application$dialogs$junkmail$AddressesListPane = AddressesListPane.class$("com.novell.gw.jclient.application.dialogs.junkmail.AddressesListPane")) : class$com$novell$gw$jclient$application$dialogs$junkmail$AddressesListPane));
    private JCheckBox cbAddresses = new OrientableCheckBox(StringResources.ADDRESSES);
    private JCheckBox cbDomains = new OrientableCheckBox(StringResources.DOMAINS);
    private JButton btnNew;
    private JButton btnEdit;
    private JButton btnDelete;
    private JButton btnTop;
    private JButton btnBottom;
    private JTable tableEntries;
    private JunkTableModel model;
    private JLabel lbCount = new OrientableLabel("0");
    private JunkMailList junkMailList;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$junkmail$AddressesListPane;
    static /* synthetic */ Class class$java$lang$Object;

    public AddressesListPane(JunkMailList junkMailList) {
        this.junkMailList = junkMailList;
        this.model = new JunkTableModel(this.junkMailList);
        this.buildUI();
        this.updateCount();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                AddressesListPane.this.updateAll();
            }
        });
    }

    private void buildUI() {
        this.setBorder(new EmptyBorder(5, 10, 10, 10));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddressesListPane.this.applyFilter();
            }
        };
        this.cbAddresses.addActionListener(actionListener);
        this.cbDomains.addActionListener(actionListener);
        this.cbAddresses.setSelected(true);
        this.cbDomains.setSelected(true);
        this.btnNew = new JButton(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddressesListPane.this.addNewEntry();
            }
        });
        this.btnEdit = new JButton(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddressesListPane.this.editSelectedEntry();
            }
        });
        this.btnDelete = new JButton(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddressesListPane.this.deleteEntry();
            }
        });
        this.btnNew.setText(StringResources.NEW_D);
        this.btnEdit.setText(StringResources.EDIT_D);
        this.btnDelete.setText(StringResources.DELETE);
        if (!OS.isMacOS()) {
            this.btnNew.setMnemonic(StringResources.getMnemonic(StringResources.NEW_D));
            this.btnEdit.setMnemonic(StringResources.getMnemonic(StringResources.EDIT_D));
            this.btnDelete.setMnemonic(StringResources.getMnemonic(StringResources.DELETE));
        }
        this.btnTop = new JButton(this.createTopMoveAction());
        this.btnBottom = new JButton(this.createBottomMoveAction());
        this.btnEdit.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnTop.setEnabled(false);
        this.btnBottom.setEnabled(false);
        this.createTable();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 7;
        this.add((Component)new OrientableLabel(StringResources.SHOW_C), gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.createChecksPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.btnNew, gridBagConstraints);
        this.add((Component)this.btnEdit, gridBagConstraints);
        this.add((Component)this.btnDelete, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.createMoveButtonsPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.tableEntries);
        orientableScrollPane.getViewport().setBackground(Color.WHITE);
        this.add((Component)orientableScrollPane, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.createStatusPanel(), gridBagConstraints);
    }

    private void createTable() {
        Object object;
        this.tableEntries = new OrientableTable(this.model);
        this.tableEntries.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = AddressesListPane.class$("java.lang.Object")) : class$java$lang$Object, new OrientableTableCellRenderer());
        this.tableEntries.setSelectionMode(0);
        this.tableEntries.setShowGrid(false);
        JTableHeader jTableHeader = this.tableEntries.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.tableEntries.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = AddressesListPane.this.tableEntries.getSelectedRow() > -1;
                AddressesListPane.this.btnEdit.setEnabled(bl);
                AddressesListPane.this.btnDelete.setEnabled(bl);
                AddressesListPane.this.btnTop.setEnabled(bl);
                AddressesListPane.this.btnBottom.setEnabled(bl);
            }
        });
        if (OS.isMacOS()) {
            object = new Dimension(20, PLAFChanger.getFontSize() + 10);
            jTableHeader.setSize((Dimension)object);
            jTableHeader.setPreferredSize((Dimension)object);
            jTableHeader.setMinimumSize((Dimension)object);
        }
        jTableHeader.getColumnModel().getColumn(0).setCellRenderer(new IconRenderer());
        object = this.tableEntries.getColumnModel();
        TableColumn tableColumn = object.getColumn(0);
        tableColumn.setMaxWidth(22);
        tableColumn.setMinWidth(22);
        tableColumn.setResizable(false);
        tableColumn = object.getColumn(3);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(50);
        this.tableEntries.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    AddressesListPane.this.editSelectedEntry();
                }
            }
        });
    }

    private JPanel createChecksPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridLayout(-1, 1, 0, 0));
        orientablePanel.add(this.cbAddresses);
        orientablePanel.add(this.cbDomains);
        return orientablePanel;
    }

    private JPanel createMoveButtonsPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        orientablePanel.add((Component)this.btnTop, gridBagConstraints);
        orientablePanel.add((Component)this.btnBottom, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel createStatusPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        orientablePanel.add(new OrientableLabel(StringResources.TOTAL));
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        orientablePanel.add((Component)this.lbCount, gridBagConstraints);
        OrientablePanel orientablePanel2 = new OrientablePanel();
        orientablePanel2.setBorder(BorderFactory.createEtchedBorder());
        Dimension dimension = new Dimension(2, 40);
        orientablePanel2.setPreferredSize(dimension);
        orientablePanel2.setMinimumSize(dimension);
        orientablePanel2.setMaximumSize(dimension);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.weighty = 1.0;
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        orientablePanel.add((Component)new HTMLLabel(this.getPaneComment()), gridBagConstraints);
        return orientablePanel;
    }

    private void addNewEntry() {
        int n;
        String string = AddNewEntryDialog.show(this, "");
        if (string != null && (n = this.junkMailList.addItem(string)) > 0) {
            this.updateAll();
        }
    }

    private void editSelectedEntry() {
        int n = this.tableEntries.getSelectedRow();
        String string = this.junkMailList.getItemAddress(n);
        String string2 = AddNewEntryDialog.show(this, string);
        if (string2 != null) {
            boolean bl = this.junkMailList.deleteItem(n);
            this.junkMailList.addItem(string2);
            this.tableEntries.invalidate();
        }
    }

    private void deleteEntry() {
        this.junkMailList.deleteItem(this.tableEntries.getSelectedRow());
        this.updateAll();
    }

    private void applyFilter() {
        int n = 0;
        if (this.cbAddresses.isSelected() && this.cbDomains.isSelected()) {
            n = 3;
        } else if (this.cbDomains.isSelected()) {
            n = 2;
        } else if (this.cbAddresses.isSelected()) {
            n = 1;
        }
        this.junkMailList.setAddressTypeFilter(n);
        this.updateAll();
    }

    public void updateAll() {
        int n = this.tableEntries.getSelectedRow();
        this.model.fireTableDataChanged();
        this.updateCount();
        if (n != -1) {
            this.selectNearestRow(n);
        }
    }

    private void selectNearestRow(int n) {
        if (n >= this.junkMailList.getSize()) {
            --n;
        }
        if (n >= 0) {
            this.tableEntries.setRowSelectionInterval(n, n);
        }
    }

    private void updateCount() {
        this.lbCount.setText(String.valueOf(this.tableEntries.getRowCount()));
    }

    protected abstract AbstractAction createTopMoveAction();

    protected abstract AbstractAction createBottomMoveAction();

    protected abstract String getPaneComment();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class IconRenderer
    extends OrientableLabel
    implements TableCellRenderer {
        public IconRenderer() {
            this.setBorder(new EmptyBorder(0, 5, 0, 3));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Icon) {
                this.setIcon((Icon)object);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    protected final class MoveToTrustAction
    extends MoveEntryAction {
        public MoveToTrustAction() {
            super(1, StringResources.MOVE_TO_TRUST);
        }
    }

    protected final class MoveToBlockAction
    extends MoveEntryAction {
        public MoveToBlockAction() {
            super(2, StringResources.MOVE_TO_BLOCK);
        }
    }

    protected final class MoveToJunkAction
    extends MoveEntryAction {
        public MoveToJunkAction() {
            super(3, StringResources.MOVE_TO_JUNK);
        }
    }

    private abstract class MoveEntryAction
    extends AbstractAction {
        private int type;

        public MoveEntryAction(int n, String string) {
            super(string);
            this.type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = AddressesListPane.this.tableEntries.getSelectedRow();
            AddressesListPane.this.junkMailList.moveItem(n, this.type);
            AddressesListPane.this.updateAll();
        }
    }
}

