/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.newfolder;

import com.appframework.components.EmptyStringDocumentListener;
import com.appframework.components.GWTextArea;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePaneController;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.NormalFolder;
import com.novell.gw.jclient.bl.om.folders.SharedFolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;

class FolderNamePane
extends OrientablePanel
implements MVCView {
    private JTextComponent tfName = new OrientableTextField();
    private JTextComponent taDescription = new GWTextArea(3, 1);
    private PlainFoldersTree foldersTree;
    private AbstractFolder parentFolder;
    private AbstractFolder newFolder;
    private AbstractAction actionUp = new MoveUPFolderAction();
    private AbstractAction actionDown = new MoveDownFolderAction();
    private AbstractAction actionRight = new MoveRightFolderAction();
    private AbstractAction actionLeft = new MoveLeftFolderAction();
    private MVCController controller;
    private boolean wasShown = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$folders$CabinetFolder;

    public FolderNamePane(MVCController mVCController, AbstractFolder abstractFolder, AbstractButton abstractButton) {
        this.controller = new FolderNamePaneController(this, mVCController);
        this.parentFolder = abstractFolder;
        this.tfName.getDocument().addDocumentListener(new EmptyStringDocumentListener(abstractButton));
        this.tfName.setText(StringResources.NEW_FOLDER);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tfName.getDocument().addDocumentListener(new FNDocumentListener());
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                FolderNamePane.this.tfName.requestFocus();
                FolderNamePane.this.tfName.selectAll();
                if (!FolderNamePane.this.wasShown) {
                    FolderNamePane.this.foldersTree.scrollFolderToBottom(FolderNamePane.this.newFolder);
                    FolderNamePane.this.wasShown = true;
                }
            }
        });
    }

    private void buildUI() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)new JLabel(StringResources.NAME_THE_NEW_FOLDER), gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel(StringResources.NAME_C), gridBagConstraints);
        this.tfName.selectAll();
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel(StringResources.DESCRIPTION_C), gridBagConstraints);
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = 25;
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taDescription);
        orientableScrollPane.setVerticalScrollBarPolicy(22);
        ++gridBagConstraints.gridy;
        this.add((Component)orientableScrollPane, gridBagConstraints);
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel(StringResources.POSITION_C), gridBagConstraints);
        String string = ControlsUtils.getUserGuid(this.controller);
        this.foldersTree = new PlainFoldersTree(this.controller, string);
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        ++gridBagConstraints.gridy;
        OrientableScrollPane orientableScrollPane2 = new OrientableScrollPane(this.foldersTree);
        orientableScrollPane2.setPreferredSize(new Dimension(300, 150));
        this.add((Component)orientableScrollPane2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.buildButtonsPane(), gridBagConstraints);
        if (!this.parentFolder.canHaveChildren() || this.parentFolder.isCalendarFolder()) {
            this.parentFolder = FoldersCache.getFolder(class$com$novell$gw$jclient$bl$om$folders$CabinetFolder == null ? (class$com$novell$gw$jclient$bl$om$folders$CabinetFolder = FolderNamePane.class$("com.novell.gw.jclient.bl.om.folders.CabinetFolder")) : class$com$novell$gw$jclient$bl$om$folders$CabinetFolder, string);
        }
    }

    public void setController(MVCController mVCController) {
    }

    public MVCController getController() {
        return null;
    }

    public void setMVCModel(Object object) {
        this.addNewFolder((Boolean)object);
    }

    public Object getMVCModel() {
        return null;
    }

    private void addNewFolder(boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.foldersTree.getFolderNode(this.parentFolder);
        this.newFolder = bl ? new SharedFolder() : new NormalFolder();
        this.newFolder.setName(this.tfName.getText());
        this.newFolder.setExist(false);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.foldersTree.getFolderNode(this.newFolder);
        if (defaultMutableTreeNode2 != null) {
            defaultMutableTreeNode2.removeFromParent();
        }
        defaultMutableTreeNode.insert(new DefaultMutableTreeNode(this.newFolder), 0);
        this.foldersTree.updateFolderNode(defaultMutableTreeNode, this.newFolder);
        this.enableActions(this.newFolder);
        this.foldersTree.scrollFolderToBottom(this.newFolder);
    }

    private JPanel buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new BoxLayout(orientablePanel, 1));
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridLayout(-1, 1, 0, 5));
        OrientablePanel orientablePanel3 = new OrientablePanel(new GridLayout(-1, 1, 0, 5));
        orientablePanel2.add(new JMnemonicButton(this.actionUp));
        orientablePanel2.add(new JMnemonicButton(this.actionDown));
        orientablePanel3.add(new JMnemonicButton(this.actionLeft));
        orientablePanel3.add(new JMnemonicButton(this.actionRight));
        orientablePanel3.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        orientablePanel.add(orientablePanel2);
        orientablePanel.add(orientablePanel3);
        return orientablePanel;
    }

    private void enableActions(AbstractFolder abstractFolder) {
        this.foldersTree.enableActions(abstractFolder, this.actionUp, this.actionDown, this.actionRight, this.actionLeft);
    }

    public String getFolderName() {
        return this.tfName.getText();
    }

    public String getFolderDescription() {
        return this.taDescription.getText();
    }

    public AbstractFolder getParentFolder() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.foldersTree.getFolderNode(this.newFolder);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        return (AbstractFolder)defaultMutableTreeNode2.getUserObject();
    }

    public int getFolderPosition() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.foldersTree.getFolderNode(this.newFolder);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        return defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FNDocumentListener
    implements DocumentListener {
        private FNDocumentListener() {
        }

        private void updateFolderName() {
            FolderNamePane.this.newFolder.setName(FolderNamePane.this.tfName.getText());
            FolderNamePane.this.foldersTree.updateUI();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateFolderName();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateFolderName();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateFolderName();
        }
    }

    private class MoveRightFolderAction
    extends AbstractAction {
        public MoveRightFolderAction() {
            super(StringResources.RIGHT);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FolderNamePane.this.foldersTree.moveRightFolder(FolderNamePane.this.newFolder);
            FolderNamePane.this.enableActions(FolderNamePane.this.newFolder);
        }
    }

    private class MoveLeftFolderAction
    extends AbstractAction {
        public MoveLeftFolderAction() {
            super(StringResources.LEFT);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FolderNamePane.this.foldersTree.moveLeftFolder(FolderNamePane.this.newFolder);
            FolderNamePane.this.enableActions(FolderNamePane.this.newFolder);
        }
    }

    private class MoveDownFolderAction
    extends AbstractAction {
        public MoveDownFolderAction() {
            super(StringResources.DOWN);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FolderNamePane.this.foldersTree.moveDownFolder(FolderNamePane.this.newFolder);
            FolderNamePane.this.enableActions(FolderNamePane.this.newFolder);
        }
    }

    private class MoveUPFolderAction
    extends AbstractAction {
        public MoveUPFolderAction() {
            super(StringResources.UP);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FolderNamePane.this.foldersTree.moveUpFolder(FolderNamePane.this.newFolder);
            FolderNamePane.this.enableActions(FolderNamePane.this.newFolder);
        }
    }
}

