/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.proxy;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.ab.Address;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelector;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorCloseListener;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.proxy.ProxyDialogController;
import com.novell.gw.jclient.application.dialogs.proxy.UserListTableModel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ProxyDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$proxy$ProxyDialog == null ? (class$com$novell$gw$jclient$application$dialogs$proxy$ProxyDialog = ProxyDialog.class$("com.novell.gw.jclient.application.dialogs.proxy.ProxyDialog")) : class$com$novell$gw$jclient$application$dialogs$proxy$ProxyDialog));
    private JButton btnOk = new JMnemonicButton(new OkAction());
    private JButton btnRemove = new JMnemonicButton(new RemoveAction());
    private AddressSelector stfUser;
    private JLabel lbUserName = new JLabel(StringResources.USER_NAME_C);
    private UserListTableModel model = new UserListTableModel();
    private JTable tableUsers = new ExtendedGWTable(this.model);
    private boolean selectCausedByRemove = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$proxy$ProxyDialog;

    public ProxyDialog(ApplicationFrame applicationFrame) {
        super(applicationFrame, true);
        this.setController(new ProxyDialogController(this, applicationFrame.getController()));
        this.stfUser = new AddressSelector(null, this.getController());
        this.stfUser.setAddressSelectorCloseListener(new AddressSelectorCloseListener(){

            public void contactSelected(Contact contact) {
                boolean bl = contact.getUserName().equals(EngineCommandManager.getUserInfo().getID());
                ProxyHistoryEntry proxyHistoryEntry = new ProxyHistoryEntry((Addressable)contact);
                ProxyDialog.this.performProxy(proxyHistoryEntry, bl);
            }
        });
        this.setTitle(StringResources.PROXY);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.buildUI();
    }

    private void buildUI() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(orientablePanel);
        gridBagAdapter.setColumnCount(3);
        gridBagAdapter.setResizableColumn(0);
        gridBagAdapter.setGridWidth(3);
        gridBagAdapter.setInsets(new Insets(0, 5, 5, 5));
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.setFill(0);
        gridBagAdapter.addComponent(this.lbUserName);
        gridBagAdapter.setGridWidth(3);
        gridBagAdapter.addComponent(this.stfUser);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)new OrientableLabel(StringResources.USERS_LIST_C), "North");
        ColoredScrollPane coloredScrollPane = new ColoredScrollPane(this.tableUsers);
        coloredScrollPane.setPreferredSize(new Dimension(350, 150));
        orientablePanel2.add((Component)coloredScrollPane, "Center");
        gridBagAdapter.setGridWidth(3);
        gridBagAdapter.setWidthY(100);
        gridBagAdapter.setInsets(new Insets(0, 5, 5, 5));
        gridBagAdapter.addComponent(orientablePanel2);
        this.panCenterPanel.add((Component)orientablePanel, "Center");
        this.panCenterPanel.add((Component)this.buildButtonsPane(), "After");
        this.tableUsers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProxyDialog.this.processItemSelection();
            }
        });
        if (this.tableUsers.getRowCount() > 0) {
            this.tableUsers.setRowSelectionInterval(0, 0);
        }
        this.tableUsers.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (keyEvent.getKeyCode() == n) {
                    ProxyDialog.this.btnRemove.getAction().actionPerformed(null);
                } else if (keyEvent.getKeyCode() == 10) {
                    ProxyDialog.this.btnOk.getAction().actionPerformed(null);
                }
            }
        });
        this.tableUsers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    int n = ProxyDialog.this.tableUsers.getSelectedRow();
                    if (ProxyDialog.this.performProxy(ProxyDialog.this.model.getEntryAt(n), n == 0)) {
                        GWDialog.disposeDialog(ProxyDialog.this);
                    }
                }
            }
        });
    }

    private void processItemSelection() {
        int n = this.tableUsers.getSelectedRow();
        if (n != -1) {
            this.btnRemove.setEnabled(n != 0);
            if (this.selectCausedByRemove) {
                this.selectCausedByRemove = false;
                this.stfUser.setText("");
            } else {
                this.stfUser.setText(this.model.getEntryAt(n).getDisplayName());
            }
        }
    }

    private JPanel buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(orientablePanel);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.addComponent(this.btnOk);
        gridBagAdapter.addComponent(this.btnCancel);
        gridBagAdapter.addComponent(this.btnRemove);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)orientablePanel, "North");
        return orientablePanel2;
    }

    private void saveChanges() {
        this.model.saveChanges();
    }

    private boolean performProxy(ProxyHistoryEntry proxyHistoryEntry, boolean bl) {
        if (bl) {
            this.getController().getActionList().performAction("Show User Store");
            this.saveChanges();
        } else {
            try {
                String string = ControlsUtils.getUserGuid(this.controller);
                String string2 = GWCommandManager.getInstance(string).performProxy(proxyHistoryEntry);
                this.model.addEntry(proxyHistoryEntry);
                this.saveChanges();
                this.getController().processCommand(new Command(750, string2));
                this.getController().getActionList().performAction("Refresh");
            }
            catch (EngineException engineException) {
                JOptionPane.showMessageDialog(this, EngineException.getErrorString((int)engineException.getErrorCode()), StringResources.NOVELL_GROUPWISE, 2);
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(StringResources.REMOVE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProxyDialog.this.selectCausedByRemove = true;
            int n = ProxyDialog.this.tableUsers.getSelectedRow();
            ProxyDialog.this.model.removeEntryAt(n);
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProxyHistoryEntry proxyHistoryEntry;
            String string = ProxyDialog.this.stfUser.getText().trim();
            if (string.equals("")) {
                ProxyDialog.this.saveChanges();
                GWDialog.disposeDialog(ProxyDialog.this);
                return;
            }
            Contact contact = ProxyDialog.this.stfUser.getContact();
            if (contact == null) {
                proxyHistoryEntry = ProxyDialog.this.model.getEntryAt(ProxyDialog.this.tableUsers.getSelectedRow());
                if (!proxyHistoryEntry.getDisplayName().equals(string)) {
                    proxyHistoryEntry = new ProxyHistoryEntry((Addressable)new Address(string, string));
                }
            } else {
                proxyHistoryEntry = new ProxyHistoryEntry((Addressable)contact);
            }
            boolean bl = ProxyDialog.this.model.getEntryAt(0).isEqual(proxyHistoryEntry);
            if (ProxyDialog.this.performProxy(proxyHistoryEntry, bl)) {
                GWDialog.disposeDialog(ProxyDialog.this);
            }
        }
    }
}

