/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.ApplicationFrame;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.Item;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.rules.CreateRuleDialog;
import com.novell.gw.jclient.application.dialogs.rules.RulesDialogController;
import com.novell.gw.jclient.application.dialogs.rules.RulesTable;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.rules.Rule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class RulesDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$rules$RulesDialog == null ? (class$com$novell$gw$jclient$application$dialogs$rules$RulesDialog = RulesDialog.class$("com.novell.gw.jclient.application.dialogs.rules.RulesDialog")) : class$com$novell$gw$jclient$application$dialogs$rules$RulesDialog));
    private RulesTable tableRules;
    private JButton btnClose = new JMnemonicButton(new CloseAction());
    private JButton btnNew = new JMnemonicButton(new NewAction());
    private JButton btnEdit = new JMnemonicButton(new EditAction());
    private JButton btnCopy = new JMnemonicButton(new CopyAction());
    private JButton btnDelete = new JMnemonicButton(new DeleteAction());
    private JButton btnDisable = new JMnemonicButton(new DisableAction());
    private JButton btnRun = new JMnemonicButton(new RunAction());
    private JButton btnMoveUp = new JMnemonicButton(new MoveUpAction());
    private JButton btnMoveDown = new JMnemonicButton(new MoveDownAction());
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$rules$RulesDialog;

    public RulesDialog(ApplicationFrame applicationFrame, AbstractFolder abstractFolder, Item[] itemArray) {
        super(applicationFrame, true);
        this.setTitle(StringResources.RULES);
        if (applicationFrame != null) {
            this.setController(new RulesDialogController(this, applicationFrame.getController()));
        } else {
            this.setController(new RulesDialogController(this, new MVCController(LevelManager.getInstance().getGlobalLevel()){}));
        }
        this.userGuid = applicationFrame.getUserGuid();
        this.tableRules = new RulesTable(this.getController(), this.btnDisable, abstractFolder, itemArray, this.userGuid);
        this.buildUI();
        this.tableRules.selectRow(0);
    }

    private void buildUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Container container = this.buildButtonsPane();
        jPanel.add((Component)container, "After");
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout(10, 10));
        orientablePanel.add((Component)new OrientableLabel("<html>" + StringResources.RULES_ARE_EXECUTED_IN_THE_ORDER + "</html>"), "North");
        orientablePanel.add((Component)this.buildTablePane(), "Center");
        orientablePanel.setPreferredSize(new Dimension(350, 300));
        jPanel.add((Component)orientablePanel, "Center");
        this.setDefaultButton(this.btnClose);
        this.setCancelButton(this.btnClose);
    }

    private Container buildTablePane() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.add((Component)new ColoredScrollPane(this.tableRules), "Center");
        orientablePanel.add((Component)new OrientableLabel(StringResources.RULES_LIST_C), "North");
        return orientablePanel;
    }

    private Container buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        orientablePanel.add(this.btnClose);
        orientablePanel.add(this.btnNew);
        orientablePanel.add(this.btnEdit);
        orientablePanel.add(this.btnCopy);
        orientablePanel.add(this.btnDelete);
        orientablePanel.add(this.btnDisable);
        orientablePanel.add(this.btnRun);
        orientablePanel.add(Box.createHorizontalStrut(5));
        orientablePanel.add(this.btnMoveUp);
        orientablePanel.add(this.btnMoveDown);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)orientablePanel, "North");
        return orientablePanel2;
    }

    public void setMVCModel(Object object) {
        if (object instanceof Rule) {
            Rule rule = (Rule)object;
            this.btnEdit.setEnabled(true);
            this.btnCopy.setEnabled(true);
            this.btnDisable.setEnabled(true);
            this.btnRun.setEnabled(true);
            int n = this.tableRules.getSelectedRow();
            int n2 = this.tableRules.getRowCount();
            boolean bl = n2 > 1 && n != 0;
            this.btnMoveUp.setEnabled(bl);
            bl = n2 > 1 && n < n2 - 1;
            this.btnMoveDown.setEnabled(bl);
            if (rule.isEnabled()) {
                this.btnDisable.setText(StringResources.DISABLE);
            } else {
                this.btnDisable.setText(StringResources.ENABLE);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.btnDelete.setEnabled(true);
    }

    public void setButtonsDisable() {
        this.btnEdit.setEnabled(false);
        this.btnCopy.setEnabled(false);
        this.btnDisable.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnRun.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class MoveDownAction
    extends AbstractAction {
        public MoveDownAction() {
            super(StringResources.MOVE_DOWN);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RulesDialog.this.tableRules.moveDown();
        }
    }

    protected class MoveUpAction
    extends AbstractAction {
        public MoveUpAction() {
            super(StringResources.MOVE_UP);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RulesDialog.this.tableRules.moveUp();
        }
    }

    protected class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(StringResources.COPY_D);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RulesDialog.this.tableRules.copyRule();
        }
    }

    protected class RunAction
    extends AbstractAction {
        public RunAction() {
            super(StringResources.RUN);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RulesDialog.this.tableRules.executeRule();
        }
    }

    protected class DisableAction
    extends AbstractAction {
        public DisableAction() {
            super(StringResources.DISABLE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RulesDialog.this.tableRules.setSelectedRuleEnabled();
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(StringResources.DELETE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RulesDialog.this.tableRules.deleteSelectedRule();
        }
    }

    protected class EditAction
    extends AbstractAction {
        public EditAction() {
            super(StringResources.EDIT_D);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RulesDialog.this.tableRules.editRule();
        }
    }

    protected class NewAction
    extends AbstractAction {
        public NewAction() {
            super(StringResources.NEW_D);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new CreateRuleDialog(RulesDialog.this, RulesDialog.this.userGuid).showMe();
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RulesDialog.this.setActionCompleteSuccessfully(true);
            GWDialog.disposeDialog(RulesDialog.this);
        }
    }
}

