/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.engine.Item;
import com.novell.gw.jclient.application.OrientableTable;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.rules.CreateRuleDialog;
import com.novell.gw.jclient.application.dialogs.rules.RulesTableController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleList;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class RulesTable
extends OrientableTable
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$rules$RulesTable == null ? (class$com$novell$gw$jclient$application$dialogs$rules$RulesTable = RulesTable.class$("com.novell.gw.jclient.application.dialogs.rules.RulesTable")) : class$com$novell$gw$jclient$application$dialogs$rules$RulesTable));
    private RulesTableController controller;
    private RuleList ruleList;
    private AbstractButton btnEnableRule;
    private Item[] items;
    private AbstractFolder folder;
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$rules$RulesTable;
    static /* synthetic */ Class class$java$lang$Boolean;

    public RulesTable(MVCController mVCController, JButton jButton, AbstractFolder abstractFolder, Item[] itemArray, String string) {
        Object object;
        this.userGuid = string;
        this.controller = new RulesTableController(this, mVCController);
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.btnEnableRule = jButton;
        this.folder = abstractFolder;
        this.items = itemArray;
        this.setModel(new RulesTableModel());
        this.getSelectionModel().setSelectionMode(0);
        this.tableHeader.setReorderingAllowed(false);
        if (OS.isMacOS()) {
            object = new Dimension(20, 22);
            this.tableHeader.setSize((Dimension)object);
            this.tableHeader.setPreferredSize((Dimension)object);
            this.tableHeader.setMinimumSize((Dimension)object);
        }
        object = this.getSelectionModel();
        object.addListSelectionListener(new RulesTableListSelectionListener());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    RulesTable.this.editRule();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    RulesTable.this.editRule();
                }
            }
        });
        if (this.getColumnModel().getColumnCount() > 0) {
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(0).setMaxWidth(20);
            this.getColumnModel().getColumn(0).setMinWidth(20);
            this.getColumnModel().getColumn(0).setResizable(false);
        }
    }

    public void editRule() {
        new CreateRuleDialog((GWDialog)ControlsUtils.getWindowForComponent(this), this.getSelectedRule(), this.userGuid).showMe();
    }

    public void copyRule() {
        Rule rule = this.ruleList.copyRule(this.getSelectedRow());
        new CreateRuleDialog((GWDialog)ControlsUtils.getWindowForComponent(this), rule, this.userGuid).showMe();
    }

    public void moveUp() {
        int n = this.getSelectedRow();
        this.ruleList.moveRule(n--, n);
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.updateTable(n);
    }

    private void updateTable(int n) {
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
        this.selectNearestRow(n);
    }

    public void moveDown() {
        int n = this.getSelectedRow();
        this.ruleList.moveRule(this.getSelectedRule(), n + 2);
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.updateTable(++n);
    }

    private Rule getSelectedRule() {
        int n = this.getSelectedRow();
        Rule rule = this.ruleList.getRuleAt(n);
        return rule;
    }

    public void selectRow(int n) {
        if (this.ruleList.getSize() > 0) {
            this.setRowSelectionInterval(n, n);
        }
    }

    public void setController(MVCController mVCController) {
        if (mVCController instanceof RulesTableController) {
            this.controller = (RulesTableController)mVCController;
        }
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
    }

    public void refreshModel() {
        int n = this.getSelectedRow();
        this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
        this.updateTable(n);
    }

    public Object getMVCModel() {
        return null;
    }

    public void setSelectedRuleEnabled() {
        this.toggleRuleStatus(this.getSelectedRow());
    }

    public void deleteSelectedRule() {
        int n = this.getSelectedRow();
        boolean bl = this.ruleList.deleteRule(n);
        if (bl) {
            this.ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
            this.updateTable(n);
            if (this.ruleList.getSize() == 0) {
                Command command = new Command(320);
                this.getController().processCommand(command);
            }
        }
    }

    private void selectNearestRow(int n) {
        if (n >= this.ruleList.getSize()) {
            --n;
        }
        if (n >= 0) {
            this.setRowSelectionInterval(n, n);
        }
    }

    private void setRuleEnabledAt(int n, boolean bl) {
        Rule rule = this.ruleList.getRuleAt(n);
        if (rule.isEnabled() != bl) {
            this.toggleRuleStatus(n);
        }
    }

    private void toggleRuleStatus(int n) {
        Rule rule = this.ruleList.getRuleAt(n);
        this.ruleList.toggleRuleStatus(n);
        this.repaint();
        String string = rule.isEnabled() ? StringResources.DISABLE : StringResources.ENABLE;
        this.btnEnableRule.setText(string);
    }

    public void executeRule() {
        if (this.items != null && this.items.length > 0) {
            this.ruleList.executeRule(this.getSelectedRow(), this.items);
        } else {
            this.ruleList.executeRule(this.getSelectedRow(), this.folder.getNativeFolder());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class RulesTableListSelectionListener
    implements ListSelectionListener {
        protected RulesTableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = RulesTable.this.getSelectedRow();
            if (n != -1) {
                Command command = new Command(310, RulesTable.this.ruleList.getRuleAt(n));
                RulesTable.this.getController().processCommand(command);
            } else {
                Command command = new Command(320);
                RulesTable.this.getController().processCommand(command);
            }
        }
    }

    protected class RulesTableModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"", StringResources.RULE_NAME, StringResources.EVENT};

        protected RulesTableModel() {
        }

        public int getRowCount() {
            return RulesTable.this.ruleList.getSize();
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof Boolean) {
                RulesTable.this.setRuleEnabledAt(n, (Boolean)object);
            }
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = RulesTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return super.getColumnClass(n);
        }

        private String getEventType(Rule rule) {
            switch (rule.getEventExecutionType()) {
                case 5: {
                    return StringResources.NEW_ITEM;
                }
                case 10: {
                    return StringResources.FILED_ITEM;
                }
                case 4: {
                    return StringResources.OPEN_FOLDER;
                }
                case 3: {
                    return StringResources.CLOSE_FOLDER;
                }
                case 1: {
                    return StringResources.STARTUP;
                }
                case 2: {
                    return StringResources.EXIT;
                }
                case 9: {
                    return StringResources.USER_ACTIVATED;
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return new Boolean(RulesTable.this.ruleList.getRuleAt(n).isEnabled());
                }
                case 1: {
                    return RulesTable.this.ruleList.getRuleAt(n).getName();
                }
                case 2: {
                    return this.getEventType(RulesTable.this.ruleList.getRuleAt(n));
                }
            }
            return "";
        }
    }
}

