/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules.actions;

import com.appframework.components.GWTextArea;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.addressbook.DLSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.popedit.ComboEdit;
import com.novell.gw.jclient.application.controls.popedit.ComboEditImpl;
import com.novell.gw.jclient.application.controls.popedit.StringParser;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.rules.actions.RuleActionDialog;
import com.novell.gw.jclient.application.dialogs.rules.actions.ValidateAttachmentDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

abstract class AbstractMailActionDialog
extends RuleActionDialog {
    private static final Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$rules$actions$AbstractMailActionDialog == null ? (class$com$novell$gw$jclient$application$dialogs$rules$actions$AbstractMailActionDialog = AbstractMailActionDialog.class$("com.novell.gw.jclient.application.dialogs.rules.actions.AbstractMailActionDialog")) : class$com$novell$gw$jclient$application$dialogs$rules$actions$AbstractMailActionDialog));
    ComboEdit stfTO;
    private ComboEdit stfCC;
    private ComboEdit stfBC;
    JTextField tfFrom = new OrientableTextField();
    private JButton btnAddressBook = new JMnemonicButton(new ViewAddressSelectorAction());
    JTextArea taMessage = new GWTextArea();
    JTextField tfSubject = new OrientableTextField();
    JComponent lbTo;
    private boolean isComponentShownFirstTime = true;
    JTextField tfFiles = new OrientableTextField(){

        public void setText(String string) {
            super.setText(string);
            if (string != null && string.length() > 0) {
                this.setCaretPosition(0);
            }
        }
    };
    private static final String FILE_SEPARATOR = ", ";
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$rules$actions$AbstractMailActionDialog;

    AbstractMailActionDialog(GWDialog gWDialog, RuleAction ruleAction, Rule rule, String string) {
        super(gWDialog, ruleAction, rule);
        this.stfTO = new ComboEditImpl(this.getController(), 1);
        this.stfCC = new ComboEditImpl(this.getController(), 2);
        this.stfBC = new ComboEditImpl(this.getController(), 4);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, this.stfTO.getComponent());
        this.buildUI();
        this.tfFrom.setText(GWCommandManager.getInstance(string).getCurrentUserInfo().getID());
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                if (AbstractMailActionDialog.this.isComponentShownFirstTime) {
                    AbstractMailActionDialog.this.taMessage.grabFocus();
                    AbstractMailActionDialog.this.taMessage.setCaretPosition(0);
                    AbstractMailActionDialog.this.isComponentShownFirstTime = false;
                }
            }
        });
        ActionListener[] actionListenerArray = this.btnOK.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.btnOK.removeActionListener(actionListenerArray[i]);
        }
        this.btnOK.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractMailActionDialog.this.writeRuleAction();
                AbstractMailActionDialog.this.sendCommands();
                AbstractMailActionDialog.this.setActionCompleteSuccessfully(true);
                AbstractMailActionDialog.this.dispose();
            }
        });
        this.btnOK.setText(StringResources.OK);
    }

    private void buildUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setPreferredSize(new Dimension(510, 220));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout(10, 5));
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        orientablePanel2.add(this.btnOK);
        orientablePanel2.add(this.btnCancel);
        orientablePanel2.add(this.btnAddressBook);
        orientablePanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        orientablePanel.add((Component)orientablePanel2, "North");
        jPanel.add((Component)orientablePanel, "After");
        OrientablePanel orientablePanel3 = new OrientablePanel(new GridBagLayout());
        TitleValueContainer titleValueContainer = new TitleValueContainer(orientablePanel3);
        OrientablePanel orientablePanel4 = new OrientablePanel(new BorderLayout(5, 0));
        orientablePanel4.add((Component)this.tfFiles, "Center");
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.FROM_C, this.tfFrom), this.tfFrom, new JMnemonicLabel(StringResources.CC_C, this.stfCC.getComponent()), this.stfCC.getComponent(), 0);
        titleValueContainer.buildRow(this.lbTo, this.stfTO.getComponent(), new JMnemonicLabel(StringResources.BC_C, this.stfBC.getComponent()), this.stfBC.getComponent(), 1);
        titleValueContainer.buildRow(new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject), this.tfSubject, new JMnemonicLabel(StringResources.FILES_C, orientablePanel4), orientablePanel4, 2);
        titleValueContainer.buildRow((JComponent)new JMnemonicLabel(StringResources.MESSAGE_C, this.taMessage), (JComponent)new OrientableScrollPane(this.taMessage), 3, true);
        jPanel.add((Component)orientablePanel3, "Center");
        this.tfFiles.setDropTarget(new DropTarget(this.tfFiles, 3, new MADDropTargetListener()));
    }

    List getRecipients() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.stfTO.getRecipients());
        arrayList.addAll(this.stfCC.getRecipients());
        arrayList.addAll(this.stfBC.getRecipients());
        return arrayList;
    }

    String getAttachments(String string) {
        int n;
        String string2 = this.tfFiles.getText().trim();
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0) {
            List list = StringParser.getTokens(string2, new char[]{','});
            for (int i = 0; i < list.size(); ++i) {
                String string3 = ((String)list.get(i)).trim();
                if (new File(string3).isFile() || string != null && string.indexOf(string3) != -1) {
                    stringBuffer.append(string3);
                    stringBuffer.append(FILE_SEPARATOR);
                    continue;
                }
                ValidateAttachmentDialog validateAttachmentDialog = new ValidateAttachmentDialog((JDialog)this, string3);
                validateAttachmentDialog.showMe();
                if (!validateAttachmentDialog.isActionCompleteSuccessfully()) continue;
                stringBuffer.append(validateAttachmentDialog.getFileName());
                stringBuffer.append(FILE_SEPARATOR);
            }
        }
        if ((n = stringBuffer.length()) > 2) {
            stringBuffer.delete(n - 2, n);
        }
        return stringBuffer.toString();
    }

    void setRecipients(DistributionList distributionList) {
        this.stfTO.setRecipients(AbstractMailActionDialog.getRecipientsByCopyType(1, distributionList));
        this.stfCC.setRecipients(AbstractMailActionDialog.getRecipientsByCopyType(2, distributionList));
        this.stfBC.setRecipients(AbstractMailActionDialog.getRecipientsByCopyType(4, distributionList));
    }

    private static List getRecipientsByCopyType(int n, DistributionList distributionList) {
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        int n2 = distributionList.getSize();
        for (int i = 0; i < n2; ++i) {
            Recipient recipient = distributionList.getRecipient(i);
            if ((recipient.getCopyType() & n) != n) continue;
            arrayList.add(recipient);
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MADDropTargetListener
    extends DropTargetAdapter {
        private MADDropTargetListener() {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getSourceActions());
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                Object object;
                if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(GWFlavors.uriListFlavor)) {
                    object = (String)transferable.getTransferData(GWFlavors.uriListFlavor);
                    if (((String)object).length() > 0 && ((String)object).charAt(((String)object).length() - 1) == '\u0000') {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    object = URLDecoder.decode((String)object);
                    List list = StringParser.getTokens((String)object, "\r\n");
                    for (int i = 0; i < list.size(); ++i) {
                        String string = (String)list.get(i);
                        try {
                            if ("".equals(string)) continue;
                            stringBuffer.append(new URL(string).getPath());
                            stringBuffer.append(AbstractMailActionDialog.FILE_SEPARATOR);
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                        }
                    }
                } else if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(DataFlavor.javaFileListFlavor)) {
                    object = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (int i = 0; i < object.size(); ++i) {
                        File file = (File)object.get(i);
                        stringBuffer.append(file.getAbsolutePath());
                        stringBuffer.append(AbstractMailActionDialog.FILE_SEPARATOR);
                    }
                } else if (dropTargetDropEvent.getCurrentDataFlavorsAsList().contains(DataFlavor.stringFlavor)) {
                    stringBuffer.append((String)transferable.getTransferData(DataFlavor.stringFlavor));
                }
                try {
                    if (stringBuffer.length() > 0) {
                        AbstractMailActionDialog.this.tfFiles.getDocument().insertString(AbstractMailActionDialog.this.tfFiles.getCaretPosition(), stringBuffer.toString(), null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                logger.error((Object)unsupportedFlavorException, (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
        }
    }

    private class ViewAddressSelectorAction
    extends AbstractAction {
        public ViewAddressSelectorAction() {
            super(StringResources.ADDRESS_BOOK_D);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DLSelectorDialog dLSelectorDialog = new DLSelectorDialog(AbstractMailActionDialog.this, AbstractMailActionDialog.this.getRecipients(), AbstractMailActionDialog.this.getController());
            dLSelectorDialog.showMe();
            if (dLSelectorDialog.isActionCompleteSuccessfully()) {
                AbstractMailActionDialog.this.stfTO.setRecipients(dLSelectorDialog.getToRecipients());
                AbstractMailActionDialog.this.stfCC.setRecipients(dLSelectorDialog.getCCRecipients());
                AbstractMailActionDialog.this.stfBC.setRecipients(dLSelectorDialog.getBCRecipients());
            }
        }
    }
}

