/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.addressbook;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.addressbook.AddressBookScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.DirectoriesTree;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressBookTable;
import com.novell.gw.jclient.application.controls.header.HeaderPanel;
import com.novell.gw.jclient.application.controls.menus.FrameAddressBookMenuBar;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.ComponentWithMenu;
import com.novell.gw.jclient.application.controls.toolbars.FrameAddressBookToolBar;
import com.novell.gw.jclient.application.frames.addressbook.FilterOffAction;
import com.novell.gw.jclient.application.frames.addressbook.FrameAddressBookActionList;
import com.novell.gw.jclient.application.frames.addressbook.GroupFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.OrganizationFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.ResourceFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.UserFilterAction;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FrameAddressBook
extends ApplicationFrame {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$frames$addressbook$FrameAddressBook == null ? (class$com$novell$gw$jclient$application$frames$addressbook$FrameAddressBook = FrameAddressBook.class$("com.novell.gw.jclient.application.frames.addressbook.FrameAddressBook")) : class$com$novell$gw$jclient$application$frames$addressbook$FrameAddressBook));
    private JTextField tfInput;
    public static final String LOOK_FOR = "Look For";
    public static final String SEARCH = "Search";
    private AbstractAddressBook selectedDirectory;
    private JLabel lbABName = new OrientableLabel();
    private JLabel lbNCCPosition = new OrientableLabel(StringResources.formatString(StringResources.NAME_COMPLETION_POSITION_C, new String[]{StringResources.NOT_SEARCHED}));
    private JLabel lbFilter = new OrientableLabel(ImageResources.ICON_UNACTIVE_FILTER);
    private AddressBookTable tableAddressBook;
    private FilterPopupMenu popupFilter;
    private DirectoriesTree directoriesTree;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$addressbook$FrameAddressBook;

    public FrameAddressBook(MVCController mVCController, String string) {
        super(StringResources.ADDRESS_BOOK, "ADDRESS_BOOK_FRAME", string);
        this.setAppActionList(new FrameAddressBookActionList(this, mVCController));
        this.tfInput = new OrientableTextField();
        this.tfInput.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                FrameAddressBook.this.setStatusText(StringResources.WAITING_FOR_USER_INPUT);
            }

            public void focusLost(FocusEvent focusEvent) {
                FrameAddressBook.this.setStatusText("");
            }
        });
        this.tableAddressBook = new AddressBookTable(this.getAppActionList(), this.tfInput);
        this.getAppActionList().addAction(new FilterOffAction((ActionList)this.getAppActionList(), this.tableAddressBook));
        this.getAppActionList().addAction(new GroupFilterAction((ActionList)this.getAppActionList(), this.tableAddressBook));
        this.getAppActionList().addAction(new OrganizationFilterAction((ActionList)this.getAppActionList(), this.tableAddressBook));
        this.getAppActionList().addAction(new ResourceFilterAction((ActionList)this.getAppActionList(), this.tableAddressBook));
        this.getAppActionList().addAction(new UserFilterAction((ActionList)this.getAppActionList(), this.tableAddressBook));
        this.popupFilter = new FilterPopupMenu(this.appActionList);
        this.buildUI();
        this.setGWMenuBar(new FrameAddressBookMenuBar(this.getAppActionList()));
    }

    public void beforeDispose() {
        this.directoriesTree.dispose();
        this.tableAddressBook.dispose();
        super.beforeDispose();
    }

    public void showMe() {
        super.showMe();
        this.tfInput.requestFocus();
    }

    public AddressBookTable getTableAddressBook() {
        return this.tableAddressBook;
    }

    public void buildUI() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)this.buildSearchPane(), "North");
        orientablePanel2.add((Component)new AddressBookScrollPane(this.tableAddressBook), "Center");
        orientablePanel.add((Component)this.buildRightHeader(), "North");
        orientablePanel.add((Component)orientablePanel2, "Center");
        this.directoriesTree = new DirectoriesTree(this.getAppActionList());
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.directoriesTree);
        orientableScrollPane.setMinimumSize(new Dimension(100, 200));
        GWSplitPane gWSplitPane = new GWSplitPane(1, orientableScrollPane, orientablePanel);
        int n = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_WIDTH", 700);
        int n2 = ApplicationOptions.getInstance().getInteger("ADDRESS_BOOK_SPLITPOS", 150);
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            n2 = n - n2;
        }
        gWSplitPane.setDividerLocation(n2);
        gWSplitPane.addPropertyChangeListener(new DividerPositionListener("ADDRESS_BOOK_SPLITPOS", gWSplitPane));
        this.centeredContentPanel.add((Component)gWSplitPane, "Center");
        this.centeredContentPanel.add((Component)new FrameAddressBookToolBar(this.getAppActionList()), "North");
    }

    private JComponent buildRightHeader() {
        this.lbABName.setForeground(Color.white);
        this.lbABName.setFont(Utils.deriveFont(this.lbABName.getFont(), 1));
        this.lbNCCPosition.setForeground(Color.white);
        ComponentOrientation componentOrientation = UIUtils.getComponentOrientation();
        this.lbABName.setComponentOrientation(componentOrientation);
        this.lbNCCPosition.setComponentOrientation(componentOrientation);
        this.lbFilter.setComponentOrientation(componentOrientation);
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new BoxLayout(orientablePanel, 0));
        orientablePanel.setOpaque(false);
        orientablePanel.add(this.lbNCCPosition);
        orientablePanel.add(Box.createHorizontalStrut(10));
        orientablePanel.add(new ComponentWithMenu(this.lbFilter, this.popupFilter));
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        orientablePanel2.setBackground(HeaderPanel.DEFAULT_HEADER_BACKGROUND_COLOR);
        orientablePanel2.add((Component)this.lbABName, "Before");
        orientablePanel2.add((Component)orientablePanel, "After");
        this.lbNCCPosition.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(new Cursor(12));
            }
        });
        this.lbNCCPosition.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(new Cursor(0));
                FrameAddressBook.this.getAppActionList().performAction("NCC search Order");
            }
        });
        return orientablePanel2;
    }

    private void setNCCNumber() {
        int n = Arrays.asList(EngineCommandManager.getNCCSearchOrder()).indexOf(this.selectedDirectory.getNativeAddressBook());
        String string = n == -1 ? StringResources.formatString(StringResources.NAME_COMPLETION_POSITION_C, new String[]{StringResources.NOT_SEARCHED}) : StringResources.formatString(StringResources.NAME_COMPLETION_POSITION_C, new String[]{new Integer(++n).toString()});
        this.lbNCCPosition.setText(string);
    }

    public void setMVCModel(Object object) {
        if (object instanceof AbstractAddressBook) {
            this.selectedDirectory = (AbstractAddressBook)object;
            this.lbABName.setIcon(ControlsUtils.getIconForAddressBook(this.selectedDirectory));
            this.lbABName.setText(this.selectedDirectory.getName());
            this.lbFilter.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
            AddressBookItemListFilter addressBookItemListFilter = new AddressBookItemListFilter(false);
            addressBookItemListFilter.setContactType(15);
            this.tableAddressBook.setFilter(addressBookItemListFilter);
            this.popupFilter.selectAction("AB Filter Off");
            this.setNCCNumber();
        }
    }

    private JPanel buildSearchPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        Object[] objectArray = new Integer[]{new Integer(25), new Integer(48), new Integer(9), new Integer(3), new Integer(28), new Integer(11)};
        OrientableComboBox orientableComboBox = new OrientableComboBox(objectArray);
        orientableComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                this.setText(AddressBookManager.getPropertyLabel((int)((Integer)object)));
                return this;
            }
        });
        orientableComboBox.setName(SEARCH);
        orientableComboBox.setSelectedIndex(3);
        orientableComboBox.setEnabled(false);
        this.tfInput.setName(LOOK_FOR);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.right = 4;
        orientablePanel.add((Component)new OrientableLabel(StringResources.LOOK_FOR_C), gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        orientablePanel.add((Component)this.tfInput, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.insets.right = 0;
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(4, 2, 2, 2));
        return orientablePanel;
    }

    public void release() {
        super.release();
        this.selectedDirectory = null;
        this.lbABName = null;
        FocusListener[] focusListenerArray = this.tfInput.getFocusListeners();
        for (int i = 0; i < focusListenerArray.length; ++i) {
            FocusListener focusListener = focusListenerArray[i];
            this.tfInput.removeFocusListener(focusListener);
        }
        this.tfInput = null;
        this.lbNCCPosition = null;
        this.lbFilter = null;
        this.tableAddressBook = null;
        this.popupFilter = null;
        this.directoriesTree = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FilterPopupMenu
    extends JPopupMenu {
        private ButtonGroup buttonGroup = new ButtonGroup();
        private ItemListener itemListener = new FilterItemListener();

        public FilterPopupMenu(ActionList actionList) {
            OrientableRadioButtonMenuItem orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter Off"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_OFF);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter Group"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_FOR_GROUPS);
            this.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter User"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_FOR_CONTACTS);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter Resource"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_FOR_RESOURCES);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter Organization"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_FOR_ORGANIZATIONS);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.add(orientableRadioButtonMenuItem);
        }

        public void selectAction(String string) {
            for (int i = 0; i < this.getComponents().length; ++i) {
                String string2;
                Component component = this.getComponents()[i];
                if (!(component instanceof JRadioButtonMenuItem) || !(string2 = ((AppAction)((JMenuItem)component).getAction()).getAppActionModel().getName()).equals(string)) continue;
                ((JMenuItem)component).setSelected(true);
            }
        }
    }

    private class FilterItemListener
    implements ItemListener {
        private FilterItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Action action = ((JMenuItem)itemEvent.getItem()).getAction();
                if (action instanceof FilterOffAction) {
                    FrameAddressBook.this.lbFilter.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
                } else {
                    FrameAddressBook.this.lbFilter.setIcon(ImageResources.ICON_ACTIVE_FILTER);
                }
            }
        }
    }
}

