/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;

public class AccountGeneralOptionsDialog
extends GWDialog {
    private JCheckBox ckSendRetrieveRepeatable;
    private JSpinner spSendRetrieveRepeateTime;
    private JCheckBox ckSendRetrieveOnStartup;
    private JTextField tfDisplayName;

    public AccountGeneralOptionsDialog(JFrame jFrame) {
        super(jFrame);
        this.buildUI();
        this.initControls();
        this.setTitle(StringResources.INTERNET_ACCOUNT_GENERAL_SETTINGS);
        this.setDefaultCloseOperation(3);
        this.enableControls();
        this.pack();
    }

    private void initControls() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        this.ckSendRetrieveRepeatable.setSelected(accountSettings.isIntervalSyncEnabled());
        this.spSendRetrieveRepeateTime.setValue(new Integer(accountSettings.getSyncInterval()));
        this.ckSendRetrieveOnStartup.setSelected(accountSettings.isStartupSyncEnabled());
        this.tfDisplayName.setText(accountSettings.getFromText());
    }

    private void buildUI() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = this.buildOptionsPanel();
        JButton jButton = new JButton(new OKDialogAction());
        this.setDefaultButton(jButton);
        JButton jButton2 = new JButton(new GWDialog.CancelDialogAction(this));
        this.setCancelButton(jButton2);
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new FlowLayout(4));
        OS.addButtons(orientablePanel, jButton, jButton2);
        OrientableTabbedPane orientableTabbedPane = new OrientableTabbedPane();
        orientableTabbedPane.addTab(StringResources.GENERAL, jPanel);
        container.add((Component)orientableTabbedPane, "Center");
        container.add((Component)orientablePanel, "South");
    }

    private JPanel buildOptionsPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridBagLayout());
        orientablePanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        JLabel jLabel = new JLabel(StringResources.DISPLAY_NAME_C);
        this.tfDisplayName = new JTextField("");
        orientablePanel2.add((Component)jLabel, "Before");
        orientablePanel2.add((Component)this.tfDisplayName, "Center");
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        this.ckSendRetrieveRepeatable = new OrientableCheckBox(StringResources.SEND_RETRIEVE + " " + StringResources.ALL_MARKED_ACCOUNTS + " " + StringResources.EVERY_SMALL + " ");
        this.ckSendRetrieveRepeatable.addActionListener(new SendRetireveRepeatableUpdateListener());
        this.spSendRetrieveRepeateTime = new OrientableSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        this.spSendRetrieveRepeateTime.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.spSendRetrieveRepeateTime.setComponentOrientation(UIUtils.getComponentOrientation());
        JLabel jLabel2 = new JLabel(" " + StringResources.MINUTE_S_SMALL);
        OrientablePanel orientablePanel3 = new OrientablePanel(new BorderLayout());
        orientablePanel3.add((Component)this.ckSendRetrieveRepeatable, "Before");
        orientablePanel3.add((Component)this.spSendRetrieveRepeateTime, "Center");
        orientablePanel3.add((Component)jLabel2, "After");
        gridBagConstraints.gridy = 1;
        orientablePanel.add((Component)orientablePanel3, gridBagConstraints);
        this.ckSendRetrieveOnStartup = new OrientableCheckBox(StringResources.SEND_RETRIEVE + " " + StringResources.ALL_MARKED_ACCOUNTS + " " + StringResources.AT_STARTUP);
        gridBagConstraints.gridy = 2;
        orientablePanel.add((Component)this.ckSendRetrieveOnStartup, gridBagConstraints);
        OrientablePanel orientablePanel4 = new OrientablePanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)orientablePanel4, gridBagConstraints);
        return orientablePanel;
    }

    private void enableControls() {
        this.spSendRetrieveRepeateTime.setEnabled(this.ckSendRetrieveRepeatable.isSelected());
    }

    private void applyChanges() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        accountSettings.setIntervalSyncEnabled(this.ckSendRetrieveRepeatable.isSelected());
        accountSettings.setSyncInterval(((Integer)this.spSendRetrieveRepeateTime.getValue()).intValue());
        accountSettings.setStartupSyncEnabled(this.ckSendRetrieveOnStartup.isSelected());
        accountSettings.setFromText(this.tfDisplayName.getText());
        GWClient.getGwClientActionList().processCommand(new GlobalCommand(810));
    }

    private class OKDialogAction
    extends AbstractAction {
        public OKDialogAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AccountGeneralOptionsDialog.this.applyChanges();
            GWDialog.disposeDialog(AccountGeneralOptionsDialog.this);
        }
    }

    private class SendRetireveRepeatableUpdateListener
    implements ActionListener {
        private SendRetireveRepeatableUpdateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AccountGeneralOptionsDialog.this.enableControls();
        }
    }
}

