/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.Account;
import com.novell.gw.account.GroupWiseAccount;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.passworddialog.PasswordChangeDialog;
import com.novell.gw.jclient.application.frames.options.AccountUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class AccountPropertiesDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$frames$options$AccountPropertiesDialog == null ? (class$com$novell$gw$jclient$application$frames$options$AccountPropertiesDialog = AccountPropertiesDialog.class$("com.novell.gw.jclient.application.frames.options.AccountPropertiesDialog")) : class$com$novell$gw$jclient$application$frames$options$AccountPropertiesDialog));
    private Account account;
    private JTextField tfAccountName;
    private JLabel lblAccountTypeString;
    private JTextField tfFromName;
    private JTextField tfOrganization;
    private JTextField tfEmailAddress;
    private JTextField tfIPAddress;
    private JTextField tfIPPort;
    private JCheckBox ckRefreshAddressBookAndRules;
    private JSpinner spRefreshAddressBooksTime;
    private JButton btnOnlinePassword;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$options$AccountPropertiesDialog;

    public AccountPropertiesDialog(JFrame jFrame, Account account) {
        super(jFrame);
        this.account = account;
        this.buildUI();
        this.initControls();
        this.setTitle(account.getName() + " " + StringResources.PROPERTIES_C);
        this.setDefaultCloseOperation(3);
        this.enableControls();
    }

    private void initControls() {
        this.tfAccountName.setText(this.account.getName());
        this.lblAccountTypeString.setText(AccountUtils.getAccountTypeString(this.account));
        this.tfFromName.setText(this.account.getFromText());
        this.tfOrganization.setText(this.account.getOrganization());
        this.tfEmailAddress.setText(this.account.getEmailAddress());
        if (this.account instanceof GroupWiseAccount) {
            GroupWiseAccount groupWiseAccount = (GroupWiseAccount)this.account;
            this.tfIPAddress.setText(groupWiseAccount.getIpAddress());
            this.tfIPPort.setText(String.valueOf(groupWiseAccount.getIpPort()));
            int n = groupWiseAccount.getSystemSyncInterval();
            this.ckRefreshAddressBookAndRules.setSelected(n != 0);
            if (n == 0) {
                n = 7;
            }
            this.spRefreshAddressBooksTime.setValue(new Integer(n));
        }
    }

    private void buildUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.buildGeneralPanel();
        JPanel jPanel3 = this.buildAdvancedPanel();
        JButton jButton = new JButton(new OKDialogAction());
        this.setDefaultButton(jButton);
        JButton jButton2 = new JButton(new GWDialog.CancelDialogAction(this));
        this.setCancelButton(jButton2);
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new FlowLayout(4));
        OS.addButtons(orientablePanel, jButton, jButton2);
        OrientableTabbedPane orientableTabbedPane = new OrientableTabbedPane();
        orientableTabbedPane.addTab(StringResources.GENERAL, jPanel2);
        orientableTabbedPane.addTab(StringResources.ADVANCED, jPanel3);
        orientableTabbedPane.setSelectedIndex(0);
        jPanel.add((Component)orientableTabbedPane, "Center");
        jPanel.add((Component)orientablePanel, "South");
    }

    private JPanel buildGeneralPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridBagLayout());
        orientablePanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(StringResources.ACCOUNT_NAME_DESCRIPTION + ".");
        jLabel.setHorizontalTextPosition(2);
        this.tfAccountName = new OrientableTextField("");
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.gridwidth = 2;
        orientablePanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        orientablePanel.add((Component)this.tfAccountName, gridBagConstraints);
        JLabel jLabel2 = new JLabel(StringResources.ACCOUNT_TYPE_C);
        jLabel2.setHorizontalTextPosition(2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        orientablePanel.add((Component)jLabel2, gridBagConstraints);
        this.lblAccountTypeString = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 26, 10, 10);
        orientablePanel.add((Component)this.lblAccountTypeString, gridBagConstraints);
        JLabel jLabel3 = new JLabel(StringResources.FROM_NAME_C);
        jLabel3.setHorizontalTextPosition(10);
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        orientablePanel.add((Component)jLabel3, gridBagConstraints);
        this.tfFromName = new OrientableTextField("");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 26, 5, 10);
        orientablePanel.add((Component)this.tfFromName, gridBagConstraints);
        JLabel jLabel4 = new JLabel(StringResources.ORGANIZATION_C);
        jLabel4.setHorizontalTextPosition(2);
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        orientablePanel.add((Component)jLabel4, gridBagConstraints);
        this.tfOrganization = new OrientableTextField("");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 26, 5, 10);
        orientablePanel.add((Component)this.tfOrganization, gridBagConstraints);
        JLabel jLabel5 = new JLabel(StringResources.EMAIL_ADDRESS_C);
        jLabel5.setHorizontalTextPosition(2);
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        orientablePanel.add((Component)jLabel5, gridBagConstraints);
        this.tfEmailAddress = new OrientableTextField("");
        this.tfEmailAddress.setEditable(false);
        this.tfEmailAddress.setEnabled(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 26, 5, 10);
        orientablePanel.add((Component)this.tfEmailAddress, gridBagConstraints);
        OrientableCheckBox orientableCheckBox = new OrientableCheckBox(StringResources.INCLUDE_ACCOUNT_DESCRIPTION);
        orientableCheckBox.setSelected(true);
        orientableCheckBox.setEnabled(false);
        gridBagConstraints.insets = new Insets(20, 10, 10, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        orientablePanel.add((Component)orientableCheckBox, gridBagConstraints);
        OrientablePanel orientablePanel2 = new OrientablePanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel buildAdvancedPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridBagLayout());
        orientablePanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(StringResources.IP_ADDRESS_C);
        jLabel.setHorizontalTextPosition(10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        orientablePanel.add((Component)jLabel, gridBagConstraints);
        this.tfIPAddress = new OrientableTextField("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        orientablePanel.add((Component)this.tfIPAddress, gridBagConstraints);
        JLabel jLabel2 = new JLabel(StringResources.IP_PORT_C);
        jLabel2.setHorizontalTextPosition(10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        orientablePanel.add((Component)jLabel2, gridBagConstraints);
        this.tfIPPort = new OrientableTextField("");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        orientablePanel.add((Component)this.tfIPPort, gridBagConstraints);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        this.btnOnlinePassword = new JButton(new OnlinePasswordAction());
        orientablePanel2.add((Component)this.btnOnlinePassword, "Before");
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        this.ckRefreshAddressBookAndRules = new OrientableCheckBox(StringResources.REFRESH_ADDRESS_BOOKS_AND_RULES + " " + StringResources.EVERY_SMALL + " ");
        this.ckRefreshAddressBookAndRules.addActionListener(new RefreshAddressBooksUpdateListener());
        this.spRefreshAddressBooksTime = new OrientableSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        this.spRefreshAddressBooksTime.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        JLabel jLabel3 = new JLabel(" " + StringResources.DAYS);
        OrientablePanel orientablePanel3 = new OrientablePanel(new BorderLayout());
        orientablePanel3.add((Component)this.ckRefreshAddressBookAndRules, "West");
        orientablePanel3.add((Component)this.spRefreshAddressBooksTime, "Center");
        orientablePanel3.add((Component)jLabel3, "East");
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        orientablePanel.add((Component)orientablePanel3, gridBagConstraints);
        OrientablePanel orientablePanel4 = new OrientablePanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)orientablePanel4, gridBagConstraints);
        return orientablePanel;
    }

    private void enableControls() {
        this.spRefreshAddressBooksTime.setEnabled(this.ckRefreshAddressBookAndRules.isSelected());
    }

    private void applyChanges() {
        this.account.setName(this.tfAccountName.getText());
        this.account.setFromText(this.tfFromName.getText());
        this.account.setOrganization(this.tfOrganization.getText());
        this.account.setEmailAddress(this.tfEmailAddress.getText());
        if (this.account instanceof GroupWiseAccount) {
            EngineCommandManager.getUserInfo().setFromText(this.account.getFromText());
            GroupWiseAccount groupWiseAccount = (GroupWiseAccount)this.account;
            int n = groupWiseAccount.getIpPort();
            try {
                n = Integer.valueOf(this.tfIPPort.getText());
            }
            catch (NumberFormatException numberFormatException) {
                logger.debug((Object)numberFormatException, (Throwable)numberFormatException);
            }
            groupWiseAccount.setIpAddress(this.tfIPAddress.getText(), n);
            int n2 = 0;
            if (this.ckRefreshAddressBookAndRules.isSelected()) {
                n2 = (Integer)this.spRefreshAddressBooksTime.getValue();
            }
            groupWiseAccount.setSystemSyncInterval(n2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class OnlinePasswordAction
    extends AbstractAction {
        public OnlinePasswordAction() {
            super(StringResources.ONLINE_MAILBOX_PASSWORD + "...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AccountPropertiesDialog accountPropertiesDialog = AccountPropertiesDialog.this;
            PasswordChangeDialog passwordChangeDialog = new PasswordChangeDialog(accountPropertiesDialog, StringResources.CHANGE_ONLINE_MAILBOX_PASSWORD, true);
            UIUtils.centerWindow((Window)passwordChangeDialog, accountPropertiesDialog);
            passwordChangeDialog.pack();
            passwordChangeDialog.setVisible(true);
            passwordChangeDialog.dispose();
        }
    }

    private class RefreshAddressBooksUpdateListener
    implements ActionListener {
        private RefreshAddressBooksUpdateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AccountPropertiesDialog.this.enableControls();
        }
    }

    private class OKDialogAction
    extends AbstractAction {
        public OKDialogAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AccountPropertiesDialog.this.applyChanges();
            GWDialog.disposeDialog(AccountPropertiesDialog.this);
        }
    }
}

