/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.OptionsPaneController;
import com.novell.gw.jclient.application.frames.options.compose.general.GeneralOptionPane;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.security.SecurityOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.send.SendOptionsPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class OptionsViewPane
extends OrientablePanel
implements MVCView {
    private MVCController controller;
    private String selectedPageID;
    private HashMap mapOptions = new HashMap();
    private String userGuid;

    public OptionsViewPane(MVCController mVCController, String string) {
        this.userGuid = string;
        this.controller = new OptionsPaneController(this, mVCController);
        this.build();
    }

    private void build() {
        this.setLayout(new CardLayout());
        this.putComposeOption(new GeneralOptionPane("General", this.controller, this.userGuid));
        this.putComposeOption(new SendOptionsPane("Send", this.controller, this.userGuid));
        this.putComposeOption(new SecurityOptionsPane("Security", this.controller, this.userGuid));
        this.putComposeOption(new PrintOptionsPane("Printing", this.controller));
    }

    private void putComposeOption(ComposeOption composeOption) {
        this.mapOptions.put(composeOption.getOptionID(), composeOption);
        this.add((Component)composeOption, composeOption.getOptionID());
    }

    public void setSelectedPage(String string) {
        ((CardLayout)this.getLayout()).show(this, string);
        this.selectedPageID = string;
        Command command = new Command(170, string);
        this.getController().processCommand(command);
    }

    public void setController(MVCController mVCController) {
        this.controller = mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return this.selectedPageID;
    }

    public void saveOptions() {
        ComposeOption composeOption = (ComposeOption)this.mapOptions.get(this.selectedPageID);
        composeOption.save(this.getController());
        Command command = new Command(160);
        this.getController().processCommand(command);
    }

    protected void showPage(String string) {
        if (!this.selectedPageID.equals(string)) {
            ComposeOption composeOption = (ComposeOption)this.mapOptions.get(this.selectedPageID);
            if (composeOption.needSaving()) {
                int n = JOptionPane.showConfirmDialog(this, StringResources.SOME_OPTIONS_HAVE_BEEN_MODIFIEDK_DO, StringResources.SAVE_DIALOG, 1, 3);
                if (n == 0) {
                    this.processYesAnswer(composeOption, string);
                } else if (n == 1) {
                    this.processNoAnswer(composeOption, string);
                }
            } else {
                this.setSelectedPage(string);
            }
        }
    }

    private void processYesAnswer(ComposeOption composeOption, String string) {
        composeOption.save(this.getController());
        Command command = new Command(160);
        this.getController().processCommand(command);
        this.setSelectedPage(string);
    }

    private void processNoAnswer(ComposeOption composeOption, String string) {
        composeOption.putOptionValuesIntoFields();
        composeOption.changesListener.setValueSaved();
        Command command = new Command(160);
        this.getController().processCommand(command);
        this.setSelectedPage(string);
    }
}

