/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.frames.options.compose.FileChooserPanel;
import com.novell.gw.jclient.application.frames.options.compose.country.Language;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class CommonPanel
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$frames$options$compose$general$CommonPanel == null ? (class$com$novell$gw$jclient$application$frames$options$compose$general$CommonPanel = CommonPanel.class$("com.novell.gw.jclient.application.frames.options.compose.general.CommonPanel")) : class$com$novell$gw$jclient$application$frames$options$compose$general$CommonPanel));
    public static final String SHOW_NOTIFICATION = "Show notif";
    public static final String REFRESH_TIME = "Refresh time";
    public static final String PREVIEW_AT_STARTUP = "Preview";
    public static final String DELETE_CONFIRMATION = "Delete confirm";
    public static final String PREFIX = "Message prefix";
    public static final String BROWSER = "Browser";
    public static final String TEMP_DIR = "Temp dir";
    public static final String BROWSER_BUTTON = "Browser button";
    public static final String TEMP_DIR_BUTTON = "Temp files dir button";
    private JCheckBox cbShowDeletionConf = new JMnemonicCheckBox(StringResources.ITEM_DELETION_CONFIRMATION);
    private JCheckBox cbReadNextAfter = new JMnemonicCheckBox(StringResources.READ_NEXT_AFTER_ACCEPT_DECLINE_OR_DELETE);
    private JCheckBox cbSmartToolTip = new JMnemonicCheckBox(StringResources.ENABLE_SMART_TOOL_TIPS_FOR_ITEMS);
    private JCheckBox cbShowHiddenFiles = new JMnemonicCheckBox(StringResources.SHOW_HIDDEN_FILES);
    private JCheckBox cbSpellCheckBefore = new JMnemonicCheckBox(StringResources.SPELL_CHECK_BEFORE_SEND);
    private JCheckBox cbSpellCheckAsYouType = new JMnemonicCheckBox(StringResources.ACTION_RT_SPELL_CHECKER);
    private JCheckBox cbForce = new JMnemonicCheckBox(StringResources.FORCE);
    private JLabel lbLanguage = new JMnemonicLabel(StringResources.INTERFACE_LANGUAGE_C, this.cmbLanguage);
    private JComboBox cmbLanguage = new OrientableComboBox();
    private JLabel lbItemDeleteKey = new JMnemonicLabel(StringResources.ITEM_DELETION_METHOD, this.cmbItemDeleteKey);
    private JComboBox cmbItemDeleteKey = new OrientableComboBox();
    private FileChooserPanel archiveDirChooser = new FileChooserPanel(StringResources.ARCHIVE_DIRECTORY, "", 1);
    private FileChooserPanel cachingDirChooser = new FileChooserPanel(StringResources.CACHING_MAILBOX_DIRECTORY, "", 1);
    private GeneralOptions generalOptions;
    private JRadioButton rbPlanTextComposer = new OrientableRadioButton(StringResources.PLAIN_TEXT);
    private JRadioButton rbHTMLComposer = new OrientableRadioButton(StringResources.HTML);
    private AbstractButton rbPlanTextReader = new OrientableRadioButton(StringResources.PLAIN_TEXT);
    private JRadioButton rbHTMLReader = new OrientableRadioButton(StringResources.HTML);
    private FontNameComboBox cbDefaultReadPlainTextFont = new FontNameComboBox();
    private FontSizeComboBox cbDefaultReadPlainTextFontSize = new FontSizeComboBox();
    private FontNameComboBox cbDefaultComposePlainTextFont = new FontNameComboBox();
    private FontSizeComboBox cbDefaultComposePlainTextFontSize = new FontSizeComboBox();
    private FontNameComboBox cbDefaultComposeHTMLFont = new FontNameComboBox();
    private FontSizeComboBox cbDefaultComposeHTMLFontSize = new FontSizeComboBox();
    private FontNameComboBox cbInterfaceFont = new FontNameComboBox();
    private FontSizeComboBox cbInterfaceFontSize = new FontSizeComboBox();
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$options$compose$general$CommonPanel;

    public CommonPanel(ChangesListener changesListener, MVCController mVCController, String string) {
        super(changesListener, mVCController);
        this.setName(StringResources.GENERAL);
        this.userGuid = string;
        this.buildUI();
        this.cbSmartToolTip.getModel().addItemListener(this.itemListener);
        this.cbShowHiddenFiles.getModel().addItemListener(this.itemListener);
        this.cbShowDeletionConf.getModel().addItemListener(this.itemListener);
        this.cbReadNextAfter.getModel().addItemListener(this.itemListener);
        this.archiveDirChooser.setChangesListener(this.changesListener);
        this.cachingDirChooser.setChangesListener(this.changesListener);
        this.cmbLanguage.addItemListener(this.itemListener);
        this.cmbItemDeleteKey.addItemListener(this.itemListener);
        this.cbSpellCheckBefore.addItemListener(this.itemListener);
        this.cbForce.addItemListener(this.itemListener);
        this.cbSpellCheckAsYouType.addItemListener(this.itemListener);
        this.rbPlanTextComposer.getModel().addItemListener(this.itemListener);
        this.rbHTMLComposer.getModel().addItemListener(this.itemListener);
        this.rbPlanTextReader.getModel().addItemListener(this.itemListener);
        this.rbHTMLReader.getModel().addItemListener(this.itemListener);
        this.cbDefaultReadPlainTextFont.addItemListener(this.itemListener);
        this.cbDefaultReadPlainTextFontSize.addItemListener(this.itemListener);
        this.cbDefaultComposePlainTextFont.addItemListener(this.itemListener);
        this.cbDefaultComposePlainTextFontSize.addItemListener(this.itemListener);
        this.cbDefaultComposeHTMLFont.addItemListener(this.itemListener);
        this.cbDefaultComposeHTMLFontSize.addItemListener(this.itemListener);
        this.cbInterfaceFont.addItemListener(this.itemListener);
        this.cbInterfaceFontSize.addItemListener(this.itemListener);
        this.readSystemFonts(this.cbDefaultComposePlainTextFont, this.cbDefaultComposePlainTextFontSize, false);
        this.readSystemFonts(this.cbDefaultReadPlainTextFont, this.cbDefaultReadPlainTextFontSize, false);
        this.readSystemFonts(this.cbDefaultComposeHTMLFont, this.cbDefaultComposeHTMLFontSize, true);
        this.readSystemFonts(this.cbInterfaceFont, this.cbInterfaceFontSize, false);
        this.insertEmptyElement(this.cbInterfaceFontSize);
    }

    protected void build() {
    }

    private void readSystemFonts(JComboBox jComboBox, JComboBox jComboBox2, boolean bl) {
        jComboBox.setModel(new DefaultComboBoxModel<String>(UIUtils.getSystemFonts()));
        this.insertEmptyElement(jComboBox);
        jComboBox2.setModel(new DefaultComboBoxModel<Integer>(bl ? FontOptions.SIZES_HTML : FontOptions.SIZES_PLAINTEXT));
        jComboBox2.setSelectedItem(null);
    }

    private void insertEmptyElement(JComboBox jComboBox) {
        if (jComboBox.getModel().getSize() > 0) {
            ((DefaultComboBoxModel)jComboBox.getModel()).insertElementAt("", 0);
            jComboBox.setSelectedIndex(0);
        }
    }

    private void buildUI() {
        this.rbPlanTextReader.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                CommonPanel.this.cbForce.setEnabled(bl);
                if (!bl) {
                    CommonPanel.this.cbForce.setSelected(false);
                }
            }
        });
        this.archiveDirChooser.setDisplayedMnemonic(StringResources.getMnemonic(StringResources.ARCHIVE_DIRECTORY));
        this.cachingDirChooser.setDisplayedMnemonic(StringResources.getMnemonic(StringResources.CACHING_MAILBOX_DIRECTORY));
        boolean bl = EngineCommandManager.getCurrentMode() == 1;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 1, 0);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        orientablePanel.add((Component)this.lbLanguage, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets.left = 15;
        orientablePanel.add((Component)new OrientableLabel(StringResources.INTERFACE_FONT_C), gridBagConstraints);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        orientablePanel.add((Component)this.cmbLanguage, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout(5, 5));
        orientablePanel2.add((Component)this.cbInterfaceFont, "Center");
        orientablePanel2.add((Component)this.cbInterfaceFontSize, "After");
        gridBagConstraints.insets.left = 15;
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        orientablePanel.add((Component)this.cbSmartToolTip, gridBagConstraints);
        ++gridBagConstraints.gridy;
        orientablePanel.add((Component)this.cbShowDeletionConf, gridBagConstraints);
        ++gridBagConstraints.gridy;
        orientablePanel.add((Component)this.cbReadNextAfter, gridBagConstraints);
        if (!OS.isMacOS()) {
            ++gridBagConstraints.gridy;
            this.cbShowHiddenFiles.setToolTipText(StringResources.SHOW_HIDDEN_FILES_AND_DIRECTORIES_IN_OPEN_SAVEAS_DIALOGS);
            orientablePanel.add((Component)this.cbShowHiddenFiles, gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets.left = 15;
        orientablePanel2 = new OrientablePanel(new BorderLayout(5, 5));
        orientablePanel2.add((Component)this.lbItemDeleteKey, "Center");
        orientablePanel2.add((Component)this.cmbItemDeleteKey, "After");
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 21;
        this.add((Component)orientablePanel, gridBagConstraints);
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.add((Component)this.archiveDirChooser, gridBagConstraints);
        if (bl) {
            ++gridBagConstraints.gridy;
            this.add((Component)this.cachingDirChooser, gridBagConstraints);
        }
        JPanel jPanel = this.composeDefaultViewPanel();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(20, 5, 5, 5);
        this.add((Component)jPanel, gridBagConstraints);
        OrientablePanel orientablePanel3 = new OrientablePanel(new GridLayout(2, 1));
        orientablePanel3.setBorder(BorderFactory.createTitledBorder(StringResources.SPELL_CHECKER));
        orientablePanel3.add(this.cbSpellCheckBefore);
        orientablePanel3.add(this.cbSpellCheckAsYouType);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 5;
        this.add((Component)orientablePanel3, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.changesListener.setValueSaved();
    }

    private JPanel composeDefaultViewPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        OrientablePanel orientablePanel2 = new OrientablePanel();
        TitledBorder titledBorder = new TitledBorder(StringResources.DEFAULT_COMPOSE_VIEW_AND_FONT);
        orientablePanel2.setBorder(titledBorder);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbPlanTextComposer);
        buttonGroup.add(this.rbHTMLComposer);
        orientablePanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        orientablePanel2.add((Component)this.rbPlanTextComposer, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        orientablePanel2.add((Component)this.cbDefaultComposePlainTextFont, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        orientablePanel2.add((Component)this.cbDefaultComposePlainTextFontSize, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        orientablePanel2.add((Component)this.rbHTMLComposer, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 5, 5);
        orientablePanel2.add((Component)this.cbDefaultComposeHTMLFont, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        orientablePanel2.add((Component)this.cbDefaultComposeHTMLFontSize, gridBagConstraints);
        OrientablePanel orientablePanel3 = new OrientablePanel();
        orientablePanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        OrientablePanel orientablePanel4 = new OrientablePanel(new BorderLayout());
        orientablePanel4.add((Component)this.rbPlanTextReader, "Before");
        orientablePanel4.add((Component)this.cbForce, "After");
        orientablePanel3.add((Component)orientablePanel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        orientablePanel3.add((Component)this.cbDefaultReadPlainTextFont, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        orientablePanel3.add((Component)this.cbDefaultReadPlainTextFontSize, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        orientablePanel3.add((Component)this.rbHTMLReader, gridBagConstraints);
        titledBorder = new TitledBorder(StringResources.DEFAULT_READ_VIEW_AND_FONT);
        orientablePanel3.setBorder(titledBorder);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.rbPlanTextReader);
        buttonGroup2.add(this.rbHTMLReader);
        orientablePanel.setLayout(new GridLayout(1, 2));
        orientablePanel.add(orientablePanel2);
        orientablePanel.add(orientablePanel3);
        return orientablePanel;
    }

    public void collectValues() {
        OptionManager.getInstance().setTextOption(this.isSelected(this.rbHTMLComposer), this.isSelected(this.rbHTMLReader), this.isSelected(this.cbForce), this.cbDefaultComposeHTMLFont.getSelectedFontName(), this.cbDefaultComposeHTMLFontSize.getSelectedFontSize(), this.cbDefaultComposePlainTextFont.getSelectedFontName(), this.cbDefaultComposePlainTextFontSize.getSelectedFontSize(), this.cbDefaultReadPlainTextFont.getSelectedFontName(), this.cbDefaultReadPlainTextFontSize.getSelectedFontSize());
        OptionManager.getInstance().setArchiveDir(this.archiveDirChooser.getText(), this.userGuid);
        this.generalOptions.setSmartToolTipEnabled(this.cbSmartToolTip.isSelected());
        this.generalOptions.setDeletionConfirmation(this.cbShowDeletionConf.isSelected());
        this.generalOptions.setReadNextAfter(this.cbReadNextAfter.isSelected());
        this.generalOptions.setInterfaceLanguage((Language)this.cmbLanguage.getSelectedItem());
        this.generalOptions.setItemDeleteKey(CommonPanel.getItemDeleteKeyForString((String)this.cmbItemDeleteKey.getSelectedItem()));
        ApplicationOptions.getInstance().put("SPELL_CHECKER_BEFORE_SEND", new Boolean(this.cbSpellCheckBefore.isSelected()));
        ApplicationOptions.getInstance().put("SPELL_CHECKER_AS_YOU_TYPE", new Boolean(this.cbSpellCheckAsYouType.isSelected()));
        ApplicationOptions.getInstance().put("SHOW_HIDDEN_FILES", new Boolean(this.cbShowHiddenFiles.isSelected()));
        Object object = this.cbInterfaceFont.getSelectedFontName();
        if (object != null) {
            OptionManager.getInstance().getInterfaceFontOptions().setFontName(object.toString());
        } else {
            OptionManager.getInstance().getInterfaceFontOptions().setFontName(null);
        }
        object = this.cbInterfaceFontSize.getSelectedFontSize();
        if (object != null) {
            OptionManager.getInstance().getInterfaceFontOptions().setFontSize(new Integer(object.toString()));
        } else {
            OptionManager.getInstance().getInterfaceFontOptions().setFontSize(null);
        }
        try {
            OptionManager.getInstance().writeOptions(OptionManager.getInstance().getInterfaceFontOptions());
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
        }
    }

    private static int getItemDeleteKeyForString(String string) {
        if (string == null || string.equals(StringResources.DELETE_KEY)) {
            if (OS.isMacOS()) {
                return 8;
            }
            return 127;
        }
        if (string.equals(StringResources.BACKSPACE_KEY)) {
            return 8;
        }
        if (string.equals(StringResources.DEL_KEY)) {
            return 127;
        }
        return 127;
    }

    private static String getStringForItemDeleteKey(int n) {
        if (n == 8) {
            if (OS.isMacOS()) {
                return StringResources.DELETE_KEY;
            }
            return StringResources.BACKSPACE_KEY;
        }
        if (n == 127) {
            if (OS.isMacOS()) {
                return StringResources.DEL_KEY;
            }
            return StringResources.DELETE_KEY;
        }
        return StringResources.DELETE_KEY;
    }

    private Boolean isSelected(AbstractButton abstractButton) {
        return abstractButton.isSelected();
    }

    public void fireOptionsChanged() {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        this.cbDefaultComposePlainTextFont.setSelectedItem(textOption.getDefaultComposePlainTextFont());
        this.cbDefaultComposePlainTextFontSize.setSelectedItem(textOption.getDefaultComposePlainTextFontSize());
        this.cbDefaultReadPlainTextFont.setSelectedItem(textOption.getDefaultReadPlainTextFont());
        this.cbDefaultReadPlainTextFontSize.setSelectedItem(textOption.getDefaultReadPlainTextFontSize());
        this.cbDefaultComposeHTMLFont.setSelectedItem(textOption.getDefaultComposeHTMLFont());
        this.cbDefaultComposeHTMLFontSize.setSelectedItem(textOption.getDefaultComposeHTMLFontSize());
        this.cbInterfaceFont.setSelectedItem(OptionManager.getInstance().getInterfaceFontOptions().getFontName());
        this.cbInterfaceFontSize.setSelectedItem(OptionManager.getInstance().getInterfaceFontOptions().getFontSize());
        this.cbSmartToolTip.setSelected(this.generalOptions.isSmartToolTipEnabled());
        this.cbShowDeletionConf.setSelected(this.generalOptions.isDeleteConfirmationAllowed());
        this.cbReadNextAfter.setSelected(this.generalOptions.isReadNextAfter());
        this.archiveDirChooser.setText(OptionManager.getInstance().getArchiveDir(this.userGuid));
        Object[] objectArray = this.generalOptions.getAvailableLanguages();
        Arrays.sort(objectArray);
        this.cmbLanguage.setModel(new DefaultComboBoxModel<Object>(objectArray));
        this.cmbLanguage.setSelectedItem(this.generalOptions.getInterfaceLanguage());
        String[] stringArray = OS.isMacOS() ? new String[]{StringResources.DEL_KEY, StringResources.DELETE_KEY} : new String[]{StringResources.DELETE_KEY, StringResources.BACKSPACE_KEY};
        this.cmbItemDeleteKey.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbItemDeleteKey.setSelectedItem(CommonPanel.getStringForItemDeleteKey(this.generalOptions.getItemDeleteKey()));
        if (textOption.isDefaultComposeHTML()) {
            this.rbHTMLComposer.setSelected(true);
        } else {
            this.rbPlanTextComposer.setSelected(true);
        }
        if (textOption.isDefaultReadHTML()) {
            this.rbHTMLReader.setSelected(true);
        } else {
            this.rbPlanTextReader.setSelected(true);
        }
        this.cbForce.setSelected(textOption.isPlainTextReadForced());
        this.cbForce.setEnabled(this.rbPlanTextReader.isSelected());
        this.cbSpellCheckBefore.setSelected(ApplicationOptions.getInstance().getBoolean("SPELL_CHECKER_BEFORE_SEND", false));
        this.cbSpellCheckAsYouType.setSelected(ApplicationOptions.getInstance().getBoolean("SPELL_CHECKER_AS_YOU_TYPE", true));
        this.cbShowHiddenFiles.setSelected(ApplicationOptions.getInstance().getBoolean("SHOW_HIDDEN_FILES"));
        this.changesListener.setValueSaved();
    }

    public void setOptions(AbstractCloneObject abstractCloneObject) throws IllegalArgumentException {
        if (!(abstractCloneObject instanceof GeneralOptions)) {
            throw new IllegalArgumentException();
        }
        this.generalOptions = (GeneralOptions)abstractCloneObject;
        this.fireOptionsChanged();
    }

    void setCashingPath(String string) {
        this.cachingDirChooser.setText(string);
    }

    String getCashingPath() {
        return this.cachingDirChooser.getText();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FontNameComboBox
    extends OrientableComboBox {
        public FontNameComboBox() {
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ FontNameComboBox this$0;
                {
                    this.this$0 = fontNameComboBox;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                        this.this$0.setSelectedIndex(0);
                    }
                }
            });
        }

        public String getSelectedFontName() {
            Object object = this.getSelectedItem();
            if (object != null && !"".equals(object)) {
                return object.toString();
            }
            return null;
        }
    }

    private static class FontSizeComboBox
    extends OrientableComboBox {
        private FontSizeComboBox() {
        }

        public Integer getSelectedFontSize() {
            Object object = this.getSelectedItem();
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return null;
        }
    }
}

