/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.printing;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;

class PrintingMessagePanel
extends AbstractOptionPanel {
    private JCheckBox cbUserName;
    private JCheckBox cbItemType;
    private JCheckBox cbFrom;
    private JCheckBox cbTo;
    private JCheckBox cbSubject;
    private PrintingOptions printingOptions;

    public PrintingMessagePanel(ChangesListener changesListener, MVCController mVCController) {
        super(changesListener, mVCController);
        this.setName(StringResources.MESSAGE);
    }

    protected void build() {
        CheckClickActionListener checkClickActionListener = new CheckClickActionListener();
        this.cbUserName = new JMnemonicCheckBox(StringResources.USER_NAME);
        this.cbItemType = new JMnemonicCheckBox(StringResources.MESSAGE_TYPE);
        this.cbFrom = new JMnemonicCheckBox(StringResources.FROM);
        this.cbTo = new JMnemonicCheckBox(StringResources.TO);
        this.cbSubject = new JMnemonicCheckBox(StringResources.SUBJECT);
        this.cbFrom.addActionListener(checkClickActionListener);
        this.cbItemType.addActionListener(checkClickActionListener);
        this.cbSubject.addActionListener(checkClickActionListener);
        this.cbTo.addActionListener(checkClickActionListener);
        this.cbUserName.addActionListener(checkClickActionListener);
        Border border = BorderFactory.createEtchedBorder();
        border = BorderFactory.createTitledBorder(border, StringResources.FOR_EVERY_MESSAGE_PRINT_C);
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.add((Component)this.cbUserName, gridBagConstraints);
        this.add((Component)this.cbItemType, gridBagConstraints);
        this.add((Component)this.cbFrom, gridBagConstraints);
        this.add((Component)this.cbTo, gridBagConstraints);
        this.add((Component)this.cbSubject, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    public void collectValues() {
        this.printingOptions.setUserNamePrinted(this.cbUserName.isSelected());
        this.printingOptions.setItemTypePrinted(this.cbItemType.isSelected());
        this.printingOptions.setFromPrinted(this.cbFrom.isSelected());
        this.printingOptions.setToPrinted(this.cbTo.isSelected());
        this.printingOptions.setSubjectPrinted(this.cbSubject.isSelected());
    }

    public void fireOptionsChanged() {
        this.cbUserName.setSelected(this.printingOptions.isUserNamePrinted());
        this.cbItemType.setSelected(this.printingOptions.isItemTypePrinted());
        this.cbFrom.setSelected(this.printingOptions.isFromPrinted());
        this.cbTo.setSelected(this.printingOptions.isToPrinted());
        this.cbSubject.setSelected(this.printingOptions.isSubjectPrinted());
    }

    public void setOptions(AbstractCloneObject abstractCloneObject) throws IllegalArgumentException {
        if (!(abstractCloneObject instanceof PrintingOptions)) {
            throw new IllegalArgumentException();
        }
        this.printingOptions = (PrintingOptions)abstractCloneObject;
        this.fireOptionsChanged();
    }

    private class CheckClickActionListener
    implements ActionListener {
        private CheckClickActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintingMessagePanel.this.changesListener.setValueChanged();
        }
    }
}

