/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.engine.ProxyAccessEntry;
import com.novell.gw.engine.ProxyAccessList;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

class AccessTableModel
extends AbstractTableModel {
    private String[] columns = new String[]{StringResources.NAME, StringResources.ADDRESS};
    private ProxyAccessList proxyAccessList;
    private String userGuid;

    public AccessTableModel(String string) {
        this.userGuid = string;
        this.proxyAccessList = GWCommandManager.getInstance(this.userGuid).getProxyAccessList();
    }

    public int getRowCount() {
        return this.proxyAccessList.size();
    }

    public String getColumnName(int n) {
        return this.columns[n];
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.proxyAccessList.get(n).getDisplayName();
            }
            case 1: {
                return this.proxyAccessList.get(n).getEmailAddress();
            }
        }
        return "";
    }

    public ProxyAccessEntry getProxyAccessEntry(int n) {
        return this.proxyAccessList.get(n);
    }

    public int indexOf(Addressable addressable) {
        int n = -1;
        for (int i = 0; i < this.proxyAccessList.size() && n < 0; ++i) {
            if (!addressable.getDisplayName().equals(this.proxyAccessList.get(i).getDisplayName())) continue;
            n = i;
        }
        return n;
    }

    public void removeContact(int n) {
        this.proxyAccessList.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void addContacts(List list) {
        int n;
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            if (list.get(n) instanceof Contact) {
                Contact contact = (Contact)list.get(n);
                if (GWCommandManager.getInstance(this.userGuid).getCurrentUserInfo().getID().equals(contact.getUserName())) {
                    JOptionPane.showMessageDialog(null, StringResources.YOU_CANNOT_SHARE, StringResources.ADDRESS_BOOK_ERROR, 2);
                    continue;
                }
                int n3 = this.proxyAccessList.size();
                int n4 = this.proxyAccessList.add((Addressable)contact);
                int n5 = this.proxyAccessList.size();
                if (n4 != -1) {
                    if (n5 <= n3) continue;
                    ++n2;
                    continue;
                }
                JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.IS_NOT_A_VALID_GROUPWISE_USER, new String[]{contact.getDisplayName(), contact.getDisplayName()}), StringResources.NOVELL_GROUPWISE, 2);
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (n2 > 0) {
            n = this.proxyAccessList.size() - 1;
            this.fireTableRowsInserted(this.proxyAccessList.size() - n2, n);
        }
    }

    public void saveChanges() {
        this.proxyAccessList.commit();
    }
}

