/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.components.DigitDocument;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.frames.options.LockablePanel;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.sendoptions.AbstractSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MimeEncoding;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.items.sendoptions.Priority;
import com.novell.gw.jclient.bl.om.items.sendoptions.Security;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

abstract class AbstractSendPanel
extends AbstractOptionPanel {
    protected JRadioButton rbPriorityHigh;
    protected JRadioButton rbPriorityStandard;
    protected JRadioButton rbPriorityLow;
    protected JLabel lbSecurity;
    protected JComboBox cmbSecurity;
    protected JCheckBox cbReplyRequest;
    protected JRadioButton rbReplyWhenConv;
    protected JRadioButton rbReplyWithin;
    protected JTextField tfDays;
    private JLabel lbDays;
    private JLabel lbMimeEncoding;
    private JComboBox cmbMimeEncoding;
    private ButtonGroup bgPriority;
    private ButtonGroup bgReply;
    protected LockablePanel pnlPriority;
    protected LockablePanel pnlReply;
    protected Action clickAction;
    private AbstractSendOptions abstractSendOptions;

    protected AbstractSendPanel(ChangesListener changesListener, MVCController mVCController) {
        super(changesListener, mVCController);
    }

    protected void build(GridBagConstraints gridBagConstraints) {
        this.setName(StringResources.SEND_OPTIONS);
        this.clickAction = new ClickAction();
        this.cmbSecurity = new NotificationComboBox(Security.SECURITY_LIST);
        this.cmbSecurity.setFocusable(false);
        this.cmbSecurity.addActionListener(this.clickAction);
        this.cmbMimeEncoding = new OrientableComboBox(MimeEncoding.MIME_ENC_LIST);
        this.cmbMimeEncoding.addActionListener(this.clickAction);
        this.lbSecurity = new JMnemonicLabel(StringResources.CLASSIFICATION_C, this.cmbSecurity);
        this.lbMimeEncoding = new JMnemonicLabel(StringResources.MIME_ENCODING_C, this.cmbMimeEncoding);
        this.pnlPriority = this.createPriorityPanel();
        this.pnlReply = this.createReplyPanel();
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.pnlPriority, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.lbSecurity, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.cmbSecurity, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlReply, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.lbMimeEncoding, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.cmbMimeEncoding, gridBagConstraints);
    }

    private LockablePanel createPriorityPanel() {
        LockablePanel lockablePanel = new LockablePanel(new GridBagLayout());
        RadioPriorityItemLitener radioPriorityItemLitener = new RadioPriorityItemLitener(this.changesListener);
        this.rbPriorityHigh = new JMnemonicRadioButton(StringResources.HIGH_PRIORITY);
        this.rbPriorityStandard = new JMnemonicRadioButton(StringResources.STANDARD_PRIORITY);
        this.rbPriorityLow = new JMnemonicRadioButton(StringResources.LOW_PRIORITY);
        this.rbPriorityHigh.getModel().addItemListener(radioPriorityItemLitener);
        this.rbPriorityStandard.getModel().addItemListener(radioPriorityItemLitener);
        this.rbPriorityLow.getModel().addItemListener(radioPriorityItemLitener);
        this.bgPriority = new ButtonGroup();
        this.bgPriority.add(this.rbPriorityHigh);
        this.bgPriority.add(this.rbPriorityStandard);
        this.bgPriority.add(this.rbPriorityLow);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        lockablePanel.add((Component)this.rbPriorityHigh, gridBagConstraints);
        ++gridBagConstraints.gridy;
        lockablePanel.add((Component)this.rbPriorityStandard, gridBagConstraints);
        ++gridBagConstraints.gridy;
        lockablePanel.add((Component)this.rbPriorityLow, gridBagConstraints);
        return lockablePanel;
    }

    private LockablePanel createReplyPanel() {
        LockablePanel lockablePanel = new LockablePanel(new GridBagLayout());
        RadioReplyActionListener radioReplyActionListener = new RadioReplyActionListener();
        CheckReplyActionListener checkReplyActionListener = new CheckReplyActionListener();
        this.cbReplyRequest = new JMnemonicCheckBox(StringResources.REPLY_REQUESTED);
        this.rbReplyWhenConv = new JMnemonicRadioButton(StringResources.WHEN_CONVENIENT);
        this.rbReplyWithin = new JMnemonicRadioButton(StringResources.WITHIN);
        this.tfDays = new OrientableTextField();
        this.tfDays.setColumns(2);
        this.lbDays = new OrientableLabel(StringResources.L_DAYS);
        this.cbReplyRequest.addActionListener(checkReplyActionListener);
        this.rbReplyWhenConv.addActionListener(radioReplyActionListener);
        this.rbReplyWithin.addActionListener(radioReplyActionListener);
        this.rbReplyWhenConv.setEnabled(false);
        this.rbReplyWithin.setEnabled(false);
        this.tfDays.setEnabled(false);
        this.bgReply = new ButtonGroup();
        this.bgReply.add(this.rbReplyWhenConv);
        this.bgReply.add(this.rbReplyWithin);
        this.tfDays.addCaretListener(new DaysCaretListener());
        this.tfDays.setDocument(new DigitDocument());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        lockablePanel.add((Component)this.cbReplyRequest, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        lockablePanel.add((Component)this.rbReplyWhenConv, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        lockablePanel.add((Component)this.rbReplyWithin, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 0.0;
        lockablePanel.add((Component)this.tfDays, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        lockablePanel.add((Component)this.lbDays, gridBagConstraints);
        return lockablePanel;
    }

    public void setOptions(AbstractCloneObject abstractCloneObject) throws IllegalArgumentException {
        if (abstractCloneObject == null) {
            return;
        }
        if (!(abstractCloneObject instanceof AbstractSendOptions)) {
            throw new IllegalArgumentException();
        }
        this.abstractSendOptions = (AbstractSendOptions)abstractCloneObject;
        this.fireOptionsChanged();
    }

    public void fireOptionsChanged() {
        JRadioButton jRadioButton;
        switch (this.abstractSendOptions.getPriority().getValue()) {
            case 4: {
                jRadioButton = this.rbPriorityHigh;
                break;
            }
            case 1: {
                jRadioButton = this.rbPriorityLow;
                break;
            }
            case 2: {
                jRadioButton = this.rbPriorityStandard;
                break;
            }
            default: {
                jRadioButton = this.rbPriorityStandard;
            }
        }
        jRadioButton.setSelected(true);
        this.pnlPriority.setLocked(this.abstractSendOptions.isPriorityLocked());
        this.cmbSecurity.setSelectedItem(this.abstractSendOptions.getSecurity());
        this.cmbSecurity.setEnabled(!this.abstractSendOptions.isSecurityLocked());
        this.lbSecurity.setEnabled(!this.abstractSendOptions.isSecurityLocked());
        boolean bl = this.abstractSendOptions.isReplyRequested();
        this.cbReplyRequest.setSelected(bl);
        this.rbReplyWhenConv.setEnabled(bl);
        this.rbReplyWithin.setEnabled(bl);
        this.tfDays.setEnabled(bl && !this.abstractSendOptions.isReplyWhenConvenient());
        this.tfDays.setText(String.valueOf(this.abstractSendOptions.getReplyRequestDay()));
        this.lbDays.setEnabled(bl);
        if (this.abstractSendOptions.isReplyWhenConvenient()) {
            this.rbReplyWhenConv.setSelected(true);
        } else {
            this.rbReplyWithin.setSelected(true);
        }
        this.pnlReply.setLocked(this.abstractSendOptions.isReplyRequestLocked());
        this.cmbMimeEncoding.setSelectedItem(this.abstractSendOptions.getMimeEncoding());
        this.cmbMimeEncoding.setEnabled(!this.abstractSendOptions.isMimeLocked());
    }

    public void collectValues() {
        if (this.rbPriorityHigh.isSelected()) {
            this.abstractSendOptions.setPriority(Priority.HIGH);
        } else if (this.rbPriorityStandard.isSelected()) {
            this.abstractSendOptions.setPriority(Priority.STANDARD);
        } else if (this.rbPriorityLow.isSelected()) {
            this.abstractSendOptions.setPriority(Priority.LOW);
        } else {
            this.abstractSendOptions.setPriority(Priority.STANDARD);
        }
        this.abstractSendOptions.setSecurity((Security)this.cmbSecurity.getSelectedItem());
        this.abstractSendOptions.setReplyRequested(this.cbReplyRequest.isSelected());
        this.abstractSendOptions.setReplyWhenConvenient(this.rbReplyWhenConv.isSelected());
        if (this.tfDays.getText() != null && this.tfDays.getText().length() > 0) {
            int n = Integer.valueOf(this.tfDays.getText());
            if (n > 99) {
                n = 99;
            }
            this.abstractSendOptions.setReplyRequestDay(n);
        } else {
            this.abstractSendOptions.setReplyRequestDay(0);
        }
        if (this.cmbMimeEncoding.getSelectedIndex() >= 0) {
            this.abstractSendOptions.setMimeEncodingType((MimeEncoding)this.cmbMimeEncoding.getSelectedItem());
        }
    }

    protected class NotificationComboBox
    extends OrientableComboBox {
        public NotificationComboBox(Object[] objectArray) {
            super(objectArray);
        }

        public void setNotification(Notification notification) {
            this.setSelectedItem(notification);
            this.setEnabled(!notification.isLocked());
        }
    }

    class ClickAction
    extends AbstractAction {
        ClickAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractSendPanel.this.changesListener.setValueChanged();
        }
    }

    private class RadioPriorityItemLitener
    extends AbstractOptionPanel.CustomItemListener {
        public RadioPriorityItemLitener(ChangesListener changesListener) {
            super(changesListener);
        }
    }

    private class DaysCaretListener
    implements CaretListener {
        private DaysCaretListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            AbstractSendPanel.this.changesListener.setValueChanged();
        }
    }

    private class CheckReplyActionListener
    extends AbstractAction {
        private CheckReplyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = AbstractSendPanel.this.cbReplyRequest.isSelected();
            AbstractSendPanel.this.rbReplyWhenConv.setEnabled(bl);
            AbstractSendPanel.this.rbReplyWithin.setEnabled(bl);
            AbstractSendPanel.this.tfDays.setEnabled(bl && AbstractSendPanel.this.rbReplyWithin.isSelected());
            AbstractSendPanel.this.lbDays.setEnabled(bl);
            AbstractSendPanel.this.changesListener.setValueChanged();
        }
    }

    private class RadioReplyActionListener
    extends AbstractAction {
        private RadioReplyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractSendPanel.this.tfDays.setEnabled(AbstractSendPanel.this.cbReplyRequest.isSelected() && AbstractSendPanel.this.rbReplyWithin.isSelected());
            AbstractSendPanel.this.changesListener.setValueChanged();
        }
    }
}

