/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.search;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.header.HeaderPanel;
import com.novell.gw.jclient.application.controls.header.HeaderPopupMenu;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FilterGWItemsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FrameSearchMenuBar;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTable;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.ComponentWithMenu;
import com.novell.gw.jclient.application.controls.toolbars.FrameSearchToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.search.FrameItemSearchActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class FrameItemSearch
extends ApplicationFrame {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$frames$search$FrameItemSearch == null ? (class$com$novell$gw$jclient$application$frames$search$FrameItemSearch = FrameItemSearch.class$("com.novell.gw.jclient.application.frames.search.FrameItemSearch")) : class$com$novell$gw$jclient$application$frames$search$FrameItemSearch));
    private JButton btnStop = new JMnemonicButton(new StopAction());
    private JButton btnClear = new JMnemonicButton(new ClearAction());
    private JButton btnSearch = new JMnemonicButton(new SearchAction());
    private ItemListTable searchResultTable;
    private HeaderPanel tableHeaderPanel;
    private JLabel lbFilter;
    private SearchTextField tfFrom = new SearchTextField();
    private SearchTextField tfToCC = new SearchTextField();
    private JTextComponent tfSubject = new OrientableTextField();
    private JTextComponent tfMessage = new OrientableTextField();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$search$FrameItemSearch;

    public FrameItemSearch(String string) {
        super(StringResources.SEARCH_MESSAGES, "Frame Item Search", string);
        this.setAppActionList(new FrameItemSearchActionList(this, GWClient.getApplication()));
        this.searchResultTable = new ItemListTable(this.getController());
        this.searchResultTable.addFocusListener(new ResultTableFocusListener());
        this.tfFrom.setListener(new FromSearchResultListener());
        this.tfToCC.setListener(new ToSearchResultListener());
        this.buildUI();
    }

    private void buildUI() {
        this.getRootPane().setDefaultButton(this.btnSearch);
        this.centeredContentPanel.setLayout(new BorderLayout());
        ((JPanel)this.getContentPane()).setPreferredSize(new Dimension(540, 480));
        this.setGWMenuBar(new FrameSearchMenuBar(this.getAppActionList()));
        GWToolBarPanel gWToolBarPanel = new GWToolBarPanel();
        gWToolBarPanel.add((Component)new FrameSearchToolBar(this.getAppActionList()), "Center");
        this.setToolBarPanel(gWToolBarPanel, "North");
        this.setIconImage(ImageResources.ACT_FIND.getImage());
        GWSplitPane gWSplitPane = new GWSplitPane(0, this.buildSearchPane(), this.buildResultPane());
        this.centeredContentPanel.add((Component)gWSplitPane, "Center");
        this.getStatusBar().setItemsInfoPanelVisible(true);
        this.refreshStatus(false);
    }

    public void setFilterLabelIcon(ImageIcon imageIcon) {
        this.lbFilter.setIcon(imageIcon);
        this.lbFilter.invalidate();
    }

    private void buildTableHeader() {
        FilterGWItemsPopupMenu filterGWItemsPopupMenu = new FilterGWItemsPopupMenu(this.getAppActionList());
        this.lbFilter = new OrientableLabel(ImageResources.ICON_UNACTIVE_FILTER);
        ComponentWithMenu componentWithMenu = new ComponentWithMenu(this.lbFilter, filterGWItemsPopupMenu);
        this.tableHeaderPanel = new HeaderPanel(new OrientablePanel(new GridBagLayout()), this.getAppActionList());
        this.tableHeaderPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.tableHeaderPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.tableHeaderPanel.add((Component)new OrientableLabel(StringResources.SHOW_C), gridBagConstraints);
        this.tableHeaderPanel.add((Component)componentWithMenu, gridBagConstraints);
        this.tableHeaderPanel.add(Box.createHorizontalStrut(10), gridBagConstraints);
        HeaderPopupMenu headerPopupMenu = new HeaderPopupMenu(this.getAppActionList());
        this.tableHeaderPanel.addMouseListener(AbstractActionsPopupMenu.createMenuMouseListener(headerPopupMenu));
    }

    private JPanel buildSearchPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        OrientablePanel orientablePanel2 = new OrientablePanel(new FlowLayout(3));
        orientablePanel2.add(this.btnSearch);
        orientablePanel2.add(this.btnClear);
        orientablePanel2.add(this.btnStop);
        orientablePanel.add((Component)orientablePanel2, "South");
        OrientablePanel orientablePanel3 = new OrientablePanel(new GridBagLayout());
        TitleValueContainer titleValueContainer = new TitleValueContainer(orientablePanel3);
        titleValueContainer.buildRow(new OrientableLabel(StringResources.FROM_C), this.tfFrom, 0);
        titleValueContainer.buildRow(new OrientableLabel(StringResources.TO + ", " + StringResources.CC_C), this.tfToCC, 1);
        titleValueContainer.buildRow(new OrientableLabel(StringResources.SUBJECT_C), this.tfSubject, 2);
        titleValueContainer.buildRow(new OrientableLabel(StringResources.MESSAGE_C), this.tfMessage, 3);
        orientablePanel.add((Component)orientablePanel3, "Center");
        return orientablePanel;
    }

    private JPanel buildResultPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        this.buildTableHeader();
        orientablePanel.add((Component)this.tableHeaderPanel, "North");
        orientablePanel.add((Component)new ColoredScrollPane(this.searchResultTable), "Center");
        return orientablePanel;
    }

    private void startSearch() {
        QueryFolder queryFolder = GWCommandManager.getInstance(this.getUserGuid()).find(this.tfFrom.getText(), this.tfToCC.getText(), this.tfSubject.getText(), this.tfMessage.getText());
        Command command = new Command(10, queryFolder);
        this.getController().processCommand(command);
        command = new Command(1090, queryFolder);
        command.setAttribute("FORCE_REFRESH", true);
        this.getController().processCommand(command);
    }

    public void refreshStatus(boolean bl) {
        if (bl) {
            this.setStatusText(StringResources.SEARCHING + "...");
        } else {
            this.setStatusText("");
        }
        this.btnSearch.setEnabled(!bl);
        this.btnStop.setEnabled(bl);
    }

    private void stopSearch() {
        this.getController().processCommand(new Command(650));
    }

    private void clear() {
        this.tfFrom.setText("");
        this.tfMessage.setText("");
        this.tfSubject.setText("");
        this.tfToCC.setText("");
    }

    public void release() {
        super.release();
        this.btnStop = null;
        this.btnClear = null;
        this.btnSearch = null;
        this.searchResultTable = null;
        this.tableHeaderPanel = null;
        this.lbFilter = null;
        this.tfFrom = null;
        this.tfToCC = null;
        this.tfSubject = null;
        this.tfMessage = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ResultTableFocusListener
    implements FocusListener {
        private ResultTableFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            FrameItemSearch.this.getRootPane().setDefaultButton(null);
        }

        public void focusLost(FocusEvent focusEvent) {
            FrameItemSearch.this.getRootPane().setDefaultButton(FrameItemSearch.this.btnSearch);
        }
    }

    private class ToSearchResultListener
    implements SearchResultListener {
        private ToSearchResultListener() {
        }

        public void searchFinished(SearchEvent searchEvent) {
            if (searchEvent.getFoundContact() != null) {
                FrameItemSearch.this.tfToCC.setText(searchEvent.getFoundContact().getDisplayName());
            }
        }
    }

    private class FromSearchResultListener
    implements SearchResultListener {
        private FromSearchResultListener() {
        }

        public void searchFinished(SearchEvent searchEvent) {
            if (searchEvent.getFoundContact() != null) {
                FrameItemSearch.this.tfFrom.setText(searchEvent.getFoundContact().getDisplayName());
            }
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(StringResources.ACTION_CLEAR);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FrameItemSearch.this.clear();
        }
    }

    private class SearchAction
    extends AbstractAction {
        public SearchAction() {
            super(StringResources.SEARCH);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FrameItemSearch.this.startSearch();
        }
    }

    private class StopAction
    extends AbstractAction {
        public StopAction() {
            super(StringResources.ACTION_STOP);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FrameItemSearch.this.stopSearch();
        }
    }
}

