/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.plaf;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;

public class FoldersTreeUI
extends BasicTreeUI {
    private boolean isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
    private boolean isCaching;
    private int sign = this.isLeftToRight ? 1 : -1;
    public static final int NODE_SHIFT = 16;

    public FoldersTreeUI() {
        this.isCaching = EngineCommandManager.getCurrentMode() == 6;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new FoldersTreeUI();
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (treePath.getLastPathComponent() != this.tree.getModel().getRoot()) {
            int n2 = this.getNodeShift(treePath);
            if (this.isLeftToRight) {
                rectangle2.x += n2;
            }
            rectangle2.width -= n2;
        }
        super.paintRow(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
    }

    protected int getHorizontalLegBuffer() {
        return -30;
    }

    protected int getVerticalLegBuffer() {
        return -8;
    }

    protected AbstractLayoutCache createLayoutCache() {
        return new ShiftedHeightLayoutCache();
    }

    private int getNodeShift(TreePath treePath) {
        Object object;
        int n = 0;
        if (treePath != null && (object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof AbstractFolder) {
            AbstractFolder abstractFolder = (AbstractFolder)object;
            boolean bl = this.tree.isCollapsed(treePath);
            boolean bl2 = abstractFolder.hasUnopenedItems();
            if (abstractFolder instanceof SentItemsFolder) {
                if (!this.isCaching || !bl2) {
                    n = 16;
                }
            } else if (abstractFolder instanceof CalendarFolder) {
                if (!bl2) {
                    n = 16;
                }
            } else if (!bl2 || !bl || abstractFolder instanceof TrashFolder) {
                n = this.isLeftToRight ? 16 : 17;
            }
        }
        return n;
    }

    private class ShiftedHeightLayoutCache
    extends VariableHeightLayoutCache {
        private ShiftedHeightLayoutCache() {
        }

        public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
            Rectangle rectangle2 = super.getBounds(treePath, rectangle);
            if (rectangle2 != null && treePath.getLastPathComponent() != this.treeModel.getRoot()) {
                int n = FoldersTreeUI.this.getNodeShift(treePath);
                rectangle2.width += n;
                if (!FoldersTreeUI.this.isLeftToRight) {
                    rectangle2.x = rectangle2.x + (n == 0 ? 0 : FoldersTreeUI.this.sign * n);
                }
            }
            return rectangle2;
        }

        public int getPreferredWidth(Rectangle rectangle) {
            int n = super.getPreferredWidth(rectangle);
            return n + 16;
        }
    }
}

