/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing;

import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.BasicPrintManager;
import com.novell.gw.jclient.application.printing.PrintInformation;
import com.novell.gw.jclient.application.printing.PrintManagerActionList;
import com.novell.gw.jclient.application.printing.preview.PrintPreview;
import com.novell.gw.jclient.application.printing.printingaddressbook.AddressBookPrintManager;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarPrintManager;
import com.novell.gw.jclient.application.printing.printingitem.ItemPrintManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class PrintManager
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$printing$PrintManager == null ? (class$com$novell$gw$jclient$application$printing$PrintManager = PrintManager.class$("com.novell.gw.jclient.application.printing.PrintManager")) : class$com$novell$gw$jclient$application$printing$PrintManager));
    private JButton btnPrint;
    private JButton btnPreview;
    private JButton btnPageSetup;
    private JButton btnClose;
    private JButton btnConfigurePrinter;
    private JComboBox cbPrintServices;
    private boolean actionCompleteSuccessfully = false;
    private BasicPrintManager printManager;
    private PrinterJob printerJob;
    private PrintRequestAttributeSet printAttributes;
    private Object printedElement;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$printing$PrintManager;

    public PrintManager(ApplicationFrame applicationFrame, Object object, Object object2, boolean bl) {
        super(applicationFrame, true);
        this.setTitle(StringResources.PRINTING_D);
        this.setController(new PrintManagerActionList(this, applicationFrame.getAppActionList()));
        this.printedElement = object;
        this.printerJob = PrinterJob.getPrinterJob();
        this.printAttributes = new HashPrintRequestAttributeSet(OptionManager.getInstance().getPrintingOptions().getPrintAttributeSet());
        if (this.printAttributes == null) {
            this.printAttributes = new HashPrintRequestAttributeSet();
        }
        this.buildUI(object2, bl);
    }

    public PrintManager(ApplicationFrame applicationFrame, Object object) {
        this(applicationFrame, object, null, false);
    }

    public PrintManager(ApplicationFrame applicationFrame) {
        this(applicationFrame, null);
    }

    public PrintInformation getPrintInformation() {
        return new PrintInformation(this.printManager.getSelectedForm(), this.printedElement, this.printerJob, this.printAttributes);
    }

    private void buildUI(Object object, boolean bl) {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.buildPrintManager(object, bl), gridBagConstraints);
        if (!OS.isMacOS()) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.buildPrinterConfigPanel(), gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.buildButtonsPanel(), gridBagConstraints);
        this.getRootPane().setDefaultButton(this.btnPrint);
        this.btnClose.registerKeyboardAction(new BtnClose(), KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
    }

    private BasicPrintManager buildPrintManager(Object object, boolean bl) {
        if (this.printedElement == null) {
            this.printManager = new CalendarPrintManager(this.getController());
            this.printedElement = GWCalendarUtils.getToday();
            this.setTitle(StringResources.PRINTING_CALENDAR);
        } else if (this.printedElement instanceof AbstractItem) {
            this.printManager = new ItemPrintManager(this.getController(), object, bl);
            this.setTitle(StringResources.PRINTING_ITEM);
        } else if (this.printedElement instanceof AbstractAddressBook) {
            this.printManager = new AddressBookPrintManager(this.getController());
            this.setTitle(StringResources.PRINTING_ADDRESS_BOOK);
        }
        this.printManager.setMVCModel(this.printedElement);
        return this.printManager;
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        this.controller.getActionList().getAction("Print prepared form").setMVCModel(this.getPrintInformation());
        this.btnPrint = new JButton(this.controller.getActionList().getAction("Print prepared form"));
        this.btnPreview = new JButton(new BtnPreviewAction());
        this.btnPageSetup = new JButton(new BtnPageSetupAction());
        this.btnClose = new JButton(new BtnClose());
        orientablePanel.add(this.btnPrint);
        orientablePanel.add(this.btnPreview);
        orientablePanel.add(this.btnPageSetup);
        orientablePanel.add(this.btnClose);
        if (OS.isMacOS()) {
            this.btnPageSetup.setVisible(false);
        }
        return orientablePanel;
    }

    private JPanel buildPrinterConfigPanel() {
        this.cbPrintServices = new OrientableComboBox(PrintServiceLookup.lookupPrintServices(null, null));
        this.cbPrintServices.addItemListener(new CbPrintServicesItemListener());
        this.cbPrintServices.setSelectedItem(PrintServiceLookup.lookupDefaultPrintService());
        JLabel jLabel = new JLabel(StringResources.PRINTER_NAME + ": ");
        this.btnConfigurePrinter = new JButton(new BtnConfigurePrinterAction());
        OrientablePanel orientablePanel = new OrientablePanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), StringResources.PRINTER_GROUP_CAPTION);
        orientablePanel.setBorder(titledBorder);
        orientablePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        orientablePanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        orientablePanel.add((Component)this.cbPrintServices, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(3, 5, 7, 5);
        orientablePanel.add((Component)this.btnConfigurePrinter, gridBagConstraints);
        return orientablePanel;
    }

    public boolean isActionCompleteSuccessfully() {
        return this.actionCompleteSuccessfully;
    }

    public void release() {
        this.btnPrint = null;
        this.btnPreview = null;
        this.btnPageSetup = null;
        this.btnClose = null;
        this.btnConfigurePrinter = null;
        this.cbPrintServices = null;
        this.printManager = null;
        this.printerJob = null;
        this.printAttributes = null;
        this.printedElement = null;
    }

    public void setMVCModel(Object object) {
        super.setMVCModel(object);
        if (this.printManager != null) {
            this.printManager.setMVCModel(object);
        }
    }

    public void setPropertiesSelected(boolean bl) {
        this.printManager.setPropertiesSelected(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BtnClose
    extends AbstractAction {
        public BtnClose() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintManager.this.dispose();
        }
    }

    class CbPrintServicesItemListener
    implements ItemListener {
        CbPrintServicesItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && itemEvent.getItem() instanceof PrintService) {
                try {
                    PrintService printService = (PrintService)itemEvent.getItem();
                    PrintManager.this.printerJob.setPrintService(printService);
                }
                catch (PrinterException printerException) {
                    logger.error((Object)printerException);
                    logger.debug((Object)printerException, (Throwable)printerException);
                    JOptionPane.showMessageDialog(PrintManager.this, StringResources.INVALID_PRINTER, PrintManager.this.getTitle(), 0);
                }
            }
        }
    }

    class BtnConfigurePrinterAction
    extends AbstractAction {
        public BtnConfigurePrinterAction() {
            super(StringResources.PRINTER_PROPERTIES);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PrintManager.this.printerJob.printDialog(PrintManager.this.printAttributes)) {
                PrintManager.this.controller.getActionList().performAction("Print prepared form");
            }
        }
    }

    class BtnPageSetupAction
    extends AbstractAction {
        public BtnPageSetupAction() {
            super(StringResources.PAGE_SETUP);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintManager printManager = PrintManager.this;
            if (PrinterJob.lookupPrintServices().length == 0) {
                JOptionPane.showMessageDialog(printManager, StringResources.PROBLEM_WITH_PRINTERK__PRINTING_FAI);
                return;
            }
            PageFormat pageFormat = PrintManager.this.printerJob.pageDialog(PrintManager.this.printAttributes);
            if (pageFormat == null) {
                return;
            }
        }
    }

    class BtnPreviewAction
    extends AbstractAction {
        public BtnPreviewAction() {
            super(StringResources.PREVIEW);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintManager printManager = PrintManager.this;
            PrintPreview printPreview = new PrintPreview(PrintManager.this, PrintManager.this.getController(), printManager.getPrintInformation());
            printPreview = new PrintPreview(PrintManager.this, PrintManager.this.getController(), printManager.getPrintInformation());
            UIUtils.centerWindow((Window)printPreview, printManager);
            printPreview.setVisible(true);
            printPreview.getPreviewContainer().removeAll();
        }
    }
}

