/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.basicforms;

import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.PrintHTMLTextPane;
import com.appframework.components.htmleditor.RTFDocument;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.printing.basicforms.GWItemFormController;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.preview.RtfPreview;
import com.novell.gw.jclient.application.printing.printingitem.ItemChecksPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.View;
import org.apache.log4j.Logger;

public class GWItemForm
extends PrintForm
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$ApplicationFrame == null ? (class$com$appframework$ApplicationFrame = GWItemForm.class$("com.appframework.ApplicationFrame")) : class$com$appframework$ApplicationFrame));
    private GWItemFormController controller;
    protected ItemChecksPanel itemChecksPanel;
    private HTMLTextPane textPane;
    private RtfPreview rtfPreview;
    private AbstractItem item;
    protected String itemType = "";
    public static int DONT_PRINT_ATTACHMENT_LIST = 0;
    public static int PRINT_ATTACHMENT_LIST = 1;
    protected int printAttachmentList;
    private static int LEFT_TEXT_INSET = 80;
    static /* synthetic */ Class class$com$appframework$ApplicationFrame;

    public GWItemForm(AbstractItem abstractItem, MVCController mVCController) {
        this(abstractItem, DONT_PRINT_ATTACHMENT_LIST, mVCController);
    }

    public GWItemForm(AbstractItem abstractItem, int n, MVCController mVCController) {
        this.controller = new GWItemFormController(this, mVCController);
        this.item = abstractItem;
        this.printAttachmentList = n;
    }

    public void onPrintBegin() {
        MessageBody messageBody;
        this.textPane = new PrintHTMLTextPane();
        this.textPane.setEditable(false);
        this.textPane.setIgnoreDefaultFontAttributes(true);
        this.textPane.setMode(2);
        if (this.item != null && (messageBody = this.item.getMessage()) != null) {
            if (this.printAttachmentList == PRINT_ATTACHMENT_LIST) {
                this.prepareAttachmentsList(messageBody);
            } else if (messageBody.isRTFMessage()) {
                this.textPane.setStyledText(messageBody.getRTFMessage());
            } else {
                this.textPane.setText(messageBody.getMessage());
            }
        }
    }

    private void prepareAttachmentsList(MessageBody messageBody) {
        String string = "\n\n" + StringResources.ATTACHMENTS_C + '\n';
        String string2 = "";
        int n = this.item.getAttachments().size();
        for (int i = 0; i < n; ++i) {
            string2 = string2 + this.item.getAttachments().getIDObjectAt(i).toString() + "\n";
        }
        if (messageBody.isRTFMessage()) {
            this.textPane.setStyledText(messageBody.getRTFMessage());
            try {
                AttributeSet attributeSet = ((RTFDocument)this.textPane.getDocument()).getCharacterElement(0).getAttributes();
                this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), string + string2, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)StringResources.ERROR_COULD_NOT_INSERT_ATTACHMENTS_LIST, (Throwable)badLocationException);
            }
        } else {
            this.textPane.setText(messageBody.getMessage() + string + string2);
        }
    }

    public void setMessage(String string) {
        this.textPane.setText(string);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        this.pageWidth = (int)pageFormat.getImageableWidth();
        this.pageHeight = (int)pageFormat.getImageableHeight();
        graphics.setColor(Color.black);
        graphics.setClip(0, 0, this.pageWidth, this.pageHeight);
        if (ApplicationOptions.getInstance().getBoolean("PRINT_HEADER", true)) {
            this.commonHeaderH = this.printCommonHeader(graphics, n, this.pageWidth);
            graphics.translate(0, this.commonHeaderH);
        }
        if (n == 0) {
            n2 = this.printHeader(graphics);
            graphics.translate(0, n2);
        } else {
            n2 = 0;
        }
        if (this.rtfPreview == null) {
            BasicTextUI basicTextUI = (BasicTextUI)this.textPane.getUI();
            View view = basicTextUI.getRootView(this.textPane);
            this.rtfPreview = new RtfPreview(this.textPane.getDocument().getDefaultRootElement(), view, this.pageWidth, this.pageHeight - n2 - this.commonHeaderH);
        }
        boolean bl = this.rtfPreview.paintPage(graphics, this.pageHeight - n2 - this.commonHeaderH, n);
        System.gc();
        if (bl) {
            return 0;
        }
        this.rtfPreview = null;
        return 1;
    }

    protected int printHeader(Graphics graphics) {
        int n = graphics.getFontMetrics().getAscent();
        Font font = this.FNT_SUB_HEADER;
        Font font2 = this.FNT_PLAIN;
        if (this.itemChecksPanel.isFromSelected()) {
            graphics.setFont(this.FNT_SUB_HEADER);
            this.paintHeaderRow(graphics, StringResources.FROM_C, this.item.getSender().getRecipient().getAddressable().getDisplayName(), n, font, font2);
            n += graphics.getFontMetrics().getHeight();
        }
        if (this.itemChecksPanel.isToSelected()) {
            String string;
            int n2;
            graphics.setFont(this.FNT_SUB_HEADER);
            String string2 = this.item.getTo();
            if (string2 != null && string2.length() > 0) {
                n2 = (int)graphics.getFontMetrics().getStringBounds(StringResources.TO_C, graphics).getWidth();
                graphics.drawString(StringResources.TO_C, this.getTitleX(n2), n);
                LEFT_TEXT_INSET = n2 + 5;
                n = this.drawStringIntoRect(graphics, string2, n, this.pageWidth - LEFT_TEXT_INSET, this.getValueX(n2));
                n += graphics.getFontMetrics().getHeight();
            }
            if ((string = this.item.getCc()) != null && string.length() > 0) {
                n2 = (int)graphics.getFontMetrics().getStringBounds(StringResources.CC_C, graphics).getWidth();
                graphics.drawString(StringResources.CC_C, this.getTitleX(n2), n);
                LEFT_TEXT_INSET = n2 + 5;
                n = this.drawStringIntoRect(graphics, string, n, this.pageWidth - LEFT_TEXT_INSET, this.getValueX(n2));
                n += graphics.getFontMetrics().getHeight();
            }
        }
        return n;
    }

    private int getValueX(int n) {
        int n2 = UIUtils.getComponentOrientation().isLeftToRight() ? n + 5 : this.pageWidth - n;
        return n2;
    }

    protected int getTitleX(int n) {
        int n2 = UIUtils.getComponentOrientation().isLeftToRight() ? 0 : this.pageWidth - n;
        return n2;
    }

    protected int printCommonHeader(Graphics graphics, int n, int n2) {
        graphics.setFont(this.FNT_PLAIN);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = 0;
        int n4 = 0;
        n4 += fontMetrics.getAscent();
        String string = ControlsUtils.getUserGuid(this.controller);
        String string2 = GWCommandManager.getInstance(string).getUserFields().getUserName();
        if (this.item != null) {
            string2 = string2 + " - " + this.item.getSubject();
        }
        boolean bl = this.itemChecksPanel.isPageNumberSelected();
        String string3 = "";
        int n5 = 0;
        if (bl) {
            string3 = StringResources.PAGE + " " + (n + 1);
            n5 = SwingUtilities.computeStringWidth(fontMetrics, string3);
        }
        String string4 = GWCalendarUtils.getDateTimeFormat().format(GWCalendarUtils.getToday().getTime());
        int n6 = (int)graphics.getFontMetrics().getStringBounds(string4, graphics).getWidth();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            int n7 = this.pageWidth - n6 + n3;
            int n8 = this.pageWidth - n6 - 10 + n3;
            if (bl) {
                graphics.drawString(string3, this.pageWidth - n5 + n3, n4);
                n7 = n7 - n5 - 10;
                n8 = n8 - n5 - 10;
            }
            graphics.drawString(string4, n7, n4);
            graphics.drawString(UIUtils.cutStringToWidth(string2, fontMetrics, n8), n3, n4);
        } else {
            int n9 = n3;
            int n10 = this.pageWidth - n3 - n6 - 10;
            if (bl) {
                graphics.drawString(string3, n3, n4);
                n9 = n9 + n5 + 10;
                n10 = n10 - n5 - 10;
            }
            graphics.drawString(string4, n9, n4);
            String string5 = UIUtils.cutStringToWidth(string2, fontMetrics, n10);
            int n11 = this.pageWidth - SwingUtilities.computeStringWidth(fontMetrics, string5);
            graphics.drawString(string5, n11, n4);
        }
        graphics.drawLine(0, n4 + 5, n2, n4 + 5);
        return n4 += fontMetrics.getHeight() + 5;
    }

    private int drawStringIntoRect(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n3;
        int n6 = graphics.getFontMetrics().charWidth(' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n7 = graphics.getFontMetrics().stringWidth(string2);
            if (!UIUtils.getComponentOrientation().isLeftToRight()) {
                if ((n5 -= n7 + n6) < 0) {
                    n5 = n3 - (n7 + n6);
                    n4 += graphics.getFontMetrics().getHeight();
                }
            } else if (n5 + n7 >= n2) {
                n5 = n3;
                n4 += graphics.getFontMetrics().getHeight();
            }
            graphics.drawString(string2, n5, n4);
            if (!UIUtils.getComponentOrientation().isLeftToRight()) continue;
            n5 += n7 + n6;
        }
        return n4;
    }

    public ImageIcon getIcon() {
        if (this.printAttachmentList == PRINT_ATTACHMENT_LIST) {
            return ImageResources.PRINT_FRM_MAIL_ATTACH;
        }
        return ImageResources.PRINT_FRM_MAIL;
    }

    public void setController(MVCController mVCController) {
        this.controller = (GWItemFormController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof ItemChecksPanel) {
            this.itemChecksPanel = (ItemChecksPanel)object;
        }
    }

    public Object getMVCModel() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

