/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.preview;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.PrintInformation;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PrintUtils {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$printing$preview$PrintUtils == null ? (class$com$novell$gw$jclient$application$printing$preview$PrintUtils = PrintUtils.class$("com.novell.gw.jclient.application.printing.preview.PrintUtils")) : class$com$novell$gw$jclient$application$printing$preview$PrintUtils));
    public static final float[] DEFAULT_PRINTING_ATTRIBUTES = new float[]{210.0f, 297.0f, 25.4f, 25.4f, 159.2f, 246.2f, 1.0f};
    public static final float[] DEFAULT_PRINTING_ATTRIBUTES_US = new float[]{215.9f, 279.4f, 25.4f, 25.4f, 165.1f, 228.6f, 1.0f};
    static /* synthetic */ Class class$com$novell$gw$jclient$application$printing$preview$PrintUtils;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;
    static /* synthetic */ Class class$javax$print$attribute$standard$OrientationRequested;

    public static HashPrintRequestAttributeSet getAttributeFromArray(float[] fArray) {
        Object object;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        double d = fArray[0];
        double d2 = fArray[1];
        double d3 = fArray[2];
        double d4 = fArray[3];
        double d5 = fArray[4];
        double d6 = fArray[5];
        if (d <= 0.0 || d2 <= 0.0 || d5 > d || d6 > d2 || d3 < 0.0 || d4 < 0.0 || d3 + d5 > d || d4 + d6 > d2) {
            object = "US".equalsIgnoreCase(EngineCommandManager.getLocale().getCountry()) ? DEFAULT_PRINTING_ATTRIBUTES_US : DEFAULT_PRINTING_ATTRIBUTES;
            d = object[0];
            d2 = object[1];
            d3 = object[2];
            d4 = object[3];
            d5 = object[4];
            d6 = object[5];
            logger.warn((Object)StringResources.INVALID_PRINTING_ATTRIBUTES);
        }
        object = OrientationRequested.PORTRAIT;
        if ((int)fArray[6] == OrientationRequested.LANDSCAPE.getValue()) {
            object = OrientationRequested.LANDSCAPE;
        } else if ((int)fArray[6] == OrientationRequested.REVERSE_LANDSCAPE.getValue()) {
            object = OrientationRequested.REVERSE_LANDSCAPE;
        }
        hashPrintRequestAttributeSet.add((Attribute)object);
        MediaSizeName mediaSizeName = MediaSize.findMedia((float)d, (float)d2, 1000);
        if (mediaSizeName == null) {
            mediaSizeName = MediaSizeName.NA_LETTER;
        }
        hashPrintRequestAttributeSet.add(mediaSizeName);
        MediaPrintableArea mediaPrintableArea = new MediaPrintableArea((float)d3, (float)d4, (float)d5, (float)d6, 1000);
        hashPrintRequestAttributeSet.add(mediaPrintableArea);
        return hashPrintRequestAttributeSet;
    }

    public static PageFormat getPageFormatFromPrintAttributes(PrintRequestAttributeSet printRequestAttributeSet) {
        OrientationRequested orientationRequested;
        Attribute attribute;
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        Media media = (Media)printRequestAttributeSet.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PrintUtils.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        if (media instanceof MediaSizeName) {
            attribute = MediaSize.getMediaSizeForName((MediaSizeName)media);
            if (attribute != null) {
                paper.setSize(72.0 * (double)((Size2DSyntax)((Object)attribute)).getX(25400), 72.0 * (double)((Size2DSyntax)((Object)attribute)).getY(25400));
            } else {
                logger.debug((Object)("Invalid MediaSizeName detected: [" + media + "]. Default media size will be used."));
            }
        }
        if ((attribute = (MediaPrintableArea)printRequestAttributeSet.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = PrintUtils.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) != null) {
            paper.setImageableArea(72.0f * ((MediaPrintableArea)attribute).getX(25400), 72.0f * ((MediaPrintableArea)attribute).getY(25400), 72.0f * ((MediaPrintableArea)attribute).getWidth(25400), 72.0f * ((MediaPrintableArea)attribute).getHeight(25400));
        }
        if ((orientationRequested = (OrientationRequested)printRequestAttributeSet.get(class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = PrintUtils.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested)) != null) {
            if (orientationRequested == OrientationRequested.PORTRAIT) {
                pageFormat.setOrientation(1);
            } else if (orientationRequested == OrientationRequested.LANDSCAPE) {
                pageFormat.setOrientation(0);
            } else if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                pageFormat.setOrientation(2);
            }
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static boolean canPrintingToFile(PrintRequestAttributeSet printRequestAttributeSet) {
        Attribute[] attributeArray = printRequestAttributeSet.toArray();
        int n = attributeArray.length;
        for (int i = 0; i < n; ++i) {
            File file;
            Destination destination;
            if (!(attributeArray[i] instanceof Destination) || !(destination = (Destination)attributeArray[i]).getURI().getScheme().equals("file") || (file = new File(destination.getURI().getPath())).getParentFile().canWrite()) continue;
            return false;
        }
        return true;
    }

    public static float[] getValuesFromPrintAttributes(HashPrintRequestAttributeSet hashPrintRequestAttributeSet) {
        float[] fArray = new float[7];
        Attribute[] attributeArray = hashPrintRequestAttributeSet.toArray();
        int n = attributeArray.length;
        for (int i = 0; i < n; ++i) {
            DocAttribute docAttribute;
            if (attributeArray[i] instanceof MediaSizeName) {
                docAttribute = (MediaSizeName)attributeArray[i];
                if (docAttribute == null) continue;
                MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)docAttribute);
                fArray[0] = mediaSize.getX(1000);
                fArray[1] = mediaSize.getY(1000);
                continue;
            }
            if (attributeArray[i] instanceof MediaPrintableArea) {
                docAttribute = (MediaPrintableArea)attributeArray[i];
                fArray[2] = ((MediaPrintableArea)docAttribute).getX(1000);
                fArray[3] = ((MediaPrintableArea)docAttribute).getY(1000);
                fArray[4] = ((MediaPrintableArea)docAttribute).getWidth(1000);
                fArray[5] = ((MediaPrintableArea)docAttribute).getHeight(1000);
                continue;
            }
            if (!(attributeArray[i] instanceof OrientationRequested)) continue;
            docAttribute = (OrientationRequested)attributeArray[i];
            fArray[6] = ((EnumSyntax)((Object)docAttribute)).getValue();
        }
        return fArray;
    }

    public static void print(PrintInformation printInformation, ActionList actionList) {
        try {
            Object object;
            PrintRequestAttributeSet printRequestAttributeSet;
            PrintForm printForm = printInformation.getPrintForm();
            if (printForm == null) {
                logger.debug((Object)"Print form is not set");
                return;
            }
            PrinterJob printerJob = printInformation.getPrinterJob();
            if (printerJob == null) {
                logger.debug((Object)"Print job is not set. Creating default print job.");
                printerJob = PrinterJob.getPrinterJob();
            }
            if ((printRequestAttributeSet = printInformation.getPrintAttributes()) == null) {
                printRequestAttributeSet = OptionManager.getInstance().getPrintingOptions().getPrintAttributeSet();
            }
            if (!PrintUtils.canPrintingToFile(printRequestAttributeSet)) {
                JOptionPane.showMessageDialog(actionList.getOwnerComponent(), StringResources.YOU_HAVE_NO_RIGHT);
                return;
            }
            if (OS.isMacOS()) {
                if (printerJob.printDialog()) {
                    printForm.onPrintBegin();
                    printerJob.setPrintable(printForm);
                    printerJob.print();
                }
            } else {
                if (printerJob.getPrintService() == null) {
                    throw new PrinterException(StringResources.PRINTER_IS_NOT_CONFIGURED);
                }
                printForm.onPrintBegin();
                printerJob.setPrintable(printForm);
                printerJob.print(printRequestAttributeSet);
            }
            if ((object = printInformation.getPrintObject()) instanceof AbstractItem) {
                ((AbstractItem)object).markOpen();
            }
            actionList.processCommand(new Command(295, object));
        }
        catch (PrinterException printerException) {
            logger.debug((Object)"printer exception! ");
            JOptionPane.showMessageDialog(actionList.getOwnerComponent(), StringResources.PROBLEM_WITH_PRINTERK__PRINTING_FAI);
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

