/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentParam;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.DailyListForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class DailyTableForm
extends DailyListForm {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$printing$printingcalendar$printforms$DailyTableForm == null ? (class$com$novell$gw$jclient$application$printing$printingcalendar$printforms$DailyTableForm = DailyTableForm.class$("com.novell.gw.jclient.application.printing.printingcalendar.printforms.DailyTableForm")) : class$com$novell$gw$jclient$application$printing$printingcalendar$printforms$DailyTableForm));
    private final int MAX_HOURS = 20;
    private final int LEFT_MARGIN = 80;
    private final int WGAP = 5;
    private int labelHeight = 32;
    int quarterHourH = this.labelHeight / 4;
    BasicStroke halfHourLine = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{20.0f, 5.0f}, 0.0f);
    BasicStroke hourLine = new BasicStroke(1.0f);
    private final int quarterTickWidth = 8;
    private HashMap hmAppointments;
    private HashMap hmAppointmentsCopy;
    private int columnSize;
    private int columnSizeCopy;
    private HashMap hmPrintApp;
    private HashMap hmPrintAppCopy;
    private DailyView dailyViewNew;
    private Color colorNotWorking = new Color(240, 240, 240);
    private Color colorAppointment = new Color(225, 225, 225);
    private static float SUBJECT_FONT_SIZE = 8.0f;
    private boolean isTablePrintingAppointmentsFinished = true;
    private boolean isTablePrintingAppointmentsFinishedCopy = true;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$printing$printingcalendar$printforms$DailyTableForm;

    public DailyTableForm(MVCController mVCController) {
        super(mVCController);
        this.dailyViewNew = new DailyView(GWCalendarUtils.getToday(), new TypesToggle("CALENDAR", true, true, true), this.getController());
        this.dailyViewNew.setFolder(this.getFolder());
    }

    protected void beforePrintNewDay() {
        super.beforePrintNewDay();
        this.isTablePrintingAppointmentsFinished = false;
        this.hmPrintApp.clear();
        this.dailyViewNew.setMVCModel(this.gcDay.getTime());
        this.hmAppointments = this.dailyViewNew.getAppointmentHashMap();
        this.columnSize = this.dailyViewNew.getAppointmentsColumns();
        if (this.columnSize == 0) {
            this.columnSize = 1;
        }
    }

    public void onPrintBegin() {
        super.onPrintBegin();
        this.isTablePrintingAppointmentsFinished = true;
    }

    protected int getStartAppointments() {
        return 8;
    }

    private int getEndAppointments() {
        return 19;
    }

    protected void refreshPrint(int n) {
        super.refreshPrint(n);
        if (n > this.dayPageIndex) {
            this.isTablePrintingAppointmentsFinishedCopy = this.isTablePrintingAppointmentsFinished;
        } else {
            this.isTablePrintingAppointmentsFinished = this.isTablePrintingAppointmentsFinishedCopy;
        }
        if (this.isPriningNewPage) {
            this.hmAppointmentsCopy = (HashMap)this.hmAppointments.clone();
            this.hmPrintAppCopy = (HashMap)this.hmPrintApp.clone();
            this.columnSizeCopy = this.columnSize;
        } else {
            this.hmAppointments = (HashMap)this.hmAppointmentsCopy.clone();
            this.hmPrintApp = (HashMap)this.hmPrintAppCopy.clone();
            this.columnSize = this.columnSizeCopy;
        }
    }

    protected boolean printAppointments(Graphics graphics) {
        if (this.isPrintingAppointmentsFinished) {
            return false;
        }
        if (!this.isTablePrintingAppointmentsFinished) {
            int n = this.printingY;
            int n2 = this.pageHeight - this.commonHeaderH;
            if (n + this.labelHeight * 3 > n2) {
                this.printingY = 0;
                return true;
            }
            this.printTableAppointments(graphics, n, n2);
        }
        IDObjectsCollection iDObjectsCollection = this.getNonWorkingHoursAppointments();
        return this.printNotWorkHoursAppointments(graphics, iDObjectsCollection, (Graphics2D)graphics, StringResources.APPOINTMENTS_C);
    }

    private IDObjectsCollection getNonWorkingHoursAppointments() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.gcDay.clone();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar2.set(11, this.getStartAppointments());
        IDObjectsCollection iDObjectsCollection = GWCalendarUtils.getAppointments(this.getItemList(), this.gcDay.getTime());
        IDObjectsCollection iDObjectsCollection2 = GWCalendarUtils.getAppointmentsForTimeInterval(iDObjectsCollection, new TimeInterval(gregorianCalendar.getTime(), gregorianCalendar2.getTime()));
        gregorianCalendar.set(11, 20);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar2.set(11, 24);
        IDObjectsCollection iDObjectsCollection3 = GWCalendarUtils.getAppointmentsForTimeInterval(iDObjectsCollection, new TimeInterval(gregorianCalendar.getTime(), gregorianCalendar2.getTime()));
        iDObjectsCollection2.addCollection(iDObjectsCollection3);
        return iDObjectsCollection2;
    }

    private void printTableAppointments(Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.FNT_HEADER);
        graphics2D.setColor(Color.black);
        this.paintHeaderRow(graphics, StringResources.APPOINTMENTS_C, "", n);
        n += graphics.getFontMetrics().getHeight() + 5;
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        graphics.setFont(this.FNT_HEADER);
        Stroke stroke = graphics2D.getStroke();
        int n3 = graphics.getFontMetrics().getHeight() / 2 + 3;
        for (int i = this.firstAppointmentOnPage; i < 20; ++i) {
            gregorianCalendar.set(11, i);
            if (n + this.labelHeight > n2) {
                this.printingY = 0;
                break;
            }
            this.lastAppointmentOnPage = i;
            int n4 = n - n3;
            graphics2D.setColor(Color.black);
            int n5 = this.isLeftToRight ? 3 : this.pageWidth - 80 + 3;
            graphics.drawString(GWCalendarUtils.getTimeFormat().format(gregorianCalendar.getTime()), n5, n + 3);
            graphics2D.setColor(Color.gray);
            graphics2D.setStroke(this.hourLine);
            graphics2D.drawLine(0, n4, this.pageWidth, n4);
            n5 = this.isLeftToRight ? 80 : this.pageWidth - 80;
            graphics2D.drawLine(n5, n4, n5, n4 + this.labelHeight);
            n5 = this.isLeftToRight ? 80 - this.quarterTickWidth : this.pageWidth - this.quarterTickWidth;
            int n6 = this.isLeftToRight ? 80 : this.pageWidth;
            graphics2D.drawLine(n5, n4 + this.quarterHourH, n6, n4 + this.quarterHourH);
            graphics2D.drawLine(n5, n4 + this.quarterHourH * 2, n6, n4 + this.quarterHourH * 2);
            graphics2D.drawLine(n5, n4 + this.quarterHourH * 3, n6, n4 + this.quarterHourH * 3);
            graphics2D.setStroke(this.halfHourLine);
            n5 = this.isLeftToRight ? 80 : 0;
            n6 = this.isLeftToRight ? this.pageWidth : this.pageWidth - 80;
            graphics2D.drawLine(n5, n4 + this.labelHeight / 2, n6, n4 + this.labelHeight / 2);
            graphics2D.setStroke(stroke);
            this.printAppointmentsTable(graphics, i, n4);
            n += this.labelHeight;
        }
        graphics2D.setStroke(this.hourLine);
        graphics2D.drawLine(0, n - n3, this.pageWidth, n - n3);
        graphics2D.setStroke(stroke);
        this.printingY = n + 5;
        if (this.lastAppointmentOnPage >= this.getEndAppointments()) {
            this.isTablePrintingAppointmentsFinished = true;
            this.firstAppointmentOnPage = 0;
            this.lastAppointmentOnPage = -1;
        }
        this.printingY = n + 10;
        graphics2D.setColor(Color.black);
    }

    private boolean printNotWorkHoursAppointments(Graphics graphics, IDObjectsCollection iDObjectsCollection, Graphics2D graphics2D, String string) {
        if (!this.isTablePrintingAppointmentsFinished) {
            return true;
        }
        if (this.isPrintingAppointmentsFinished) {
            return true;
        }
        graphics.setFont(this.FNT_HEADER);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = this.printingY;
        int n3 = this.pageHeight - this.commonHeaderH;
        if (n2 + n * 3 > n3) {
            this.printingY = 0;
            return true;
        }
        n2 = this.printAppointmentsHeader(graphics, n2, graphics.getFontMetrics().getHeight(), string);
        this.printAppointmentsCollection(iDObjectsCollection, ++n2, graphics.getFontMetrics().getHeight(), n3, graphics);
        graphics2D.setColor(Color.black);
        return true;
    }

    private void printAppointmentsTable(Graphics graphics, int n, int n2) {
        this.prepareAppointmentsPrintingMap(n);
        int n3 = (this.pageWidth - 80 - 5) / this.columnSize - 5;
        for (int i = n * 4; i < n * 4 + 4; ++i) {
            int n4 = n2 + (i - n * 4) * this.quarterHourH;
            for (int j = 0; j < this.columnSize; ++j) {
                int n5 = i * 100 + j + 1;
                AppPrintParam appPrintParam = (AppPrintParam)this.hmPrintApp.get(new Integer(n5));
                if (appPrintParam == null) continue;
                int n6 = this.isLeftToRight ? 80 : 0;
                graphics.setColor(this.colorAppointment);
                graphics.fillRect((n6 += 5 + j * (n3 + 5)) + 1, n4, n3 - 1, this.quarterHourH);
                graphics.setColor(Color.black);
                graphics.drawLine(n6, n4, n6, n4 + this.quarterHourH);
                graphics.drawLine(n6 + n3, n4, n6 + n3, n4 + this.quarterHourH);
                graphics.drawLine(n6 + n3 + 1, n4, n6 + n3 + 1, n4 + this.quarterHourH);
                if (appPrintParam.isFirst) {
                    graphics.drawLine(n6, n4, n6 + n3, n4);
                }
                if (appPrintParam.isLast) {
                    graphics.drawLine(n6, n4 + this.quarterHourH, n6 + n3, n4 + this.quarterHourH);
                }
                if (!appPrintParam.isSubjectPrinted) continue;
                this.printSubject(graphics, n6, n4, appPrintParam);
            }
        }
    }

    private void printSubject(Graphics graphics, int n, int n2, AppPrintParam appPrintParam) {
        int n3 = (this.pageWidth - 80 - 5) / this.columnSize - 5;
        Shape shape = graphics.getClip();
        Rectangle rectangle = new Rectangle(n + 5, n2 - this.labelHeight, n3 - 5, this.labelHeight * 2);
        graphics.setClip(rectangle);
        graphics.setFont(Utils.deriveFontForSize(this.FNT_PLAIN, SUBJECT_FONT_SIZE));
        int n4 = n2;
        if (appPrintParam.getGridHeigth() == 1 || appPrintParam.getGridHeigth() == 2) {
            n4 += this.quarterHourH - graphics.getFontMetrics().getDescent();
        }
        graphics.drawString(appPrintParam.item.getSubject() == null ? "" : appPrintParam.item.getSubject(), n + 5, n4);
        graphics.setClip(shape);
        graphics.setFont(this.FNT_PLAIN);
    }

    private void prepareAppointmentsPrintingMap(int n) {
        for (int i = n * 4; i < n * 4 + 4; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                int n2 = i * 100 + j + 1;
                AppointmentParam appointmentParam = (AppointmentParam)this.hmAppointments.get(new Integer(n2));
                if (appointmentParam == null) continue;
                int n3 = appointmentParam.getGridHeigh();
                int n4 = 0;
                n4 = n3 == 1 || n3 == 2 ? n3 - 1 : (n3 == 3 ? 2 : n3 / 2);
                for (int k = 0; k < n3; ++k) {
                    AppPrintParam appPrintParam = new AppPrintParam(appointmentParam.getAppointmentItem());
                    if (k == 0) {
                        appPrintParam.isFirst = true;
                    }
                    if (k == n3 - 1) {
                        appPrintParam.isLast = true;
                    }
                    if (k == n4) {
                        appPrintParam.isSubjectPrinted = true;
                    }
                    appPrintParam.setGridHeigth(n3);
                    this.hmPrintApp.put(new Integer(n2 + k * 100), appPrintParam);
                }
            }
        }
    }

    public String toString() {
        return StringResources.CALENDAR_PRINT_TABLE_AND_LIST;
    }

    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_DAILY_TABLE;
    }

    public void setMVCModel(Object object) {
        super.setMVCModel(object);
        if (object instanceof GregorianCalendar) {
            this.dailyViewNew.setMVCModel(((GregorianCalendar)object).getTime());
        }
        this.hmPrintApp = new HashMap();
        this.hmAppointments = new HashMap();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AppPrintParam {
        AbstractItem item;
        boolean isFirst = false;
        boolean isLast = false;
        boolean isSubjectPrinted = false;
        private int gridHeigth = 0;

        public AppPrintParam(AbstractItem abstractItem, boolean bl, boolean bl2) {
            this.item = abstractItem;
            this.isFirst = bl;
            this.isLast = bl2;
        }

        public AppPrintParam(AbstractItem abstractItem) {
            this(abstractItem, false, false);
        }

        public int getGridHeigth() {
            return this.gridHeigth;
        }

        public void setGridHeigth(int n) {
            this.gridHeigth = n;
        }
    }
}

