/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingitem;

import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.printing.BasicPrintManager;
import com.novell.gw.jclient.application.printing.basicforms.GWItemForm;
import com.novell.gw.jclient.application.printing.basicforms.HTMLAttachmentPrintForm;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.basicforms.TextPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.ItemChecksPanel;
import com.novell.gw.jclient.application.printing.printingitem.ItemPrintManagerController;
import com.novell.gw.jclient.application.printing.printingitem.printforms.AppointmentForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.AttachmentPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.GWItemHTMLPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.GWItemPropertiesHTMLPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.MailForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.PhoneForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.ReminderNoteForm;
import com.novell.gw.jclient.application.printing.printingitem.printforms.TaskForm;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ItemPrintManager
extends BasicPrintManager {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$printing$printingitem$ItemPrintManager == null ? (class$com$novell$gw$jclient$application$printing$printingitem$ItemPrintManager = ItemPrintManager.class$("com.novell.gw.jclient.application.printing.printingitem.ItemPrintManager")) : class$com$novell$gw$jclient$application$printing$printingitem$ItemPrintManager));
    private AbstractItem item;
    private Object selectedAttachment;
    private ItemChecksPanel itemChecksPanel;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$printing$printingitem$ItemPrintManager;

    public ItemPrintManager(MVCController mVCController) {
        this(mVCController, null);
    }

    public ItemPrintManager(MVCController mVCController, Object object) {
        this(mVCController, object, false);
    }

    public ItemPrintManager(MVCController mVCController, Object object, boolean bl) {
        this.setController(new ItemPrintManagerController(this, mVCController));
        this.selectedAttachment = object;
        this.setPropertiesSelected(bl);
        this.buildUI();
    }

    private void buildUI() {
        this.buildSelectionPanel();
        this.buildContentPanel();
        this.lstPrintingItems.addListSelectionListener(new LstPrintingItemsChanged());
        this.lstPrintingForms.addListSelectionListener(new LstPrintingFormsChanged());
    }

    protected void buildContentPanel() {
        this.itemChecksPanel = new ItemChecksPanel(this.getController());
        this.add(StringResources.CONTENTS, this.itemChecksPanel);
    }

    private void refreshSelectionPanel() {
        this.vPrintingItems = this.getPrintItems(this.item);
        this.lstPrintingItems.setListData(this.vPrintingItems);
        if (this.selectedAttachment != null) {
            this.lstPrintingItems.setSelectedValue(this.selectedAttachment, true);
        }
        if (this.lstPrintingItems.getSelectedIndex() == -1) {
            this.lstPrintingItems.setSelectedIndex(0);
        }
        this.lstPrintingForms.setListData(this.getPrintForms(this.lstPrintingItems.getSelectedValue()));
        this.lstPrintingForms.setSelectedIndex(0);
        this.pnlListSelection.validate();
    }

    private Vector getPrintItems(AbstractItem abstractItem) {
        Vector<IdentifiedObject> vector = new Vector<IdentifiedObject>();
        if (abstractItem == null) {
            return vector;
        }
        vector.add(abstractItem);
        if (this.propertiesSelected) {
            return vector;
        }
        if (abstractItem.getAttachments() == null) {
            return vector;
        }
        int n = abstractItem.getAttachments().size();
        for (int i = 0; i < n; ++i) {
            GWAttachment gWAttachment = (GWAttachment)abstractItem.getAttachments().getIDObjectAt(i);
            if (gWAttachment.isSystemAttachment()) continue;
            if (gWAttachment.isMessageAttachment()) {
                AbstractItem abstractItem2 = null;
                try {
                    String string = ControlsUtils.getUserGuid(this.controller);
                    abstractItem2 = GWCommandManager.getInstance(string).getEnclosedItem(gWAttachment);
                    vector.add(abstractItem2);
                }
                catch (GWCommandException gWCommandException) {
                    logger.error((Object)gWCommandException, (Throwable)gWCommandException);
                    ErrorDialog.processGWException(gWCommandException, this);
                }
                continue;
            }
            vector.add(gWAttachment);
        }
        return vector;
    }

    public Vector getPrintForms(Object object) {
        if (object instanceof AbstractItem) {
            if (this.propertiesSelected) {
                Vector<GWItemPropertiesHTMLPrintForm> vector = new Vector<GWItemPropertiesHTMLPrintForm>();
                vector.add(new GWItemPropertiesHTMLPrintForm((AbstractItem)object, this.itemChecksPanel, ControlsUtils.getUserGuid(this.controller)));
                return vector;
            }
            return this.getGWItemPrintForms((AbstractItem)object);
        }
        if (object instanceof GWAttachment) {
            Vector<PrintForm> vector;
            block12: {
                vector = new Vector<PrintForm>();
                GWAttachment gWAttachment = (GWAttachment)object;
                try {
                    File file = ControlsUtils.getAttachmentFilePath(gWAttachment);
                    if (!file.exists()) {
                        GWEngineUtils.saveAttachment(gWAttachment, file.getAbsolutePath());
                    }
                    String string = Utils.getExtention(gWAttachment.getFileName());
                    String string2 = ControlsUtils.getUserGuid(this.controller);
                    if (ControlsUtils.isHTML(string)) {
                        vector.add(new HTMLAttachmentPrintForm(file.toURL(), this.itemChecksPanel, string2));
                        break block12;
                    }
                    if (ControlsUtils.isText(string)) {
                        String string3 = "";
                        try {
                            int n;
                            FileReader fileReader = new FileReader(file);
                            while ((n = fileReader.read()) != -1) {
                                string3 = string3 + (char)n;
                            }
                        }
                        catch (IOException iOException) {
                            logger.error((Object)StringResources.ERROR_WHILE_READING_ATTACHMENT_FILE, (Throwable)iOException);
                        }
                        vector.add(new TextPrintForm(string3, this.itemChecksPanel, string2));
                        break block12;
                    }
                    vector.add(new AttachmentPrintForm(gWAttachment.getFileName(), this.getController(), this.itemChecksPanel));
                }
                catch (GWCommandException gWCommandException) {
                    logger.error((Object)gWCommandException, (Throwable)gWCommandException);
                    ErrorDialog.processGWException(gWCommandException);
                }
                catch (MalformedURLException malformedURLException) {
                    logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                }
            }
            return vector;
        }
        return new Vector();
    }

    private Vector getGWItemPrintForms(AbstractItem abstractItem) {
        Vector<Object> vector = new Vector<Object>();
        String string = abstractItem.getMessage().getMessage();
        if (abstractItem.isHTMLMessage() || string.indexOf("<body") >= 0) {
            String string2 = ControlsUtils.getUserGuid(this.controller);
            vector.add(new GWItemHTMLPrintForm(abstractItem, this.itemChecksPanel, string2));
            return vector;
        }
        if (abstractItem instanceof AppointmentItem) {
            AppointmentForm appointmentForm = new AppointmentForm((AppointmentItem)abstractItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            appointmentForm.setMVCModel(this.itemChecksPanel);
            vector.add(appointmentForm);
            appointmentForm = new AppointmentForm((AppointmentItem)abstractItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            appointmentForm.setMVCModel(this.itemChecksPanel);
            vector.add(appointmentForm);
            return vector;
        }
        if (abstractItem instanceof TaskItem) {
            TaskForm taskForm = new TaskForm((TaskItem)abstractItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            taskForm.setMVCModel(this.itemChecksPanel);
            vector.add(taskForm);
            taskForm = new TaskForm((TaskItem)abstractItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            taskForm.setMVCModel(this.itemChecksPanel);
            vector.add(taskForm);
            return vector;
        }
        if (abstractItem instanceof ReminderNote) {
            ReminderNoteForm reminderNoteForm = new ReminderNoteForm((ReminderNote)abstractItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            reminderNoteForm.setMVCModel(this.itemChecksPanel);
            vector.add(reminderNoteForm);
            reminderNoteForm = new ReminderNoteForm((ReminderNote)abstractItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            reminderNoteForm.setMVCModel(this.itemChecksPanel);
            vector.add(reminderNoteForm);
            return vector;
        }
        if (abstractItem instanceof MailItem) {
            MailForm mailForm = new MailForm((MailItem)abstractItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            mailForm.setMVCModel(this.itemChecksPanel);
            vector.add(mailForm);
            mailForm = new MailForm((MailItem)abstractItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            mailForm.setMVCModel(this.itemChecksPanel);
            vector.add(mailForm);
            return vector;
        }
        if (abstractItem.isPersonal()) {
            vector.add(StringResources.NO_PRINT_FORMS_AVAILABLE);
            return vector;
        }
        if (abstractItem instanceof PhoneItem) {
            PhoneForm phoneForm = new PhoneForm((PhoneItem)abstractItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, this.getController());
            phoneForm.setMVCModel(this.itemChecksPanel);
            vector.add(phoneForm);
            phoneForm = new PhoneForm((PhoneItem)abstractItem, GWItemForm.PRINT_ATTACHMENT_LIST, this.getController());
            phoneForm.setMVCModel(this.itemChecksPanel);
            vector.add(phoneForm);
            return vector;
        }
        vector.add(StringResources.NO_PRINT_FORMS_AVAILABLE);
        return vector;
    }

    public void setMVCModel(Object object) {
        if (object instanceof AbstractItem) {
            this.item = (AbstractItem)object;
            this.refreshSelectionPanel();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LstPrintingFormsChanged
    implements ListSelectionListener {
        LstPrintingFormsChanged() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!(ItemPrintManager.this.lstPrintingForms.getSelectedValue() instanceof PrintForm)) {
                Command command = new Command(290, null);
                ItemPrintManager.this.getController().processCommand(command);
                return;
            }
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ItemPrintManager.this.selectedForm = (PrintForm)ItemPrintManager.this.lstPrintingForms.getSelectedValue();
                Command command = new Command(290);
                if (ItemPrintManager.this.selectedForm != null) {
                    ItemPrintManager.this.lbPreview.setIcon(ItemPrintManager.this.selectedForm.getIcon());
                    command.setCommandObject(ItemPrintManager.this.selectedForm);
                } else {
                    ItemPrintManager.this.lbPreview.setIcon(null);
                }
                ItemPrintManager.this.getController().processCommand(command);
            }
        }
    }

    class LstPrintingItemsChanged
    implements ListSelectionListener {
        LstPrintingItemsChanged() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Object e = ItemPrintManager.this.lstPrintingItems.getSelectedValue();
                Vector vector = ItemPrintManager.this.getPrintForms(e);
                ItemPrintManager.this.lstPrintingForms.setListData(vector);
                if (vector.size() == 0) {
                    ItemPrintManager.this.lbPreview.setIcon(null);
                } else {
                    ItemPrintManager.this.lstPrintingForms.setSelectedIndex(0);
                }
            }
        }
    }
}

