/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl.utils;

import com.novell.gw.engine.DisplayColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.APIUtils;
import com.novell.gw.jclient.bl.eng_impl.utils.SortOrder;
import java.io.Serializable;

public final class ColumnInfo
implements Cloneable,
Serializable {
    private transient DisplayColumnInfo nativeColumnInfo;

    public ColumnInfo(String string, int n, boolean bl, int n2, int n3) {
        this.nativeColumnInfo = new DisplayColumnInfo(string, n, n3, n2);
        this.setSorted(bl);
    }

    public ColumnInfo(DisplayColumnInfo displayColumnInfo) {
        this.nativeColumnInfo = displayColumnInfo;
    }

    public DisplayColumnInfo getNativeColumnInfo() {
        return this.nativeColumnInfo;
    }

    public String getName() {
        return this.nativeColumnInfo.getName();
    }

    public int getFieldID() {
        return this.nativeColumnInfo.getFieldID();
    }

    public boolean isSorted() {
        return this.nativeColumnInfo.isSorted();
    }

    public boolean isSortedAscending() {
        return this.isSorted() && this.getSortOrder() == SortOrder.ASCENDING;
    }

    public boolean isSortedDescending() {
        return this.isSorted() && this.getSortOrder() == SortOrder.DESCENDING;
    }

    public SortOrder getSortOrder() {
        return APIUtils.getSortOrder(this.nativeColumnInfo.getSortOption());
    }

    public int getWidth() {
        return this.nativeColumnInfo.getWidth();
    }

    public void setWidth(int n) {
        this.nativeColumnInfo.setWidth(n);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ColumnInfo && this.doEquals((ColumnInfo)object);
    }

    private boolean doEquals(ColumnInfo columnInfo) {
        return this.getFieldID() == columnInfo.getFieldID() && this.isSorted() == columnInfo.isSorted() && this.getName().equals(columnInfo.getName()) && this.getSortOrder().equals(columnInfo.getSortOrder()) && this.getWidth() == columnInfo.getWidth();
    }

    public String toString() {
        return this.getName();
    }

    public void setSorted(boolean bl) {
        if (bl && !this.nativeColumnInfo.isSorted()) {
            this.nativeColumnInfo.setSortOption(16);
        } else if (!bl && this.nativeColumnInfo.isSorted()) {
            this.nativeColumnInfo.setSortOption(28);
        }
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.nativeColumnInfo.setSortOption(sortOrder.getID());
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnInfo columnInfo = (ColumnInfo)super.clone();
        columnInfo.nativeColumnInfo = new DisplayColumnInfo(this.nativeColumnInfo.getName(), this.nativeColumnInfo.getFieldID(), this.nativeColumnInfo.getWidth(), this.nativeColumnInfo.getSortOption());
        return columnInfo;
    }
}

