/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;

public class StreamHandler {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$impl$StreamHandler == null ? (class$com$novell$gw$jclient$bl$impl$StreamHandler = StreamHandler.class$("com.novell.gw.jclient.bl.impl.StreamHandler")) : class$com$novell$gw$jclient$bl$impl$StreamHandler));
    private CopyObservable copyObservable;
    private boolean useNotification;
    private static final int BUFFER_SIZE = 1024;
    private static StreamHandlerLocal streamHandlerLocal = new StreamHandlerLocal();
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$impl$StreamHandler;

    private StreamHandler(boolean bl) {
        this.useNotification = bl;
        this.copyObservable = new CopyObservable();
    }

    private void setUseNotification(boolean bl) {
        this.useNotification = bl;
    }

    public static synchronized StreamHandler getInstance() {
        return StreamHandler.getInstance(false);
    }

    public static synchronized StreamHandler getInstance(boolean bl) {
        return streamHandlerLocal.get(bl);
    }

    public synchronized void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null || outputStream == null) {
            throw new NullPointerException("Streams cann't be null.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        int n = 0;
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            this.notifyCopyProgress(n);
        }
        outputStream.flush();
        outputStream.close();
        bufferedInputStream.close();
    }

    public synchronized byte[] getStreamData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        this.copyStream(inputStream, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray == null ? new byte[]{} : byArray;
    }

    public synchronized void addCopyListener(CopyProgressListener copyProgressListener) {
        this.copyObservable.addObserver(copyProgressListener);
    }

    public synchronized void removeCopyListener(CopyProgressListener copyProgressListener) {
        this.copyObservable.deleteObserver(copyProgressListener);
    }

    private void notifyCopyProgress(int n) {
        if (this.useNotification) {
            this.copyObservable.notifyObservers(new Integer(n));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class StreamHandlerLocal
    extends ThreadLocal {
        private StreamHandlerLocal() {
        }

        protected synchronized Object initialValue() {
            return new StreamHandler(false);
        }

        public StreamHandler get(boolean bl) {
            StreamHandler streamHandler = (StreamHandler)super.get();
            streamHandler.setUseNotification(bl);
            return streamHandler;
        }
    }

    private class CopyObservable
    extends Observable {
        private CopyObservable() {
        }

        public void notifyObservers(Integer n) {
            this.setChanged();
            super.notifyObservers(n);
            this.setChanged();
        }
    }

    public static interface CopyProgressListener
    extends Observer {
    }
}

