/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.message.Message;
import com.novell.gw.message.Note;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public abstract class AbstractCalendarItem
extends AbstractItem {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$om$items$AbstractCalendarItem == null ? (class$com$novell$gw$jclient$bl$om$items$AbstractCalendarItem = AbstractCalendarItem.class$("com.novell.gw.jclient.bl.om.items.AbstractCalendarItem")) : class$com$novell$gw$jclient$bl$om$items$AbstractCalendarItem));
    protected ArrayList startDates;
    protected GregorianCalendar endDate;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$AbstractCalendarItem;

    protected AbstractCalendarItem(Note note) {
        super((Message)note);
        this.endDate = GWCalendarUtils.getToday();
        this.startDates = new ArrayList();
        this.startDates.add(this.endDate.clone());
    }

    protected AbstractCalendarItem() {
    }

    public boolean isRecurring() {
        return ((Note)this.nativeItem).isAutodate();
    }

    public Date[] getStartDates() {
        GregorianCalendar[] gregorianCalendarArray = new GregorianCalendar[this.startDates.size()];
        return GWCalendarUtils.CalendarToDate(this.startDates.toArray(gregorianCalendarArray));
    }

    public Date getEndDate() {
        return this.endDate.getTime();
    }

    public boolean isAccepted() {
        return ((Note)this.nativeItem).isAccepted();
    }

    public boolean hasAlarm() {
        return this.nativeItem.hasAlarm();
    }

    public void changeTimeStart(int n) {
        for (int i = 0; i < this.startDates.size(); ++i) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.startDates.get(i);
            this.getChangedTimeOnly(gregorianCalendar, n);
        }
    }

    public void changeTimeEnd(int n) {
        this.getChangedTimeOnly(this.endDate, n);
    }

    private void getChangedTimeOnly(GregorianCalendar gregorianCalendar, int n) {
        gregorianCalendar.set(11, n / 60);
        gregorianCalendar.set(12, n % 60);
    }

    public void setStartDates(Date[] dateArray) {
        this.startDates.clear();
        for (int i = 0; i < dateArray.length; ++i) {
            Date date = dateArray[i];
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
            gregorianCalendar.setTime(date);
            this.startDates.add(gregorianCalendar);
        }
    }

    public void setEndDate(Date date) {
        this.endDate.setTime(date);
    }

    public boolean isInTimeInterval(TimeInterval timeInterval) {
        long l = this.getStartDate().getTime();
        long l2 = this.getEndDate().getTime();
        TimeInterval timeInterval2 = new TimeInterval(l, l2);
        if (this instanceof TaskItem) {
            if (timeInterval.getEndDate() < l || timeInterval.getStartDate() > l + 60000L) {
                return false;
            }
        } else {
            if (this instanceof AppointmentItem) {
                return timeInterval.hasIntersectionWith(timeInterval2);
            }
            if (timeInterval.getEndDate() < l || timeInterval.getStartDate() > l + 60000L) {
                return false;
            }
        }
        return true;
    }

    public Date getStartDate() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.startDates.get(0);
        return gregorianCalendar.getTime();
    }

    public void setComposeItemSendOptions(ComposeItemSendOptions composeItemSendOptions) {
        super.setComposeItemSendOptions(composeItemSendOptions);
        if (composeItemSendOptions != null) {
            ((Note)this.nativeItem).setNotifyWhenAccepted(composeItemSendOptions.getRNWhenAccept().getValue());
            ((Note)this.nativeItem).setNotifyWhenDeclined(composeItemSendOptions.getRNWhenDeclined().getValue());
        }
    }

    public ComposeItemSendOptions getComposeItemSendOptions(ComposeItemSendOptions composeItemSendOptions) {
        if ((composeItemSendOptions = super.getComposeItemSendOptions(composeItemSendOptions)) != null && this.getNativeItem() instanceof Note) {
            composeItemSendOptions.setRNWhenAccept(this.getNotification(((Note)this.nativeItem).getNotifyWhenAccepted()));
            composeItemSendOptions.setRNWhenDeclined(this.getNotification(((Note)this.nativeItem).getNotifyWhenDeclined()));
        }
        return composeItemSendOptions;
    }

    public long getDuration() {
        return this.endDate.getTime().getTime() - this.getStartDate().getTime();
    }

    public void changeDuration(int n) {
        this.endDate.add(12, n);
    }

    public boolean accept() {
        return ((Note)this.nativeItem).accept(0);
    }

    public boolean accept(String string) {
        return ((Note)this.nativeItem).accept(string, 0);
    }

    public boolean decline() {
        return ((Note)this.nativeItem).decline(0);
    }

    public boolean decline(String string) {
        return ((Note)this.nativeItem).decline(string, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

