/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.store;

import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.util.Date;

public class GWItemFormatSerializer {
    private static String NEW_LINE = Utils.LINE_SEPARATOR;
    private static String BOLD_START = "<b>";
    private static String BOLD_END = "</b>";
    protected AbstractItem theItem;
    protected String theMessage;

    public GWItemFormatSerializer(AbstractItem abstractItem) {
        this.theItem = abstractItem;
    }

    protected void save(String string) throws GWException {
        this.theMessage = this.getItemHeader(this.theItem, true);
        if (this.theItem.getMessage() != null) {
            this.theMessage = this.theMessage + (this.theItem.getMessage().getMessage() == null ? "" : this.theItem.getMessage().getMessage());
        }
    }

    protected String addTitleValue(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            stringBuffer.append(BOLD_START);
            stringBuffer.append(string);
            stringBuffer.append(BOLD_END);
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(' ');
            stringBuffer.append(BOLD_START);
            stringBuffer.append(string);
            stringBuffer.append(BOLD_END);
        }
        return stringBuffer.toString();
    }

    private String parsePhoneItem(String string, String string2) {
        if (string.indexOf(string2) > -1) {
            return "[X] " + string2;
        }
        return "[ ] " + string2;
    }

    public String getItemHeader(AbstractItem abstractItem, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (abstractItem instanceof AppointmentItem) {
            AppointmentItem appointmentItem = (AppointmentItem)abstractItem;
            stringBuffer.append(this.addTitleValue(StringResources.ITEM_TYPE_C, StringResources.APPOINTMENT));
            stringBuffer.append(NEW_LINE);
            if (bl) {
                String string = appointmentItem.getDate() == null ? "" : GWCalendarUtils.getDateTimeFormat().format(appointmentItem.getDate());
                stringBuffer.append(this.addTitleValue(StringResources.START_DATE_C, string));
                stringBuffer.append(NEW_LINE);
                long l = appointmentItem.getDuration() / 60000L;
                long l2 = appointmentItem.getDuration() % 60000L;
                String string2 = this.addTitleValue(StringResources.HOUR_S, Long.toString(l));
                String string3 = this.addTitleValue(StringResources.MINUTES, Long.toString(l2));
                String string4 = this.addTitleValue(string2, string3);
                stringBuffer.append(this.addTitleValue(StringResources.DURATION_C, string4));
                stringBuffer.append(NEW_LINE);
            }
            stringBuffer.append(this.addTitleValue(StringResources.PLACE_C, appointmentItem.getLocation()));
        } else if (abstractItem instanceof TaskItem) {
            TaskItem taskItem = (TaskItem)abstractItem;
            stringBuffer.append(this.addTitleValue(StringResources.ITEM_TYPE_C, StringResources.TASK));
            stringBuffer.append(NEW_LINE);
            if (bl) {
                String string = GWCalendarUtils.getDateFormat().format(new Date(taskItem.getDateTaskAssigned()));
                stringBuffer.append(this.addTitleValue(StringResources.START_DATE_C, string));
                stringBuffer.append(NEW_LINE);
                String string5 = taskItem.getEndDate() == null ? "" : GWCalendarUtils.getDateFormat().format(taskItem.getEndDate());
                stringBuffer.append(this.addTitleValue(StringResources.DUE_C, string5));
                stringBuffer.append(NEW_LINE);
            }
            stringBuffer.append(this.addTitleValue(StringResources.PRIORITY_C, Integer.toString(taskItem.getPriority())));
            stringBuffer.append(NEW_LINE);
        } else if (abstractItem instanceof ReminderNote) {
            ReminderNote reminderNote = (ReminderNote)abstractItem;
            stringBuffer.append(this.addTitleValue(StringResources.ITEM_TYPE_C, StringResources.REMINDERNOTE));
            stringBuffer.append(NEW_LINE);
            if (bl) {
                String string = reminderNote.getDate() == null ? "" : GWCalendarUtils.getDateTimeFormat().format(reminderNote.getDate());
                stringBuffer.append(this.addTitleValue(StringResources.DATE_C, string));
                stringBuffer.append(NEW_LINE);
            }
        } else if (abstractItem instanceof PhoneItem) {
            PhoneItem phoneItem = (PhoneItem)abstractItem;
            stringBuffer.append(this.addTitleValue(StringResources.ITEM_TYPE_C, StringResources.PHONE));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(this.addTitleValue(StringResources.CALLER_C, phoneItem.getCaller()));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(this.addTitleValue(StringResources.COMPANY_C, phoneItem.getCompany()));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(this.addTitleValue(StringResources.PHONE_C, phoneItem.getPhone()));
            stringBuffer.append(NEW_LINE);
            String string = phoneItem.getSubject() == null ? "" : phoneItem.getSubject();
            stringBuffer.append(this.parsePhoneItem(string, StringResources.TELEPHONED) + NEW_LINE);
            stringBuffer.append(this.parsePhoneItem(string, StringResources.WILL_CALL_AGAIN) + NEW_LINE);
            stringBuffer.append(this.parsePhoneItem(string, StringResources.WANTS_TO_SEE_YOU) + NEW_LINE);
            stringBuffer.append(this.parsePhoneItem(string, StringResources.URGENT) + NEW_LINE);
            stringBuffer.append(this.parsePhoneItem(string, StringResources.PLEASE_CALL) + NEW_LINE);
            stringBuffer.append(this.parsePhoneItem(string, StringResources.RETURNED_YOUR_CALL) + NEW_LINE);
            stringBuffer.append(this.parsePhoneItem(string, StringResources.CAME_TO_SEE_YOU) + NEW_LINE);
        } else if (!(abstractItem instanceof MailItem) && abstractItem.isPersonal()) {
            String string = this.addTitleValue(StringResources.POSTED, abstractItem.getType());
            stringBuffer.append(this.addTitleValue(StringResources.ITEM_TYPE_C, string));
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(NEW_LINE);
        return stringBuffer.toString();
    }

    public String getAdditionalItemHeader(AbstractItem abstractItem, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            string = abstractItem.getSender().getDisplayText() == null ? "" : abstractItem.getSender().getDisplayText();
            stringBuffer.append(this.addTitleValue(StringResources.FROM_C, string));
            stringBuffer.append(NEW_LINE);
        }
        if (bl2) {
            String string2;
            string = abstractItem.getTo() == null ? "" : abstractItem.getTo();
            stringBuffer.append(this.addTitleValue(StringResources.TO_C, string));
            stringBuffer.append(NEW_LINE);
            String string3 = string2 = abstractItem.getCc() == null ? "" : abstractItem.getCc();
            if (!"".equals(string2)) {
                stringBuffer.append(this.addTitleValue(StringResources.CC_C, string2));
                stringBuffer.append(NEW_LINE);
            }
        }
        if (bl3) {
            string = abstractItem.getDate() == null ? "" : GWCalendarUtils.getDateTimeFormatWithDayOfWeek().format(abstractItem.getDate());
            stringBuffer.append(this.addTitleValue(StringResources.DATE_C, string));
            stringBuffer.append(NEW_LINE);
        }
        if (bl4) {
            string = abstractItem.getSubject() == null ? "" : abstractItem.getSubject();
            stringBuffer.append(this.addTitleValue(StringResources.SUBJECT_C, string));
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(NEW_LINE);
        return stringBuffer.toString();
    }
}

