/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.rmi.one_instance.server;

import com.novell.gw.jclient.application.options.RMISettings;
import com.novell.gw.jclient.rmi.one_instance.RMIException;
import com.novell.gw.jclient.rmi.one_instance.server.GWClientRMIImpl;
import java.net.ServerSocket;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.log4j.Logger;

public class GWClientRMIServer {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$rmi$one_instance$server$GWClientRMIServer == null ? (class$com$novell$gw$jclient$rmi$one_instance$server$GWClientRMIServer = GWClientRMIServer.class$("com.novell.gw.jclient.rmi.one_instance.server.GWClientRMIServer")) : class$com$novell$gw$jclient$rmi$one_instance$server$GWClientRMIServer));
    protected int port = 1099;
    boolean started = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$rmi$one_instance$server$GWClientRMIServer;

    public boolean initialise() throws RMIException {
        logger.debug((Object)"Try to load RMI Registry...");
        this.validateNotStartedState();
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            this.port = serverSocket.getLocalPort();
            serverSocket.close();
            logger.debug((Object)("Try to load rmiregistry on port: " + this.port));
            Registry registry = LocateRegistry.createRegistry(this.port);
            GWClientRMIImpl gWClientRMIImpl = new GWClientRMIImpl();
            logger.debug((Object)("Perform Bind..." + registry.list()));
            Naming.bind("//localhost:" + this.port + "/" + "GWClientRMIServer", gWClientRMIImpl);
            RMISettings.getInstance().storeRMIPort(this.port);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to initialize RMI server " + exception.getMessage()));
            return false;
        }
        this.started = true;
        return true;
    }

    public void validateNotStartedState() throws RMIException {
        if (this.isStarted()) {
            throw new RMIException("Sorry, but RMI server is already started");
        }
    }

    public void validateStartedState() throws RMIException {
        if (!this.isStarted()) {
            throw new RMIException("Sorry, but RMI server is not started");
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isStarted() {
        return this.started;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

