#!/usr/bin/env python
# -*- coding: utf-8 -*-
# 
# a system tray applet to watch the status of and stop and (re)start
# the Novell iprint listener.
#
# Author: A. Gebhardt <albrecht.gebhardt@uni-klu.ac.at>
#
# Code Copyright:
#
# GPL, please read /usr/share/common-licenses/GPL for more information.
#
# Icon Artwork: Copyright by Novell Inc.
# 
# modelled after GUInterfaces system tray applet from 
# Guillaume Duveau <guix_d-gnu@yahoo.fr>
#

import os
import subprocess
import sys
import gtk
import gobject
import pygtk

APPDIR="/usr/share/iprint"

def quit(widget, data = None):
	if data:
		data.set_visible(False)
	gtk.main_quit()

def popup_menu(widget, button, time, data = None):
	if button == 3:
		if data:
			data.show_all()
			data.popup(None, None, None, 3, time)
	pass

def about(widget, data = None):
	msgBox = gtk.MessageDialog(parent = None, buttons = gtk.BUTTONS_OK, 
                                   message_format = "iPrint Watchdog Applet by \n Albrecht Gebhardt <agebhard@uni-klu.ac.at>\n Use it to watch or fix status of the iprint-listener process.")
	msgBox.run()
	msgBox.destroy()

def restart(self):
	os.system(APPDIR + "/iprintman restart")

def stop(self):
	os.system(APPDIR + "/iprintman stop")
        menu_item_check.set_active(False)

def start(self):
	os.system(APPDIR + "/iprintman start")


		
def check():
        if menu_item_check.get_active():
                os.system(APPDIR + "/iprintman check")
        gobject.timeout_add(10000, check)

def update():
        try:
                p = subprocess.Popen([APPDIR + "/iprintman", "status"], stdout=subprocess.PIPE)
                output  = p.communicate()[0]
                retcode = p.returncode
                
        except OSError, e:
                print >>sys.stderr, "Execution failed:", e 



        if retcode:
                statusIcon.set_from_file(APPDIR + "/iprint-grey_32.png")
                menu_item_stop.set_sensitive(False)
                menu_item_start.set_sensitive(True)
                statusIcon.set_tooltip("iPrint Watchdog: Listener is " + output)
        else:
                statusIcon.set_from_file(APPDIR + "/iprint_32.png")
                menu_item_stop.set_sensitive(True)
                menu_item_start.set_sensitive(False)
                statusIcon.set_tooltip("iPrint Watchdog: Listener is " + output)

        gobject.timeout_add(1000, update)


statusIcon = gtk.StatusIcon()
menu = gtk.Menu()



#menu_item_start = gtk.ImageMenuItem(gtk.STOCK_START)
menu_item_start = gtk.MenuItem("Start")
menu_item_start.connect('activate', start)
menu.append(menu_item_start)

#menu_item_stop = gtk.ImageMenuItem(gtk.STOCK_STOP)
menu_item_stop = gtk.MenuItem("Stop")
menu_item_stop.connect('activate', stop)
menu_item_stop.set_sensitive(False)
menu.append(menu_item_stop)

#menu_item = gtk.ImageMenuItem(gtk.STOCK_REFRESH)
menu_item = gtk.MenuItem("Restart")
menu_item.connect('activate', restart)
menu.append(menu_item)

menu_item_check =  gtk.CheckMenuItem("Keep alive")
menu_item_check.set_active(True)
menu.append(menu_item_check)

menu_separator = gtk.MenuItem()
menu.append(menu_separator)
menuItem = gtk.ImageMenuItem(gtk.STOCK_ABOUT)
menuItem.connect('activate', about)
menu.append(menuItem)
menuItem = gtk.ImageMenuItem(gtk.STOCK_QUIT)
menuItem.connect('activate', quit, statusIcon)
menu.append(menuItem)
statusIcon.set_from_file(APPDIR + "/iprint_32.png")
statusIcon.set_tooltip("iPrint Watchdog")
statusIcon.connect('popup-menu', popup_menu, menu)
statusIcon.set_visible(True)


# timers in us
gobject.timeout_add(30000, check)
gobject.timeout_add(5000, update)

gtk.main() 



