/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.cnkjava;

import com.insightful.cnkjava.CNKObj;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Stack;
import java.util.TimeZone;

public class CNKSplusDateFormat {
    public static final String DEFAULT_DATE_PARSE_STRING = "%m[/][.]%d[/][,]%y [%H[:%M[:%S[.%N]]]] [%p]";
    public static final String DEFAULT_DATE_FORMAT_STRING = "%02m/%02d/%Y %02H:%02M:%02S";
    public static final int DEFAULT_CENTURY_CUTOFF = 1950;
    private static final String[] m_defaultAmPmStrings = new String[]{"AM", "PM"};
    private static final String[] m_defaultMonthStrings = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] m_defaultMonthAbbStrings = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] m_defaultWeekdayStrings = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] m_defaultWeekdayAbbStrings = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static CNKSplusDateFormat m_defaultParser = null;
    private static CNKSplusDateFormat m_defaultFormatter = null;
    private Calendar m_calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private Date m_date = new Date();
    private StringBuffer m_buf = new StringBuffer();
    private String m_format = "%m[/][.]%d[/][,]%y [%H[:%M[:%S[.%N]]]] [%p]";
    private int m_centuryCutoff = 1950;
    private String[] m_amPmStrings = m_defaultAmPmStrings;
    private String[] m_monthStrings = m_defaultMonthStrings;
    private String[] m_monthAbbStrings = m_defaultMonthAbbStrings;
    private String[] m_weekdayStrings = m_defaultWeekdayStrings;
    private String[] m_weekdayAbbStrings = m_defaultWeekdayAbbStrings;
    private String m_zoneString = null;
    private String m_zoneDSTString = null;
    private static Stack m_oneIntArrayCache;

    public static CNKSplusDateFormat getDefaultParser() {
        return m_defaultParser;
    }

    public static void setDefaultParser(CNKSplusDateFormat val) {
        m_defaultParser = val;
    }

    public static CNKSplusDateFormat getDefaultFormatter() {
        return m_defaultFormatter;
    }

    public static void setDefaultFormatter(CNKSplusDateFormat val) {
        m_defaultFormatter = val;
    }

    public static long defaultConvertStringToTimeDate(String str) {
        if (m_defaultParser == null) {
            return CNKObj.getTimeDateNA();
        }
        try {
            long td = m_defaultParser.convertStringToTimeDate(str);
            return td;
        }
        catch (Exception ex) {
            return CNKObj.getTimeDateNA();
        }
    }

    public static String defaultConvertTimeDateToString(long td) {
        if (m_defaultFormatter == null) {
            return CNKObj.getStringNA();
        }
        String str = m_defaultFormatter.convertTimeDateToString(td);
        return str;
    }

    public static String defaultConvertJulianDateToString(double jul) {
        if (m_defaultFormatter == null) {
            return CNKObj.getStringNA();
        }
        String str = m_defaultFormatter.convertJulianDateToString(jul);
        return str;
    }

    public static void main(String[] args) {
        String[] dateStrings = new String[]{"1/1/1900 00:00:00", "1/1/1900 03:03:03", "1/1/1900 15:15:15", "1/15/1900 00:00:00", "1/15/1900 03:03:03", "1/15/1900 15:15:15", "8/15/1900 00:00:00", "8/15/1900 03:03:03", "8/15/1900 15:15:15", "1/1/1935 00:00:00", "1/1/1935 03:03:03", "1/1/1935 15:15:15", "1/15/1935 00:00:00", "1/15/1935 03:03:03", "1/15/1935 15:15:15", "8/15/1935 00:00:00", "8/15/1935 03:03:03", "8/15/1935 15:15:15", "1/1/1995 00:00:00", "1/1/1995 03:03:03", "1/1/1995 15:15:15", "1/15/1995 00:00:00", "1/15/1995 03:03:03", "1/15/1995 15:15:15", "8/15/1995 00:00:00", "8/15/1995 03:03:03", "8/15/1995 15:15:15", "1/2/1923 3:45 pm", "1/2/1923 3:45pm", "1/2/1923 3:45pm ", "  1/2/1923 3:45:34.234    am ", "Jan 3 2003 13:54", "Jan 3 2003 13:54 pm", "Jan 3 2003 13:54 am", "Jan 3 2003 12 am", "Jan 3 2003 12 pm", "ja.3,65 1:23:45", "fe 3,65 1:23:45", "fe 30,65 1:23:45", "marchx 34", "march 3 23", "5/23/02 4:50pm", "5/24/02 4:50pm", "5/25/02 4:50pm", "5/26/02 4:50pm", "1/1/02", "3/31/02", "4/1/02", "7/1/02", "12/31/02", "5/23/02 12:30am", "5/23/02 1:30am", "5/23/02 12:30pm", "2/29/2007", "11/65/2007", "5/23/02 1:30pm", ""};
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.setLenient(false);
        dateFormat.setCalendar(cal);
        CNKSplusDateFormat fm = new CNKSplusDateFormat();
        fm.setFormat("[%m[/][.]%d[/][,]%y [%H[:%M[:%S[.%N]]]] [%p]]");
        CNKSplusDateFormat outfm = new CNKSplusDateFormat();
        outfm.setZoneString("SZ/DZ");
        outfm.setFormat("%02m/%02d/%Y %02H:%02M:%02S.%03N || a=%a,A=%A,b=%b,B=%B,C=%C,d=%d,D=%D,H=%H,I=%I,m=%m,M=%M,N=%N,p=%p,q=%q,Q=%Q,S=%S,y=%y,Y=%Y,z=%z,Z=%Z,%%,%4A,%1d");
        for (int i = 0; i < dateStrings.length; ++i) {
            long dt = fm.convertStringToTimeDate(dateStrings[i]);
            boolean ok = !CNKObj.isTimeDateNA(dt);
            System.out.print(dateStrings[i] + " -> ");
            if (!ok) {
                System.out.println("parse error");
                continue;
            }
            String outStr = dateFormat.format(new Date(dt));
            String cOut = outfm.convertTimeDateToString(dt);
            System.out.println(outStr + " -> " + (CNKObj.isStringNA(cOut) ? "err" : cOut));
        }
    }

    public CNKSplusDateFormat() {
        this.m_calendar.setLenient(false);
    }

    public CNKSplusDateFormat(String format) {
        this.m_calendar.setLenient(false);
        this.m_format = format;
    }

    public Calendar getCalendar() {
        return this.m_calendar;
    }

    public void setCalendar(Calendar val) {
        this.m_calendar = val;
        this.m_calendar.setLenient(false);
    }

    public String getFormat() {
        return this.m_format;
    }

    public void setFormat(String val) {
        this.m_format = val;
    }

    public int getCenturyCutoff() {
        return this.m_centuryCutoff;
    }

    public void setCenturyCutoff(int val) {
        this.m_centuryCutoff = val;
    }

    public void setAmPmStrings(String[] val) {
        this.m_amPmStrings = val;
    }

    public void setMonthStrings(String[] val) {
        this.m_monthStrings = val;
    }

    public void setMonthAbbStrings(String[] val) {
        this.m_monthAbbStrings = val;
    }

    public void setWeekdayStrings(String[] val) {
        this.m_weekdayStrings = val;
    }

    public void setWeekdayAbbStrings(String[] val) {
        this.m_weekdayAbbStrings = val;
    }

    public void setZoneString(String str) {
        int slash_pos = str.indexOf(47);
        if (slash_pos < 0) {
            this.m_zoneString = str;
            this.m_zoneDSTString = str;
        } else {
            this.m_zoneDSTString = str.substring(slash_pos + 1);
            this.m_zoneString = str.substring(0, slash_pos);
        }
    }

    public long convertStringToTimeDate(String str) {
        long dt;
        if (str == null || CNKObj.isStringNA(str)) {
            return CNKObj.getTimeDateNA();
        }
        CalendarFields cf = CalendarFields.borrowCalendarFields();
        int[] recurseInposArray = CNKSplusDateFormat.borrowOneIntArray();
        int[] recurseFormposArray = CNKSplusDateFormat.borrowOneIntArray();
        recurseInposArray[0] = 0;
        recurseFormposArray[0] = 0;
        boolean ok = this.parse_input(str.trim(), recurseInposArray, this.m_format, recurseFormposArray, '\u0000', cf);
        if (ok) {
            this.m_calendar.clear();
            try {
                this.m_calendar.setTimeInMillis(CNKObj.getDoubleDateEpoch());
                cf.setCalendarFromFields(this.m_calendar);
                dt = this.m_calendar.getTimeInMillis();
            }
            catch (Exception ex) {
                dt = CNKObj.getTimeDateNA();
            }
        } else {
            dt = CNKObj.getTimeDateNA();
        }
        CalendarFields.returnCalendarFields(cf);
        CNKSplusDateFormat.returnOneIntArray(recurseInposArray);
        CNKSplusDateFormat.returnOneIntArray(recurseFormposArray);
        return dt;
    }

    public String convertTimeDateToString(long td) {
        if (CNKObj.isTimeDateNA(td)) {
            return CNKObj.getStringNA();
        }
        this.m_date.setTime(td);
        this.m_calendar.setTime(this.m_date);
        this.m_buf.setLength(0);
        boolean ok = this.mdyt_format(this.m_buf);
        if (ok) {
            return this.m_buf.toString();
        }
        return CNKObj.getStringNA();
    }

    public String convertJulianDateToString(double jul) {
        if (CNKObj.isDoubleNA(jul)) {
            return CNKObj.getStringNA();
        }
        long td = (long)(jul * 8.64E7);
        String str = this.convertTimeDateToString(td);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] borrowOneIntArray() {
        Stack stack = m_oneIntArrayCache;
        synchronized (stack) {
            if (m_oneIntArrayCache.empty()) {
                return new int[1];
            }
            return (int[])m_oneIntArrayCache.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void returnOneIntArray(int[] val) {
        if (val != null) {
            Stack stack = m_oneIntArrayCache;
            synchronized (stack) {
                m_oneIntArrayCache.push(val);
            }
        }
    }

    private boolean parse_input(String input_string, int[] inposArray, String format_string, int[] formposArray, char stopchar, CalendarFields cal) {
        if (input_string == null || this.m_format == null || cal == null) {
            return false;
        }
        int formpos = formposArray[0];
        int inpos = inposArray[0];
        while (formpos < this.m_format.length() && this.m_format.charAt(formpos) != stopchar) {
            if (this.m_format.charAt(formpos) == '[') {
                CalendarFields newCal = CalendarFields.borrowCalendarFields();
                int[] recurseInposArray = CNKSplusDateFormat.borrowOneIntArray();
                int[] recurseFormposArray = CNKSplusDateFormat.borrowOneIntArray();
                recurseInposArray[0] = inpos;
                recurseFormposArray[0] = ++formpos;
                if (this.parse_input(input_string, recurseInposArray, this.m_format, recurseFormposArray, ']', newCal)) {
                    inpos = recurseInposArray[0];
                    formpos = recurseFormposArray[0];
                    cal.copySetFieldsFromOther(newCal);
                    CalendarFields.returnCalendarFields(newCal);
                    CNKSplusDateFormat.returnOneIntArray(recurseInposArray);
                    CNKSplusDateFormat.returnOneIntArray(recurseFormposArray);
                    continue;
                }
                CalendarFields.returnCalendarFields(newCal);
                CNKSplusDateFormat.returnOneIntArray(recurseInposArray);
                CNKSplusDateFormat.returnOneIntArray(recurseFormposArray);
                int depth = 1;
                int nextlbr = this.m_format.indexOf(91, formpos);
                int nextrbr = this.m_format.indexOf(93, formpos);
                while (depth > 0) {
                    if (nextrbr < 0) {
                        return false;
                    }
                    if (nextlbr >= 0 && nextlbr < nextrbr) {
                        ++depth;
                        nextlbr = this.m_format.indexOf(91, nextlbr + 1);
                        continue;
                    }
                    if (--depth <= 0) continue;
                    nextrbr = this.m_format.indexOf(93, nextrbr + 1);
                }
                if (nextrbr >= 0) {
                    formpos = nextrbr + 1;
                    continue;
                }
                return false;
            }
            if (Character.isSpaceChar(this.m_format.charAt(formpos))) {
                ++formpos;
                continue;
            }
            while (inpos < input_string.length() && Character.isSpaceChar(input_string.charAt(inpos))) {
                ++inpos;
            }
            if (this.m_format.charAt(formpos) != '%') {
                if (inpos < input_string.length() && input_string.charAt(inpos) == this.m_format.charAt(formpos)) {
                    ++inpos;
                    ++formpos;
                    continue;
                }
                return false;
            }
            if (this.m_format.charAt(++formpos) == '%' || this.m_format.charAt(formpos) == '[' || this.m_format.charAt(formpos) == ']') {
                if (input_string.charAt(inpos) == this.m_format.charAt(formpos)) {
                    ++inpos;
                    ++formpos;
                    continue;
                }
                return false;
            }
            int width = -1;
            char delim = '\u0000';
            if (this.m_format.charAt(formpos) == ':') {
                width = -2;
                delim = this.m_format.charAt(formpos + 1);
                formpos += 2;
            } else if (this.m_format.charAt(formpos) == '$') {
                width = -3;
            } else {
                int endpos = formpos;
                while (Character.isDigit(this.m_format.charAt(endpos))) {
                    ++endpos;
                }
                if (endpos > formpos) {
                    String widthStr = this.m_format.substring(formpos, endpos);
                    try {
                        width = Integer.parseInt(widthStr);
                    }
                    catch (Exception ex) {
                        return false;
                    }
                    formpos = endpos;
                }
            }
            int n = ++formpos;
            ++formpos;
            char specChar = this.m_format.charAt(n);
            int[] specInposArray = new int[]{inpos};
            if (!this.input_one(input_string, specInposArray, specChar, width, delim, cal)) {
                return false;
            }
            inpos = specInposArray[0];
        }
        inposArray[0] = inpos;
        formposArray[0] = formpos;
        if (stopchar == '\u0000' && formpos >= this.m_format.length() && inpos >= input_string.length()) {
            return true;
        }
        if (formpos < this.m_format.length() && this.m_format.charAt(formpos) == stopchar) {
            formposArray[0] = ++formpos;
            return true;
        }
        return false;
    }

    private boolean input_one(String input_string, int[] inposArray, char spec_char, int width, char delim, CalendarFields cal) {
        int endpos;
        int inpos;
        int tmplng = 0;
        if (input_string == null || inposArray == null || cal == null || width == 0) {
            return false;
        }
        for (inpos = inposArray[0]; inpos < input_string.length() && Character.isSpaceChar(input_string.charAt(inpos)); ++inpos) {
        }
        if (spec_char == 'w') {
            while (inpos < input_string.length() && !Character.isSpaceChar(input_string.charAt(inpos))) {
                ++inpos;
            }
            inposArray[0] = inpos;
            return true;
        }
        int isnum = -1;
        if (width == -2) {
            endpos = input_string.indexOf(delim, inpos);
        } else if (width == -3) {
            endpos = input_string.length();
        } else if (width > 0) {
            endpos = inpos + width;
        } else {
            switch (spec_char) {
                case 'c': {
                    isnum = 0;
                    endpos = inpos + 1;
                    break;
                }
                case 'H': 
                case 'M': 
                case 'N': 
                case 'S': 
                case 'Y': 
                case 'd': 
                case 'n': 
                case 'y': {
                    isnum = 1;
                    for (endpos = inpos; endpos < input_string.length() && Character.isDigit(input_string.charAt(endpos)); ++endpos) {
                    }
                    break;
                }
                case 'Z': 
                case 'p': {
                    isnum = 0;
                    for (endpos = inpos; endpos < input_string.length() && !Character.isSpaceChar(input_string.charAt(endpos)); ++endpos) {
                    }
                    break;
                }
                case 'm': {
                    int n = isnum = endpos < input_string.length() && Character.isDigit(input_string.charAt(endpos)) ? 1 : 0;
                    if (isnum != 0) {
                        for (endpos = inpos; endpos < input_string.length() && Character.isDigit(input_string.charAt(endpos)); ++endpos) {
                        }
                        isnum = 1;
                        break;
                    }
                    while (endpos < input_string.length() && Character.isLetter(input_string.charAt(endpos))) {
                        ++endpos;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (isnum == -1) {
            switch (spec_char) {
                case 'Z': 
                case 'c': 
                case 'p': {
                    isnum = 0;
                    break;
                }
                case 'H': 
                case 'M': 
                case 'N': 
                case 'S': 
                case 'Y': 
                case 'd': 
                case 'n': 
                case 'y': {
                    isnum = 1;
                    break;
                }
                case 'm': {
                    int n = isnum = Character.isDigit(input_string.charAt(inpos)) ? 1 : 0;
                    if (isnum == 0) break;
                    isnum = 1;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (endpos <= inpos) {
            return false;
        }
        width = endpos - inpos;
        if (input_string.length() - inpos < width) {
            return false;
        }
        if (isnum != 0) {
            for (int pos = inpos; pos < endpos; ++pos) {
                if (Character.isDigit(input_string.charAt(pos))) continue;
                return false;
            }
            String numStr = input_string.substring(inpos, endpos);
            try {
                tmplng = Integer.parseInt(numStr);
            }
            catch (Exception ex) {
                return false;
            }
        }
        block12 : switch (spec_char) {
            case 'c': {
                break;
            }
            case 'd': {
                cal.set(5, tmplng);
                break;
            }
            case 'H': {
                cal.set(11, tmplng);
                break;
            }
            case 'M': {
                cal.set(12, tmplng);
                break;
            }
            case 'S': {
                cal.set(13, tmplng);
                break;
            }
            case 'Y': {
                cal.set(1, tmplng);
                break;
            }
            case 'y': {
                if (tmplng < 100) {
                    tmplng = tmplng < this.m_centuryCutoff % 100 ? (tmplng += this.m_centuryCutoff / 100 * 100 + 100) : (tmplng += this.m_centuryCutoff / 100 * 100);
                }
                cal.set(1, tmplng);
                break;
            }
            case 'n': {
                cal.set(14, tmplng);
                break;
            }
            case 'N': {
                int ms = tmplng;
                if (width == 1) {
                    ms *= 100;
                } else if (width == 2) {
                    ms *= 10;
                }
                cal.set(14, ms);
                break;
            }
            case 'Z': {
                String zone = input_string.substring(inpos, endpos);
                cal.setZone(zone);
                break;
            }
            case 'p': {
                int len = this.match_index(input_string.substring(inpos, endpos), this.m_amPmStrings);
                switch (len) {
                    case 1: {
                        cal.set(9, 0);
                        break block12;
                    }
                    case 2: {
                        cal.set(9, 1);
                        break block12;
                    }
                }
                return false;
            }
            case 'm': {
                if (isnum != 0) {
                    if (tmplng < 1 || tmplng > 12) {
                        return false;
                    }
                    cal.set(2, tmplng - 1);
                    break;
                }
                int monthNum = this.match_index(input_string.substring(inpos, endpos), this.m_monthStrings);
                if (monthNum < 1) {
                    return false;
                }
                cal.set(2, monthNum - 1);
                break;
            }
            default: {
                return false;
            }
        }
        inposArray[0] = endpos;
        return true;
    }

    private int match_index(String match_str, String[] str_array) {
        if (str_array == null || match_str == null) {
            return 0;
        }
        int which_matched = -1;
        int most_matched = 0;
        boolean unique = false;
        int our_len = match_str.length();
        int array_len = str_array.length;
        for (int i = 0; i < array_len; ++i) {
            if (str_array[i] == null) continue;
            int this_len = str_array[i].length();
            int this_matched = 0;
            int j = 0;
            while (j < this_len && j < our_len && Character.toLowerCase(match_str.charAt(j)) == Character.toLowerCase(str_array[i].charAt(j))) {
                this_matched = j++;
            }
            if (j < our_len) continue;
            if (this_matched == most_matched) {
                unique = false;
                continue;
            }
            if (this_matched <= most_matched) continue;
            unique = true;
            most_matched = this_matched;
            which_matched = i;
        }
        if (!unique) {
            return 0;
        }
        return which_matched + 1;
    }

    boolean mdyt_format(StringBuffer buf) {
        if (this.m_format == null) {
            return false;
        }
        int inpos = 0;
        while (inpos < this.m_format.length()) {
            int endpos;
            if (this.m_format.charAt(inpos++) != '%') {
                buf.append(this.m_format.charAt(inpos - 1));
                continue;
            }
            if (this.m_format.charAt(inpos) == '%') {
                buf.append('%');
                ++inpos;
                continue;
            }
            int width = -1;
            boolean zeropad = this.m_format.charAt(inpos) == '0';
            for (endpos = inpos; endpos < this.m_format.length() && Character.isDigit(this.m_format.charAt(endpos)); ++endpos) {
            }
            if (endpos > inpos) {
                String widthStr = this.m_format.substring(inpos, endpos);
                try {
                    width = Integer.parseInt(widthStr);
                }
                catch (Exception ex) {
                    return false;
                }
                inpos = endpos;
            }
            if (this.output_one(buf, this.m_format.charAt(inpos++), width, zeropad)) continue;
            return false;
        }
        return true;
    }

    private boolean output_one(StringBuffer buf, char spec_char, int field_width, boolean zero_pad) {
        int print_val = 0;
        if (buf == null) {
            return false;
        }
        if (field_width == 0) {
            return false;
        }
        if (zero_pad && field_width < 1) {
            return false;
        }
        String print_str = null;
        block0 : switch (spec_char) {
            case 'a': {
                int weekday = this.m_calendar.get(7) - 1;
                if (this.m_weekdayAbbStrings == null || weekday < 0 || weekday >= this.m_weekdayAbbStrings.length) {
                    return false;
                }
                print_str = this.m_weekdayAbbStrings[weekday];
                break;
            }
            case 'A': {
                int weekday = this.m_calendar.get(7) - 1;
                if (this.m_weekdayStrings == null || weekday < 0 || weekday >= this.m_weekdayStrings.length) {
                    return false;
                }
                print_str = this.m_weekdayStrings[weekday];
                break;
            }
            case 'b': {
                int month = this.m_calendar.get(2);
                if (this.m_monthAbbStrings == null || month < 0 || month >= this.m_monthAbbStrings.length) {
                    return false;
                }
                print_str = this.m_monthAbbStrings[month];
                break;
            }
            case 'B': {
                int month = this.m_calendar.get(2);
                if (this.m_monthStrings == null || month < 0 || month >= this.m_monthStrings.length) {
                    return false;
                }
                print_str = this.m_monthStrings[month];
                break;
            }
            case 'Q': {
                int quarter = this.m_calendar.get(2) / 3 + 1;
                switch (quarter) {
                    case 1: {
                        print_str = "I";
                        break block0;
                    }
                    case 2: {
                        print_str = "II";
                        break block0;
                    }
                    case 3: {
                        print_str = "III";
                        break block0;
                    }
                    case 4: {
                        print_str = "IV";
                        break block0;
                    }
                }
                return false;
            }
            case 'Z': {
                if (this.m_zoneString != null) {
                    print_str = this.m_zoneString;
                    break;
                }
                print_str = "";
                break;
            }
            case 'z': {
                if (this.m_zoneString == null || this.m_zoneDSTString == null) {
                    print_str = "";
                    break;
                }
                if (this.m_calendar.get(16) != 0) {
                    print_str = this.m_zoneDSTString;
                    break;
                }
                print_str = this.m_zoneString;
                break;
            }
            case 'p': {
                if (this.m_amPmStrings == null || this.m_amPmStrings.length < 2) {
                    return false;
                }
                if (this.m_calendar.get(9) == 0) {
                    print_str = this.m_amPmStrings[0];
                    break;
                }
                print_str = this.m_amPmStrings[1];
                break;
            }
            case 'C': {
                print_val = this.m_calendar.get(1) % 100;
                break;
            }
            case 'd': {
                print_val = this.m_calendar.get(5);
                break;
            }
            case 'D': {
                print_val = this.m_calendar.get(6);
                break;
            }
            case 'H': {
                print_val = this.m_calendar.get(11);
                break;
            }
            case 'I': {
                print_val = this.m_calendar.get(10);
                if (print_val >= 1) break;
                print_val = 12;
                break;
            }
            case 'm': {
                print_val = this.m_calendar.get(2) + 1;
                break;
            }
            case 'M': {
                print_val = this.m_calendar.get(12);
                break;
            }
            case 'q': {
                print_val = this.m_calendar.get(2) / 3 + 1;
                break;
            }
            case 'S': {
                print_val = this.m_calendar.get(13);
                break;
            }
            case 'N': {
                if (field_width == 1) {
                    print_val = this.m_calendar.get(14) / 100;
                    break;
                }
                if (field_width == 2) {
                    print_val = this.m_calendar.get(14) / 10;
                    break;
                }
                print_val = this.m_calendar.get(14);
                break;
            }
            case 'y': {
                int yr = this.m_calendar.get(1);
                if (yr >= this.m_centuryCutoff && yr < this.m_centuryCutoff + 100) {
                    print_val = yr % 100;
                    break;
                }
                print_val = yr;
                break;
            }
            case 'Y': {
                print_val = this.m_calendar.get(1);
                break;
            }
            default: {
                return false;
            }
        }
        if (print_str != null) {
            int num_chars = print_str.length();
            if (field_width > 0) {
                if (field_width < num_chars) {
                    for (int i = 0; i < field_width; ++i) {
                        buf.append(print_str.charAt(i));
                    }
                } else {
                    for (int i = num_chars; i < field_width; ++i) {
                        buf.append(' ');
                    }
                    buf.append(print_str);
                }
            } else {
                buf.append(print_str);
            }
        } else {
            print_str = Integer.toString(print_val);
            int num_chars = print_str.length();
            if (field_width > 0) {
                if (num_chars > field_width) {
                    for (int i = 0; i < field_width; ++i) {
                        buf.append('*');
                    }
                } else {
                    for (int i = num_chars; i < field_width; ++i) {
                        buf.append(zero_pad ? (char)'0' : ' ');
                    }
                    buf.append(print_str);
                }
            } else {
                buf.append(print_str);
            }
        }
        return true;
    }

    static {
        m_defaultParser = new CNKSplusDateFormat();
        m_defaultParser.setFormat(DEFAULT_DATE_PARSE_STRING);
        m_defaultFormatter = new CNKSplusDateFormat();
        m_defaultFormatter.setFormat(DEFAULT_DATE_FORMAT_STRING);
        m_oneIntArrayCache = new Stack();
    }

    private static class CalendarFields {
        private static Stack m_cache = new Stack();
        private int[] m_fieldVals = new int[17];
        private boolean[] m_fieldSet = new boolean[17];
        private String m_zone = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CalendarFields borrowCalendarFields() {
            CalendarFields val = null;
            Stack stack = m_cache;
            synchronized (stack) {
                val = m_cache.empty() ? new CalendarFields() : (CalendarFields)m_cache.pop();
            }
            val.clear();
            return val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void returnCalendarFields(CalendarFields cal) {
            if (cal != null) {
                Stack stack = m_cache;
                synchronized (stack) {
                    m_cache.push(cal);
                }
            }
        }

        public CalendarFields() {
            this.clear();
        }

        public void copySetFieldsFromOther(CalendarFields other) {
            for (int i = 0; i < this.m_fieldSet.length; ++i) {
                if (!other.m_fieldSet[i]) continue;
                this.m_fieldVals[i] = other.m_fieldVals[i];
                this.m_fieldSet[i] = true;
            }
            if (other.m_zone != null) {
                this.m_zone = other.m_zone;
            }
        }

        public String getZone() {
            return this.m_zone;
        }

        public void setZone(String val) {
            this.m_zone = val;
        }

        public void set(int index, int val) {
            this.m_fieldVals[index] = val;
            this.m_fieldSet[index] = true;
        }

        public int get(int index) {
            return this.m_fieldVals[index];
        }

        public void clear() {
            for (int i = 0; i < this.m_fieldSet.length; ++i) {
                this.m_fieldSet[i] = false;
            }
        }

        public void setCalendarFromFields(Calendar cal) {
            if (this.m_fieldSet[9]) {
                if (this.m_fieldSet[11]) {
                    int am_pm = this.m_fieldVals[9];
                    int hour = this.m_fieldVals[11];
                    if (am_pm == 1 && hour < 12) {
                        hour += 12;
                    } else if (am_pm == 0 && hour == 12) {
                        hour = 0;
                    }
                    this.m_fieldVals[11] = hour;
                }
                this.m_fieldSet[9] = false;
            }
            for (int i = 0; i < this.m_fieldSet.length; ++i) {
                if (!this.m_fieldSet[i]) continue;
                cal.set(i, this.m_fieldVals[i]);
            }
        }
    }
}

