/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ActivityNodeState;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.BaseNodePort;
import com.insightful.miner.GenerateCNodeModel;
import com.insightful.miner.GenerateInputNodeModel;
import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.PMMLExportable;
import com.insightful.miner.PMMLImportable;
import com.insightful.miner.PredictorPort;
import com.insightful.miner.StateVisualCueImage;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XTNetwork;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;

public class ActivityNodeArea
extends BaseNodeArea
implements ChangeListener,
Serializable {
    private ActivityNodeModel m_nodeModel;
    private JGoImage m_antiSplus = null;
    private PredictorPort m_modelLinkInputPort = null;
    private PredictorPort m_modelLinkOutputPort = null;

    public void initialize(ActivityNodeModel nodeModel) {
        this.setNodeModel(nodeModel);
        nodeModel.addChangeListener(this);
        super.initialize(nodeModel.getLabelText(), nodeModel.getLargeIconName(), nodeModel.getNumInputs(), nodeModel.getNumOutputs());
        this.layoutChildren();
    }

    protected void adjustModelPortsLocation() {
        this.adjustModelPortLocation(true);
        this.adjustModelPortLocation(false);
    }

    private void adjustModelPortLocation(boolean inputPort) {
        ActivityNodeModel model = this.getNodeModel();
        if (inputPort) {
            this.adjustModelPortLocation(inputPort, model instanceof PMMLImportable, false);
        } else {
            this.adjustModelPortLocation(inputPort, false, model instanceof PMMLExportable);
        }
    }

    void adjustModelPortLocation(boolean inputPort, boolean pmmlImportable, boolean pmmlExportable) {
        int numPorts;
        PredictorPort predPort = inputPort ? this.m_modelLinkInputPort : this.m_modelLinkOutputPort;
        int y_location = 0;
        int x_offset = 1;
        int location = 8;
        ActivityNodeModel model = this.getNodeModel();
        boolean modelInput = true;
        boolean mustAdd = false;
        Vector ports = null;
        if (pmmlImportable) {
            ports = this.getInputPorts();
        } else if (pmmlExportable) {
            ports = this.getOutputPorts();
            location = 4;
            modelInput = false;
        } else {
            return;
        }
        if (predPort == null && modelInput == inputPort) {
            if (inputPort) {
                this.m_modelLinkInputPort = new PredictorPort(this, model);
            } else {
                this.m_modelLinkOutputPort = new PredictorPort(this, model);
            }
            predPort = inputPort ? this.m_modelLinkInputPort : this.m_modelLinkOutputPort;
            predPort.setValidDestination(inputPort);
            predPort.setValidSource(!inputPort);
            mustAdd = true;
        }
        JGoObject icon = this.getIcon();
        Point p = null;
        if (icon != null) {
            p = icon.getSpotLocation(location);
        }
        if (modelInput) {
            x_offset = -(BaseNodePort.DEFAULT_RECTANGLE.width + x_offset);
        }
        int n = numPorts = ports == null ? 0 : ports.size();
        if (numPorts > 0) {
            for (int i = 0; i < numPorts; ++i) {
                JGoPort port = (JGoPort)ports.elementAt(i);
                if (port == null || !this.isPortVisible(port) || icon == null) continue;
                y_location += 10;
            }
        } else {
            y_location += 10;
        }
        if (ports != null && predPort != null) {
            if (mustAdd) {
                this.addObjectAtTail((JGoObject)predPort);
            }
            if (p != null) {
                predPort.setLocationOffset(p.x + x_offset, p.y - 5, 0, y_location);
            } else {
                predPort.setSpotLocation(location, (JGoObject)this, location);
            }
            XTNetwork.NodeInfo info = model.getNodeInfo();
            if (pmmlImportable) {
                boolean dynamicImportable = info.model == null || info.model.modelString == null;
                predPort.setBrush(dynamicImportable ? JGoBrush.lightGray : JGoBrush.darkGray);
            } else if (pmmlExportable) {
                boolean dynamicImportable = model instanceof PMMLImportable && (info.model == null || info.model.modelString == null);
                boolean staticImportable = model instanceof PMMLImportable && info.model != null && info.model.modelString != null;
                boolean emptyExportable = !model.isComputed() && !staticImportable;
                predPort.setBrush(emptyExportable || dynamicImportable ? JGoBrush.lightGray : JGoBrush.darkGray);
            } else {
                predPort.setBrush(JGoBrush.lightGray);
            }
        }
    }

    protected StateVisualCueImage getStateIcon() {
        return this.getNodeModel().getStateVisualCue();
    }

    public void layoutChildren() {
        super.layoutChildren();
        this.adjustModelPortsLocation();
        this.addDisabledOverlay();
    }

    protected void addDisabledOverlay() {
        JGoObject object = this.getIcon();
        String engineClass = this.getNodeModel().getNodeInfo().engineClass;
        boolean splusLicensed = MinerApp.isSplusLicensed();
        if (this.m_antiSplus != null) {
            this.removeObject((JGoObject)this.m_antiSplus);
            this.m_antiSplus = null;
        }
        if (object != null && !MinerApp.isHeadless() && (MinerApp.isSplusEngineNode(engineClass) && !splusLicensed || (this.m_nodeModel instanceof GenerateCNodeModel || this.m_nodeModel instanceof GenerateInputNodeModel) && !MinerApp.getLicenseInfo().isProductionEdition())) {
            this.m_antiSplus = new JGoImage(object.getBoundingRect());
            this.m_antiSplus.loadImage(MinerApp.getResourceManager().getImage("unlicensed_large.gif"), true);
            this.m_antiSplus.setVisible(true);
            this.m_antiSplus.setSelectable(false);
            this.addObjectAtTail((JGoObject)this.m_antiSplus);
        }
    }

    public PredictorPort getModelLinkInputPort() {
        return this.m_modelLinkInputPort;
    }

    public PredictorPort getModelLinkOutputPort() {
        return this.m_modelLinkOutputPort;
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 1: {
                this.setBoundingRect((Rectangle)e.getValue(undo));
                this.stateChanged(new ChangeEvent(this.getNodeModel().getState()));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void stateChanged(ChangeEvent e) {
        Point oldPoint = this.getTopLeft();
        Object source = e.getSource();
        if (source instanceof ActivityNodeState) {
            WorksheetView view;
            this.addStateVisualCue();
            WorksheetDocument doc = this.getDoc();
            WorksheetView worksheetView = view = MinerApp.getMainFrame() != null ? MinerApp.getCurrentView() : null;
            if (view != null) {
                doc = view.getDoc();
            }
            String nodeID = Integer.toString(this.getID());
            Vector outPorts = this.getOutputPorts();
            for (int i = 0; outPorts != null && i < outPorts.size(); ++i) {
                BaseNodePort port = (BaseNodePort)((Object)outPorts.get(i));
                Object obj = null;
                if (doc != null) {
                    obj = GuiMessageHandler.sendMessageToEngine(doc.getWorksheetID(), "", "hasNodeDataCache", new Object[]{nodeID, new Integer(i)});
                }
                boolean hasDataCache = obj != null && obj instanceof Boolean && (Boolean)obj != false;
                port.setBrush(hasDataCache ? JGoBrush.darkGray : JGoBrush.lightGray);
            }
            this.adjustModelPortsLocation();
        } else {
            this.setPorts();
            this.loadIconImage(this.m_nodeModel.getLargeIconName(), false);
            this.addDisabledOverlay();
        }
        Dimension dim = this.getSize();
        this.setBoundingRect(oldPoint, dim);
        this.update();
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        ActivityNodeArea newobj = (ActivityNodeArea)super.copyObject(env);
        ActivityNodeModel newmodel = null;
        if (newobj == null) {
            return null;
        }
        try {
            newmodel = this.getNodeModel().copy();
            newobj.setNodeModel(newmodel);
            newobj.adjustModelPortsLocation();
            newmodel.addChangeListener(newobj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        newobj.layoutChildren();
        return newobj;
    }

    public void updateModelInfo(JGoCopyEnvironment env, ActivityNodeArea origCopy) {
        ActivityNodeArea copyModelParentArea;
        ActivityNodeArea origModelParentArea;
        XTNetwork.NodeInfo info = this.getNodeInfo();
        WorksheetDocument origDoc = origCopy.getDoc();
        if (info.modelParent != null) {
            String tempModelParent = info.modelParent;
            info.modelParent = null;
            if (origDoc != null && (origModelParentArea = (ActivityNodeArea)origDoc.findFlatNodeByID(Integer.parseInt(tempModelParent))) != null && (copyModelParentArea = (ActivityNodeArea)env.get((Object)origModelParentArea)) != null) {
                info.modelParent = Integer.toString(copyModelParentArea.getID());
            }
        }
        if (info.executeAfter != null) {
            String tempExecuteAfter = info.executeAfter;
            info.executeAfter = null;
            if (origDoc != null && (origModelParentArea = (ActivityNodeArea)origDoc.findFlatNodeByID(Integer.parseInt(tempExecuteAfter))) != null && (copyModelParentArea = (ActivityNodeArea)env.get((Object)origModelParentArea)) != null) {
                info.executeAfter = Integer.toString(copyModelParentArea.getID());
            }
        }
    }

    protected void ownerChange(Object oldOwner, Object newOwner) {
        WorksheetDocument doc;
        if (oldOwner == null && newOwner != null && newOwner instanceof WorksheetDocument) {
            if (this.getNodeModel().getID() == -1) {
                WorksheetDocument doc2 = (WorksheetDocument)((Object)newOwner);
                int id = doc2.getNextNodeID();
                if (id != -1) {
                    this.getNodeModel().setID(id);
                    String name = this.getText();
                    if (name.endsWith(")")) {
                        try {
                            int openParen = name.lastIndexOf("(");
                            int closeParen = name.lastIndexOf(")");
                            Integer.parseInt(name.substring(openParen + 1, closeParen));
                            if (openParen > 0) {
                                name = name.substring(0, openParen);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!name.endsWith(" ")) {
                        name = name + " ";
                    }
                    String label = name + "(" + Integer.toString(this.getID()) + ")";
                    this.setText(label);
                }
                this.getNodeModel().setDocument((WorksheetDocument)((Object)newOwner));
                doc2.setEngineNetworkDirty();
            }
        } else if (oldOwner != null && newOwner == null && !(doc = (WorksheetDocument)((Object)oldOwner)).isCollapsing()) {
            doc.setEngineNetworkDirty();
        }
    }

    public XTNetwork.NodeInfo getNodeInfo() {
        XTNetwork.NodeInfo ret = this.m_nodeModel.getNodeInfo();
        Point point = this.getTopLeft();
        ret.x = point.x;
        ret.y = point.y;
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getNodeModel());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setNodeModel((ActivityNodeModel)in.readObject());
    }

    public static ActivityNodeArea buildActivityNodeFromInfo(XTNetwork.NodeInfo info) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        if (info == null) {
            throw new IllegalArgumentException("Node could not be created.");
        }
        ActivityNodeArea area = new ActivityNodeArea();
        ActivityNodeModel model = null;
        int id = Integer.parseInt(info.nodeID);
        String modeltype = info.guiClass;
        model = ActivityNodeModel.createActivityNodeModel(modeltype, info);
        model.setID(id);
        area.initialize(model);
        area.setTopLeft(info.x, info.y);
        return area;
    }

    public static ActivityNodeArea buildActivityNodeFromXML(Element elt) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        XTNetwork.NodeInfo info = new XTNetwork.NodeInfo();
        info.convertFromXML(elt);
        return ActivityNodeArea.buildActivityNodeFromInfo(info);
    }

    public void setPorts() {
        int existInputs = this.getInputPorts().size();
        int existOutputs = this.getOutputPorts().size();
        try {
            BaseNodePort port;
            int numInputs = this.getNodeModel().getNodeInfo().numInputs;
            int numOutputs = this.getNodeModel().getNodeInfo().numOutputs;
            if (existInputs == 1 && !(port = (BaseNodePort)((Object)this.getInputPorts().get(0))).isSingle() && numInputs != -1) {
                this.getInputPorts().removeElementAt(0);
                this.removeObject((JGoObject)port);
                existInputs = 0;
            }
            if (existInputs < numInputs) {
                for (int i = existInputs; i < numInputs; ++i) {
                    this.addPort(true);
                }
            } else if (existInputs > numInputs) {
                int limit = numInputs > 0 ? numInputs : 0;
                for (int i = existInputs - 1; i >= limit; --i) {
                    JGoPort port2 = (JGoPort)this.getInputPorts().get(i);
                    this.getInputPorts().removeElementAt(i);
                    this.removeObject((JGoObject)port2);
                }
                if (numInputs == -1) {
                    BaseNodePort multiPort = new BaseNodePort(true, false, this);
                    this.getInputPorts().addElement(multiPort);
                }
            }
            if (existOutputs < numOutputs) {
                for (int i = existOutputs; i < numOutputs; ++i) {
                    this.addPort(false);
                }
            } else if (existOutputs > numOutputs) {
                for (int i = existOutputs - 1; i >= numOutputs; --i) {
                    JGoPort port3 = (JGoPort)this.getOutputPorts().get(i);
                    this.getOutputPorts().removeElementAt(i);
                    this.removeObject((JGoObject)port3);
                }
            }
            this.layoutChildren();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getToolTipText() {
        return this.m_nodeModel.getToolTipText();
    }

    public boolean doMouseDblClick(int modifiers, Point dc, Point vc, JGoView view) {
        this.m_nodeModel.getState().onDoubleClick(this.m_nodeModel);
        return true;
    }

    private void setNodeModel(ActivityNodeModel nodeModel) {
        this.m_nodeModel = nodeModel;
    }

    public ActivityNodeModel getNodeModel() {
        return this.m_nodeModel;
    }

    public int getID() {
        return this.m_nodeModel.getID();
    }

    public void setID(int id) {
        this.m_nodeModel.setID(id);
    }

    public void setText(String s) {
        super.setText(s);
        this.getNodeModel().setLabelText(s);
        WorksheetDocument doc = this.getDoc();
        if (doc != null) {
            doc.setEngineNetworkDirty();
        }
    }
}

