/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.AggregateEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SelectColumnsPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class AggregateDialog
extends NodeDialog {
    private JTable table;
    private AggregateTableModel tableModel;
    private SelectColumnsPanel selectColumnsPanel;
    private JButton addColumnButton;
    private JButton removeColumnButton;
    private JComboBox aggregateFunctionComboBox;
    private JCheckBox sortCheckBox;
    private DefaultComboBoxModel categoricalModel;
    private DefaultComboBoxModel continuousModel;
    private static final String[] categoricalFunctions = new String[]{AggregateEngineNode.FIRST_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.LAST_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.COUNT_METHOD_ATTRIBUTE_TAG};
    private static final String[] continuousFunctions = new String[]{AggregateEngineNode.FIRST_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.LAST_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.COUNT_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.SUM_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.MEAN_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.MIN_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.MAX_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.STD_DEV_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.VAR_METHOD_ATTRIBUTE_TAG, AggregateEngineNode.RANGE_METHOD_ATTRIBUTE_TAG};
    private AbstractAction addColumnAction;
    private AbstractAction removeColumnAction;
    private static AggregateDialog instance = null;

    public static AggregateDialog getInstance() {
        if (instance == null) {
            instance = new AggregateDialog();
        }
        return instance;
    }

    private AggregateDialog() {
        this.setSize(500, 600);
        this.setMinimumSize(new Dimension(450, 600));
        this.setResizable(true);
        this.pack();
    }

    public void restoreProperties() {
        super.restoreProperties();
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.tableModel.clearTable();
        this.selectColumnsPanel.restoreProperties(this.getNodeModel());
        XTProps props = this.getNodeModel().getXTProps();
        String[] propertyString = new String[]{AggregateEngineNode.SUMMARY_COLUMNS_ATTRIBUTE_TAG, "", ""};
        Vector columnNames = props.getSubProperties(AggregateEngineNode.SUMMARY_COLUMNS_ATTRIBUTE_TAG);
        for (int i = 0; i < columnNames.size(); ++i) {
            propertyString[1] = (String)columnNames.get(i);
            propertyString[2] = AggregateEngineNode.SUMMARY_METHOD_ATTRIBUTE_TAG;
            String selectedFunction = props.getValue(propertyString);
            propertyString[2] = AggregateEngineNode.INPUT_NAME_ATTRIBUTE_TAG;
            String inputName = props.getValue(propertyString);
            this.tableModel.addRow(new Object[]{inputName, selectedFunction, propertyString[1]});
        }
        int columnCount = this.tableModel.getColumnCount();
        try {
            XTMetaData md = this.getNodeModel().getInputMetaData(0);
            for (int i = 0; i < columnCount; ++i) {
                TableColumn column = this.table.getColumn(this.table.getColumnName(i));
                column.setCellRenderer(new NodeDialog.GeneralRenderer());
                if (i == 0) {
                    String[] inputs = this.selectColumnsPanel.getInputColumnNames();
                    JComboBox<String> inputCB = new JComboBox<String>(inputs);
                    column.setCellEditor(new DefaultCellEditor(inputCB));
                    inputs = null;
                    continue;
                }
                if (i == 1) {
                    column.setCellEditor(new AggregateComboBoxEditor(md));
                    continue;
                }
                column.setCellEditor(new DefaultCellEditor(new JTextField()));
            }
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
        }
        if (this.tableModel.getRowCount() > 0) {
            this.removeColumnButton.setEnabled(true);
        }
        this.sortCheckBox.setSelected(props.getBoolean(AggregateEngineNode.SORT_ATTRIBUTE_TAG, true));
        propertyString = null;
    }

    public void saveProperties() throws NodeDialog.DialogException {
        String inputName;
        int j;
        super.saveProperties();
        this.selectColumnsPanel.saveProperties(this.getNodeModel());
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        Vector<String> inputNames = new Vector<String>();
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String name = (String)this.table.getValueAt(i, 2);
            int inputNameSize = inputNames.size();
            for (j = 0; j < inputNameSize; ++j) {
                if (!inputNames.get(j).equals(name)) continue;
                throw new NodeDialog.DialogException(MinerApp.getText("AggregateDialog_errorMessage"));
            }
            inputNames.add(name);
        }
        Object[] objects = this.selectColumnsPanel.getOutputColumns();
        for (int i = 0; i < rowCount; ++i) {
            String name = (String)this.table.getValueAt(i, 0);
            for (j = 0; j < objects.length; ++j) {
                NodeDialog.ColumnInformationObject object = (NodeDialog.ColumnInformationObject)objects[j];
                String compareName = object.getText();
                if (!compareName.equals(name)) continue;
                throw new NodeDialog.DialogException(MinerApp.getText("AggregateDialog_sameNameError"));
            }
        }
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{AggregateEngineNode.SUMMARY_COLUMNS_ATTRIBUTE_TAG});
        String[] propertyString = new String[]{AggregateEngineNode.SUMMARY_COLUMNS_ATTRIBUTE_TAG, "", ""};
        int numRows = this.table.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            String columnName;
            inputName = (String)this.table.getValueAt(i, 0);
            String function = (String)this.table.getValueAt(i, 1);
            propertyString[1] = columnName = (String)this.table.getValueAt(i, 2);
            propertyString[2] = AggregateEngineNode.SUMMARY_METHOD_ATTRIBUTE_TAG;
            props.set(propertyString, function);
            propertyString[2] = AggregateEngineNode.INPUT_NAME_ATTRIBUTE_TAG;
            props.set(propertyString, inputName);
        }
        props.set(AggregateEngineNode.SORT_ATTRIBUTE_TAG, this.sortCheckBox.isSelected());
        inputName = null;
        Object function = null;
        Object columnName = null;
        propertyString = null;
    }

    public void createActions() {
        super.createActions();
        this.addColumnAction = new AbstractAction(MinerApp.getText("AggregateDialog_addColumn")){

            public void actionPerformed(ActionEvent e) {
                Object[] columns = AggregateDialog.this.selectColumnsPanel.getSelectedInputColumns();
                for (int i = 0; i < columns.length; ++i) {
                    NodeDialog.ColumnInformationObject o = (NodeDialog.ColumnInformationObject)columns[i];
                    String columnName = o.getText();
                    String selectedFunction = (String)AggregateDialog.this.aggregateFunctionComboBox.getSelectedItem();
                    String outputColumnName = columnName + "." + selectedFunction;
                    AggregateDialog.this.tableModel.addRow(new Object[]{columnName, selectedFunction, outputColumnName});
                }
                if (AggregateDialog.this.tableModel.getRowCount() > 0) {
                    AggregateDialog.this.removeColumnButton.setEnabled(true);
                }
                columns = null;
            }
        };
        this.removeColumnAction = new AbstractAction(MinerApp.getText("AggregateDialog_removeColumn")){

            public void actionPerformed(ActionEvent e) {
                if (AggregateDialog.this.table.isEditing()) {
                    AggregateDialog.this.table.getCellEditor().stopCellEditing();
                }
                int[] rows = AggregateDialog.this.table.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    AggregateDialog.this.tableModel.removeRow(rows[i]);
                }
                if (AggregateDialog.this.table.getRowCount() < 1) {
                    AggregateDialog.this.removeColumnButton.setEnabled(false);
                }
                rows = null;
            }
        };
    }

    public JPanel createNodePanel() {
        JPanel globalPanel = new JPanel(new BorderLayout());
        globalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NodeDialog_sortOptions")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.sortCheckBox = new JCheckBox(MinerApp.getText("NodeDialog_sortRequired"));
        globalPanel.add((Component)this.sortCheckBox, "West");
        return globalPanel;
    }

    public JPanel createOptionsPanel() {
        this.selectColumnsPanel = new SelectColumnsPanel(this.okAction, MinerApp.getText("AggregateDialog_inputColumns"), MinerApp.getText("AggregateDialog_aggregateBy"), AggregateEngineNode.AGGREGATE_COLUMNS_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.addListSelectionListenerToInputColumns(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JList list = (JList)e.getSource();
                Object[] selected = list.getSelectedValues();
                AggregateDialog.this.addColumnButton.setEnabled(selected.length != 0);
                for (int i = 0; i < selected.length; ++i) {
                    NodeDialog.ColumnInformationObject object = (NodeDialog.ColumnInformationObject)selected[i];
                    if (!object.getType().equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
                    AggregateDialog.this.aggregateFunctionComboBox.setModel(AggregateDialog.this.categoricalModel);
                    return;
                }
                AggregateDialog.this.aggregateFunctionComboBox.setModel(AggregateDialog.this.continuousModel);
            }
        });
        JPanel aggregateTablePanel = new JPanel(new GridBagLayout());
        aggregateTablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        Dimension buttonSize = new Dimension(130, 25);
        this.addColumnButton = new JButton(this.addColumnAction);
        this.addColumnButton.setPreferredSize(buttonSize);
        this.addColumnButton.setEnabled(false);
        this.addColumnButton.setMnemonic(MinerApp.getText("AggregateDialog_addColumnHotkey").charAt(0));
        String aggregateFunctionString = MinerApp.getText("AggregateDialog_aggregateFunction");
        JLabel aggregateFunctionLabel = new JLabel(aggregateFunctionString);
        this.aggregateFunctionComboBox = new JComboBox<String>(categoricalFunctions);
        aggregateFunctionLabel.setLabelFor(this.aggregateFunctionComboBox);
        aggregateFunctionLabel.setDisplayedMnemonic(MinerApp.getText("AggregateDialog_aggregateFunctionHotkey").charAt(0));
        this.aggregateFunctionComboBox.setPreferredSize(buttonSize);
        this.categoricalModel = new DefaultComboBoxModel<String>(categoricalFunctions);
        this.continuousModel = new DefaultComboBoxModel<String>(continuousFunctions);
        this.aggregateFunctionComboBox.setModel(this.continuousModel);
        constraints.anchor = 17;
        aggregateTablePanel.add((Component)this.addColumnButton, constraints);
        constraints.gridx = 8;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 13;
        aggregateTablePanel.add((Component)aggregateFunctionLabel, constraints);
        constraints.gridx = 9;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 5, 0, 0);
        aggregateTablePanel.add((Component)this.aggregateFunctionComboBox, constraints);
        this.tableModel = new AggregateTableModel();
        this.tableModel.setColumnIdentifiers(new Object[]{MinerApp.getText("AggregateDialog_inputColumn"), MinerApp.getText("AggregateDialog_aggregateOperation"), MinerApp.getText("AggregateDialog_outputColumn")});
        this.table = new JTable(this.tableModel);
        NodeDialog.addKeyboardNavigation(this.table);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        int rowHeight = 25;
        this.table.setRowHeight(rowHeight);
        JScrollPane scrollingTable = new JScrollPane(this.table);
        scrollingTable.setPreferredSize(new Dimension(400, 200));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 10;
        constraints.gridwidth = 10;
        constraints.insets = new Insets(10, 0, 10, 0);
        constraints.fill = 1;
        constraints.anchor = 10;
        aggregateTablePanel.add((Component)scrollingTable, constraints);
        this.removeColumnButton = new JButton(this.removeColumnAction);
        this.removeColumnButton.setPreferredSize(buttonSize);
        this.removeColumnButton.setMnemonic(76);
        this.removeColumnButton.setEnabled(false);
        constraints.gridx = 0;
        constraints.gridy = 11;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 0;
        constraints.anchor = 17;
        aggregateTablePanel.add((Component)this.removeColumnButton, constraints);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)this.selectColumnsPanel, "Center");
        optionsPanel.add((Component)aggregateTablePanel, "South");
        return optionsPanel;
    }

    public static class AggregateComboBoxEditor
    extends DefaultCellEditor {
        private static CBDelegate categoricalD = null;
        private static JComboBox categoricalCB = null;
        private static JComboBox continuousCB = null;
        private static CBDelegate continuousD = null;
        private XTMetaData metaData = null;

        public AggregateComboBoxEditor(XTMetaData md) {
            super(new JComboBox());
            categoricalCB = new JComboBox<String>(categoricalFunctions);
            categoricalD = new CBDelegate(categoricalCB);
            categoricalCB.addActionListener(categoricalD);
            continuousCB = new JComboBox<String>(continuousFunctions);
            continuousD = new CBDelegate(continuousCB);
            continuousCB.addActionListener(continuousD);
            this.metaData = md;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String columnName = (String)table.getValueAt(row, 0);
            if (this.metaData.isContinuousColumn(columnName)) {
                continuousCB.setSelectedItem(value);
                this.editorComponent = continuousCB;
                this.delegate = continuousD;
                return continuousCB;
            }
            categoricalCB.setSelectedItem(value);
            this.editorComponent = categoricalCB;
            this.delegate = categoricalD;
            return categoricalCB;
        }

        private class CBDelegate
        extends DefaultCellEditor.EditorDelegate {
            private JComboBox comboBox;

            public CBDelegate(JComboBox cb) {
                super(AggregateComboBoxEditor.this);
                this.comboBox = null;
                this.comboBox = cb;
            }

            public void setValue(Object value) {
                this.comboBox.setSelectedItem(value);
            }

            public Object getCellEditorValue() {
                return this.comboBox.getSelectedItem();
            }

            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }

            public boolean stopCellEditing() {
                if (this.comboBox.isEditable()) {
                    this.comboBox.actionPerformed(new ActionEvent(AggregateComboBoxEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        }
    }

    private class AggregateTableModel
    extends DefaultTableModel {
        private AggregateTableModel() {
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }
    }
}

