/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.miner.BDLIndexRetrievalEngineNode;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.ModifyColumnsEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.DataInputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class BDLIndexAssignmentEngineNode
extends BDLIndexRetrievalEngineNode {
    public static final String COLUMN_NAMES_ATTRIBUTE_TAG = "columnNames";
    protected int[] m_inColNums = new int[0];
    protected int[] m_outColNums = new int[0];

    protected void initVars(XTProps props) throws Exception {
        super.initVars(props);
        Vector cNames = props.getSubPropertyValues(COLUMN_NAMES_ATTRIBUTE_TAG);
        int inputNum = this.getNumInputs() == 3 ? 2 : 1;
        XTMetaData inMD = this.getInputMetaData(inputNum);
        XTMetaData vMD = this.getInputMetaData(0);
        int numColumns = cNames.size();
        this.m_inColNums = new int[numColumns];
        this.m_outColNums = new int[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            String c = (String)cNames.get(i);
            this.m_inColNums[i] = inMD.nameToOrdinal(c);
            this.m_outColNums[i] = vMD.nameToOrdinal(c);
        }
    }

    public boolean executeDataCacheProc() throws Exception {
        XTProps props = this.getNodeProperties();
        this.initVars(props);
        this.copyInputToOutput();
        return this.indexing();
    }

    private boolean needModifyColumns(XTProps modifyColProps) {
        XTMetaData inputMD = this.getInputMetaData(0);
        int inputNum = this.getNumInputs() == 3 ? 2 : 1;
        XTMetaData valueMD = this.getInputMetaData(inputNum);
        int numValueColumns = valueMD.getNumColumns();
        if (inputNum == 1) {
            --numValueColumns;
        }
        boolean modifyColumnsNeeded = false;
        int vCol = 0;
        for (int i = 0; i < this.m_outColNums.length; ++i) {
            if (inputMD.getColumnType(this.m_outColNums[i]).equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG) && valueMD.getColumnType(vCol).equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                modifyColProps.set(new String[]{"columns", inputMD.ordinalToName(this.m_outColNums[i]), "datatype"}, valueMD.getColumnType(vCol));
                modifyColumnsNeeded = true;
            }
            if (++vCol != numValueColumns) continue;
            vCol = 0;
        }
        return modifyColumnsNeeded;
    }

    protected boolean copyInputToOutput() throws Exception {
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        boolean modifyColumnsNeeded = this.needModifyColumns(props);
        boolean ok = true;
        if (modifyColumnsNeeded) {
            CoersionEngineNode modifyColsEN = new CoersionEngineNode();
            modifyColsEN.setNodeID(this.getNodeID());
            modifyColsEN.setNetworkManager(this.getNetworkManager());
            CNKProcJavaTransform proc = new CNKProcJavaTransform();
            proc.setExecObject(modifyColsEN);
            this.printlnVerbose("converting double columns to string columns.");
            ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc);
            this.procDelete(proc);
            props.removeProperty(new String[]{"columns"});
        } else {
            this.getNetworkManager().copyFile(this.getInputDataCacheFileName(0), this.getOutputDataCacheFileName(0));
            this.setOutputMetaData(0, inputMD);
        }
        return ok;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps modifyColProps = this.getNodeProperties();
        try {
            this.initVars(modifyColProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean modifyColumnsNeeded = this.needModifyColumns(modifyColProps);
        XTMetaData outMD = null;
        if (modifyColumnsNeeded) {
            outMD = ModifyColumnsEngineNode.calculateOutputMetaData(modifyColProps, inputMD, 32);
            outMD.setNumRows(inputMD.getNumRows());
        } else {
            outMD = inputMD;
        }
        return outMD;
    }

    protected Vector[][] getLevelVectors(XTMetaData valueMD, XTMetaData outputMD) {
        int i;
        Vector[][] ret = new Vector[2][];
        ret[0] = new Vector[valueMD.getNumColumns()];
        for (i = 0; i < ret[0].length; ++i) {
            ret[0][i] = valueMD.getCategoricalDataFieldLevels(valueMD.ordinalToName(i));
        }
        ret[1] = new Vector[outputMD.getNumColumns()];
        for (i = 0; i < ret[1].length; ++i) {
            ret[1][i] = outputMD.getCategoricalDataFieldLevels(outputMD.ordinalToName(i));
        }
        return ret;
    }

    protected void copyColumn(DataCacheRowBuf val, int nValCol, Vector valLevs, DataCacheRowBuf out, int nOutCol, Vector outLevs) {
        if (out.isFactor(nOutCol)) {
            if (!val.isFactor(nValCol)) {
                out.setNA(nOutCol);
            } else {
                double v = val.getDouble(nValCol);
                if (Double.isNaN(v)) {
                    out.setNA(nOutCol);
                } else {
                    String lev = (String)valLevs.get((int)v);
                    int index = outLevs.indexOf(lev);
                    if (index == -1) {
                        index = outLevs.size();
                        outLevs.add(lev);
                    }
                    out.setLevelNum(nOutCol, index);
                }
            }
        } else if (!out.isDouble(nOutCol) || !val.isString(nValCol)) {
            if (out.isDouble(nOutCol) && val.isFactor(nValCol)) {
                out.setDouble(nOutCol, val.getLevelNum(nValCol));
            } else if (out.isString(nOutCol) && val.isDouble(nValCol)) {
                out.setString(nOutCol, Double.toString(val.getDouble(nValCol)));
            } else if (out.isString(nOutCol) && val.isFactor(nValCol)) {
                out.setString(nOutCol, Double.toString(val.getLevelNum(nValCol)));
            } else {
                out.copyColumn(nOutCol, nValCol, val);
            }
        }
    }

    protected void updateCategories(XTMetaData outputMD, Vector[] levels) {
        for (int c = 0; c < this.m_outColNums.length; ++c) {
            if (levels[this.m_outColNums[c]].size() == 0) continue;
            String cName = outputMD.ordinalToName(this.m_outColNums[c]);
            outputMD.setCategoricalLevels(cName, levels[this.m_outColNums[c]]);
        }
    }

    protected boolean positiveIndexing(DataCacheRowBuf buf, DataCacheRowBuf indBuf, DataCacheRowBuf outputBuf, DataInputStream indInputStream, XTMetaData outputMD, long ni, long nr) throws Exception {
        RandomAccessFile indStream = new RandomAccessFile(this.getInputDataCacheFileName(1), "rw");
        int bytesPerRow = indBuf.getBytesPerRow();
        byte[] indRowData = new byte[bytesPerRow];
        int inputNum = this.getNumInputs() == 3 ? 2 : 1;
        XTMetaData valueMD = this.getInputMetaData(inputNum);
        int indColumn = valueMD.getNumColumns() - 1;
        RandomAccessFile valueStream = new RandomAccessFile(this.getInputDataCacheFileName(inputNum), "rw");
        DataCacheRowBuf valueBuf = new DataCacheRowBuf(valueMD);
        int valueBytesPerRow = valueBuf.getBytesPerRow();
        byte[] valueData = new byte[valueBytesPerRow];
        int numValueColumns = valueMD.getNumColumns();
        if (inputNum == 1) {
            --numValueColumns;
        } else {
            indColumn = 0;
        }
        RandomAccessFile outputRWStream = new RandomAccessFile(this.getOutputDataCacheFileName(0), "rw");
        int outBytesPerRow = outputBuf.getBytesPerRow();
        byte[] outRowData = new byte[outBytesPerRow];
        Vector[][] levs = this.getLevelVectors(valueMD, outputMD);
        Vector[] valLevs = levs[0];
        Vector[] outLevs = levs[1];
        long outputRows = 0L;
        long indSeek = 0L;
        long valueSeek = 0L;
        for (long i = 0L; i < ni; ++i) {
            indStream.seek(indSeek);
            indStream.read(indRowData);
            indBuf.readRow(indRowData, 0);
            double rowNum = Math.floor(indBuf.getDouble(indColumn)) - 1.0;
            valueStream.seek(valueSeek);
            valueStream.read(valueData);
            valueBuf.readRow(valueData, 0);
            long seekTo = (long)(rowNum * (double)outBytesPerRow);
            outputRWStream.seek(seekTo);
            outputRWStream.read(outRowData);
            outputBuf.readRow(outRowData, 0);
            int defCol = 0;
            for (int c = 0; c < this.m_inColNums.length; ++c) {
                int inputColNum = defCol++;
                this.copyColumn(valueBuf, inputColNum, valLevs[inputColNum], outputBuf, this.m_outColNums[c], outLevs[this.m_outColNums[c]]);
                if (defCol != numValueColumns) continue;
                defCol = 0;
            }
            outputRWStream.seek(seekTo);
            outputRWStream.write(outputBuf.getDataBytes());
            indSeek += (long)bytesPerRow;
            valueSeek += (long)valueBytesPerRow;
        }
        indStream.close();
        valueStream.close();
        outputRWStream.close();
        this.updateCategories(outputMD, outLevs);
        return true;
    }

    protected boolean negativeIndexing(DataCacheRowBuf buf, DataCacheRowBuf indBuf, DataCacheRowBuf outputBuf, DataInputStream indInputStream, XTMetaData outputMD, long ni, long nr) throws Exception {
        XTMetaData valueMD = this.getInputMetaData(2);
        RandomAccessFile valueStream = new RandomAccessFile(this.getInputDataFile(), "r");
        DataCacheRowBuf valueBuf = new DataCacheRowBuf(valueMD);
        int valueBytesPerRow = valueBuf.getBytesPerRow();
        byte[] valueData = new byte[valueBytesPerRow];
        long numValueColumns = valueMD.getNumColumns();
        long numValueRows = valueMD.getNumRows();
        RandomAccessFile outputRWStream = new RandomAccessFile(this.getOutputDataCacheFileName(0), "rw");
        int bytesPerRow = outputBuf.getBytesPerRow();
        byte[] rowData = new byte[bytesPerRow];
        Vector[][] levs = this.getLevelVectors(valueMD, outputMD);
        Vector[] valLevs = levs[0];
        Vector[] outLevs = levs[1];
        long outputRows = 0L;
        double exclRow = -1.0;
        long i = 0L;
        long v = 0L;
        long r = 0L;
        long seekPos = 0L;
        long valSeekPos = 0L;
        while (r < nr) {
            if (i == 0L) {
                indBuf.readRow(indInputStream);
                exclRow = Math.floor(Math.abs(indBuf.getDouble(0))) - 1.0;
            }
            if ((double)i != exclRow) {
                if (v++ > numValueRows) {
                    valSeekPos = 0L;
                    v = 0L;
                }
                valueStream.seek(valSeekPos);
                valueStream.read(valueData);
                valueBuf.readRow(valueData, 0);
                outputRWStream.seek(seekPos);
                outputRWStream.read(rowData);
                outputBuf.readRow(rowData, 0);
                int defCol = 0;
                for (int c = 0; c < this.m_inColNums.length; ++c) {
                    int inputColNum = defCol++;
                    this.copyColumn(valueBuf, inputColNum, valLevs[inputColNum], outputBuf, this.m_outColNums[c], outLevs[this.m_outColNums[c]]);
                    if ((long)defCol != numValueColumns) continue;
                    defCol = 0;
                }
                outputRWStream.seek(seekPos);
                outputRWStream.write(outputBuf.getDataBytes());
                valSeekPos += (long)valueBytesPerRow;
            } else {
                indBuf.readRow(indInputStream);
                exclRow = Math.floor(Math.abs(indBuf.getDouble(0))) - 1.0;
            }
            seekPos += (long)bytesPerRow;
            ++r;
            ++i;
        }
        valueStream.close();
        outputRWStream.close();
        this.updateCategories(outputMD, outLevs);
        return true;
    }

    protected boolean logicalIndexing(DataCacheRowBuf unusedInBuf, DataCacheRowBuf indBuf, DataCacheRowBuf outputBuf, DataInputStream indInputStream, XTMetaData outputMD, long ni, long nr) throws Exception {
        if (ni != nr) {
            throw new RuntimeException("number of logical indices must match number of rows.");
        }
        XTMetaData valueMD = this.getInputMetaData(2);
        RandomAccessFile valueStream = new RandomAccessFile(this.getInputDataFile(), "r");
        DataCacheRowBuf valueBuf = new DataCacheRowBuf(valueMD);
        int valueBytesPerRow = valueBuf.getBytesPerRow();
        byte[] valueData = new byte[valueBytesPerRow];
        long numValueColumns = valueMD.getNumColumns();
        long numValueRows = valueMD.getNumRows();
        RandomAccessFile outputRWStream = new RandomAccessFile(this.getOutputDataCacheFileName(0), "rw");
        int bytesPerRow = outputBuf.getBytesPerRow();
        byte[] rowData = new byte[bytesPerRow];
        Vector[][] levs = this.getLevelVectors(valueMD, outputMD);
        Vector[] valLevs = levs[0];
        Vector[] outLevs = levs[1];
        long outputRows = 0L;
        long v = 0L;
        long seekPos = 0L;
        long valSeekPos = 0L;
        for (long i = 0L; i < ni; ++i) {
            boolean changeRow;
            indBuf.readRow(indInputStream);
            boolean bl = changeRow = Math.floor(indBuf.getDouble(0)) == 1.0;
            if (changeRow) {
                if (v++ > numValueRows) {
                    valSeekPos = 0L;
                    v = 0L;
                }
                valueStream.seek(valSeekPos);
                valueStream.read(valueData);
                valueBuf.readRow(valueData, 0);
                outputRWStream.seek(seekPos);
                outputRWStream.read(rowData);
                outputBuf.readRow(rowData, 0);
                int defCol = 0;
                for (int c = 0; c < this.m_inColNums.length; ++c) {
                    int inputColNum = defCol++;
                    this.copyColumn(valueBuf, inputColNum, valLevs[inputColNum], outputBuf, this.m_outColNums[c], outLevs[this.m_outColNums[c]]);
                    if ((long)defCol != numValueColumns) continue;
                    defCol = 0;
                }
                outputRWStream.seek(seekPos);
                outputRWStream.write(outputBuf.getDataBytes());
                valSeekPos += (long)valueBytesPerRow;
            }
            seekPos += (long)bytesPerRow;
        }
        valueStream.close();
        outputRWStream.close();
        this.updateCategories(outputMD, outLevs);
        return true;
    }

    protected String getInputDataFile() {
        return this.getInputDataCacheFileName(2);
    }

    protected String getInputDataBlobFile() {
        return this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), 2);
    }

    protected String getSetDataFile() {
        return this.getInputDataFile();
    }

    protected String getSetDataBlobFile() {
        return this.getInputDataBlobFile();
    }

    protected String getIndexFile() {
        return this.getInputDataCacheFileName(1);
    }

    protected XTMetaData getOutputMD() throws Exception {
        return this.getOutputMetaData(0);
    }

    private class CoersionEngineNode
    extends ModifyColumnsEngineNode {
    }
}

