/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class DesktopUtils {
    protected static final int UNUSED_HEIGHT = 0;
    protected static int nextX;
    protected static int nextY;
    protected static final int DEFAULT_OFFSETX = 24;
    protected static final int DEFAULT_OFFSETY = 24;
    protected static int offsetX;
    protected static int offsetY;

    public static void tileVertical(JDesktopPane desktop) {
        DesktopManager manager = desktop.getDesktopManager();
        if (manager == null) {
            return;
        }
        Component[] comps = desktop.getComponents();
        JInternalFrame[] allFrames = new JInternalFrame[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (comp instanceof JInternalFrame) {
                allFrames[i] = (JInternalFrame)comp;
                continue;
            }
            if (!(comp instanceof JInternalFrame.JDesktopIcon)) continue;
            JInternalFrame jif = ((JInternalFrame.JDesktopIcon)comp).getInternalFrame();
            try {
                jif.setIcon(false);
                allFrames[i] = jif;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int resizableCnt = 0;
        for (int x = 0; x < allFrames.length; ++x) {
            JInternalFrame frame = allFrames[x];
            if (frame == null || !frame.isVisible() || frame.isIcon()) continue;
            if (!frame.isResizable()) {
                try {
                    frame.setMaximum(false);
                }
                catch (Exception _e) {
                    // empty catch block
                }
            }
            if (!frame.isResizable()) continue;
            ++resizableCnt;
        }
        int count = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            if (allFrames[i] == null) continue;
            ++count;
        }
        if (count > 0 && resizableCnt > 0) {
            double root = Math.sqrt(count);
            int rows = (int)root;
            int columns = count / rows;
            int spares = count - columns * rows;
            Dimension paneSize = desktop.getSize();
            int columnWidth = paneSize.width / columns;
            int availableHeight = paneSize.height - 0;
            int mainHeight = availableHeight / rows;
            int smallerHeight = availableHeight / (rows + 1);
            int rowHeight = mainHeight;
            int x = 0;
            int y = 0;
            int thisRow = rows;
            int normalColumns = columns - spares;
            for (int i = allFrames.length - 1; i >= 0; --i) {
                JInternalFrame comp = allFrames[i];
                if (comp == null) continue;
                comp.setSize(columnWidth, rowHeight);
                comp.setLocation(x, y);
                y += rowHeight;
                if (--thisRow != 0) continue;
                y = 0;
                x += columnWidth;
                if (--normalColumns <= 0) {
                    thisRow = rows + 1;
                    rowHeight = smallerHeight;
                    continue;
                }
                thisRow = rows;
            }
        }
    }

    public static final void tileHorizontal(JDesktopPane desktop) {
        int resizableCnt = 0;
        Component[] allComps = desktop.getComponents();
        JInternalFrame[] allFrames = new JInternalFrame[allComps.length];
        for (int i = 0; i < allComps.length; ++i) {
            Component comp = allComps[i];
            if (comp instanceof JInternalFrame) {
                allFrames[i] = (JInternalFrame)comp;
                continue;
            }
            if (!(comp instanceof JInternalFrame.JDesktopIcon)) continue;
            JInternalFrame jif = ((JInternalFrame.JDesktopIcon)comp).getInternalFrame();
            try {
                jif.setIcon(false);
                allFrames[i] = jif;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int x = 0; x < allFrames.length; ++x) {
            JInternalFrame frame = allFrames[x];
            if (frame == null || !frame.isVisible() || frame.isIcon()) continue;
            if (!frame.isResizable()) {
                try {
                    frame.setMaximum(false);
                }
                catch (Exception _e) {
                    // empty catch block
                }
            }
            if (!frame.isResizable()) continue;
            ++resizableCnt;
        }
        int width = desktop.getBounds().width;
        int height = DesktopUtils.arrangeIcons(desktop);
        if (resizableCnt != 0) {
            int fHeight = height / resizableCnt;
            int yPos = 0;
            for (int x = 0; x < allFrames.length; ++x) {
                JInternalFrame frame = allFrames[x];
                if (!frame.isVisible() || !frame.isResizable() || frame.isIcon()) continue;
                frame.setSize(width, fHeight);
                frame.setLocation(0, yPos);
                yPos += fHeight;
            }
        }
    }

    public static final int arrangeIcons(JDesktopPane desktop) {
        int height;
        int iconCnt = 0;
        JInternalFrame[] allFrames = desktop.getAllFrames();
        for (int x = 0; x < allFrames.length; ++x) {
            if (!allFrames[x].isVisible() || !allFrames[x].isIcon()) continue;
            ++iconCnt;
        }
        int yPos = height = desktop.getBounds().height;
        if (iconCnt != 0) {
            int width = desktop.getBounds().width;
            int xPos = 0;
            for (int x = 0; x < allFrames.length; ++x) {
                JInternalFrame frame = allFrames[x];
                if (!frame.isVisible() || !frame.isIcon()) continue;
                Dimension dim = frame.getDesktopIcon().getSize();
                int iWidth = dim.width;
                int iHeight = dim.height;
                if (yPos == height) {
                    yPos = height - iHeight;
                }
                if (xPos + iWidth > width && xPos != 0) {
                    xPos = 0;
                    yPos -= iHeight;
                }
                frame.getDesktopIcon().setLocation(xPos, yPos);
                xPos += iWidth;
            }
        }
        return yPos;
    }

    public static void cascadeAll(JDesktopPane desktop) {
        Component[] comps = desktop.getComponents();
        int count = comps.length;
        nextX = 0;
        nextY = 0;
        for (int i = count - 1; i >= 0; --i) {
            Component comp = comps[i];
            if (comp instanceof JInternalFrame && comp.isVisible()) {
                DesktopUtils.cascade(comp, desktop);
                continue;
            }
            if (!(comp instanceof JInternalFrame.JDesktopIcon)) continue;
            JInternalFrame jif = ((JInternalFrame.JDesktopIcon)comp).getInternalFrame();
            try {
                jif.setIcon(false);
                DesktopUtils.cascade(jif, desktop);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void minimizeAll(JDesktopPane desktop) {
        Component[] comps = desktop.getComponents();
        int count = comps.length;
        for (int i = count - 1; i >= 0; --i) {
            JInternalFrame jif;
            Component comp = comps[i];
            if (!(comp instanceof JInternalFrame) || !comp.isVisible() || !(jif = (JInternalFrame)comp).isIconifiable()) continue;
            try {
                jif.setIcon(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static void cascade(Component comp, JDesktopPane desktop) {
        Dimension paneSize = desktop.getSize();
        int targetWidth = 3 * paneSize.width / 4;
        int targetHeight = 3 * paneSize.height / 4;
        DesktopManager manager = desktop.getDesktopManager();
        if (manager == null) {
            comp.setBounds(0, 0, targetWidth, targetHeight);
            return;
        }
        if (nextX + targetWidth > paneSize.width || nextY + targetHeight > paneSize.height) {
            nextX = 0;
            nextY = 0;
        }
        manager.setBoundsForFrame((JComponent)comp, nextX, nextY, targetWidth, targetHeight);
        nextX += offsetX;
        nextY += offsetY;
    }

    static {
        offsetX = 24;
        offsetY = 24;
    }
}

