/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKSplusDateFormat;
import com.insightful.miner.WorksheetPropertiesManager;

public class EngineStringConverter {
    private CNKSplusDateFormat m_dateFormatter = null;
    private CNKSplusDateFormat m_dateParser = null;
    private WorksheetPropertiesManager m_worksheetPropertiesManager = null;
    private String m_dateFormatterString = null;
    private String m_dateParserString = null;

    public EngineStringConverter(WorksheetPropertiesManager wpm, String parserString, String formatterString) {
        this.m_worksheetPropertiesManager = wpm.copy();
        this.m_dateParserString = parserString;
        this.m_dateFormatterString = formatterString;
    }

    public CNKSplusDateFormat getDateFormatter() {
        if (this.m_dateFormatter == null) {
            String dateString = this.m_dateFormatterString != null ? this.m_dateFormatterString : this.m_worksheetPropertiesManager.getDateFormatString();
            this.m_dateFormatter = new CNKSplusDateFormat(dateString);
            this.m_dateFormatter.setCenturyCutoff(this.m_worksheetPropertiesManager.getCenturyCutoff());
        }
        return this.m_dateFormatter;
    }

    public CNKSplusDateFormat getDateParser() {
        if (this.m_dateParser == null) {
            String dateString = this.m_dateParserString != null ? this.m_dateParserString : this.m_worksheetPropertiesManager.getDateParseString();
            this.m_dateParser = new CNKSplusDateFormat(dateString);
            this.m_dateParser.setCenturyCutoff(this.m_worksheetPropertiesManager.getCenturyCutoff());
        }
        return this.m_dateParser;
    }

    public String convertDoubleToString(double val) {
        String str = this.m_worksheetPropertiesManager.formatFreeDouble(val);
        return str;
    }

    public double convertStringToDouble(String val) {
        try {
            double d = this.m_worksheetPropertiesManager.parseFreeDouble(val);
            return d;
        }
        catch (Exception ex) {
            return CNKObj.getDoubleNA();
        }
    }

    public String convertDateToString(long dt) {
        String val = this.getDateFormatter().convertTimeDateToString(dt);
        return val;
    }

    public long convertStringToDate(String val) {
        long dt = this.getDateParser().convertStringToTimeDate(val);
        return dt;
    }

    public static long convertJulianToDate(double val) {
        long dt = (long)(val * 8.64E7);
        return dt;
    }

    public static double convertDateToJulian(long val) {
        double jul = (double)val / 8.64E7;
        return jul;
    }
}

