/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.XTProps;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class EngineWorksheetManager {
    private Hashtable m_worksheetIDToNetworkHash = new Hashtable();

    public Object getMessageSendee(String worksheetID, String nodeID) {
        if (worksheetID == null || worksheetID.length() == 0) {
            return this;
        }
        EngineNetworkManager mgr = this.getNetworkManager(worksheetID);
        if (mgr == null || nodeID == null || nodeID.length() == 0) {
            return mgr;
        }
        return mgr.getNode(nodeID);
    }

    public void closeWorksheet(String worksheetID) throws Exception {
        EngineNetworkManager mgr = this.getNetworkManager(worksheetID);
        if (mgr == null) {
            return;
        }
        mgr.closeWorksheet();
        this.m_worksheetIDToNetworkHash.remove(worksheetID);
    }

    public EngineNetworkManager getNetworkManager(String worksheetID) {
        if (worksheetID == null || worksheetID.length() == 0) {
            return null;
        }
        Object obj = this.m_worksheetIDToNetworkHash.get(worksheetID);
        return (EngineNetworkManager)obj;
    }

    private String getNewWorksheetID(String filename) {
        String id;
        String string = id = filename == null || filename.equals("") ? null : new File(filename).getName();
        if (id == null || id.length() == 0) {
            id = "worksheet";
        }
        if (this.m_worksheetIDToNetworkHash.containsKey(id)) {
            for (int i = 2; i < 1000; ++i) {
                if (this.m_worksheetIDToNetworkHash.containsKey(id + i)) continue;
                id = id + i;
                break;
            }
        }
        return id;
    }

    public String createEngineNetworkManager(String worksheetDir, String imwPath, boolean imwIsReadOnly) throws Exception {
        String worksheetID = this.getNewWorksheetID(worksheetDir);
        EngineNetworkManager netMgr = new EngineNetworkManager(worksheetID, worksheetDir, imwPath, imwIsReadOnly);
        this.m_worksheetIDToNetworkHash.put(worksheetID, netMgr);
        return worksheetID;
    }

    public void registerEngineNetworkManager(String worksheetID, EngineNetworkManager netMgr) {
        this.m_worksheetIDToNetworkHash.put(worksheetID, netMgr);
    }

    public void storeGuiGlobalOptionsInAllWorksheets(XTProps val) {
        Enumeration e = this.m_worksheetIDToNetworkHash.elements();
        while (e.hasMoreElements()) {
            EngineNetworkManager netMgr = (EngineNetworkManager)e.nextElement();
            netMgr.storeGuiGlobalOptions(val);
        }
    }
}

