/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.HelpManager;
import com.insightful.miner.MinerApp;
import com.insightful.miner.TextOutputScrollPane;
import java.io.InputStream;
import java.io.PrintWriter;

public class HelpManagerImpl
implements HelpManager {
    private InputStream helpErr = null;
    private InputStream helpOut = null;
    private PrintWriter output = null;
    private Process extHelp;
    private TextOutputScrollPane tWindow = null;

    public HelpManagerImpl(TextOutputScrollPane w, boolean launch) {
        if (launch) {
            this.launchHelp();
        }
        this.tWindow = w;
    }

    public HelpManagerImpl(TextOutputScrollPane w) {
        this(w, true);
    }

    public HelpManagerImpl() {
        this.launchHelp();
    }

    private void launchHelp() {
        try {
            String classpath;
            String helpURL;
            String cmd = System.getProperty("sprime.home");
            if (System.getProperty("os.name", "").toLowerCase().indexOf("windows") < 0) {
                cmd = cmd + "/splus/java/jre/bin/java";
                if (System.getProperty("os.name", "unknown").toLowerCase().indexOf("irix") >= 0) {
                    cmd = cmd + " -native";
                }
            } else {
                cmd = "\"" + cmd.replace('/', '\\') + "\\splus\\java\\jre\\bin\\javaw\"";
            }
            if ((helpURL = System.getProperty("splus.help.host")) != null) {
                String hostname = null;
                String helplink = null;
                if (helpURL.toLowerCase().startsWith("http://")) {
                    helpURL = helpURL.substring(7);
                }
                if (helpURL.length() > 0) {
                    int idx = helpURL.indexOf("/");
                    if (idx != -1) {
                        hostname = helpURL.substring(0, idx);
                        helplink = helpURL.length() > idx + 1 ? helpURL.substring(idx + 1) : "";
                    } else {
                        hostname = helpURL;
                    }
                    if (hostname != null && hostname.length() > 0) {
                        cmd = cmd + " -Dsplus.server.host=" + hostname;
                    }
                    if (helplink != null && helplink.length() > 0) {
                        cmd = cmd + " -Dsplus.server.helplink=" + helplink;
                    }
                }
            }
            if ((classpath = "\"" + System.getProperty("java.class.path") + "\"") != null) {
                cmd = cmd + " -classpath " + classpath;
            }
            cmd = cmd + " -Dsprime.home=" + System.getProperty("sprime.home");
            cmd = cmd + " com.insightful.miner.HelpProxy &";
            this.extHelp = Runtime.getRuntime().exec(cmd);
            this.output = new PrintWriter(this.extHelp.getOutputStream());
            this.helpOut = this.extHelp.getInputStream();
            this.helpErr = this.extHelp.getErrorStream();
            Thread dumpHelpOut = new Thread(new Runnable(){

                public void run() {
                    try {
                        while (HelpManagerImpl.this.helpOut.read() != -1) {
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            dumpHelpOut.start();
            Thread dumpHelpErr = new Thread(new Runnable(){

                public void run() {
                    try {
                        while (HelpManagerImpl.this.helpErr.read() != -1) {
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            dumpHelpErr.start();
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
        }
    }

    public void addHelpSet(String classpath, String name) {
        this.sendCmd("addHelpset &" + classpath + "& &" + name + "&\n");
    }

    public void removeHelpSet(String hsname) {
        this.sendCmd("removeHelpset &" + hsname + "&\n");
    }

    public void openJhelp() {
        this.sendCmd("openJhelp\n");
    }

    public void openJhelp(String view) {
        this.sendCmd("openJhelp &" + view + "&\n");
    }

    public void displayJhelp(String topic) {
        this.sendCmd("displayJhelp &" + topic + "&\n");
    }

    public void closeJhelp() {
        this.extHelp.destroy();
        this.output = null;
    }

    private void sendCmd(String cmd) {
        boolean crashed = false;
        try {
            this.extHelp.exitValue();
            crashed = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.output == null || crashed) {
            String msg = "Starting up Java help system.  This may take a minute.";
            if (this.tWindow == null) {
                System.out.println("Starting up Java help system.  This may take a minute.");
            } else {
                Thread warn = new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        HelpManagerImpl.this.tWindow.append("Starting up Java help system.  This may take a minute.\n> ", MinerApp.getMessageSeverity());
                    }
                });
                warn.start();
            }
            this.launchHelp();
        }
        this.output.print(cmd);
        this.output.flush();
    }

    public void createJhelp(String name) {
    }

    public void createJhelp(String name, int width, int height) {
    }

    public void exit() {
        this.closeJhelp();
    }

    public void showViewer() {
        this.openJhelp();
    }

    public void showContents() {
        this.openJhelp("TOC");
    }

    public void showIndex() {
        this.openJhelp("Index");
    }

    public void showSearch() {
        this.openJhelp("Search");
    }

    public void showTopic(String key) {
        key = key.toLowerCase().replace(' ', '_');
        if (!(key = key.replace(':', '_')).endsWith("_htm")) {
            key = key + "_htm";
        }
        this.displayJhelp(key);
    }

    public void showPDF(String filePath) {
        String pdfViewer = MinerApp.getPDFViewer();
        if (pdfViewer.length() == 0) {
            pdfViewer = "acroread";
        }
        String cmd = pdfViewer + " " + filePath;
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception ex) {
            System.err.println("Can't find acrobat reader (acroread).");
            System.err.println("Make sure the reader is installed and the executable is in your PATH.");
            throw new RuntimeException("Acrobat reader not found.");
        }
    }
}

