/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeConfigured;
import com.insightful.miner.ActivityNodeLinked;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ActivityNodeState;
import com.insightful.miner.AppAction;
import com.insightful.miner.BDLManager;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.CollabraSpaceLinkManager;
import com.insightful.miner.CollapsedNodeArea;
import com.insightful.miner.CollapsedNodeDialog;
import com.insightful.miner.ColumnFilterGenerator;
import com.insightful.miner.ColumnFilterTools;
import com.insightful.miner.CommentUtilities;
import com.insightful.miner.CreateLinkDialog;
import com.insightful.miner.CreateNodeDialog;
import com.insightful.miner.DefaultNodePropertiesDialog;
import com.insightful.miner.DesktopUtils;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.ExecViewer;
import com.insightful.miner.ExplorerPane;
import com.insightful.miner.ExtensionManager;
import com.insightful.miner.FilePropertiesDialog;
import com.insightful.miner.GlobalPropertiesDialog;
import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.HelpManager;
import com.insightful.miner.HelpManagerImpl;
import com.insightful.miner.IMinerExeImpl;
import com.insightful.miner.LibraryManagerDialog;
import com.insightful.miner.MinerAboutBox;
import com.insightful.miner.MinerFrame;
import com.insightful.miner.MinerLicenseInfo;
import com.insightful.miner.MinerTextNode;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.NodeViewer;
import com.insightful.miner.PredictNodeModel;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.PredictorLink;
import com.insightful.miner.PrintPreview;
import com.insightful.miner.ResourceManager;
import com.insightful.miner.SPLUSVersionInfo;
import com.insightful.miner.SplashScreen;
import com.insightful.miner.StartupDialog;
import com.insightful.miner.TextOutputScrollPane;
import com.insightful.miner.UnixLicenseManager;
import com.insightful.miner.Viewable;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.Win32Tools;
import com.insightful.miner.WinHelpManagerImpl;
import com.insightful.miner.WinLicenseManager;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetFileFilter;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XMLTreeProps;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.miner.graph.ExportGraphCommand;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineQueryHandler;
import com.insightful.splus.SplusLicenseException;
import com.insightful.splus.SplusServerFileHandler;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionImpl;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.client.ServerFileSystemView;
import com.insightful.splus.util.StringUtilities;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoCopyMap;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.layout.JGoLayeredDigraphAutoLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MinerApp
implements SplusEngineQueryHandler,
SplusServerFileHandler,
SplusWinSessionListener {
    private static boolean g_isWindowsOS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    private static boolean g_isSolarisOS = System.getProperty("os.name").toLowerCase().indexOf("sunos") >= 0;
    private static boolean g_isLinuxOS = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0;
    private static boolean g_isHPUXOS = System.getProperty("os.name").toLowerCase().indexOf("hp-ux") >= 0;
    private static boolean g_isAIXOS = System.getProperty("os.name").toLowerCase().indexOf("aix") >= 0;
    private static boolean g_isInteractive = true;
    private static String g_userName;
    private static String g_userHome;
    private static String g_sprimeHome;
    private static String g_workDir;
    private static String g_tempDir;
    private static String g_splusHome;
    private static String g_splusProj;
    private static String g_settingsDir;
    private static final String DEFAULT_SETTINGS_FILE_NAME = "DefaultSettings.xml";
    private static final String SETTINGS_DIR_NAME = ".iminer_settings_8_0";
    private static final String TEMP_DIR_NAME = ".Temp";
    private static final String USERS_RELATIVE_PATH = "users";
    private static final String HELP_CHM_RELATIVE_PATH = "help/iminer.chm";
    private static final String DEFAULT_WORKDIR_NAME = "iminer_work_8_0";
    private static final String HELP_CHM_RELATIVE_PATH_INBDL = "cmd/gui.chm";
    public static final String WORKSHEET_DIR_EXTENSION = ".wsd";
    public static final String DEFAULT_SETTINGS_NODE_TAG = "DefaultSettings";
    public static final String GLOBAL_OPTIONS_NODE_TAG = "GlobalOptions";
    public static final String RECENTLY_SAVED_FILE_NODE_TAG = "RecentlySavedFileList";
    public static String LOCALE_LANGUAGE;
    public static String LOCALE_COUNTRY;
    public static boolean INTERNATIONAL;
    private static ResourceBundle g_textBundles;
    public static String m_uiFontName;
    private static SplusSession g_splusSession;
    private static boolean g_addSplusListener;
    private static MinerApp g_mainApp;
    private static MinerFrame g_mainFrame;
    private static HelpManager g_helpManager;
    private static ResourceManager g_resourceManager;
    private static PrintStream g_originalStandardOut;
    private static PrintStream g_batchLogfileStream;
    public static int SUCCESS_CODE;
    public static int ERROR_CODE;
    private static int g_returnCode;
    private static String g_defaultSettingsFile;
    private static XMLTree g_appSettings;
    private static XTProps g_globalOptions;
    private static WorksheetPropertiesManager g_worksheetPropertiesManager;
    private static WorksheetView g_worksheetPropertiesView;
    private static Vector g_recentFileList;
    private static Vector g_nodeViewers;
    private static Object g_evalSync;
    private static boolean g_evalInProgress;
    private static boolean g_engineChangingState;
    private static HashMap g_nodesToInvalidate;
    private static SPLUSVersionInfo g_splusVersionInfo;
    public static final int DEBUG_MESSAGE_SEVERITY = 0;
    public static final int VERBOSE_MESSAGE_SEVERITY = 1;
    public static final int INFORMATION_MESSAGE_SEVERITY = 2;
    public static final int WARNING_MESSAGE_SEVERITY = 3;
    public static final int ERROR_MESSAGE_SEVERITY = 4;
    private static int g_messageSeverity;
    private static int g_logMessageSeverity;
    public static String DEBUG_MESSAGE_SEVERITY_STRING;
    public static String VERBOSE_MESSAGE_SEVERITY_STRING;
    public static String INFORMATION_MESSAGE_SEVERITY_STRING;
    public static String WARNING_MESSAGE_SEVERITY_STRING;
    public static String ERROR_MESSAGE_SEVERITY_STRING;
    public static boolean m_loadIMBigDataLibraryDone;
    private static XTProps g_lastGlobalOptions;
    private static boolean g_splusBusy;
    public static final String SPLUS_PARSE_COMPLETE = "complete";
    public static final String SPLUS_PARSE_PARTIAL = "partial";
    private static final String SPLUS_PARSE_TEST_FUNCTION = "parseTestFunc <- function(str) {  obj <- try(parse(textConnection(str)));   if (class(obj) == 'Error') return(substring(unpaste(obj, sep='\n')[[1]], 40))   else return('complete')}";
    private static WorksheetView g_bdView;
    private static WorksheetDocument g_bdDoc;
    public static final int WINDOW_OFFSET = 25;
    public static final int WINDOW_MAX = 5;
    private static int g_winCount;
    private static boolean g_stopRequested;
    private static boolean g_isRunning;
    private static HashPrintRequestAttributeSet g_defaultPrintAttributeSet;
    private static PageFormat g_defaultPageFormat;
    private static AppAction g_FileNewAction;
    private static AppAction g_FileOpenAction;
    private static AppAction g_FileCloseAction;
    private static AppAction g_FileSaveAction;
    private static AppAction g_FileSaveAsAction;
    private static AppAction g_FileSaveAsJPEGAction;
    private static AppAction g_FilePropertiesAction;
    private static AppAction g_PrintPreviewAction;
    private static AppAction g_PrintSetupAction;
    private static AppAction g_PrintAction;
    private static AppAction g_ExitAction;
    private static AppAction g_CutAction;
    private static AppAction g_CopyAction;
    private static AppAction g_PasteAction;
    private static AppAction g_DeleteAction;
    private static AppAction g_SelectAllAction;
    private static AppAction g_UndoAction;
    private static AppAction g_RedoAction;
    private static AppAction g_ObjectPropertiesAction;
    private static AppAction g_ObjectViewAction;
    private static AppAction g_ShowDataViewerAction;
    private static AppAction g_ViewToolbarAction;
    private static AppAction g_ViewExplorerAction;
    private static AppAction g_ViewMessagePaneAction;
    private static AppAction g_ViewCommandLineAction;
    private static AppAction g_ZoomNormalAction;
    private static AppAction g_ZoomInAction;
    private static AppAction g_ZoomOutAction;
    private static AppAction g_ZoomToFitAction;
    private static AppAction g_OrthoAllAction;
    private static AppAction g_OrthoAction;
    private static AppAction g_ExpandExpAction;
    private static AppAction g_CollapseExpAction;
    private static AppAction g_AutoLayoutAction;
    private static AppAction g_AboutAction;
    private static AppAction g_ToolsOptionsAction;
    private static AppAction g_InvalidateNodeAction;
    private static AppAction g_RunAction;
    private static AppAction g_RunToHereAction;
    private static AppAction g_StopAction;
    private static AppAction g_HelpContentsAction;
    private static AppAction g_HelpIndexAction;
    private static AppAction g_HelpSearchAction;
    private static AppAction g_ExpandAllAction;
    private static AppAction g_ExpandAction;
    private static AppAction g_CollapseAction;
    private static AppAction g_CopyToUserLibraryAction;
    private static AppAction g_CreateFilterAction;
    private static AppAction g_CreatePredictorAction;
    private static AppAction g_EditCommentsAction;
    private static AppAction g_RenameAction;
    private static AppAction g_MouseDrivenPasteAction;
    private static AppAction g_TileHorizontalAction;
    private static AppAction g_TileVerticalAction;
    private static AppAction g_CascadeAction;
    private static AppAction g_ArrangeIconsAction;
    private static AppAction g_MinimizeAllAction;
    private static AppAction g_HelpNodeAction;
    private static AppAction g_HelpUsersGuideAction;
    private static AppAction g_HelpGettingStartedAction;
    private static AppAction g_CreateLink;
    private static AppAction g_CreateNode;
    private static AppAction g_DefaultNodeProperties;
    private static AppAction g_DeleteNodeCacheAction;
    private static AppAction g_DisplayNodeCacheAction;
    private static AppAction g_CollabraSpaceOpenAction;
    private static AppAction g_CollabraSpaceSaveAction;
    private static AppAction g_CreateTextNode;
    private static AppAction g_CloseViewers;
    private static AppAction g_manageLibrariesAction;
    private static AppAction g_libraryPasteAction;
    private static AppAction g_createNewFolderAction;
    private static AppAction g_hideLibraryAction;
    private static AppAction g_libraryPropertiesAction;
    private static AppAction g_saveLibraryAsAction;
    private static AppAction g_revertLibraryAction;
    private static AppAction g_createNewLibraryAction;
    private static AppAction g_toggleLibraryDropable;
    private static AppAction g_clipWorksheetAction;
    private static JMenuItem g_undoMenuItem;
    private static JMenuItem g_redoMenuItem;
    private static StringBuffer m_savedBatchOutput;
    private static boolean g_checkedSplusLicenseFlag;
    private static boolean g_hasSplusLicenseFlag;
    private static final String CANNOT_START_SPLUS_TITLE = "Cannot Start S-PLUS";
    private static final String CANNOT_START_SPLUS_MSG = "S-PLUS is installed but S-PLUS cannot be started.\nThis may indicate that a trial version of S-PLUS has expired\nor that an S-PLUS license is not available.\n\nThe S-PLUS Library functionality will be disabled.";
    private static final String[] SPLUS_ENGINE_NODES;
    private static final String[] INVISIBLE_BETA_NODES;
    private static HashMap g_execViewerMap;
    private static Runnable g_mainThreadRequest;
    private static Object g_mainThreadResult;
    private static Object g_mainThreadWaitObject;
    private static Object g_mainThreadRequestWaitObject;
    private static boolean m_isInBDL;
    private static boolean m_isInBDLInit;
    private static ResourceBundle m_errorBundle;

    private MinerApp() {
    }

    public static boolean isSplusValidVersion() {
        return g_splusVersionInfo.IsValid();
    }

    public static boolean setupWorkingDir(boolean interactive) {
        File workDirTmp;
        boolean bValidWorkDir = false;
        String sAltWorkDir = g_workDir;
        try {
            workDirTmp = new File(sAltWorkDir);
            bValidWorkDir = !workDirTmp.exists() ? workDirTmp.mkdirs() : true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create work dir at: " + sAltWorkDir);
        }
        if (bValidWorkDir) {
            return bValidWorkDir;
        }
        sAltWorkDir = MinerApp.getUserHome() + "/" + DEFAULT_WORKDIR_NAME;
        if (sAltWorkDir.endsWith(":")) {
            sAltWorkDir = sAltWorkDir + "/";
        }
        try {
            workDirTmp = new File(sAltWorkDir);
            if (!workDirTmp.exists()) {
                bValidWorkDir = workDirTmp.mkdirs();
                if (bValidWorkDir) {
                    g_workDir = sAltWorkDir;
                }
            } else {
                bValidWorkDir = true;
                g_workDir = sAltWorkDir;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create work dir at: " + sAltWorkDir);
        }
        if (bValidWorkDir) {
            return bValidWorkDir;
        }
        String sErrorMsg = MinerApp.getText("MinerApp_msg_failedToCreateWorkingDir") + "\n" + MinerApp.getText("MinerApp_msg_programCannotbeUsedWithoutValidWorkingDir") + "\n\n" + MinerApp.getText("MinerApp_msg_triedToCreateDirAt") + "\n" + g_workDir + " " + MinerApp.getText("MinerApp_msg_andAt") + "\n" + sAltWorkDir + "\n";
        if (interactive) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), sErrorMsg);
        } else {
            System.out.println(sErrorMsg);
        }
        return bValidWorkDir;
    }

    public static void init(boolean interactive) {
        String msgType;
        if (g_mainApp != null) {
            return;
        }
        if (MinerApp.isInBDL()) {
            interactive = false;
        }
        g_isInteractive = interactive;
        g_worksheetPropertiesManager = new WorksheetPropertiesManager();
        if (!(System.getProperty("iminer.use.english", "").toLowerCase().equals("true") || System.getProperty("user.language", "").equals("en") && System.getProperty("user.country", "").equals("US"))) {
            LOCALE_LANGUAGE = System.getProperty("user.language", "");
            LOCALE_COUNTRY = System.getProperty("user.country", "");
            INTERNATIONAL = true;
            g_textBundles = MinerApp.getBundle("textBundles");
            if (MinerApp.isErrorBundle(g_textBundles)) {
                LOCALE_LANGUAGE = "en";
                LOCALE_COUNTRY = "US";
                INTERNATIONAL = false;
            }
        }
        if (!INTERNATIONAL && MinerApp.isErrorBundle(g_textBundles = MinerApp.getBundle("textBundles"))) {
            MinerApp.displayError("Settings Not Loaded.", "Error while attempting to load text properties.");
            System.exit(1);
        }
        if (System.getProperty("iminer.use.windows.string.encoding") == null) {
            System.setProperty("iminer.use.windows.string.encoding", INTERNATIONAL ? "true" : "false");
        }
        m_uiFontName = System.getProperty("iminer.font", INTERNATIONAL ? "Dialog" : "Arial");
        Font uiFont = MinerApp.getFont(0, 12);
        UIManager.put("MenuBar.font", uiFont);
        UIManager.put("MenuItem.font", uiFont);
        UIManager.put("Menu.font", uiFont);
        UIManager.put("PopupMenu.font", uiFont);
        UIManager.put("ToolTip.font", uiFont);
        UIManager.put("ToolBar.font", uiFont);
        UIManager.put("CheckBoxMenuItem.font", uiFont);
        UIManager.put("RadioButtonMenuItem.font", uiFont);
        UIManager.put("OptionPane.font", uiFont);
        UIManager.put("OptionPane.buttonFont", uiFont);
        UIManager.put("OptionPane.messageFont", uiFont);
        g_mainApp = new MinerApp();
        g_nodeViewers = new Vector();
        g_userName = System.getProperty("user.name");
        g_userHome = System.getProperty("user.home");
        g_sprimeHome = System.getProperty("sprime.home");
        if (g_sprimeHome == null) {
            throw new RuntimeException("sprime.home is not set");
        }
        File sprimeHomeFile = new File(g_sprimeHome);
        if (!sprimeHomeFile.exists()) {
            throw new IllegalArgumentException("sprime.home directory does not exist:  " + g_sprimeHome);
        }
        g_sprimeHome = sprimeHomeFile.getAbsolutePath();
        if (!MinerApp.isInBDL()) {
            g_splusHome = new File(g_sprimeHome + "/splus").getAbsolutePath();
            System.setProperty("splus.shome", g_splusHome);
        } else {
            g_splusHome = System.getProperty("splus.shome");
        }
        if (!MinerApp.isInBDL()) {
            if (MinerApp.isWindowsOS()) {
                if (!WinLicenseManager.hasValidLicense()) {
                    WinLicenseManager.shutdownLicenseManager();
                    System.exit(1);
                }
            } else if (MinerApp.isUnixOS() && !UnixLicenseManager.hasValidLicense()) {
                UnixLicenseManager.shutdownLicenseManager();
                System.exit(1);
            }
        }
        JWindow splash_frame = null;
        if (MinerApp.isInteractive()) {
            splash_frame = new JWindow();
            Dimension screenSize = splash_frame.getToolkit().getScreenSize();
            splash_frame.setBounds((screenSize.width - 520) / 2, (screenSize.height - 315) / 2, 520, 315);
            splash_frame.getContentPane().add(new SplashScreen());
            splash_frame.pack();
            splash_frame.setVisible(true);
            splash_frame.setCursor(Cursor.getPredefinedCursor(3));
            splash_frame.toFront();
        }
        if ((msgType = System.getProperty("sprime.message.severity")) != null) {
            if (msgType.equalsIgnoreCase(DEBUG_MESSAGE_SEVERITY_STRING)) {
                MinerApp.setDebugMessageSeverity();
            } else if (msgType.equalsIgnoreCase(VERBOSE_MESSAGE_SEVERITY_STRING)) {
                MinerApp.setVerboseMessageSeverity();
            } else if (msgType.equalsIgnoreCase(INFORMATION_MESSAGE_SEVERITY_STRING)) {
                MinerApp.setInformationMessageSeverity();
            } else if (msgType.equalsIgnoreCase(WARNING_MESSAGE_SEVERITY_STRING)) {
                MinerApp.setWarningMessageSeverity();
            } else if (msgType.equalsIgnoreCase(ERROR_MESSAGE_SEVERITY_STRING)) {
                MinerApp.setErrorMessageSeverity();
            }
        }
        g_settingsDir = MinerApp.getUserHome() + "/" + SETTINGS_DIR_NAME;
        File settingsDirFile = new File(g_settingsDir);
        try {
            String buildDateString;
            SimpleDateFormat buildDateFormatter;
            long buildTime;
            long settingsDirCreationTime;
            if (settingsDirFile.exists() && settingsDirFile.isDirectory() && (settingsDirCreationTime = settingsDirFile.lastModified()) < (buildTime = (buildDateFormatter = new SimpleDateFormat("yyyy/MM/dd 'at' hh:mm:ss a")).parse(buildDateString = ResourceBundle.getBundle("minerBuild").getString("buildDate")).getTime())) {
                boolean deleteSettings = true;
                if (MinerApp.isInteractive()) {
                    int answer = AcceleratorOptionPane.showOKCancelDialog(null, MinerApp.getText("MinerApp_deleteSettingsDirMsg"), MinerApp.getText("MinerApp_deleteSettingsDirTitle"), 3);
                    deleteSettings = answer == 0;
                } else {
                    System.out.println(MinerApp.getText("MinerApp_deleteSettingsDirMsg"));
                }
                if (deleteSettings) {
                    File[] files = settingsDirFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        files[i].delete();
                    }
                    settingsDirFile.delete();
                    settingsDirFile.mkdir();
                }
            }
        }
        catch (MissingResourceException mre) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!settingsDirFile.exists()) {
                settingsDirFile.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot create settings dir: " + g_settingsDir);
        }
        g_settingsDir = settingsDirFile.getAbsolutePath();
        g_defaultSettingsFile = g_settingsDir + "/" + DEFAULT_SETTINGS_FILE_NAME;
        g_appSettings = MinerApp.getAppSettings();
        g_workDir = MinerApp.getGlobalOptions().getValue("workingDir");
        if (g_workDir == null || g_workDir.length() == 0) {
            g_workDir = System.getProperty("sprime.work");
        }
        if (g_workDir == null || g_workDir.length() == 0) {
            g_workDir = MinerApp.getUserHome() + "/" + DEFAULT_WORKDIR_NAME;
        }
        if (g_workDir.endsWith(":")) {
            g_workDir = g_workDir + "/";
        }
        if (!MinerApp.setupWorkingDir(interactive)) {
            System.exit(1);
        }
        File workDirFile = new File(g_workDir);
        g_workDir = workDirFile.getAbsolutePath();
        String logfileName = System.getProperty("sprime.logfile", "");
        MinerApp.setOriginalStandardOut(System.out);
        if (logfileName.length() == 0) {
            logfileName = workDirFile.getAbsolutePath() + "/logfile.txt";
        }
        if (logfileName.length() > 0 && !logfileName.equals("false")) {
            MinerApp.startLogfile(logfileName);
        }
        MinerApp.println("LOCALE_LANGUAGE=" + LOCALE_LANGUAGE + ", LOCALE_COUNTRY=" + LOCALE_COUNTRY + ", INTERNATIONAL=" + INTERNATIONAL);
        MinerApp.println("iminer.use.windows.string.encoding==" + System.getProperty("iminer.use.windows.string.encoding"));
        MinerApp.println("UI font name=" + m_uiFontName);
        System.setProperty("user.home", g_workDir);
        g_tempDir = System.getProperty("sprime.temp");
        if (g_tempDir == null || g_tempDir.equals("")) {
            g_tempDir = MinerApp.getWorkDir() + "/" + TEMP_DIR_NAME;
        }
        File tempDirFile = new File(g_tempDir);
        try {
            if (!tempDirFile.exists()) {
                tempDirFile.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot create temp dir: " + g_tempDir);
        }
        g_tempDir = tempDirFile.getAbsolutePath();
        g_splusProj = System.getProperty("splus.sproj");
        if (g_splusProj == null) {
            g_splusProj = g_workDir;
        }
        File projFile = new File(g_splusProj);
        try {
            projFile.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot create S-PLUS project dir: " + g_splusProj);
        }
        g_splusProj = projFile.getAbsolutePath();
        g_recentFileList = MinerApp.loadRecentlySavedFileList();
        String userDir = System.getProperty("user.dir");
        if (MinerApp.isSplusLicensed() && !MinerApp.isInBDL()) {
            MinerApp.loadIMBigDataLibrary();
        }
        System.setProperty("user.dir", userDir);
        if (!MinerApp.isInBDL()) {
            SplusSystem.setEngineQueryHandler((SplusEngineQueryHandler)g_mainApp);
            MinerApp.initCwd();
            SplusSystem.setServerFileHandler((SplusServerFileHandler)g_mainApp);
        }
        g_resourceManager = new ResourceManager(new String[]{MinerApp.getSplusHome() + "/library/bigdata/images/", MinerApp.getSplusHome() + "/library/bigdata/images/nodes/"});
        if (!MinerApp.isHeadless()) {
            MinerApp.initAppActions();
            MinerApp.initPopupMenus();
            g_mainFrame = new MinerFrame(g_mainApp);
        }
        if (!MinerApp.isHeadless()) {
            g_mainFrame.show();
            g_mainFrame.toFront();
            if (MinerApp.isWindowsOS()) {
                Win32Tools.init();
            }
        }
        MinerApp.outputText("", 2, true);
        if (!MinerApp.isHeadless()) {
            ExtensionManager.init();
        }
        if (!MinerApp.isWindowsOS()) {
            if (MinerApp.isHeadless()) {
                g_helpManager = new HelpManager(){

                    public void showViewer() {
                    }

                    public void showContents() {
                    }

                    public void showIndex() {
                    }

                    public void showSearch() {
                    }

                    public void showTopic(String key) {
                    }

                    public void showPDF(String filePath) {
                    }

                    public void exit() {
                    }
                };
            } else {
                try {
                    g_helpManager = new HelpManagerImpl(g_mainFrame.getOutputScrollPane(), true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            String chmFile = MinerApp.getSprimeHome() + "/" + HELP_CHM_RELATIVE_PATH;
            if (INTERNATIONAL && !MinerApp.isInBDL()) {
                String intlChmFile = chmFile.replace(".chm", "_" + LOCALE_LANGUAGE + "_" + LOCALE_COUNTRY + ".chm");
                if (new File(intlChmFile).exists()) {
                    chmFile = intlChmFile;
                } else {
                    MinerApp.println("Can't find localized file " + intlChmFile + " : will use " + chmFile);
                }
            }
            if (MinerApp.isInBDL()) {
                chmFile = System.getProperty("splus.shome", "") + "/" + HELP_CHM_RELATIVE_PATH_INBDL;
            }
            g_helpManager = new WinHelpManagerImpl(chmFile);
        }
        if (CollabraSpaceLinkManager.isInstalled()) {
            CollabraSpaceLinkManager.init();
        }
        if (MinerApp.isInteractive()) {
            if (g_isWindowsOS) {
                IMinerExeImpl iMinerExe = new IMinerExeImpl();
                iMinerExe.callback();
            }
            splash_frame.dispose();
            g_mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
        AppAction.updateAllActions();
    }

    public static void loadIMBigDataLibrary() {
        try {
            MinerApp.println("bigdata library load: started");
            m_loadIMBigDataLibraryDone = false;
            MinerApp.getSession().writeSplusIn("{try({library(bigdata);bd.internal.miner.init()});.JavaMethod('com/insightful/miner/MinerApp', 'loadIMBigDataLibraryDone', '()V')}\n");
            int cnt = 1;
            int sleepMsec = 250;
            int printInc = 4;
            int timeoutMsec = 20000;
            for (int i = 0; i < timeoutMsec / sleepMsec && !m_loadIMBigDataLibraryDone; ++i) {
                if (i % printInc == 0) {
                    MinerApp.println("bigdata library load: waiting for load... (" + cnt++ + ")");
                }
                try {
                    Thread.sleep(sleepMsec);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            MinerApp.println("bigdata library load: " + (m_loadIMBigDataLibraryDone ? "done" : "timeout"));
        }
        catch (RemoteException e) {
            MinerApp.println("bigdata library load: exception: " + e);
            e.printStackTrace();
        }
    }

    public static void loadIMBigDataLibraryDone() {
        m_loadIMBigDataLibraryDone = true;
    }

    public static void main(String[] args) {
        int i;
        if (System.getProperty("version") != null) {
            try {
                MinerAboutBox versionInfo = new MinerAboutBox();
                String versionText = versionInfo.getVersionInfoText();
                versionText = versionText + versionInfo.getCopywriteInfoText();
                System.out.println(versionText);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
        MinerApp.init(true);
        ExplorerPane pane = MinerApp.getMainFrame().getExplorerPane();
        XTProps globalProps = MinerApp.getGlobalOptions();
        String[] libraryPath = new String[]{"ExplorerPage", ""};
        String[] showPath = new String[]{"ExplorerPage", "", "show"};
        Vector originalPaths = null;
        Vector editableNames = null;
        int imlArgs = 0;
        for (i = 0; i < args.length; ++i) {
            String eName;
            libraryPath[1] = null;
            showPath[1] = null;
            if (i == 0) {
                originalPaths = globalProps.getSubPropertyValues(libraryPath[0]);
                editableNames = globalProps.getSubProperties(libraryPath[0]);
            }
            if (!args[i].endsWith(".iml")) continue;
            ++imlArgs;
            File file = MinerApp.getAbsolutePathFile(args[i]);
            String filePath = file.getAbsolutePath();
            int index = originalPaths.indexOf(filePath);
            if (index != -1) {
                libraryPath[1] = showPath[1] = (String)editableNames.get(index);
            }
            if (index != -1 && globalProps.getBoolean(showPath, false)) continue;
            String string = eName = index == -1 ? MinerApp.generateUniqueEditName(file.getName(), globalProps) : showPath[1];
            if (index == -1) {
                pane.externalAdd(ExplorerPane.getLibrary(eName, filePath), eName, true);
                continue;
            }
            pane.changeVisibility(eName, filePath, true, null, MinerApp.getIMLShowPos(eName, globalProps));
        }
        if (args.length - imlArgs == 0) {
            for (i = 0; i < args.length; ++i) {
                int tabNum;
                if (!args[i].endsWith(".iml") || (tabNum = pane.getTabPosition(new File(args[i]).getName())) == -1) continue;
                pane.setSelectedIndex(tabNum);
                break;
            }
            if (globalProps.getBoolean("showStartup", true)) {
                MinerApp.showStartupDialog();
            }
        } else {
            boolean firstIMLFile = true;
            for (int i2 = 0; i2 < args.length; ++i2) {
                int tabNum;
                if (!args[i2].endsWith(".iml")) {
                    MinerApp.openWorksheet(MinerApp.getAbsolutePathFile(args[i2]), true);
                    continue;
                }
                if (!firstIMLFile || (tabNum = pane.getTabPosition(args[i2])) == -1) continue;
                pane.setSelectedIndex(tabNum);
                firstIMLFile = false;
            }
        }
        if (MinerApp.isSolarisOS() && MinerApp.isInteractive()) {
            MinerApp.handleMainThreadRequests();
        }
    }

    public static void applyCommandLineParameters(WorksheetDocument doc) {
        XTProps params = doc.getWorksheetParameters();
        if (params == null) {
            try {
                params = new XTProps();
                doc.setWorksheetParameters(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MinerApp.applyCommandLineParameters(params);
        doc.setEngineNetworkDirty();
    }

    public static void applyCommandLineParameters(XTNetwork net) {
        XTProps params = net.getWorksheetParameters();
        if (params == null) {
            try {
                params = new XTProps();
                net.setWorksheetParameters(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MinerApp.applyCommandLineParameters(params);
    }

    private static void applyCommandLineParameters(XTProps params) {
        String parameters = System.getProperty("parameters");
        String parameterFile = System.getProperty("parameterFile");
        if (parameterFile != null) {
            try {
                FileInputStream fis = new FileInputStream(parameterFile);
                if (fis != null) {
                    Properties props = new Properties();
                    props.load(new BufferedInputStream(fis));
                    Enumeration<Object> keyList = props.keys();
                    if (keyList.hasMoreElements()) {
                        parameters = parameters == null ? new String("") : parameters + ", ";
                    }
                    while (keyList.hasMoreElements()) {
                        String key = (String)keyList.nextElement();
                        String value = props.getProperty(key);
                        parameters = parameters + key + "=" + value + (keyList.hasMoreElements() ? ", " : "");
                    }
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (parameters == null) {
            return;
        }
        StringTokenizer csvTokenizer = new StringTokenizer(parameters, ",");
        int numParams = csvTokenizer.countTokens();
        String[] paramNames = new String[numParams];
        String[] paramValues = new String[numParams];
        numParams = 0;
        while (csvTokenizer.hasMoreElements()) {
            paramValues[numParams] = null;
            paramNames[numParams] = null;
            String equation = (String)csvTokenizer.nextElement();
            StringTokenizer esvTokenizer = new StringTokenizer(equation, "=");
            if (esvTokenizer.countTokens() <= 0) continue;
            String pName = (String)esvTokenizer.nextElement();
            paramNames[numParams] = pName.trim();
            paramValues[numParams++] = equation.replaceAll(pName + "=", "").trim();
        }
        for (int p = 0; p < numParams; ++p) {
            String pName = paramNames[p];
            if (pName.startsWith("%") && pName.endsWith("%")) {
                params.set(pName, paramValues[p]);
                continue;
            }
            params.set("%" + pName + "%", paramValues[p]);
        }
    }

    private static File getAbsolutePathFile(String filename) {
        File argumentFile = new File(filename);
        if (!argumentFile.isAbsolute()) {
            return new File(MinerApp.getSprimeHome() + "/" + filename);
        }
        return argumentFile;
    }

    public static int getIMLShowPos(String editName, XTProps globalProps) {
        String[] showPath = new String[]{"ExplorerPage", "", "show"};
        Vector editableNames = globalProps.getSubProperties(showPath[0]);
        int ret = 0;
        for (int i = 0; i < editableNames.size(); ++i) {
            showPath[1] = (String)editableNames.get(i);
            if (showPath[1].equals(editName)) {
                return ret;
            }
            if (!globalProps.getBoolean(showPath, false)) continue;
            ++ret;
        }
        return -1;
    }

    public static String generateUniqueEditName(String desiredName, XTProps globalProps) {
        String extension = "";
        String fileName = desiredName;
        String tFileName = desiredName;
        int extensionLoc = desiredName.lastIndexOf(".");
        if (extensionLoc > -1) {
            tFileName = fileName = desiredName.substring(0, extensionLoc);
            extension = desiredName.substring(extensionLoc);
        }
        int num = 2;
        Vector currentEditNames = globalProps.getSubProperties("ExplorerPage");
        String settingsDir = System.getProperty("user.home") + "/" + SETTINGS_DIR_NAME + "/";
        while (currentEditNames.contains(fileName + extension) || new File(settingsDir + fileName + extension).exists()) {
            fileName = tFileName + Integer.toString(num++);
        }
        return fileName + extension;
    }

    private static void showStartupDialog() {
        StartupDialog startupDialog = null;
        startupDialog = g_recentFileList.size() > 0 ? new StartupDialog(g_recentFileList) : new StartupDialog(new Vector());
        if (!startupDialog.isCancelRequested()) {
            if (startupDialog.isNewWorksheet()) {
                MinerApp.newWorksheet();
            } else if (startupDialog.getWorksheetFilename() != null) {
                MinerApp.openWorksheet(new File(startupDialog.getWorksheetFilename()));
            }
        }
        startupDialog.dispose();
        AppAction.updateAllActions();
    }

    public static HelpManager getHelpManager() {
        return g_helpManager;
    }

    public static MinerFrame getMainFrame() {
        return g_mainFrame;
    }

    public static String getWorksheetDir(String filename) {
        String fileStem = filename;
        String ext = ".imw";
        if (fileStem.toLowerCase().endsWith(ext)) {
            fileStem = fileStem.substring(0, fileStem.length() - ext.length());
        }
        return fileStem + WORKSHEET_DIR_EXTENSION;
    }

    public static void changeDocWorksheetDir(WorksheetDocument doc, boolean copyState) {
        try {
            String newWorksheetDir = null;
            String wsd = MinerApp.getWSDFromWorksheetProperties(doc);
            if (wsd != null) {
                newWorksheetDir = wsd;
            } else {
                String newDocFilename = doc.getLocation();
                if (newDocFilename.equals("")) {
                    throw new Exception("changeDocWorksheetDir given empty filename");
                }
                newWorksheetDir = MinerApp.getWorksheetDir(newDocFilename);
            }
            GuiMessageHandler.sendMessageToEngine(MinerApp.getCurrentWorksheetID(doc), "", "changeWorksheetDir", new Object[]{newWorksheetDir, new Boolean(copyState)});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeDocWorksheet(WorksheetDocument doc) {
        try {
            String worksheetID = doc.getWorksheetID();
            if (worksheetID.equals("")) {
                return;
            }
            GuiMessageHandler.sendMessageToEngine("", "", "closeWorksheet", new Object[]{worksheetID});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getCurrentWorksheetID() throws Exception {
        return MinerApp.getCurrentWorksheetID(MinerApp.getCurrentDoc());
    }

    public static String getCurrentWorksheetID(WorksheetDocument doc) throws Exception {
        String worksheetID = doc.getWorksheetID();
        if (worksheetID.equals("")) {
            boolean imwIsReadOnly;
            Object obj;
            String worksheetDirPath = MinerApp.getWorksheetDirPath(doc);
            boolean initTempWSD = worksheetDirPath == null || worksheetDirPath.equals("");
            String imwPath = doc.getLocation();
            if (imwPath == null) {
                imwPath = "";
            }
            if ((obj = GuiMessageHandler.sendMessageToEngine("", "", "createEngineNetworkManager", new Object[]{worksheetDirPath, imwPath, new Boolean(imwIsReadOnly = doc.isLocationReadOnly())})) != null && obj instanceof Exception) {
                throw (Exception)obj;
            }
            if (obj == null || !(obj instanceof String) || "".equals(obj)) {
                throw new Exception("error creating worksheet directory " + worksheetDirPath + ": " + obj);
            }
            worksheetID = (String)obj;
            doc.setWorksheetID(worksheetID);
            boolean wsdIsTemp = false;
            try {
                obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "isTempWorksheetDir", null);
                if (obj != null && obj instanceof Boolean) {
                    wsdIsTemp = (Boolean)obj;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            doc.setIsTemp(wsdIsTemp && !initTempWSD);
            if (wsdIsTemp) {
                XTProps props = doc.getWorksheetProperties();
                String currentDefaultFileDir = props.getValue("defaultFileDir", "");
                String currentWSDDir = props.getValue("wsdDir", "");
                if (currentDefaultFileDir.equals("") && !initTempWSD) {
                    File parentDir = new File(worksheetDirPath).getParentFile();
                    props.set("defaultFileDir", parentDir.getPath());
                    MinerApp.outputText("Worksheet Default File Directory set to " + parentDir.getPath(), 3, true);
                }
                if (!currentWSDDir.equals("")) {
                    props.set("wsdDir", "");
                    MinerApp.outputText("Worksheet Data Directory set to \"\"", 3, true);
                }
                doc.setWorksheetProperties(props);
                MinerApp.updateWorksheetPropertiesManager();
            }
            g_lastGlobalOptions = null;
        }
        return worksheetID;
    }

    public static String getWorksheetDirPath(WorksheetDocument doc) {
        String docFile = doc.getLocation();
        String propsWSD = MinerApp.getWSDFromWorksheetProperties(doc);
        String worksheetDirPath = null;
        worksheetDirPath = propsWSD != null ? propsWSD : (!docFile.equals("") ? MinerApp.getWorksheetDir(docFile) : "");
        return worksheetDirPath;
    }

    public static String getWSDFromWorksheetProperties(WorksheetDocument doc) {
        String wsd = WorksheetPropertiesManager.getWSDDirectoryFromProps(doc.getWorksheetProperties());
        return wsd == null || wsd.equals("") ? null : wsd;
    }

    public static String getAbsolutePath(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            fileName = "";
        }
        String result = fileName;
        try {
            WorksheetDocument doc = MinerApp.getCurrentView().getDoc();
            String worksheetID = MinerApp.getCurrentWorksheetID(doc);
            MinerApp.saveGuiNetworkToEngine(doc);
            Object obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "getAbsolutePath", new Object[]{fileName});
            if (obj != null && obj instanceof String) {
                result = (String)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean doesEngineFileExist(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            fileName = "";
        }
        boolean result = false;
        try {
            WorksheetDocument doc = MinerApp.getCurrentDoc();
            String worksheetID = MinerApp.getCurrentWorksheetID(doc);
            MinerApp.saveGuiNetworkToEngine(doc);
            Object obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "doesFileExist", new Object[]{fileName});
            if (obj != null && obj instanceof Boolean) {
                result = (Boolean)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void saveGuiNetworkToEngine(WorksheetDocument doc) throws Exception {
        Object obj;
        if (doc == null || doc.isDummyEngineConnection()) {
            return;
        }
        String worksheetID = MinerApp.getCurrentWorksheetID(doc);
        try {
            XTProps currentGlobalOptions = MinerApp.getGlobalOptions();
            if (g_lastGlobalOptions == null || !g_lastGlobalOptions.equals(currentGlobalOptions)) {
                XTProps copyGlobalOptions = new XTProps(currentGlobalOptions);
                obj = GuiMessageHandler.sendMessageToEngine("", "", "storeGuiGlobalOptionsInAllWorksheets", new Object[]{copyGlobalOptions});
                g_lastGlobalOptions = copyGlobalOptions;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (doc.isEngineNetworkDirty()) {
            XTNetwork net = (XTNetwork)doc.getXTNetwork().copy();
            obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "saveGuiNetwork", new Object[]{net});
            net = null;
            System.gc();
            if (obj instanceof Exception) {
                System.out.println("error saving network to engine: " + obj);
                throw (Exception)obj;
            }
            doc.resetEngineNetworkDirty();
        }
    }

    public SplusDataResult processDataQuery(String cmd) {
        return MinerApp.eval(cmd);
    }

    public SplusDataResult processDataQuery(String cmd, int timeout) {
        return MinerApp.eval(cmd);
    }

    public void processDialogCommand(String cmd) {
        MinerApp.eval(cmd);
    }

    public void writeEngineOutput(String data, boolean prompt) {
    }

    public static boolean waitingOnSplus() {
        return g_splusBusy;
    }

    private static void setSplusBusy(boolean value) {
        g_splusBusy = value;
        if (g_mainFrame != null) {
            if (value) {
                g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_eval_splusexp"));
            } else {
                g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_ready"));
            }
            if (g_StopAction != null) {
                g_StopAction.updateEnabled();
            }
            if (g_RunAction != null) {
                g_RunAction.updateEnabled();
            }
            if (g_RunToHereAction != null) {
                g_RunToHereAction.updateEnabled();
            }
            g_mainFrame.setCommandLineEnabled(!value);
        }
    }

    private static void splusInteractiveCommand() {
        g_mainFrame.setCommandLineEnabled(true);
    }

    public void eventOccurred(SplusWinSessionEvent event) {
        if (event == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                MinerApp.setSplusBusy(true);
                break;
            }
            case 21: {
                MinerApp.splusInteractiveCommand();
                break;
            }
            case 2: {
                MinerApp.setSplusBusy(false);
                break;
            }
            case 32: {
                MinerApp.exit();
                break;
            }
        }
    }

    public static void writeEngineInput(final String expr) {
        if (g_splusSession != null) {
            if (g_addSplusListener) {
                ((SplusWinSessionImpl)g_splusSession).addListener((SplusWinSessionListener)g_mainApp);
                g_addSplusListener = false;
            }
            new Thread(new Runnable(){

                public void run() {
                    try {
                        g_splusSession.writeSplusIn(expr);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public FileSystemView getServerFileSystemView() {
        return FileSystemView.getFileSystemView();
    }

    public FileInputStream getServerFileInputStream(String name) throws FileNotFoundException {
        return new FileInputStream(name);
    }

    public FileOutputStream getServerFileOutputStream(String name) throws FileNotFoundException, IOException {
        return new FileOutputStream(name);
    }

    public static SplusSession getSession() {
        if (g_splusSession == null && !MinerApp.isInBDL() && !g_checkedSplusLicenseFlag) {
            System.setProperty("splus.interactive.commandline", System.getProperty("splus.interactive.commandline", "T"));
            if (!MinerApp.isWindowsOS()) {
                System.setProperty("splus.help.off", "true");
            }
            String[] args = new String[]{"java.exe", "/mNr_", "S_HOME=" + MinerApp.getSprimeHome() + "/splus", "S_PROJ=" + g_splusProj};
            try {
                g_splusSession = new SplusWinSessionImpl(args);
                g_checkedSplusLicenseFlag = true;
                g_hasSplusLicenseFlag = true;
            }
            catch (SplusLicenseException sle) {
                g_checkedSplusLicenseFlag = true;
                g_hasSplusLicenseFlag = false;
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (g_splusSession == null) {
                if (MinerApp.isInteractive()) {
                    AcceleratorOptionPane.showOKDialog(null, CANNOT_START_SPLUS_MSG, CANNOT_START_SPLUS_TITLE, 0);
                } else {
                    System.out.println(CANNOT_START_SPLUS_MSG);
                }
            }
        }
        return g_splusSession;
    }

    public static void endSession(boolean killClient) {
        if (g_splusSession != null) {
            try {
                g_splusSession.sessionExit(killClient);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            g_splusSession = null;
        }
    }

    private static void initCwd() {
        File cwd = null;
        if (System.getProperty("splus.client.mode", "").equals("true")) {
            try {
                cwd = new ServerFileSystemView().getHomeDirectory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            cwd = new File(MinerApp.getWorkDir());
        }
        SplusSystem.setCwd((File)cwd);
    }

    public static ResourceManager getResourceManager() {
        return g_resourceManager;
    }

    public static SplusDataResult eval(String cmd) {
        return MinerApp.eval(cmd, false, true, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplusDataResult eval(String cmd, boolean Output, boolean Result2, boolean Errors, boolean Warnings, boolean Expr) {
        String errorString = "unknown error";
        Object object = g_evalSync;
        synchronized (object) {
            if (g_evalInProgress) {
                throw new RuntimeException("SplusUserApp.eval called while eval in progress");
            }
            g_evalInProgress = true;
        }
        try {
            SplusDataResult result;
            if (MinerApp.getSession() == null) {
                throw new Exception("Can't access S-PLUS session");
            }
            SplusDataResult splusDataResult = result = MinerApp.getSession().evalDataQuery("{" + cmd + "}", Output, Result2, Errors, Warnings, Expr);
            return splusDataResult;
        }
        catch (Exception ex) {
            errorString = ex.getLocalizedMessage();
        }
        finally {
            g_evalInProgress = false;
        }
        return new SplusDataResult("", "MinerApp.eval error: " + errorString, cmd, new String[0]);
    }

    public static String splusParseTest(String expression) {
        String result = "[Error in parse test]";
        String teststring = "{parseTestFunc <- function(str) {  obj <- try(parse(textConnection(str)));   if (class(obj) == 'Error') return(substring(unpaste(obj, sep='\n')[[1]], 40))   else return('complete')}; parseTestFunc('" + StringUtilities.escapeSpecialCharacters((String)expression) + "')}";
        MinerApp.getMainFrame().getOutputHandler().setWriteToOutputPane(false);
        try {
            result = MinerApp.eval(teststring).getStringData()[0];
            if (result.startsWith("Unexpected end of file")) {
                result = SPLUS_PARSE_PARTIAL;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MinerApp.getMainFrame().getOutputHandler().setWriteToOutputPane(true);
        return result;
    }

    public static boolean shouldSplusBeHidden() {
        return false;
    }

    public static boolean getSplusLicensedGlobalOptions() {
        return MinerApp.getGlobalOptions().getBoolean("sfl", false);
    }

    public static void setSplusLicensedGlobalOptions() {
        MinerApp.getGlobalOptions().set("sfl", true);
    }

    public static void resetSplusLicensedGlobalOptions() {
        MinerApp.getGlobalOptions().removeProperty(new String[]{"sfl"});
    }

    public static void exit() {
        boolean ok = true;
        if (!MinerApp.isHeadless()) {
            try {
                g_mainFrame.closeDocuments();
            }
            catch (PropertyVetoException e) {
                ok = false;
            }
            g_mainFrame.saveWindowInfo();
            if (ok) {
                try {
                    if (MinerApp.isSplusLicensed()) {
                        MinerApp.setSplusLicensedGlobalOptions();
                    }
                    g_mainFrame.getExplorerPane().save(MinerApp.getGlobalOptions());
                    MinerApp.storeRecentlySavedFileList();
                    MinerApp.storeAppSettings();
                    if (!MinerApp.isInBDL()) {
                        if (MinerApp.isWindowsOS()) {
                            WinLicenseManager.shutdownLicenseManager();
                        } else if (MinerApp.isUnixOS()) {
                            UnixLicenseManager.shutdownLicenseManager();
                        }
                    }
                    if (g_helpManager != null) {
                        g_helpManager.exit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (ok) {
            System.exit(MinerApp.getReturnCode());
        }
    }

    private static void setOriginalStandardOut(PrintStream outs) {
        g_originalStandardOut = outs;
    }

    public static PrintStream getOriginalStandardOut() {
        return g_originalStandardOut;
    }

    public static void setBatchLogfile(String logfilePath, boolean appendLog) throws FileNotFoundException {
        if (g_batchLogfileStream != null) {
            try {
                g_batchLogfileStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            g_batchLogfileStream = null;
        }
        if (logfilePath != null && logfilePath.length() > 0) {
            g_batchLogfileStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(logfilePath), appendLog)));
        }
    }

    public static PrintStream getBatchLogfileStream() {
        return g_batchLogfileStream;
    }

    public static void flushBatchLogfile() {
        try {
            if (MinerApp.getBatchLogfileStream() != null) {
                MinerApp.getBatchLogfileStream().flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setReturnError(boolean error) {
        if (error) {
            g_returnCode = ERROR_CODE;
        }
    }

    public static int getReturnCode() {
        return g_returnCode;
    }

    private static void startLogfile(String filename) {
        try {
            PrintStream outStr = new PrintStream(new FileOutputStream(new File(filename)), true);
            System.setOut(outStr);
            System.setErr(outStr);
            if (!g_isWindowsOS) {
                String chmodCmd = "chmod 640 " + filename;
                try {
                    Runtime.getRuntime().exec(chmodCmd);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("\n\nCan't set permissions on logfile.\n");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error initializing logfile.");
            e.printStackTrace();
        }
    }

    public static WorksheetView getCurrentView() {
        if (CollapsedNodeDialog.getView() != null) {
            return CollapsedNodeDialog.getView();
        }
        if (MinerApp.isHeadless()) {
            return g_bdView;
        }
        return g_mainFrame.getCurrentView();
    }

    public static WorksheetDocument getCurrentDoc() {
        if (CollapsedNodeDialog.getView() != null) {
            return CollapsedNodeDialog.getView().getDoc();
        }
        if (MinerApp.isHeadless()) {
            return g_bdDoc;
        }
        return g_mainFrame.getCurrentView().getDoc();
    }

    public static void addWorksheet(WorksheetView view) {
        if (MinerApp.isHeadless()) {
            g_bdView = view;
        } else {
            MinerApp.getMainFrame().addWorksheet(view);
        }
    }

    public static void setCurrentView(WorksheetView view) {
        if (MinerApp.isHeadless()) {
            g_bdView = view;
        } else {
            MinerApp.getMainFrame().setCurrentView(view);
        }
    }

    public static void setCurrentDoc(WorksheetDocument doc) {
        if (MinerApp.isHeadless()) {
            g_bdDoc = doc;
        }
    }

    public static void resetNextWindowLocation() {
        g_winCount = 0;
    }

    public static Point getNextWindowLocation() {
        int offset = g_winCount % 5 * 25;
        ++g_winCount;
        return new Point(offset, offset);
    }

    public static WorksheetView getViewWithID(String id) {
        JInternalFrame[] frames = g_mainFrame.getDesktop().getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            for (int j = frames[i].getContentPane().getComponentCount() - 1; j >= 0; --j) {
                try {
                    Container pane = frames[i].getContentPane();
                    WorksheetView v = (WorksheetView)((Object)pane.getComponent(j));
                    WorksheetDocument d = v.getDoc();
                    if (!id.equals(d.getWorksheetID())) continue;
                    return v;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void newWorksheet() {
        Component comp = g_mainFrame.getGlassPane();
        Cursor oldCursor = comp.getCursor();
        comp.setCursor(Cursor.getPredefinedCursor(3));
        MouseAdapter ma = new MouseAdapter(){};
        KeyAdapter ka = new KeyAdapter(){};
        comp.addMouseListener(ma);
        comp.addKeyListener(ka);
        comp.setVisible(true);
        WorksheetDocument doc = new WorksheetDocument(true);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat df = new SimpleDateFormat("MMMMMMMMM dd, yyyy");
            doc.setComments(CommentUtilities.createNewComments(document, MinerApp.getUserName(), df.format(now)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XTProps props = doc.getWorksheetProperties();
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, MinerApp.getGlobalOptions());
        doc.setWorksheetProperties(props);
        doc.initEngineConnection();
        MinerApp.addWorksheet(new WorksheetView(doc));
        MinerApp.updateFrameWindowMenu();
        AppAction.updateAllActions();
        try {
            MinerApp.getCurrentWorksheetID();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        doc.setModified(false);
        doc.discardAllEdits();
        comp.removeMouseListener(ma);
        comp.removeKeyListener(ka);
        comp.setVisible(false);
        comp.setCursor(oldCursor);
    }

    public static void showAboutBox() {
        new MinerAboutBox().show();
    }

    public static void editWorksheetProperties() {
        WorksheetView v = MinerApp.getCurrentView();
        if (v != null) {
            FilePropertiesDialog.getInstance().showFileProperties(v.getDoc());
        }
    }

    public static void openWorksheet() {
        int returnVal;
        File curFile = null;
        boolean fileExists = false;
        WideFileChooser chooser = new WideFileChooser(SplusSystem.getCwd(), SplusSystem.getServerFileHandler().getServerFileSystemView());
        chooser.addChoosableFileFilter(new WorksheetFileFilter());
        while (!fileExists && (returnVal = chooser.showOpenDialog(MinerApp.getMainFrame())) == 0) {
            curFile = chooser.getSelectedFile();
            fileExists = curFile.exists();
            if (fileExists) continue;
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("MinerApp_msg_fileMustExist"));
        }
        if (curFile != null && fileExists) {
            SplusSystem.setCwd((File)curFile.getParentFile());
            new OpenFileThread(curFile).start();
        }
    }

    public static void openWorksheet(File file) {
        MinerApp.openWorksheet(file, false);
    }

    public static void openWorksheet(File file, boolean checkCommandLineParams) {
        JInternalFrame[] frames = MinerApp.getMainFrame().getDesktop().getAllFrames();
        String absolutePath = file.getAbsolutePath();
        for (int i = 0; i < frames.length; ++i) {
            WorksheetView view = (WorksheetView)((Object)frames[i].getContentPane().getComponent(0));
            if (!view.getDoc().getLocation().equals(absolutePath)) continue;
            MinerApp.getMainFrame().getDesktop().getDesktopManager().activateFrame(frames[i]);
            AppAction.updateAllActions();
            return;
        }
        Component comp = g_mainFrame.getGlassPane();
        Cursor oldCursor = comp.getCursor();
        comp.setCursor(Cursor.getPredefinedCursor(3));
        MouseAdapter ma = new MouseAdapter(){};
        KeyAdapter ka = new KeyAdapter(){};
        comp.addMouseListener(ma);
        comp.addKeyListener(ka);
        comp.setVisible(true);
        String prevStatus = g_mainFrame.getStatusText();
        g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_opening") + "  " + absolutePath);
        SplusSystem.setCwd((File)file);
        WorksheetView view = new WorksheetView();
        JInternalFrame frame = MinerApp.getMainFrame().addWorksheet(view);
        WorksheetDocument doc = WorksheetDocument.open(file);
        if (doc != null && checkCommandLineParams) {
            MinerApp.applyCommandLineParameters(doc);
        }
        boolean worksheetPropsChanged = false;
        if (doc == null) {
            frame.dispose();
        } else {
            XTProps props = (XTProps)doc.getWorksheetProperties().copy();
            WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, MinerApp.getGlobalOptions());
            if (!props.equals(doc.getWorksheetProperties())) {
                doc.setWorksheetProperties(props);
                worksheetPropsChanged = true;
            }
            view.setDocument(doc);
            view.updateTitle();
            MinerApp.addFileToRecentlySavedList(doc.getLocation());
            MinerApp.updateFrameWindowMenu();
            try {
                doc.initEngineConnection();
                MinerApp.saveGuiNetworkToEngine(doc);
                g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_update_node_state"));
                boolean prevDeep = ActivityNodeState.isDeepMode();
                ActivityNodeState.setDeepMode(false);
                MinerApp.updateAllNodes(doc);
                ActivityNodeState.setDeepMode(prevDeep);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        g_mainFrame.setStatusText(prevStatus);
        if (doc != null) {
            if (worksheetPropsChanged) {
                doc.setModified(true);
            } else {
                doc.setModified(false);
            }
        }
        try {
            MinerApp.getCurrentWorksheetID();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        comp.removeMouseListener(ma);
        comp.removeKeyListener(ka);
        comp.setVisible(false);
        comp.setCursor(oldCursor);
        AppAction.updateAllActions();
    }

    public static void closeWorksheet() {
        JInternalFrame frame;
        if (MinerApp.getCurrentView() != null && (frame = MinerApp.getCurrentView().getInternalFrame()) != null) {
            try {
                frame.setClosed(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void saveWorksheet() {
        if (MinerApp.getCurrentView() != null) {
            WorksheetDocument doc = MinerApp.getCurrentDoc();
            String prevStatus = g_mainFrame.getStatusText();
            g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_saving") + " " + doc.getName());
            doc.save();
            MinerApp.addFileToRecentlySavedList(doc.getLocation());
            MinerApp.updateFrameWindowMenu();
            g_FileSaveAction.updateEnabled();
            g_mainFrame.setStatusText(prevStatus);
        }
    }

    public static void saveAsWorksheet() {
        if (MinerApp.getCurrentView() != null) {
            WorksheetDocument doc = MinerApp.getCurrentView().getDoc();
            String oldLocation = doc.getLocation();
            doc.saveAs();
            String newLocation = doc.getLocation();
            if (oldLocation.equals(newLocation)) {
                return;
            }
            MinerApp.addFileToRecentlySavedList(doc.getLocation());
            MinerApp.updateFrameWindowMenu();
            g_FileSaveAction.updateEnabled();
        }
    }

    public static void printPreviewWorksheet() {
        Thread runner = new Thread(){

            public void run() {
                MinerApp.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                new PrintPreview((Printable)((Object)MinerApp.getCurrentView()));
                MinerApp.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        runner.start();
    }

    public static void copySelToUserLibrary() {
        ExplorerPane explorerPane = g_mainFrame.getExplorerPane();
        JGoSelection sel = MinerApp.getCurrentView().getSelection();
        JGoListPosition pos = sel.getFirstObjectPos();
        JGoCopyMap cMap = new JGoCopyMap();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            pos = sel.getNextObjectPos(pos);
            if (!(obj instanceof BaseNodeArea)) continue;
            BaseNodeArea node = (BaseNodeArea)obj.copyObject((JGoCopyEnvironment)cMap);
            node.forceOwnershipChange(null, (Object)new WorksheetDocument());
            node.getLabel().setText(obj.toString());
            explorerPane.copySelToUserLibrary(node);
        }
    }

    public static void createPredictorNode() {
        Thread cp = new Thread(){

            public void run() {
                Component comp = g_mainFrame.getGlassPane();
                Cursor oldCursor = comp.getCursor();
                comp.setCursor(Cursor.getPredefinedCursor(3));
                MouseAdapter ma = new MouseAdapter(){};
                KeyAdapter ka = new KeyAdapter(){};
                comp.addMouseListener(ma);
                comp.addKeyListener(ka);
                comp.setVisible(true);
                String origText = MinerApp.getMainFrame().getStatusText();
                MinerApp.getMainFrame().setStatusText(MinerApp.getText("MinerFrame_statusbar_create_predict_node"));
                Object baseNodeArea = null;
                PredictNodeModel newPredictModel = null;
                ActivityNodeArea newNodeArea = null;
                PredictableNodeModel pnModel = null;
                WorksheetView view = MinerApp.getCurrentView();
                JGoSelection selection = view.getSelection();
                JGoListPosition pos = selection.getFirstObjectPos();
                JGoObject obj = selection.getObjectAtPos(pos);
                if (obj instanceof ActivityNodeArea && ((ActivityNodeArea)obj).getNodeModel() instanceof PredictableNodeModel) {
                    pnModel = (PredictableNodeModel)((ActivityNodeArea)obj).getNodeModel();
                    newPredictModel = new PredictNodeModel(pnModel);
                    newNodeArea = new ActivityNodeArea();
                    newNodeArea.initialize(newPredictModel);
                    Point iPoint = obj.getSpotLocation(7);
                    view.copyFromExplorerPane(newNodeArea, iPoint);
                    WorksheetDocument doc = view.getDoc();
                    doc.startTransaction();
                    doc.addObjectAtTail((JGoObject)newNodeArea);
                    selection.selectObject((JGoObject)newNodeArea);
                    PredictorLink.newPredictionLink(pnModel.getID(), newPredictModel.getID(), doc);
                    doc.setEngineNetworkDirty();
                    doc.endTransaction("Add Node");
                    pnModel = null;
                    System.gc();
                } else {
                    AcceleratorOptionPane.showOKDialog(g_mainFrame, MinerApp.getText("MinerApp_msg_createPredictorAvailableForModelComponents"), MinerApp.getText("MinerApp_msg_createPredictorNotAvailable"), 1);
                }
                newPredictModel = null;
                baseNodeArea = null;
                newNodeArea = null;
                selection = null;
                pnModel = null;
                view = null;
                pos = null;
                obj = null;
                System.gc();
                MinerApp.getMainFrame().setStatusText(origText);
                comp.removeMouseListener(ma);
                comp.removeKeyListener(ka);
                comp.setCursor(oldCursor);
                comp.setVisible(false);
            }
        };
        cp.start();
        cp = null;
    }

    public static void createFilterColumnsNode() {
        JGoListPosition pos;
        String[] colNames = null;
        Object baseNodeArea = null;
        ActivityNodeArea newNodeArea = null;
        WorksheetView view = MinerApp.getCurrentView();
        JGoSelection selection = view.getSelection();
        JGoObject obj = selection.getObjectAtPos(pos = selection.getFirstObjectPos());
        if (obj instanceof ActivityNodeArea && ((ActivityNodeArea)obj).getNodeModel() instanceof ColumnFilterGenerator) {
            ActivityNodeModel model = ((ActivityNodeArea)obj).getNodeModel();
            colNames = ((ColumnFilterGenerator)((Object)model)).getFilterColumnsToExclude();
            try {
                model = ColumnFilterTools.createNodeModel(colNames, model.getInputMetaData(0));
                if (model != null) {
                    newNodeArea = new ActivityNodeArea();
                    newNodeArea.initialize(model);
                    Point iPoint = obj.getSpotLocation(7);
                    view.copyFromExplorerPane(newNodeArea, iPoint);
                    view.getDoc().addObjectAtTail((JGoObject)newNodeArea);
                    selection.selectObject((JGoObject)newNodeArea);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            AcceleratorOptionPane.showOKDialog(g_mainFrame, MinerApp.getText("MinerApp_msg_createFilterAvailableForSelectedComponents"), MinerApp.getText("MinerApp_msg_createFilterNotAvailable"), 1);
        }
        baseNodeArea = null;
        newNodeArea = null;
        selection = null;
        colNames = null;
        view = null;
        pos = null;
        obj = null;
        System.gc();
    }

    public static void addChildNodeToView(ActivityNodeArea newNodeArea, String worksheetID, int parentID) {
        WorksheetView view = MinerApp.getViewWithID(worksheetID);
        WorksheetDocument doc = view.getDoc();
        JGoSelection selection = view.getSelection();
        BaseNodeArea obj = doc.findNodeByID(parentID);
        if (obj != null) {
            Point iPoint = obj.getSpotLocation(7);
            view.copyFromExplorerPane(newNodeArea, iPoint);
        } else {
            view.copyFromExplorerPane(newNodeArea);
        }
        view.getDoc().addObjectAtTail((JGoObject)newNodeArea);
        selection.selectObject((JGoObject)newNodeArea);
    }

    public static void editComments() {
        try {
            BaseNodeArea area = MinerApp.getCurrentSelectedBaseNodeArea();
            Element existComments = null;
            if (area != null) {
                if (area instanceof ActivityNodeArea) {
                    existComments = ((ActivityNodeArea)area).getNodeModel().getComments();
                    Element newComments = CommentUtilities.editComments(existComments, ((ActivityNodeArea)area).getNodeModel().getLabelText());
                    if (newComments != null) {
                        ((ActivityNodeArea)area).getNodeModel().setComments(newComments);
                        if (existComments == null || !new XMLTree(existComments).equals(new XMLTree(newComments))) {
                            MinerApp.getCurrentDoc().setModified(true);
                        }
                    }
                } else {
                    existComments = ((CollapsedNodeArea)area).getComments();
                    Element newComments = CommentUtilities.editComments(existComments, ((ActivityNodeArea)area).getNodeModel().getLabelText());
                    if (newComments != null) {
                        ((CollapsedNodeArea)area).setComments(newComments);
                        if (existComments == null || !new XMLTree(existComments).equals(new XMLTree(newComments))) {
                            MinerApp.getCurrentDoc().setModified(true);
                        }
                    }
                }
            } else {
                WorksheetDocument doc = MinerApp.getCurrentDoc();
                existComments = doc.getComments();
                Element newComments = CommentUtilities.editComments(existComments, doc.getName());
                if (newComments != null) {
                    doc.setComments(newComments);
                    if (existComments == null || !new XMLTree(existComments).equals(new XMLTree(newComments))) {
                        MinerApp.getCurrentDoc().setModified(true);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void autoLayoutAction() {
        WorksheetDocument doc = MinerApp.getCurrentDoc();
        doc.startTransaction();
        JGoLayeredDigraphAutoLayout l = new JGoLayeredDigraphAutoLayout((JGoDocument)doc, 30, 30, 3, 1, 2, 1, 4, 1);
        l.performLayout();
        doc.endTransaction("Auto Layout");
    }

    public static void expandExpAction() {
        ExplorerPane ep = MinerApp.getMainFrame().getExplorerPane();
        ep.expandJTree();
    }

    public static void collapseExpAction() {
        ExplorerPane ep = MinerApp.getMainFrame().getExplorerPane();
        ep.collapseJTree();
    }

    public static void doInvalidateNode() {
        ActivityNodeConfigured conf = ActivityNodeConfigured.instance();
        ActivityNodeComputed comp = ActivityNodeComputed.instance();
        WorksheetDocument doc = MinerApp.getCurrentDoc();
        String worksheetID = doc.getWorksheetID();
        JGoSelection sel = MinerApp.getCurrentView().getSelection();
        JGoListPosition pos = sel.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            pos = sel.getNextObjectPos(pos);
            Vector<JGoObject> nodes = new Vector<JGoObject>();
            if (obj instanceof ActivityNodeArea) {
                nodes.add(obj);
            } else if (obj instanceof CollapsedNodeArea) {
                ((CollapsedNodeArea)obj).getContainedNodes(nodes);
            }
            for (int i = 0; i < nodes.size(); ++i) {
                ActivityNodeArea area = (ActivityNodeArea)nodes.get(i);
                String nodeID = Integer.toString(area.getID());
                ActivityNodeModel mod = area.getNodeModel();
                ActivityNodeState state = mod.getState();
                if (!state.isPresentStateAtLeastAsAdvancedAsTestState(comp)) continue;
                if (worksheetID.length() > 0) {
                    GuiMessageHandler.sendMessageToEngine(worksheetID, "", "invalidateNode", new Object[]{nodeID});
                }
                mod.setState(conf);
            }
        }
        AppAction.updateAllActions();
    }

    public static void invalidateNode(String nodeID) {
        WorksheetDocument doc = MinerApp.getCurrentDoc();
        ActivityNodeArea area = (ActivityNodeArea)doc.findNodeByID(Integer.parseInt(nodeID));
        if (area == null) {
            return;
        }
        ActivityNodeModel mod = area.getNodeModel();
        boolean valid = mod.getState().isPresentStateAtLeastAsAdvancedAsTestState(ActivityNodeComputed.instance());
        if (valid) {
            String worksheetID = doc.getWorksheetID();
            if (!worksheetID.equals("")) {
                GuiMessageHandler.sendMessageToEngine(worksheetID, "", "invalidateNode", new Object[]{nodeID});
            }
            mod.setState(ActivityNodeConfigured.instance());
        }
        AppAction.updateAllActions();
    }

    public static void doDeleteOrDisplayNodeCache(boolean delete) {
        JGoSelection sel = MinerApp.getCurrentView().getSelection();
        JGoListPosition pos = sel.getFirstObjectPos();
        Vector<String> nodes = new Vector<String>();
        Vector<ActivityNodeArea> areas = new Vector<ActivityNodeArea>();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            pos = sel.getNextObjectPos(pos);
            if (!(obj instanceof ActivityNodeArea)) continue;
            ActivityNodeArea area = (ActivityNodeArea)obj;
            int nodeIDInt = area.getID();
            String nodeID = Integer.toString(nodeIDInt);
            boolean valid = area.getNodeModel().getState().isPresentStateAtLeastAsAdvancedAsTestState(ActivityNodeComputed.instance());
            if (!valid) continue;
            nodes.add(nodeID);
            areas.add(area);
        }
        WorksheetDocument doc = MinerApp.getCurrentDoc();
        String worksheetID = doc.getWorksheetID();
        if (!worksheetID.equals("") && nodes.size() > 0) {
            String method = delete ? "clearNodeDataCaches" : "displayNodeCacheInfo";
            GuiMessageHandler.sendMessageToEngine(worksheetID, "", method, new Object[]{nodes});
            for (int i = 0; delete && i < areas.size(); ++i) {
                ActivityNodeArea area = (ActivityNodeArea)areas.get(i);
                area.stateChanged(new ChangeEvent(area.getNodeModel().getState()));
            }
        }
        AppAction.updateAllActions();
    }

    public static void doRun() {
        MinerApp.runToNode(new String[0]);
    }

    public static void doRunToHere() {
        JGoSelection sel = MinerApp.getCurrentView().getSelection();
        JGoListPosition pos = sel.getFirstObjectPos();
        Vector<JGoObject> nodes = new Vector<JGoObject>();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            pos = sel.getNextObjectPos(pos);
            if (obj instanceof ActivityNodeArea) {
                nodes.add(obj);
                continue;
            }
            if (!(obj instanceof CollapsedNodeArea)) continue;
            ((CollapsedNodeArea)obj).getContainedNodes(nodes);
        }
        String[] idList = new String[nodes.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = Integer.toString(((ActivityNodeArea)nodes.get(i)).getID());
        }
        if (idList.length != 0) {
            MinerApp.runToNode(idList);
        } else {
            AcceleratorOptionPane.showOKDialog(g_mainFrame, MinerApp.getText("MinerApp_msg_runToHereAvailableforActivityComponents"), MinerApp.getText("MinerApp_msg_runToHereNotAvailable"), 2);
        }
    }

    public static void runToNode(String[] id) {
        MinerApp.runToNode(id, true);
    }

    public static void runToNode(final String[] id, final boolean checkUnrunnable) {
        Thread runThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ActivityNodeModel mod;
                    g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_running"));
                    g_isRunning = true;
                    g_stopRequested = false;
                    AppAction.updateAllActions();
                    WorksheetDocument doc = MinerApp.getCurrentDoc();
                    String worksheetID = MinerApp.getCurrentWorksheetID(doc);
                    MinerApp.saveGuiNetworkToEngine(doc);
                    XTNetwork net = doc.getXTNetwork();
                    Vector allNodeIDs = net.getFlatNodes();
                    Vector<String> runnableNodeIDs = new Vector<String>();
                    Vector<String> unRunnableNodeIDs = new Vector<String>();
                    List<String> runToNodes = null;
                    if (id.length == 0) {
                        runToNodes = new Vector(allNodeIDs);
                    } else {
                        runToNodes = new Vector<String>();
                        for (int i = 0; i < id.length; ++i) {
                            runToNodes.add(id[i]);
                        }
                        Object sortedNodesObj = GuiMessageHandler.sendMessageToEngine(worksheetID, null, "getSortedRunNodesFromVector", new Object[]{runToNodes});
                        if (sortedNodesObj == null || !(sortedNodesObj instanceof List)) {
                            throw new Exception("bad sorted nodes from engine");
                        }
                        runToNodes = (List)sortedNodesObj;
                    }
                    if (checkUnrunnable) {
                        for (String nodeID : runToNodes) {
                            int nodeIDInt = Integer.parseInt(nodeID);
                            mod = ((ActivityNodeArea)doc.findFlatNodeByID(nodeIDInt)).getNodeModel();
                            if (mod.getState().isPresentStateAtLeastAsAdvancedAsTestState(ActivityNodeConfigured.instance())) {
                                runnableNodeIDs.add(nodeID);
                                continue;
                            }
                            unRunnableNodeIDs.add(nodeID);
                        }
                    } else {
                        runnableNodeIDs.addAll(runToNodes);
                    }
                    Object obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "runToHere", new Object[]{runnableNodeIDs, unRunnableNodeIDs});
                    if (obj instanceof Exception) {
                        throw new Exception("error sending runToHere to engine: " + obj);
                    }
                    while (true) {
                        if (g_stopRequested) {
                            obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "interrupt", new Object[0]);
                            g_stopRequested = false;
                        }
                        if ((obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "isRunning", new Object[0])) == null || obj instanceof Exception) {
                            throw new Exception("error sending isRunning to engine: " + obj);
                        }
                        Boolean bVal = (Boolean)obj;
                        if (!bVal.booleanValue()) break;
                        Thread.sleep(1000L);
                    }
                    g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_update_node_state"));
                    MinerApp.updateAllValidNodes();
                    if (id.length != 0 && MinerApp.getGlobalOptions().getBoolean("runToHereShowViewer", false)) {
                        for (int i = 0; i < id.length; ++i) {
                            obj = GuiMessageHandler.sendMessageToEngine(worksheetID, "", "isValid", new Object[]{id[i]});
                            if (obj == null || !(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
                            int numeric_id = Integer.parseInt(id[i]);
                            ActivityNodeArea area = (ActivityNodeArea)doc.findFlatNodeByID(numeric_id);
                            ActivityNodeModel activityNodeModel = mod = area != null ? area.getNodeModel() : null;
                            if (mod == null) continue;
                            mod.showView(MinerApp.getMainFrame());
                        }
                    }
                }
                catch (Exception e) {
                    AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), e.toString(), MinerApp.getText("MinerApp_msg_runError"), 0);
                }
                finally {
                    g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_ready"));
                    g_mainFrame.setProgressDone(0);
                    g_isRunning = false;
                    g_stopRequested = false;
                    MinerApp.executionEnded();
                    AppAction.updateAllActions();
                }
            }
        });
        runThread.start();
    }

    public static boolean runNetworkIsNodeRunnable(String nodeID) {
        if (!MinerApp.isInteractive()) {
            return true;
        }
        try {
            WorksheetDocument doc = MinerApp.getCurrentDoc();
            int nodeIDInt = Integer.parseInt(nodeID);
            ActivityNodeModel mod = ((ActivityNodeArea)doc.findFlatNodeByID(nodeIDInt)).getNodeModel();
            return mod.getState().isPresentStateAtLeastAsAdvancedAsTestState(ActivityNodeConfigured.instance());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void runNetworkNodeExecuted(String nodeID) {
        try {
            WorksheetView view = MinerApp.getCurrentView();
            if (view == null) {
                return;
            }
            WorksheetDocument doc = view.getDoc();
            if (doc == null) {
                return;
            }
            int nodeIDInt = Integer.parseInt(nodeID);
            ActivityNodeArea nodeArea = (ActivityNodeArea)doc.findFlatNodeByID(nodeIDInt);
            if (nodeArea == null) {
                throw new Exception("node not found: " + nodeIDInt);
            }
            ActivityNodeModel mod = nodeArea.getNodeModel();
            g_engineChangingState = true;
            ActivityNodeState.setComputed(mod);
            g_engineChangingState = false;
        }
        catch (Exception ex) {
            MinerApp.println("MinerApp.runNetworkNodeExecuted exception: " + ex);
        }
    }

    private static void updateAllValidNodes() {
        WorksheetView view = MinerApp.getCurrentView();
        if (view != null) {
            WorksheetDocument doc = view.getDoc();
            MinerApp.updateAllValidNodes(doc);
        }
    }

    private static void updateAllValidNodes(WorksheetDocument doc) {
        MinerApp.updateNodeStatesFromEngine(doc, true);
    }

    private static void updateAllNodes(WorksheetDocument doc) {
        MinerApp.updateNodeStatesFromEngine(doc, false);
    }

    private static void updateNodeStatesFromEngine(WorksheetDocument doc, boolean justValidNodes) {
        String prevStatus = g_mainFrame.getStatusText();
        boolean prevDeep = ActivityNodeState.isDeepMode();
        ActivityNodeState.setDeepMode(false);
        try {
            MinerApp.saveGuiNetworkToEngine(doc);
            String worksheetID = MinerApp.getCurrentWorksheetID(doc);
            Object obj = GuiMessageHandler.sendMessageToEngine(worksheetID, null, "getSortedNodes", null);
            if (obj == null || !(obj instanceof List)) {
                throw new Exception("bad sorted nodes from engine");
            }
            List sortedNodes = (List)obj;
            obj = GuiMessageHandler.sendMessageToEngine(worksheetID, null, "getValidNodes", null);
            if (obj == null || !(obj instanceof List)) {
                throw new Exception("bad valid nodes from engine");
            }
            List validNodeList = (List)obj;
            HashSet validNodeSet = new HashSet(validNodeList);
            for (String nodeID : sortedNodes) {
                int nodeIDInt;
                ActivityNodeArea nodeArea;
                boolean isValid = validNodeSet.contains(nodeID);
                if (justValidNodes && !isValid || (nodeArea = (ActivityNodeArea)doc.findFlatNodeByID(nodeIDInt = Integer.parseInt(nodeID))) == null) continue;
                ActivityNodeModel mod = nodeArea.getNodeModel();
                g_engineChangingState = true;
                if (isValid) {
                    ActivityNodeState.setComputed(mod);
                } else {
                    mod.getState().changeState(mod);
                }
                g_engineChangingState = false;
                AppAction.updateAllActions();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ActivityNodeState.setDeepMode(prevDeep);
        g_mainFrame.setStatusText(prevStatus);
    }

    public static void doStop() {
        if (MinerApp.isRunning()) {
            g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_stop_requested"));
            g_stopRequested = true;
            if (MinerApp.isSplusLicensed()) {
                try {
                    g_splusSession.Interrupt();
                }
                catch (Exception exc) {}
            }
        } else {
            g_mainFrame.setStatusText(MinerApp.getText("MinerFrame_statusbar_stop_requested"));
            if (MinerApp.isSplusLicensed()) {
                try {
                    g_splusSession.Interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isRunning() {
        return g_isRunning;
    }

    public static void appendToMessagePane(String str) {
        g_mainFrame.appendToMessagePane(str);
    }

    public static void showPrintSetupDialog() {
        Thread thrd = new Thread(){

            public void run() {
                PrinterJob job = PrinterJob.getPrinterJob();
                MinerApp.setDefaultPageFormat(job.pageDialog(MinerApp.getPrintAttributeSet()));
                if (MinerApp.getMainFrame() != null) {
                    MinerApp.getCurrentView().requestFocusInWindow();
                }
            }
        };
        thrd.start();
    }

    public static void setPrintAttributeSet(HashPrintRequestAttributeSet as) {
        g_defaultPrintAttributeSet = as;
    }

    public static HashPrintRequestAttributeSet getPrintAttributeSet() {
        if (g_defaultPrintAttributeSet == null) {
            g_defaultPrintAttributeSet = new HashPrintRequestAttributeSet();
            g_defaultPrintAttributeSet.add(MediaSizeName.NA_LETTER);
        }
        return g_defaultPrintAttributeSet;
    }

    public static void setDefaultPageFormat(PageFormat pf) {
        g_defaultPageFormat = pf;
    }

    public static PageFormat getDefaultPageFormat() {
        if (g_defaultPageFormat == null) {
            g_defaultPageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        return g_defaultPageFormat;
    }

    public static void initAppActions() {
        g_FileNewAction = new AppAction(MinerApp.getText("MinerApp_menu_item_new"), MinerApp.getIcon("new.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.newWorksheet();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_FileOpenAction = new AppAction(MinerApp.getText("MinerApp_menu_item_open"), MinerApp.getIcon("open.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.openWorksheet();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_FileCloseAction = new AppAction(MinerApp.getText("MinerApp_menu_item_close"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.closeWorksheet();
            }
        };
        g_FileSaveAction = new AppAction(MinerApp.getText("MinerApp_menu_item_save"), MinerApp.getIcon("save.gif")){

            public void actionPerformed(ActionEvent e) {
                if (this.getView().getDoc().isPreVersion70() && AcceleratorOptionPane.showOKCancelDialog(MinerApp.getMainFrame(), MinerApp.getText("WorksheetDocument_msg_savePre70Warning"), MinerApp.getText("WorksheetDocument_msg_savePre70WarningTitle"), 2) != 0) {
                    return;
                }
                MinerApp.saveWorksheet();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModified();
            }
        };
        g_FileSaveAsAction = new AppAction(MinerApp.getText("MinerApp_menu_item_saveas"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.saveAsWorksheet();
            }
        };
        g_FileSaveAsJPEGAction = new AppAction(MinerApp.getText("MinerApp_menu_item_saveas_jpeg"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.saveAsJPEG((Component)MinerApp.getCurrentView().getCanvas());
            }
        };
        g_CloseViewers = new AppAction(MinerApp.getText("MinerApp_menu_item_close_viewers"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                ModifiableViewerFrame.manageOpenFrames(this.toString());
            }
        };
        g_FilePropertiesAction = new AppAction(MinerApp.getText("MinerApp_menu_item_properties"), MinerApp.getIcon("properties.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.editWorksheetProperties();
            }
        };
        g_PrintPreviewAction = new AppAction(MinerApp.getText("MinerApp_menu_item_print_preview"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.printPreviewWorksheet();
            }
        };
        g_PrintSetupAction = new AppAction(MinerApp.getText("MinerApp_menu_item_print_setup"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.showPrintSetupDialog();
            }
        };
        g_PrintAction = new AppAction(MinerApp.getText("MinerApp_menu_item_print"), MinerApp.getIcon("print.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().print();
            }
        };
        g_ExitAction = new AppAction(MinerApp.getText("MinerApp_menu_item_exit"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.exit();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_CutAction = new AppAction(MinerApp.getText("MinerApp_menu_item_cut"), MinerApp.getIcon("cut.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().cut();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty() && this.getView().getDoc().isModifiable();
            }
        };
        g_CopyAction = new AppAction(MinerApp.getText("MinerApp_menu_item_copy"), MinerApp.getIcon("copy.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().copy();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty();
            }
        };
        g_PasteAction = new AppAction(MinerApp.getText("MinerApp_menu_item_paste"), MinerApp.getIcon("paste.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().paste();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModifiable();
            }
        };
        g_MouseDrivenPasteAction = new AppAction(MinerApp.getText("MinerApp_menu_item_paste"), MinerApp.getIcon("paste.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().mouseDrivenPaste();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModifiable();
            }
        };
        g_DeleteAction = new AppAction(MinerApp.getText("MinerApp_menu_item_delete"), MinerApp.getIcon("delete.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().deleteSelection();
            }

            public boolean canAct() {
                return super.canAct() && !this.getView().getSelection().isEmpty() && this.getView().getDoc().isModifiable();
            }
        };
        g_SelectAllAction = new AppAction(MinerApp.getText("MinerApp_menu_item_selectall"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().selectAll();
                this.getView().grabFocus();
            }
        };
        g_clipWorksheetAction = new AppAction(MinerApp.getText("MinerApp_action_clipWorksheet"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().updateViewForNodeChanges(true);
                this.getView().grabFocus();
            }
        };
        g_manageLibrariesAction = new AppAction(MinerApp.getText("ExplorerPane_manageLibraries"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                LibraryManagerDialog dialog = new LibraryManagerDialog(MinerApp.getMainFrame().getExplorerPane());
                dialog.show();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_libraryPasteAction = new AppAction(MinerApp.getText("ExplorerPane_paste"), MinerApp.getIcon("paste.gif")){

            public boolean canAct() {
                if (MinerApp.isHeadless()) {
                    return false;
                }
                return MinerApp.getMainFrame().getExplorerPane().isDropable();
            }

            public void actionPerformed(ActionEvent e) {
                MinerApp.getMainFrame().getExplorerPane().doPaste();
            }
        };
        g_createNewFolderAction = new AppAction(MinerApp.getText("ExplorerPane_createFolder"), MinerApp.getIcon("open.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getMainFrame().getExplorerPane().createNewFolder();
            }

            public boolean canAct() {
                if (MinerApp.isHeadless()) {
                    return false;
                }
                return MinerApp.getMainFrame().getExplorerPane().isDropable();
            }
        };
        g_hideLibraryAction = new AppAction(MinerApp.getText("ExplorerPane_hideLibrary"), ExplorerPane.getPlainGrayIcon()){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getMainFrame().getExplorerPane().hideLibrary();
            }

            public boolean canAct() {
                if (MinerApp.getMainFrame() != null && MinerApp.getMainFrame().getExplorerPane() != null) {
                    return MinerApp.getMainFrame().getExplorerPane().canHideLibrary();
                }
                return false;
            }
        };
        g_libraryPropertiesAction = new AppAction(MinerApp.getText("ExplorerPane_libraryProperties"), MinerApp.getIcon("properties.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getMainFrame().getExplorerPane().libraryProperties();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_saveLibraryAsAction = new AppAction(MinerApp.getText("ExplorerPane_saveLibraryAs"), MinerApp.getIcon("save.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getMainFrame().getExplorerPane().saveLibraryAs();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_revertLibraryAction = new AppAction(MinerApp.getText("ExplorerPane_revertLibrary"), ExplorerPane.getPlainGrayIcon()){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getMainFrame().getExplorerPane().revertLibrary();
            }

            public boolean canAct() {
                if (MinerApp.isHeadless()) {
                    return false;
                }
                return MinerApp.getMainFrame().getExplorerPane().isDropable();
            }
        };
        g_createNewLibraryAction = new AppAction(MinerApp.getText("ExplorerPane_createNewLibrary"), MinerApp.getIcon("new.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getMainFrame().getExplorerPane().createNewLibrary();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_CreateLink = new AppAction(MinerApp.getText("MinerApp_menu_item_create_new_link"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                WorksheetDocument doc = this.getView().getDoc();
                Vector fromList = new Vector();
                Vector toList = new Vector();
                Vector fModelList = new Vector();
                Vector tModelList = new Vector();
                doc.getAvailableNodes(true, fromList, fModelList);
                doc.getAvailableNodes(false, toList, tModelList);
                CreateLinkDialog cld = new CreateLinkDialog(MinerApp.getMainFrame(), fromList, fModelList, toList, tModelList);
                cld.show();
                if (cld.success) {
                    JGoPort fromPort = cld.getFromPort();
                    JGoPort toPort = cld.getToPort();
                    if (fromPort != null && toPort != null) {
                        doc.startTransaction();
                        this.getView().newLink(fromPort, toPort, true);
                    }
                    fromPort = null;
                    toPort = null;
                }
                cld = null;
            }

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                WorksheetView view = this.getView();
                if (view == null) {
                    return false;
                }
                WorksheetDocument doc = view.getDoc();
                try {
                    boolean noTo;
                    Vector fromList = new Vector();
                    Vector toList = new Vector();
                    Vector fModelList = new Vector();
                    Vector tModelList = new Vector();
                    doc.getAvailableNodes(true, fromList, fModelList);
                    doc.getAvailableNodes(false, toList, tModelList);
                    boolean noFrom = fromList.size() == 0 && fModelList.size() == 0;
                    boolean bl = noTo = toList.size() == 0 && tModelList.size() == 0;
                    if (noFrom || noTo) {
                        return false;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
                return true;
            }
        };
        g_DefaultNodeProperties = new AppAction(MinerApp.getText("MinerApp_action_defaultNodeProperties"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                DefaultNodePropertiesDialog dialog = new DefaultNodePropertiesDialog(MinerApp.getMainFrame());
                dialog.show();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_CreateNode = new AppAction(MinerApp.getText("MinerApp_menu_item_create_new_node"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                CreateNodeDialog dialog = new CreateNodeDialog(MinerApp.getMainFrame());
                dialog.show();
            }
        };
        g_UndoAction = new AppAction(MinerApp.getText("MinerApp_action_undo"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().getDocument().undo();
                AppAction.updateAllActions();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDocument().canUndo();
            }

            public void updateEnabled() {
                super.updateEnabled();
                if (g_undoMenuItem != null && this.getView() != null) {
                    g_undoMenuItem.setText(this.getView().getDocument().getUndoManager().getUndoPresentationName());
                }
            }
        };
        g_RedoAction = new AppAction(MinerApp.getText("MinerApp_menu_item_redo"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().getDocument().redo();
                AppAction.updateAllActions();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDocument().canRedo();
            }

            public void updateEnabled() {
                super.updateEnabled();
                if (g_redoMenuItem != null && this.getView() != null) {
                    g_redoMenuItem.setText(this.getView().getDocument().getUndoManager().getRedoPresentationName());
                }
            }
        };
        g_ObjectPropertiesAction = new AppAction(MinerApp.getText("MinerApp_menu_item_properties"), MinerApp.getIcon("properties.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().editObjectProperties();
            }

            public boolean canAct() {
                boolean flag = super.canAct();
                if (MinerApp.getCurrentView() == null || MinerApp.getCurrentView().getSelection().getNumObjects() > 1) {
                    return false;
                }
                JGoArea area = MinerApp.getCurrentSelectedArea();
                if (area == null || !flag) {
                    return false;
                }
                if (area instanceof CollapsedNodeArea || area instanceof MinerTextNode) {
                    return true;
                }
                if (area instanceof ActivityNodeArea) {
                    ActivityNodeState state = ((ActivityNodeArea)area).getNodeModel().getState();
                    return state.isPresentStateAtLeastAsAdvancedAsTestState(ActivityNodeLinked.instance());
                }
                return false;
            }
        };
        g_ObjectViewAction = new AppAction(MinerApp.getText("MinerApp_menu_item_viewer"), MinerApp.getIcon("viewer.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().showObjectViewer();
            }

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                return MinerApp.canActDependentOnAllNodeState(ActivityNodeComputed.instance(), false);
            }
        };
        g_ShowDataViewerAction = new AppAction(MinerApp.getText("MinerApp_menu_item_tableviewer"), MinerApp.getIcon("tabular_reports_small.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().showDataViewer();
            }

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                JGoSelection sel = MinerApp.getCurrentView().getSelection();
                JGoListPosition pos = sel.getFirstObjectPos();
                if (pos == null) {
                    return false;
                }
                while (pos != null) {
                    Object obj = sel.getObjectAtPos(pos);
                    if (obj instanceof BaseLink) {
                        obj = ((BaseLink)((Object)obj)).getFromNode();
                    }
                    if (obj instanceof PredictorLink) {
                        return false;
                    }
                    if (obj instanceof MinerTextNode) {
                        return false;
                    }
                    if (obj instanceof ActivityNodeArea && ((ActivityNodeModel)(obj = ((ActivityNodeArea)obj).getNodeModel())).getNumInputs() == 0 && ((ActivityNodeModel)obj).getNumOutputs() == 0) {
                        return false;
                    }
                    if (obj instanceof Viewable && !((Viewable)obj).isComputed()) {
                        return false;
                    }
                    pos = sel.getNextObjectPos(pos);
                }
                return true;
            }
        };
        g_TileHorizontalAction = new AppAction(MinerApp.getText("MinerApp_menu_item_tileHorizontal"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                DesktopUtils.tileHorizontal(MinerApp.getMainFrame().getDesktop());
            }

            public boolean canAct() {
                return true;
            }
        };
        g_TileVerticalAction = new AppAction(MinerApp.getText("MinerApp_menu_item_tileVertical"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                DesktopUtils.tileVertical(MinerApp.getMainFrame().getDesktop());
            }

            public boolean canAct() {
                return true;
            }
        };
        g_CascadeAction = new AppAction(MinerApp.getText("MinerApp_menu_item_cascade"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                DesktopUtils.cascadeAll(MinerApp.getMainFrame().getDesktop());
            }

            public boolean canAct() {
                return true;
            }
        };
        g_MinimizeAllAction = new AppAction(MinerApp.getText("MinerApp_menu_item_minimizeAll"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                DesktopUtils.minimizeAll(MinerApp.getMainFrame().getDesktop());
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ArrangeIconsAction = new AppAction(MinerApp.getText("MinerApp_menu_item_arrangeIcons"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                DesktopUtils.arrangeIcons(MinerApp.getMainFrame().getDesktop());
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ViewToolbarAction = new AppAction(MinerApp.getText("MinerApp_menu_item_viewToolbar"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                g_mainFrame.toggleToolBar();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ExpandExpAction = new AppAction(MinerApp.getText("MinerApp_menu_item_expandExplorer"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.expandExpAction();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_CollapseExpAction = new AppAction(MinerApp.getText("MinerApp_menu_item_collapseExplorer"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.collapseExpAction();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ViewExplorerAction = new AppAction(MinerApp.getText("MinerApp_menu_item_viewExplorer"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                g_mainFrame.toggleExplorer();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ViewMessagePaneAction = new AppAction(MinerApp.getText("MinerApp_menu_item_viewMessagePane"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                g_mainFrame.toggleMessagePane();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ViewCommandLineAction = new AppAction(MinerApp.getText("MinerApp_menu_item_viewCommandLine"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                g_mainFrame.toggleCommandLine();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ZoomNormalAction = new AppAction(MinerApp.getText("MinerApp_menu_item_normalZoom"), MinerApp.getIcon("zoom_not.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().zoomNormal();
            }
        };
        g_ZoomInAction = new AppAction(MinerApp.getText("MinerApp_menu_item_zoomIn"), MinerApp.getIcon("zoom_in.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().zoomIn();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getScale() < 8.0;
            }
        };
        g_ZoomOutAction = new AppAction(MinerApp.getText("MinerApp_menu_item_zoomOut"), MinerApp.getIcon("zoom_out.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().zoomOut();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getScale() > (double)0.13f;
            }
        };
        g_ZoomToFitAction = new AppAction(MinerApp.getText("MinerApp_menu_item_zoomToFit"), MinerApp.getIcon("zoom_fit.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().zoomToFit();
            }
        };
        g_OrthoAllAction = new AppAction(MinerApp.getText("MinerApp_menu_item_toggleDiagonalFlows"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().toggleOrthogonalFlows();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getDoc().isModifiable();
            }
        };
        g_OrthoAction = new AppAction(MinerApp.getText("MinerApp_menu_item_toggleDiagonalFlow"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                g_OrthoAllAction.actionPerformed(e);
            }
        };
        g_AutoLayoutAction = new AppAction(MinerApp.getText("MinerApp_menu_item_autoLayout"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.autoLayoutAction();
            }
        };
        g_AboutAction = new AppAction(MinerApp.getText("MinerApp_menu_item_about"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.showAboutBox();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ToolsOptionsAction = new AppAction(MinerApp.getText("MinerApp_menu_item_options"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                GlobalPropertiesDialog.getInstance().showGlobalProperties();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_InvalidateNodeAction = new AppAction(MinerApp.getText("MinerApp_menu_item_invalidate"), MinerApp.getIcon("invalidate.gif")){

            public void actionPerformed(ActionEvent e) {
                InvalidateThread invalidate = new InvalidateThread(MinerApp.getText("MinerFrame_statusbar_ready"));
                invalidate.start();
            }

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                return !MinerApp.isRunning() && MinerApp.canActDependentOnOneNodeState(ActivityNodeComputed.instance(), false);
            }
        };
        g_DeleteNodeCacheAction = new AppAction(MinerApp.getText("MinerApp_menu_item_deleteDataCache"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                DeleteOrDisplayNodeCacheThread dnc = new DeleteOrDisplayNodeCacheThread(MinerApp.getText("MinerFrame_statusbar_ready"), true);
                dnc.start();
            }

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                return MinerApp.canActDependentOnAllNodeState(ActivityNodeComputed.instance());
            }
        };
        g_DisplayNodeCacheAction = new AppAction(MinerApp.getText("MinerApp_menu_item_cacheInformation"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                DeleteOrDisplayNodeCacheThread dnc = new DeleteOrDisplayNodeCacheThread(MinerApp.getText("MinerFrame_statusbar_ready"), false);
                dnc.start();
            }

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                return MinerApp.canActDependentOnAllNodeState(ActivityNodeComputed.instance());
            }
        };
        g_RunAction = new AppAction(MinerApp.getText("MinerApp_menu_item_run"), MinerApp.getIcon("start.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.doRun();
            }

            public boolean canAct() {
                return super.canAct() && !MinerApp.isRunning() && !MinerApp.waitingOnSplus();
            }
        };
        g_RunToHereAction = new AppAction(MinerApp.getText("MinerApp_menu_item_runToHere"), MinerApp.getIcon("run_to_here.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.doRunToHere();
            }

            public boolean canAct() {
                boolean flag = super.canAct() && !MinerApp.isRunning() && !MinerApp.waitingOnSplus() && MinerApp.getCurrentView() != null && MinerApp.getCurrentView().getSelection().getNumObjects() > 0;
                return flag;
            }
        };
        g_StopAction = new AppAction(MinerApp.getText("MinerApp_menu_item_stop"), MinerApp.getIcon("stop.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.doStop();
            }

            public boolean canAct() {
                return MinerApp.waitingOnSplus() || MinerApp.isRunning();
            }
        };
        g_HelpNodeAction = new AppAction(MinerApp.getText("MinerApp_menu_help"), MinerApp.getIcon("help.gif")){

            public void actionPerformed(ActionEvent e) {
                JGoArea sel = MinerApp.getCurrentSelectedArea();
                if (sel instanceof MinerTextNode) {
                    ((MinerTextNode)sel).showHelp();
                } else if (sel instanceof CollapsedNodeArea) {
                    ((CollapsedNodeArea)sel).showHelp();
                } else {
                    ((ActivityNodeArea)sel).getNodeModel().showHelp();
                }
            }

            public boolean canAct() {
                boolean flag = super.canAct();
                JGoArea area = MinerApp.getCurrentSelectedArea();
                if (area instanceof MinerTextNode || area instanceof BaseNodeArea) {
                    return flag;
                }
                return false;
            }
        };
        g_HelpContentsAction = new AppAction(MinerApp.getText("MinerApp_menu_item_helpContents"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getHelpManager().showContents();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_HelpIndexAction = new AppAction(MinerApp.getText("MinerApp_menu_item_helpIndex"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getHelpManager().showIndex();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_HelpSearchAction = new AppAction(MinerApp.getText("MinerApp_menu_item_helpSearch"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getHelpManager().showSearch();
            }

            public boolean canAct() {
                return true;
            }
        };
        g_HelpGettingStartedAction = new AppAction(MinerApp.getText("MinerApp_menu_item_gettingStarted"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getHelpManager().showPDF(MinerApp.getSprimeHome() + "/doc/getstart.pdf");
            }

            public boolean canAct() {
                return true;
            }
        };
        g_HelpUsersGuideAction = new AppAction(MinerApp.getText("MinerApp_menu_item_usersGuide"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getHelpManager().showPDF(MinerApp.getSprimeHome() + "/doc/uguide.pdf");
            }

            public boolean canAct() {
                return true;
            }
        };
        g_ExpandAllAction = new AppAction(MinerApp.getText("MinerApp_menu_item_expandAll"), MinerApp.getIcon("plain_gray.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().expandAllCollapsedNodes();
            }

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                WorksheetDocument doc = this.getView().getDoc();
                JGoListPosition pos = doc.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = doc.getObjectAtPos(pos);
                    if (obj instanceof CollapsedNodeArea) {
                        return true;
                    }
                    pos = doc.getNextObjectPos(pos);
                }
                return false;
            }
        };
        g_CreateTextNode = new AppAction(MinerApp.getText("MinerApp_createTextNode"), MinerApp.getIcon("text_node.gif")){

            public void actionPerformed(ActionEvent e) {
                WorksheetView view = this.getView();
                MinerTextNode mtn = new MinerTextNode("New Annotation");
                Object obj = e.getSource();
                if (obj instanceof JMenuItem && ((JMenuItem)obj).getParent() == WorksheetView.getEmptySelectionMenu()) {
                    view.copyFromExplorerPane(mtn, view.m_popupLocation);
                } else {
                    view.copyFromExplorerPane(mtn);
                }
            }
        };
        g_ExpandAction = new AppAction(MinerApp.getText("MinerApp_menu_item_expand"), MinerApp.getIcon("expand.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().expandCollapsedNodes();
            }

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                JGoSelection sel = this.getView().getSelection();
                JGoListPosition pos = sel.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = sel.getObjectAtPos(pos);
                    pos = sel.getNextObjectPos(pos);
                    if (obj instanceof JGoLink || obj instanceof CollapsedNodeArea) continue;
                    return false;
                }
                return sel.getNumObjects() > 0;
            }
        };
        g_CollapseAction = new AppAction(MinerApp.getText("MinerApp_menu_item_collapse"), MinerApp.getIcon("collapse.gif")){

            public void actionPerformed(ActionEvent e) {
                this.getView().collapseNodeArea();
            }

            public boolean canAct() {
                return super.canAct() && this.getView().getSelection().getNumObjects() > 0;
            }
        };
        g_CopyToUserLibraryAction = new AppAction(MinerApp.getText("MinerApp_menu_item_copyToUserLibrary"), MinerApp.getIcon("copy_user_lib.gif")){

            public boolean canAct() {
                if (!super.canAct()) {
                    return false;
                }
                if (!MinerApp.getMainFrame().getExplorerPane().getUserLibrary().isDropable()) {
                    return false;
                }
                JGoSelection sel = this.getView().getSelection();
                JGoListPosition pos = sel.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = sel.getObjectAtPos(pos);
                    if (obj instanceof BaseNodeArea) {
                        return true;
                    }
                    pos = sel.getNextObjectPos(pos);
                }
                return false;
            }

            public void actionPerformed(ActionEvent e) {
                MinerApp.copySelToUserLibrary();
            }
        };
        g_CreatePredictorAction = new AppAction(MinerApp.getText("MinerApp_menu_item_createPredictor"), MinerApp.getIcon("predictor.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.createPredictorNode();
            }

            public boolean canAct() {
                boolean flag = super.canAct();
                ActivityNodeArea sel = MinerApp.getCurrentSelectedActivityNode();
                if (sel == null || !flag) {
                    return false;
                }
                ActivityNodeModel model = sel.getNodeModel();
                flag = model instanceof PredictableNodeModel && model.getState().equals(ActivityNodeComputed.instance());
                return flag;
            }
        };
        g_CreateFilterAction = new AppAction(MinerApp.getText("MinerApp_menu_item_createFilter"), MinerApp.getIcon("filter.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.createFilterColumnsNode();
            }

            public boolean canAct() {
                boolean flag = super.canAct();
                ActivityNodeArea sel = MinerApp.getCurrentSelectedActivityNode();
                if (sel == null || !flag) {
                    return false;
                }
                ActivityNodeModel model = sel.getNodeModel();
                flag = model instanceof ColumnFilterGenerator && model.getState().equals(ActivityNodeComputed.instance());
                return flag;
            }
        };
        g_EditCommentsAction = new AppAction(MinerApp.getText("MinerApp_menu_item_comments"), MinerApp.getIcon("comments.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.editComments();
            }
        };
        g_RenameAction = new AppAction(MinerApp.getText("MinerApp_menu_item_rename"), MinerApp.getIcon("plain_gray.gif")){

            public boolean canAct() {
                return super.canAct() && this.getView().getSelection().getNumObjects() == 1 && this.getView().getSelection().getPrimarySelection() instanceof BaseNodeArea;
            }

            public void actionPerformed(ActionEvent e) {
                MinerApp.getCurrentSelectedBaseNodeArea().rename();
            }
        };
        if (CollabraSpaceLinkManager.isInstalled()) {
            g_CollabraSpaceOpenAction = new AppAction(MinerApp.getText("MinerApp_menu_item_openfromCollabraSpace"), MinerApp.getIcon("open.gif")){

                public void actionPerformed(ActionEvent e) {
                    CollabraSpaceLinkManager.openAction();
                }

                public boolean canAct() {
                    return CollabraSpaceLinkManager.isConnected();
                }
            };
            g_CollabraSpaceSaveAction = new AppAction(MinerApp.getText("MinerApp_menu_item_saveToCollabraSpace"), MinerApp.getIcon("save.gif")){

                public void actionPerformed(ActionEvent e) {
                    CollabraSpaceLinkManager.saveAction();
                }

                public boolean canAct() {
                    return super.canAct() && CollabraSpaceLinkManager.isConnected();
                }
            };
        }
    }

    public static AppAction getManageLibraryAction() {
        return g_manageLibrariesAction;
    }

    public static AppAction getLibraryPasteAction() {
        return g_libraryPasteAction;
    }

    public static AppAction getCreateNewFolderAction() {
        return g_createNewFolderAction;
    }

    public static AppAction getHideLibraryAction() {
        return g_hideLibraryAction;
    }

    public static AppAction getLibraryPropertiesAction() {
        return g_libraryPropertiesAction;
    }

    public static AppAction getSaveLibraryAsAction() {
        return g_saveLibraryAsAction;
    }

    public static AppAction getRevertLibraryAction() {
        return g_revertLibraryAction;
    }

    public static AppAction getNewLibraryAction() {
        return g_createNewLibraryAction;
    }

    public static void displayError(String title, String message) {
        AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), message, title, 0);
    }

    public static JGoArea getCurrentSelectedArea() {
        WorksheetView view = MinerApp.getCurrentView();
        if (view == null) {
            return null;
        }
        try {
            JGoSelection selection = view.getSelection();
            JGoListPosition pos = selection.getFirstObjectPos();
            JGoObject obj = selection.getObjectAtPos(pos);
            if (obj instanceof JGoArea) {
                return (JGoArea)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static BaseNodeArea getCurrentSelectedBaseNodeArea() {
        WorksheetView view = MinerApp.getCurrentView();
        if (view == null) {
            return null;
        }
        try {
            JGoSelection selection = view.getSelection();
            JGoListPosition pos = selection.getFirstObjectPos();
            JGoObject obj = selection.getObjectAtPos(pos);
            if (obj instanceof BaseNodeArea) {
                return (BaseNodeArea)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ActivityNodeArea getCurrentSelectedActivityNode() {
        WorksheetView view = MinerApp.getCurrentView();
        if (view == null) {
            return null;
        }
        try {
            JGoSelection selection = view.getSelection();
            JGoListPosition pos = selection.getFirstObjectPos();
            JGoObject obj = selection.getObjectAtPos(pos);
            if (obj instanceof ActivityNodeArea) {
                return (ActivityNodeArea)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static MinerLicenseInfo getLicenseInfo() {
        if (MinerApp.isWindowsOS()) {
            return WinLicenseManager.getLicenseInfo();
        }
        return UnixLicenseManager.getLicenseInfo();
    }

    public static String getText(String key) {
        String string = MinerApp.getBundleString(g_textBundles, key);
        return string;
    }

    public static Icon getIcon(String imageName) {
        return MinerApp.getResourceManager().getIcon(imageName);
    }

    private static boolean canActDependentOnAllNodeState(ActivityNodeState minState) {
        return MinerApp.canActDependentOnAllNodeState(minState, true);
    }

    private static boolean canActDependentOnAllNodeState(ActivityNodeState minState, boolean noNodesSelectedReturnVal) {
        boolean nodesFound = false;
        JGoSelection sel = MinerApp.getCurrentView().getSelection();
        if (sel.isEmpty()) {
            return false;
        }
        JGoListPosition pos = sel.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            if (obj instanceof ActivityNodeArea) {
                nodesFound = true;
                ActivityNodeArea area = (ActivityNodeArea)obj;
                if (!area.getNodeModel().getState().isPresentStateAtLeastAsAdvancedAsTestState(minState)) {
                    return false;
                }
            } else if (obj instanceof CollapsedNodeArea) {
                nodesFound = true;
                if (!((CollapsedNodeArea)obj).getMinimumState().isPresentStateAtLeastAsAdvancedAsTestState(minState)) {
                    return false;
                }
            }
            pos = sel.getNextObjectPos(pos);
        }
        if (nodesFound) {
            return true;
        }
        return noNodesSelectedReturnVal;
    }

    private static boolean canActDependentOnOneNodeState(ActivityNodeState minState, boolean noNodesSelectedReturnVal) {
        boolean nodesFound = false;
        JGoSelection sel = MinerApp.getCurrentView().getSelection();
        if (sel.isEmpty()) {
            return false;
        }
        JGoListPosition pos = sel.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            if (obj instanceof ActivityNodeArea) {
                nodesFound = true;
                ActivityNodeArea area = (ActivityNodeArea)obj;
                if (area.getNodeModel().getState().isPresentStateAtLeastAsAdvancedAsTestState(minState)) {
                    return true;
                }
            } else if (obj instanceof CollapsedNodeArea) {
                nodesFound = true;
                if (((CollapsedNodeArea)obj).getMinimumState().isPresentStateAtLeastAsAdvancedAsTestState(minState)) {
                    return true;
                }
            }
            pos = sel.getNextObjectPos(pos);
        }
        if (nodesFound) {
            return false;
        }
        return noNodesSelectedReturnVal;
    }

    private static void initPopupMenus() {
        JPopupMenu popup = WorksheetView.getEmptySelectionMenu();
        popup.add(g_MouseDrivenPasteAction);
        popup.addSeparator();
        popup.add(g_CreateNode);
        popup.add(g_CreateLink);
        popup.add(g_CreateTextNode);
        popup.addSeparator();
        popup.add(g_OrthoAllAction);
        popup.add(g_clipWorksheetAction);
        popup.addSeparator();
        popup.add(g_EditCommentsAction);
        popup = WorksheetView.getMultiSelectionMenu();
        popup.add(g_ObjectViewAction);
        popup.add(g_InvalidateNodeAction);
        popup.addSeparator();
        popup.add(g_CutAction);
        popup.add(g_CopyAction);
        popup.add(g_PasteAction);
        popup.add(g_DeleteAction);
        popup.addSeparator();
        popup.add(g_CollapseAction);
        popup.add(g_CopyToUserLibraryAction);
        popup = WorksheetView.getActivityNodeSelectionMenu();
        popup.add(g_ObjectPropertiesAction);
        popup.add(g_ObjectViewAction);
        popup.add(g_ShowDataViewerAction);
        popup.addSeparator();
        popup.add(g_RunToHereAction);
        popup.add(g_InvalidateNodeAction);
        popup.addSeparator();
        popup.add(g_CreateFilterAction);
        popup.add(g_CreatePredictorAction);
        popup.addSeparator();
        popup.add(g_CopyToUserLibraryAction);
        popup.add(g_EditCommentsAction);
        popup.add(g_RenameAction);
        popup.addSeparator();
        popup.add(g_CutAction);
        popup.add(g_CopyAction);
        popup.add(g_PasteAction);
        popup.add(g_DeleteAction);
        popup.addSeparator();
        popup.add(g_CollapseAction);
        popup.addSeparator();
        popup.add(g_HelpNodeAction);
        popup = WorksheetView.getCollapsedNodeSelectionMenu();
        popup.add(g_ObjectPropertiesAction);
        popup.add(g_ShowDataViewerAction);
        popup.addSeparator();
        popup.add(g_ExpandAction);
        popup.add(g_CollapseAction);
        popup.addSeparator();
        popup.add(g_CopyToUserLibraryAction);
        popup.add(g_EditCommentsAction);
        popup.add(g_RenameAction);
        popup.addSeparator();
        popup.add(g_CutAction);
        popup.add(g_CopyAction);
        popup.add(g_PasteAction);
        popup.add(g_DeleteAction);
        popup.addSeparator();
        popup.add(g_HelpNodeAction);
        popup = WorksheetView.getLinkSelectionMenu();
        popup.add(g_ShowDataViewerAction);
        popup.add(g_DeleteAction);
        popup.addSeparator();
        popup.add(new JCheckBoxMenuItem(MinerApp.getOrthoAction()));
        popup = WorksheetView.getTextNodeSelectionMenu();
        popup.add(g_ObjectPropertiesAction);
        popup.addSeparator();
        popup.add(g_CutAction);
        popup.add(g_CopyAction);
        popup.add(g_PasteAction);
        popup.add(g_DeleteAction);
        popup.addSeparator();
        popup.add(g_CollapseAction);
        popup.addSeparator();
        popup.add(g_HelpNodeAction);
    }

    public static AppAction getOrthoAction() {
        return g_OrthoAction;
    }

    protected static JMenuBar buildMainMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(MinerApp.getText("MinerApp_menu_file"));
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu(MinerApp.getText("MinerApp_menu_edit"));
        editMenu.setMnemonic(69);
        menuBar.add(editMenu);
        JMenu viewMenu = new JMenu(MinerApp.getText("MinerApp_menu_view"));
        viewMenu.setMnemonic(86);
        menuBar.add(viewMenu);
        JMenu toolsMenu = new JMenu(MinerApp.getText("MinerApp_menu_tools"));
        toolsMenu.setMnemonic(84);
        menuBar.add(toolsMenu);
        JMenu windowsMenu = new JMenu(MinerApp.getText("MinerApp_menu_window"));
        windowsMenu.setMnemonic(87);
        menuBar.add(windowsMenu);
        JMenu helpMenu = new JMenu(MinerApp.getText("MinerApp_menu_help"));
        helpMenu.setMnemonic(72);
        menuBar.add(helpMenu);
        fileMenu.add(MinerApp.newMenuItem(g_FileNewAction, 'N', KeyStroke.getKeyStroke(78, 2)));
        fileMenu.add(MinerApp.newMenuItem(g_FileOpenAction, 'O', KeyStroke.getKeyStroke(79, 2)));
        fileMenu.add(MinerApp.newMenuItem(g_FileCloseAction, 'C'));
        fileMenu.addSeparator();
        fileMenu.add(MinerApp.newMenuItem(g_FileSaveAction, 'S', KeyStroke.getKeyStroke(83, 2)));
        fileMenu.add(MinerApp.newMenuItem(g_FileSaveAsAction, 'A'));
        fileMenu.add(MinerApp.newMenuItem(g_FileSaveAsJPEGAction, 'W'));
        fileMenu.addSeparator();
        if (CollabraSpaceLinkManager.isInstalled()) {
            fileMenu.add(MinerApp.newMenuItem(g_CollabraSpaceOpenAction, 'F'));
            fileMenu.add(MinerApp.newMenuItem(g_CollabraSpaceSaveAction, 'T'));
            fileMenu.addSeparator();
        }
        fileMenu.add(MinerApp.newMenuItem(g_PrintPreviewAction, 'V'));
        fileMenu.add(MinerApp.newMenuItem(g_PrintSetupAction, 'U'));
        fileMenu.add(MinerApp.newMenuItem(g_PrintAction, 'P', KeyStroke.getKeyStroke(80, 2)));
        fileMenu.addSeparator();
        fileMenu.add(MinerApp.newMenuItem(g_FilePropertiesAction, 'I'));
        if (g_recentFileList.size() > 0) {
            fileMenu.addSeparator();
            int i = 0;
            int count = 1;
            while (i < g_recentFileList.size()) {
                String filename = (String)g_recentFileList.get(i);
                String title = Integer.toString(count) + " " + filename;
                RecentlySavedFileAction recent = new RecentlySavedFileAction(title, filename);
                JMenuItem menuItem = new JMenuItem(recent);
                if (count < 10) {
                    menuItem.setMnemonic(Integer.toString(count).charAt(0));
                }
                fileMenu.add(menuItem);
                ++i;
                ++count;
            }
        }
        fileMenu.addSeparator();
        fileMenu.add(MinerApp.newMenuItem(g_ExitAction, 'X'));
        g_undoMenuItem = MinerApp.newMenuItem(g_UndoAction, 'U', KeyStroke.getKeyStroke(90, 2));
        editMenu.add(g_undoMenuItem);
        g_redoMenuItem = MinerApp.newMenuItem(g_RedoAction, 'R', KeyStroke.getKeyStroke(90, 3));
        editMenu.add(g_redoMenuItem);
        editMenu.addSeparator();
        editMenu.add(MinerApp.newMenuItem(g_CutAction, 'T', KeyStroke.getKeyStroke(88, 2)));
        editMenu.add(MinerApp.newMenuItem(g_CopyAction, 'C', KeyStroke.getKeyStroke(67, 2)));
        editMenu.add(MinerApp.newMenuItem(g_PasteAction, 'P', KeyStroke.getKeyStroke(86, 2)));
        editMenu.add(MinerApp.newMenuItem(g_DeleteAction, 'D'));
        editMenu.addSeparator();
        editMenu.add(MinerApp.newMenuItem(g_SelectAllAction, 'L', KeyStroke.getKeyStroke(65, 2)));
        editMenu.addSeparator();
        editMenu.add(MinerApp.newMenuItem(g_CopyToUserLibraryAction, 'S'));
        editMenu.add(MinerApp.newMenuItem(g_RenameAction, 'N'));
        editMenu.addSeparator();
        editMenu.add(MinerApp.newMenuItem(g_CreateNode, 'W'));
        editMenu.add(MinerApp.newMenuItem(g_CreateLink, 'K'));
        editMenu.add(MinerApp.newMenuItem(g_CreateTextNode, 'T'));
        boolean isChecked = MinerApp.getGlobalOptions().getBoolean("explorerVisible", true);
        viewMenu.add(MinerApp.newCheckBoxMenuItem(g_ViewExplorerAction, 'E', isChecked));
        viewMenu.add(MinerApp.newCheckBoxMenuItem(g_ViewToolbarAction, 'T', true));
        isChecked = MinerApp.getGlobalOptions().getBoolean("messagePaneVisible", true);
        viewMenu.add(MinerApp.newCheckBoxMenuItem(g_ViewMessagePaneAction, 'M', isChecked));
        isChecked = MinerApp.isSplusLicensed() && MinerApp.getGlobalOptions().getBoolean("commandLineVisible", false);
        JCheckBoxMenuItem vcl = MinerApp.newCheckBoxMenuItem(g_ViewCommandLineAction, 'L', isChecked);
        vcl.setEnabled(MinerApp.isSplusLicensed());
        viewMenu.add(vcl);
        viewMenu.addSeparator();
        viewMenu.add(MinerApp.newMenuItem(g_ExpandExpAction, 'J', KeyStroke.getKeyStroke(74, 2)));
        viewMenu.add(MinerApp.newMenuItem(g_CollapseExpAction, 'K', KeyStroke.getKeyStroke(75, 2)));
        viewMenu.addSeparator();
        viewMenu.add(MinerApp.newMenuItem(g_OrthoAllAction, 'O', KeyStroke.getKeyStroke(84, 2)));
        viewMenu.add(MinerApp.newMenuItem(g_AutoLayoutAction, 'A', KeyStroke.getKeyStroke(76, 2)));
        viewMenu.add(MinerApp.newMenuItem(g_clipWorksheetAction, 'R'));
        viewMenu.addSeparator();
        viewMenu.add(MinerApp.newMenuItem(g_ZoomNormalAction, 'N'));
        viewMenu.add(MinerApp.newMenuItem(g_ZoomInAction, 'I'));
        viewMenu.add(MinerApp.newMenuItem(g_ZoomOutAction, 'U'));
        viewMenu.add(MinerApp.newMenuItem(g_ZoomToFitAction, 'Z'));
        viewMenu.addSeparator();
        viewMenu.add(MinerApp.newMenuItem(g_CollapseAction, 'C'));
        viewMenu.add(MinerApp.newMenuItem(g_ExpandAction, 'X'));
        viewMenu.add(MinerApp.newMenuItem(g_ExpandAllAction, 'P'));
        toolsMenu.add(MinerApp.newMenuItem(g_ObjectPropertiesAction, 'P', KeyStroke.getKeyStroke(116, 0)));
        toolsMenu.add(MinerApp.newMenuItem(g_ObjectViewAction, 'V', KeyStroke.getKeyStroke(115, 0)));
        toolsMenu.add(MinerApp.newMenuItem(g_ShowDataViewerAction, 'W'));
        toolsMenu.addSeparator();
        toolsMenu.add(MinerApp.newMenuItem(g_RunToHereAction, 'H', KeyStroke.getKeyStroke(120, 0)));
        toolsMenu.add(MinerApp.newMenuItem(g_InvalidateNodeAction, 'I'));
        toolsMenu.addSeparator();
        toolsMenu.add(MinerApp.newMenuItem(g_RunAction, 'R', KeyStroke.getKeyStroke(120, 8)));
        toolsMenu.add(MinerApp.newMenuItem(g_StopAction, 'S', KeyStroke.getKeyStroke(27, 0)));
        toolsMenu.addSeparator();
        toolsMenu.add(MinerApp.newMenuItem(g_CreateFilterAction, 'F'));
        toolsMenu.add(MinerApp.newMenuItem(g_CreatePredictorAction, 'T'));
        toolsMenu.addSeparator();
        toolsMenu.add(MinerApp.newMenuItem(g_DisplayNodeCacheAction, 'A'));
        toolsMenu.add(MinerApp.newMenuItem(g_DeleteNodeCacheAction, 'D'));
        toolsMenu.addSeparator();
        toolsMenu.add(MinerApp.newMenuItem(g_EditCommentsAction, 'C'));
        toolsMenu.addSeparator();
        JMenu libraryMenu = new JMenu(MinerApp.getText("MinerApp_menu_item_library"));
        libraryMenu.setIcon(ExplorerPane.getPlainGrayIcon());
        toolsMenu.add(libraryMenu);
        libraryMenu.add(MinerApp.newMenuItem(g_createNewFolderAction, 'F'));
        libraryMenu.add(MinerApp.newMenuItem(g_DefaultNodeProperties, 'F'));
        libraryMenu.addSeparator();
        libraryMenu.add(MinerApp.newMenuItem(g_manageLibrariesAction, 'G'));
        libraryMenu.add(MinerApp.newMenuItem(g_createNewLibraryAction, 'N'));
        libraryMenu.add(MinerApp.newMenuItem(g_saveLibraryAsAction, 'Y'));
        libraryMenu.addSeparator();
        libraryMenu.add(MinerApp.newMenuItem(g_libraryPropertiesAction, 'E'));
        libraryMenu.add(MinerApp.newMenuItem(g_hideLibraryAction, 'B'));
        libraryMenu.add(MinerApp.newMenuItem(g_revertLibraryAction, 'L'));
        toolsMenu.add(MinerApp.newMenuItem(g_ToolsOptionsAction, 'O'));
        windowsMenu.add(MinerApp.newMenuItem(g_CloseViewers, 'W'));
        windowsMenu.addSeparator();
        windowsMenu.add(MinerApp.newMenuItem(g_TileHorizontalAction, 'H'));
        windowsMenu.add(MinerApp.newMenuItem(g_TileVerticalAction, 'V'));
        windowsMenu.add(MinerApp.newMenuItem(g_CascadeAction, 'C'));
        windowsMenu.addSeparator();
        windowsMenu.add(MinerApp.newMenuItem(g_MinimizeAllAction, 'M'));
        windowsMenu.add(MinerApp.newMenuItem(g_ArrangeIconsAction, 'A'));
        helpMenu.add(MinerApp.newMenuItem(g_HelpContentsAction, 'C', KeyStroke.getKeyStroke(112, 0)));
        helpMenu.add(MinerApp.newMenuItem(g_HelpIndexAction, 'I'));
        helpMenu.add(MinerApp.newMenuItem(g_HelpSearchAction, 'S'));
        helpMenu.addSeparator();
        helpMenu.add(MinerApp.newMenuItem(g_HelpGettingStartedAction, 'G'));
        helpMenu.add(MinerApp.newMenuItem(g_HelpUsersGuideAction, 'U'));
        helpMenu.addSeparator();
        helpMenu.add(MinerApp.newMenuItem(g_AboutAction, 'A'));
        return menuBar;
    }

    public static JMenuItem newMenuItem(Action action, char mnemonic) {
        JMenuItem menuItem = new JMenuItem(action);
        menuItem.setMnemonic(mnemonic);
        return menuItem;
    }

    public static JMenuItem newMenuItem(Action action, char mnemonic, KeyStroke keyStroke) {
        JMenuItem menuItem = new JMenuItem(action);
        menuItem.setMnemonic(mnemonic);
        menuItem.setAccelerator(keyStroke);
        return menuItem;
    }

    public static JCheckBoxMenuItem newCheckBoxMenuItem(Action action, char mnemonic, boolean state) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(action);
        menuItem.setMnemonic(mnemonic);
        menuItem.setState(state);
        return menuItem;
    }

    protected static JToolBar buildMainToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.add(MinerApp.newButton(g_FileNewAction));
        toolBar.add(MinerApp.newButton(g_FileOpenAction));
        toolBar.add(MinerApp.newButton(g_FileSaveAction));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_PrintAction));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_CutAction));
        toolBar.add(MinerApp.newButton(g_CopyAction));
        toolBar.add(MinerApp.newButton(g_PasteAction));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_ZoomNormalAction));
        toolBar.add(MinerApp.newButton(g_ZoomInAction));
        toolBar.add(MinerApp.newButton(g_ZoomOutAction));
        toolBar.add(MinerApp.newButton(g_ZoomToFitAction));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_RunToHereAction));
        toolBar.add(MinerApp.newButton(g_InvalidateNodeAction));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_RunAction));
        toolBar.add(MinerApp.newButton(g_StopAction));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_ObjectPropertiesAction));
        toolBar.add(MinerApp.newButton(g_ObjectViewAction));
        toolBar.add(MinerApp.newButton(g_ShowDataViewerAction));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_CollapseAction));
        toolBar.add(MinerApp.newButton(g_ExpandAction));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_CreateTextNode));
        toolBar.addSeparator();
        toolBar.add(MinerApp.newButton(g_CopyToUserLibraryAction));
        toolBar.add(MinerApp.newButton(g_EditCommentsAction));
        toolBar.setUI(new BasicToolBarUI(){

            protected JFrame createFloatingFrame(JToolBar toolbar) {
                JFrame frame = super.createFloatingFrame(toolbar);
                frame.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
                return frame;
            }
        });
        return toolBar;
    }

    public static JButton newButton(Action action) {
        LocalToolbarButton button = new LocalToolbarButton(action);
        button.setToolTipText((String)action.getValue("Name"));
        button.setIcon((Icon)action.getValue("SmallIcon"));
        button.setText(null);
        button.setMargin(new Insets(2, 2, 2, 2));
        return button;
    }

    private static XMLTree getAppSettings() {
        if (g_appSettings == null) {
            if (new File(g_defaultSettingsFile).exists()) {
                try {
                    g_appSettings = XMLTree.readFromFile(g_defaultSettingsFile);
                    return g_appSettings;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                g_appSettings = new XMLTree();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Document doc = g_appSettings.getDocument();
            Element elt = g_appSettings.getXML();
            Element settings = doc.createElement(DEFAULT_SETTINGS_NODE_TAG);
            elt.appendChild(settings);
            Element options = doc.createElement(GLOBAL_OPTIONS_NODE_TAG);
            options.appendChild(doc.createElement(XTProps.XT_PROPERTY_NODE_TAG));
            settings.appendChild(options);
            Element files = doc.createElement(RECENTLY_SAVED_FILE_NODE_TAG);
            files.appendChild(doc.createElement(XTProps.XT_PROPERTY_NODE_TAG));
            settings.appendChild(files);
        }
        return g_appSettings;
    }

    private static void storeAppSettings() {
        try {
            if (g_globalOptions != null) {
                NodeList settingsList;
                Element set_xml = g_appSettings.getXML();
                Element opt_xml = g_globalOptions.getXML();
                Document doc = g_appSettings.getDocument();
                NodeList optionsList = null;
                if (set_xml != null && (settingsList = set_xml.getElementsByTagName(DEFAULT_SETTINGS_NODE_TAG)) != null && settingsList.getLength() > 0) {
                    optionsList = ((Element)settingsList.item(0)).getElementsByTagName(GLOBAL_OPTIONS_NODE_TAG);
                }
                Element options = optionsList != null && optionsList.getLength() > 0 ? (Element)optionsList.item(0) : null;
                Node newProps = doc.importNode(opt_xml, true);
                NodeList list = options.getChildNodes();
                if (list.getLength() > 0) {
                    options.insertBefore(newProps, list.item(0));
                } else {
                    options.appendChild(newProps);
                }
            }
            g_appSettings.saveToFile(g_defaultSettingsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static XTProps getGlobalOptions() {
        if (g_globalOptions != null) {
            return g_globalOptions;
        }
        try {
            Element settings = (Element)MinerApp.getAppSettings().getXML().getElementsByTagName(DEFAULT_SETTINGS_NODE_TAG).item(0);
            Element options = (Element)settings.getElementsByTagName(GLOBAL_OPTIONS_NODE_TAG).item(0);
            Element node = (Element)options.getElementsByTagName(XTProps.XT_PROPERTY_NODE_TAG).item(0);
            if (node == null) {
                g_globalOptions = new XTProps();
            } else {
                g_globalOptions = new XTProps((Element)node.cloneNode(true));
                options.removeChild(node);
            }
        }
        catch (Exception e) {
            try {
                g_globalOptions = new XTProps();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(g_globalOptions);
        MinerApp.updateWorksheetPropertiesManager();
        return g_globalOptions;
    }

    public static WorksheetPropertiesManager getWorksheetPropertiesManager() {
        if (MinerApp.getCurrentView() != g_worksheetPropertiesView) {
            MinerApp.updateWorksheetPropertiesManager();
            g_worksheetPropertiesView = MinerApp.getCurrentView();
        }
        return g_worksheetPropertiesManager;
    }

    public static void updateWorksheetPropertiesManager() {
        g_worksheetPropertiesManager.setGlobalProperties(MinerApp.getGlobalOptions());
        XTProps worksheetProps = null;
        try {
            worksheetProps = new XTProps();
            worksheetProps = MinerApp.getCurrentDoc().getWorksheetProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        g_worksheetPropertiesManager.setWorksheetProperties(worksheetProps);
    }

    public static String formatDouble(double val) {
        return MinerApp.getWorksheetPropertiesManager().formatDouble(val);
    }

    public static double parseDouble(String val) {
        return MinerApp.getWorksheetPropertiesManager().parseDouble(val);
    }

    public static String formatScientificDouble(double val) {
        return MinerApp.getWorksheetPropertiesManager().getViewerScientificRoundingObject().format(val);
    }

    public static String formatFreeDouble(double val) {
        return MinerApp.getWorksheetPropertiesManager().formatFreeDouble(val);
    }

    public static double parseFreeDouble(String val) {
        return MinerApp.getWorksheetPropertiesManager().parseFreeDouble(val);
    }

    private static Vector loadRecentlySavedFileList() {
        try {
            Element settings = (Element)MinerApp.getAppSettings().getXML().getElementsByTagName(DEFAULT_SETTINGS_NODE_TAG).item(0);
            Element files = (Element)settings.getElementsByTagName(RECENTLY_SAVED_FILE_NODE_TAG).item(0);
            XTProps props = new XTProps((Element)files.getElementsByTagName(XTProps.XT_PROPERTY_NODE_TAG).item(0));
            Vector ret = props.getFirstLevelProperties();
            for (int i = 0; i < ret.size(); ++i) {
                ret.set(i, props.getValue((String)ret.elementAt(i)));
            }
            return ret;
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    private static void storeRecentlySavedFileList() {
        try {
            Element settings = (Element)MinerApp.getAppSettings().getXML().getElementsByTagName(DEFAULT_SETTINGS_NODE_TAG).item(0);
            Element files = (Element)settings.getElementsByTagName(RECENTLY_SAVED_FILE_NODE_TAG).item(0);
            XMLTreeProps props = new XMLTreeProps((Element)files.getElementsByTagName(XTProps.XT_PROPERTY_NODE_TAG).item(0));
            for (int i = 0; i < g_recentFileList.size(); ++i) {
                props.set(Integer.toString(i), (String)g_recentFileList.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateFrameWindowMenu() {
        int i;
        JMenu jWindowsMenu = g_mainFrame.getJMenuBar().getMenu(4);
        JInternalFrame[] frames = MinerApp.getMainFrame().getDesktop().getAllFrames();
        int startPoint = jWindowsMenu.getItemCount();
        for (i = startPoint - 1; i >= 0; --i) {
            Action action;
            JMenuItem item = jWindowsMenu.getItem(i);
            if (item == null || !((action = item.getAction()) instanceof ActiveWorksheetAction)) continue;
            jWindowsMenu.remove(i);
        }
        i = 0;
        int count = 1;
        while (i < frames.length) {
            String title = Integer.toString(count) + " " + frames[i].getTitle();
            ActiveWorksheetAction action = new ActiveWorksheetAction(title, frames[i]);
            JMenuItem menuItem = new JMenuItem(action);
            if (count < 10) {
                menuItem.setMnemonic(Integer.toString(count).charAt(0));
            }
            jWindowsMenu.add(menuItem);
            ++i;
            ++count;
        }
    }

    private static void addFileToRecentlySavedList(String path) {
        int i;
        if (path.equals("")) {
            return;
        }
        int length = g_recentFileList.size();
        boolean found = false;
        for (i = 0; i < length; ++i) {
            if (g_recentFileList.get(i).equals(path)) {
                found = true;
            }
            if (!found || i >= length - 1) continue;
            g_recentFileList.setElementAt(g_recentFileList.get(i + 1), i);
        }
        if (!found && length < 5 && length > 0) {
            g_recentFileList.add(length, g_recentFileList.get(length - 1));
        }
        for (i = Math.min(4, length - 1); i >= 1; --i) {
            g_recentFileList.setElementAt(g_recentFileList.get(i - 1), i);
        }
        if (length == 0) {
            g_recentFileList.add(path);
        } else {
            g_recentFileList.setElementAt(path, 0);
        }
        MinerApp.updateRecentlySavedList();
    }

    private static void updateRecentlySavedList() {
        int startPoint;
        int i;
        JMenu jFileMenu = g_mainFrame.getJMenuBar().getMenu(0);
        int propertiesIndex = 0;
        for (i = startPoint = jFileMenu.getItemCount() - 1 - 1 - 1; i >= 0; --i) {
            JMenuItem item = jFileMenu.getItem(i);
            if (item == null) continue;
            Action action = item.getAction();
            if (action instanceof RecentlySavedFileAction) {
                jFileMenu.remove(i);
                continue;
            }
            if (!action.equals(g_FilePropertiesAction)) continue;
            if (i != startPoint) {
                jFileMenu.remove(i + 1);
            }
            propertiesIndex = i;
            break;
        }
        i = 0;
        int count = 1;
        while (i < g_recentFileList.size()) {
            String filename = (String)g_recentFileList.get(i);
            String actionTitle = Integer.toString(count) + " " + filename;
            RecentlySavedFileAction recent = new RecentlySavedFileAction(actionTitle, filename);
            JMenuItem menuItem = new JMenuItem(recent);
            if (count < 10) {
                menuItem.setMnemonic(Integer.toString(count).charAt(0));
            }
            jFileMenu.insert(menuItem, propertiesIndex + i + 1);
            if (i == g_recentFileList.size() - 1) {
                jFileMenu.insertSeparator(propertiesIndex + 1);
            }
            ++i;
            ++count;
        }
    }

    public static final String getUserHome() {
        return g_userHome;
    }

    public static final String getUserName() {
        return g_userName;
    }

    public static final String getSprimeHome() {
        return g_sprimeHome;
    }

    public static final String getSplusHome() {
        return g_splusHome;
    }

    public static final String getWorkDir() {
        return g_workDir;
    }

    public static final String getSettingsDir() {
        return g_settingsDir;
    }

    public static final String getTempDir() {
        return g_tempDir;
    }

    public static final String getDefaultWorkingChapter() {
        return g_splusProj;
    }

    public static String getUserExamplesDirectory(Component parentComponent) {
        File systemExamplesDirectory = new File(MinerApp.getSprimeHome() + "/examples");
        File userExamplesDirectory = new File(MinerApp.getWorkDir() + "/examples");
        if (userExamplesDirectory.exists()) {
            return userExamplesDirectory.getPath();
        }
        int answer = AcceleratorOptionPane.showOKCancelDialog(parentComponent, MinerApp.getText("MinerApp_msg_examplesDirDoesntExist") + "\n     " + userExamplesDirectory.getPath() + "\n\n" + MinerApp.getText("MinerApp_msg_CreateExamplesDir") + "\n     " + systemExamplesDirectory.getPath(), MinerApp.getText("MinerApp_msg_copySystemExamples"), 3);
        if (answer != 0) {
            return null;
        }
        if (!userExamplesDirectory.mkdirs()) {
            AcceleratorOptionPane.showOKDialog(parentComponent, MinerApp.getText("MinerApp_msg_errorCreatingDirectory") + " " + userExamplesDirectory.getPath());
            return null;
        }
        Cursor oldCursor = null;
        if (parentComponent != null) {
            oldCursor = parentComponent.getCursor();
            parentComponent.setCursor(Cursor.getPredefinedCursor(3));
        }
        String oldStatus = MinerApp.getMainFrame().getStatusText();
        MinerApp.getMainFrame().setStatusText(MinerApp.getText("MinerApp_msg_copyingExampleFiles"));
        MinerApp.copyDirectoryContents(systemExamplesDirectory, userExamplesDirectory);
        if (parentComponent != null && oldCursor != null) {
            parentComponent.setCursor(oldCursor);
        }
        MinerApp.getMainFrame().setStatusText(oldStatus);
        return userExamplesDirectory.getPath();
    }

    public static void copyDirectoryContents(File fromDir, File toDir) {
        File[] filesToCopy = fromDir.listFiles();
        if (filesToCopy == null) {
            return;
        }
        for (int i = 0; i < filesToCopy.length; ++i) {
            File fromFile = filesToCopy[i];
            if (!fromFile.exists()) continue;
            File toFile = new File(toDir, fromFile.getName());
            if (fromFile.isDirectory()) {
                if (!toFile.mkdir()) continue;
                MinerApp.copyDirectoryContents(fromFile, toFile);
                continue;
            }
            MinerApp.copyFile(fromFile, toFile);
        }
    }

    public static void copyFile(File fromFile, File toFile) {
        try {
            int len;
            byte[] buf = new byte[32768];
            DataInputStream in = new DataInputStream(new FileInputStream(fromFile));
            DataOutputStream out = new DataOutputStream(new FileOutputStream(toFile));
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setDebugMessageSeverity() {
        g_messageSeverity = 0;
    }

    public static void setVerboseMessageSeverity() {
        g_messageSeverity = 1;
    }

    public static void setInformationMessageSeverity() {
        g_messageSeverity = 2;
    }

    public static void setWarningMessageSeverity() {
        g_messageSeverity = 3;
    }

    public static void setErrorMessageSeverity() {
        g_messageSeverity = 4;
    }

    public static void setMessageSeverity(int val) {
        g_messageSeverity = val;
    }

    public static int getMessageSeverity() {
        return g_messageSeverity;
    }

    public static void setLogMessageSeverity(int val) {
        g_logMessageSeverity = val;
    }

    public static int getLogMessageSeverity() {
        return g_logMessageSeverity;
    }

    public static void println(String msg) {
        MinerApp.outputText(msg, 0, true);
    }

    public static void startSavingBatchOutput() {
        m_savedBatchOutput = new StringBuffer(2000);
    }

    public static String stopSavingBatchOutput() {
        String val = "";
        if (m_savedBatchOutput != null) {
            val = m_savedBatchOutput.toString();
        }
        m_savedBatchOutput = null;
        return val;
    }

    public static void outputText(String msg, int severity, boolean addNewLine) {
        String outMsg;
        if (msg == null) {
            return;
        }
        String string = outMsg = addNewLine ? msg + "\n" : msg;
        if (severity >= g_messageSeverity) {
            if (MinerApp.isInteractive()) {
                TextOutputScrollPane pane;
                MinerFrame fr = MinerApp.getMainFrame();
                TextOutputScrollPane textOutputScrollPane = pane = fr == null ? null : fr.getOutputScrollPane();
                if (pane != null) {
                    pane.append(outMsg, severity);
                }
            }
            if (m_savedBatchOutput != null) {
                m_savedBatchOutput.append(outMsg);
            }
        }
        if (severity >= g_logMessageSeverity) {
            if (MinerApp.isInteractive() && severity >= g_logMessageSeverity) {
                System.out.print(outMsg);
            }
            if (MinerApp.getBatchLogfileStream() != null) {
                MinerApp.getBatchLogfileStream().print(outMsg);
            }
        }
    }

    public static String getStatusText() {
        if (MinerApp.isHeadless()) {
            if (MinerApp.isInBDL() && BDLManager.windowsProgressBarEnabled()) {
                return BDLManager.windowsProgressBarGetMessage();
            }
            return "";
        }
        return g_mainFrame.getStatusText();
    }

    public static void setStatusText(String msg) {
        if (MinerApp.isHeadless()) {
            if (MinerApp.isInBDL() && BDLManager.windowsProgressBarEnabled()) {
                BDLManager.windowsProgressBarSetMessage(msg);
            }
        } else {
            g_mainFrame.setStatusText(msg);
        }
    }

    public static void setProgressDone(int percent) {
        if (MinerApp.isHeadless()) {
            if (MinerApp.isInBDL() && BDLManager.windowsProgressBarEnabled()) {
                BDLManager.windowsProgressBarSetPos(percent);
            }
        } else {
            g_mainFrame.setProgressDone(percent);
        }
    }

    public static void setSameProgressDone() {
        if (MinerApp.isHeadless()) {
            if (MinerApp.isInBDL() && BDLManager.windowsProgressBarEnabled()) {
                BDLManager.windowsProgressBarSameDone();
            }
        } else {
            g_mainFrame.setSameProgressDone();
        }
    }

    public static void showBDLProgress(boolean show) {
        g_mainFrame.showBDLProgress(show);
    }

    public static void resetCursor(int viewerID) {
        NodeViewer nv = (NodeViewer)g_nodeViewers.get(viewerID);
        nv.resetCursor();
    }

    public static int registerNodeViewer(NodeViewer nv) {
        int location = g_nodeViewers.size();
        g_nodeViewers.add(nv);
        return location;
    }

    public static boolean removeNodeViewer(NodeViewer nv) {
        return g_nodeViewers.remove(nv);
    }

    public static final boolean isWindowsOS() {
        return g_isWindowsOS;
    }

    public static final boolean isSolarisOS() {
        return g_isSolarisOS;
    }

    public static final boolean isUnixOS() {
        return g_isSolarisOS || g_isLinuxOS || g_isHPUXOS || g_isAIXOS;
    }

    public static final boolean isInteractive() {
        return g_isInteractive;
    }

    public static final boolean isHeadless() {
        boolean headless = !g_isInteractive || MinerApp.isInBDL();
        return headless;
    }

    public static final boolean isSplusLicensed() {
        if (!g_checkedSplusLicenseFlag) {
            if (MinerApp.isInBDL()) {
                g_checkedSplusLicenseFlag = true;
                g_hasSplusLicenseFlag = false;
            } else {
                MinerApp.getSession();
            }
        }
        return g_hasSplusLicenseFlag;
    }

    public static final boolean isSplusEngineNode(String name) {
        for (int i = SPLUS_ENGINE_NODES.length - 1; i >= 0; --i) {
            if (!SPLUS_ENGINE_NODES[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static final boolean showForBeta3(String name) {
        if (MinerApp.isWindowsOS()) {
            return true;
        }
        for (int i = INVISIBLE_BETA_NODES.length - 1; i >= 0; --i) {
            if (!INVISIBLE_BETA_NODES[i].equals(name)) continue;
            return false;
        }
        return true;
    }

    public static void createExecViewer(String worksheetID, String nodeID, String nodeName, String displayClassName) {
        try {
            String key = worksheetID + "|" + nodeID;
            System.out.println("creating exec viewer for " + key + " class=" + displayClassName);
            ExecViewer disp = (ExecViewer)g_execViewerMap.get(key);
            if (disp == null) {
                Class cl = ExtensionManager.getClassForName(displayClassName);
                disp = (ExecViewer)cl.newInstance();
                g_execViewerMap.put(key, disp);
            } else {
                disp.show();
            }
            disp.setNodeName(nodeName);
            disp.setWorksheetID(worksheetID);
            disp.setNodeID(nodeID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Object sendMessageToExecViewer(String worksheetID, String nodeID, Object[] vals) {
        ExecViewer disp = MinerApp.getExecViewer(worksheetID, nodeID);
        if (disp == null || vals == null || vals.length < 1) {
            return null;
        }
        String msg = (String)vals[0];
        Object[] args = vals.length < 2 ? null : (Object[])vals[1];
        Object val = EngineMessageHandler.dispatchMessage(disp, msg, args);
        return val;
    }

    public static void closeExecViewer(String worksheetID, String nodeID) {
        System.out.println("closing exec viewer " + worksheetID + "|" + nodeID);
        ExecViewer disp = MinerApp.getExecViewer(worksheetID, nodeID);
        if (disp == null) {
            return;
        }
        disp.closeExecViewer();
        MinerApp.unlinkExecViewer(worksheetID, nodeID);
    }

    public static void unlinkExecViewer(String worksheetID, String nodeID) {
        System.out.println("unlinking exec viewer " + worksheetID + "|" + nodeID);
        g_execViewerMap.remove(worksheetID + "|" + nodeID);
    }

    private static ExecViewer getExecViewer(String worksheetID, String nodeID) {
        ExecViewer disp = (ExecViewer)g_execViewerMap.get(worksheetID + "|" + nodeID);
        return disp;
    }

    public static void nodeStateChanged(ActivityNodeModel model) {
        if (MinerApp.isRunning() && !g_engineChangingState) {
            g_nodesToInvalidate.put(new Integer(model.getID()), model);
        }
    }

    private static void executionEnded() {
        for (Integer key : g_nodesToInvalidate.keySet()) {
            ActivityNodeModel model = (ActivityNodeModel)g_nodesToInvalidate.get(key);
            model.getState().changeState(model);
        }
        g_nodesToInvalidate.clear();
    }

    public static BufferedImage getAsJPEG(Component comp) {
        Dimension rect = comp.getSize();
        Dimension oldRect = comp.getSize();
        Container cont = comp.getParent();
        JScrollBar hBar = null;
        JScrollBar vBar = null;
        Point barLoc = new Point();
        if (cont instanceof JViewport) {
            cont = cont.getParent();
        }
        if (cont != null) {
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                if (!(child instanceof JScrollBar)) continue;
                JScrollBar sb = (JScrollBar)child;
                if (sb.getOrientation() == 0) {
                    rect.width = sb.getModel().getMaximum();
                    barLoc.x = sb.getValue();
                    sb.setValue(0);
                    hBar = sb;
                    continue;
                }
                rect.height = sb.getModel().getMaximum();
                barLoc.y = sb.getValue();
                sb.setValue(0);
                vBar = sb;
            }
            if (!rect.equals(oldRect)) {
                comp.setSize(rect.width, rect.height);
            }
        }
        JGoSelection sel = null;
        if (cont instanceof WorksheetView) {
            JGoSelection oldSel = ((WorksheetView)((Object)cont)).getSelection();
            JGoListPosition pos = oldSel.getFirstObjectPos();
            sel = new JGoSelection();
            while (pos != null) {
                JGoObject obj = oldSel.getObjectAtPos(pos);
                pos = oldSel.getNextObjectPos(pos);
                sel.extendSelection(obj);
            }
            oldSel.clearSelection();
        }
        BufferedImage bimage = new BufferedImage(rect.width, rect.height, 1);
        comp.paint(bimage.createGraphics());
        if (sel != null && cont instanceof WorksheetView) {
            JGoSelection newSel = ((WorksheetView)((Object)cont)).getSelection();
            JGoListPosition pos = sel.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = sel.getObjectAtPos(pos);
                pos = sel.getNextObjectPos(pos);
                newSel.extendSelection(obj);
            }
        }
        if (cont != null && !rect.equals(oldRect)) {
            comp.setSize(oldRect.width, oldRect.height);
            if (hBar != null) {
                hBar.setValue(barLoc.x);
            }
            if (vBar != null) {
                vBar.setValue(barLoc.y);
            }
        }
        return bimage;
    }

    public static File saveAsJPEG(Component comp) {
        ExportGraphCommand exportCommand = new ExportGraphCommand((Frame)MinerApp.getMainFrame(), (JComponent)comp);
        exportCommand.doExecute();
        return new File(exportCommand.getImageFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMainThreadRequests() {
        Thread.currentThread().setPriority(1);
        g_mainThreadRequest = null;
        g_mainThreadWaitObject = new Object();
        g_mainThreadRequestWaitObject = new Object();
        while (true) {
            Object object = g_mainThreadWaitObject;
            synchronized (object) {
                if (g_mainThreadRequest == null) {
                    try {
                        g_mainThreadWaitObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (g_mainThreadRequest == null) continue;
            g_mainThreadResult = MinerApp.runReturningException(g_mainThreadRequest);
            object = g_mainThreadRequestWaitObject;
            synchronized (object) {
                g_mainThreadRequest = null;
                g_mainThreadRequestWaitObject.notify();
            }
        }
    }

    private static Object runReturningException(Runnable req) {
        try {
            req.run();
        }
        catch (Exception ex) {
            return ex;
        }
        catch (Error ex) {
            return ex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runInMainThread(Runnable req) {
        if (!MinerApp.isInteractive() || g_mainThreadRequestWaitObject == null || g_mainThreadWaitObject == null) {
            return MinerApp.runReturningException(req);
        }
        Object object = g_mainThreadRequestWaitObject;
        synchronized (object) {
            if (g_mainThreadRequest != null) {
                return MinerApp.runReturningException(req);
            }
            g_mainThreadRequest = req;
            Object object2 = g_mainThreadWaitObject;
            synchronized (object2) {
                g_mainThreadWaitObject.notify();
            }
            while (g_mainThreadRequest != null) {
                try {
                    g_mainThreadRequestWaitObject.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return g_mainThreadResult;
        }
    }

    public static boolean isInBDL() {
        if (!m_isInBDLInit) {
            m_isInBDL = System.getProperty("iminer.in.bdl", "").equalsIgnoreCase("true");
            m_isInBDLInit = true;
        }
        return m_isInBDL;
    }

    public static boolean isMainAppCreated() {
        return g_mainApp != null;
    }

    public static String getPDFViewer() {
        return MinerApp.getGlobalOptions().getValue("pdfViewer", "");
    }

    public static String getHTMLViewer() {
        return MinerApp.getGlobalOptions().getValue("htmlViewer", "");
    }

    public static Font getFont(int style, int size) {
        return new Font(m_uiFontName, style, size);
    }

    public static ResourceBundle getBundle(String bundleName) {
        ResourceBundle bundle = null;
        String bundleFilename = bundleName + "_" + LOCALE_LANGUAGE + "_" + LOCALE_COUNTRY + ".properties";
        try {
            Locale currentLocale = new Locale(LOCALE_LANGUAGE, LOCALE_COUNTRY);
            bundle = ResourceBundle.getBundle(bundleName, currentLocale);
        }
        catch (MissingResourceException e) {
            bundle = m_errorBundle;
        }
        return bundle;
    }

    public static boolean isErrorBundle(ResourceBundle bundle) {
        return bundle == m_errorBundle;
    }

    public static String getBundleString(ResourceBundle bundle, String key) {
        String string = "[Resource Not Found]";
        if (!MinerApp.isErrorBundle(bundle)) {
            try {
                string = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                MinerApp.println("Error finding bundle key: " + key);
            }
        }
        return string;
    }

    public static String getImlFileName(String lib) {
        String libFilename = lib + ".iml";
        if (INTERNATIONAL) {
            String iLib = lib + "_" + LOCALE_LANGUAGE + "_" + LOCALE_COUNTRY + ".iml";
            File iFile = new File(MinerApp.getSplusHome() + "/library/bigdata/xml/" + iLib);
            if (iFile.exists()) {
                libFilename = iLib;
            } else {
                MinerApp.println("Can't find localized file " + iLib + " : will use " + libFilename);
            }
        }
        MinerApp.println("Using IML file: " + libFilename);
        return libFilename;
    }

    static {
        LOCALE_LANGUAGE = "en";
        LOCALE_COUNTRY = "US";
        INTERNATIONAL = false;
        g_textBundles = null;
        m_uiFontName = "Arial";
        g_addSplusListener = true;
        g_originalStandardOut = null;
        g_batchLogfileStream = null;
        SUCCESS_CODE = 0;
        ERROR_CODE = 1;
        g_returnCode = SUCCESS_CODE;
        g_worksheetPropertiesView = null;
        g_evalSync = new Object();
        g_evalInProgress = false;
        g_engineChangingState = false;
        g_nodesToInvalidate = new HashMap();
        g_splusVersionInfo = new SPLUSVersionInfo();
        g_messageSeverity = 2;
        g_logMessageSeverity = 0;
        DEBUG_MESSAGE_SEVERITY_STRING = "debug";
        VERBOSE_MESSAGE_SEVERITY_STRING = "verbose";
        INFORMATION_MESSAGE_SEVERITY_STRING = "information";
        WARNING_MESSAGE_SEVERITY_STRING = "warning";
        ERROR_MESSAGE_SEVERITY_STRING = "error";
        try {
            if (g_isWindowsOS) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            if (System.getProperty("java.version").startsWith("1.4")) {
                UIManager.getDefaults().put("MenuItemUI", "com.insightful.miner.MinerMenuItemUI");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (System.getProperty("iminer.home") != null) {
            System.setProperty("sprime.home", System.getProperty("iminer.home"));
        }
        if (System.getProperty("iminer.work") != null) {
            System.setProperty("sprime.work", System.getProperty("iminer.work"));
        }
        if (System.getProperty("iminer.temp") != null) {
            System.setProperty("sprime.temp", System.getProperty("iminer.temp"));
        }
        if (System.getProperty("iminer.logfile") != null) {
            System.setProperty("sprime.logfile", System.getProperty("iminer.logfile"));
        }
        m_loadIMBigDataLibraryDone = false;
        g_lastGlobalOptions = null;
        g_splusBusy = false;
        g_bdView = null;
        g_bdDoc = null;
        g_stopRequested = false;
        g_isRunning = false;
        m_savedBatchOutput = null;
        g_checkedSplusLicenseFlag = false;
        g_hasSplusLicenseFlag = false;
        SPLUS_ENGINE_NODES = new String[]{"com.insightful.miner.ReadSplusFileEngineNode", "com.insightful.miner.WriteSplusFileEngineNode", "com.insightful.miner.SplusCreateColumnsEngineNode", "com.insightful.miner.SplusFilterRowsEngineNode", "com.insightful.miner.SplusGraphEngineNode", "com.insightful.miner.SplusSplitEngineNode", "com.insightful.miner.SplusScriptEngineNode", "com.insightful.miner.TwoDimChartEngineNode"};
        INVISIBLE_BETA_NODES = new String[]{"com.insightful.miner.ReadNativeSQLServerDatabaseEngineNode", "com.insightful.miner.ReadDatabaseEngineNode", "com.insightful.miner.WriteNativeSQLServerDatabaseEngineNode", "com.insightful.miner.WriteDatabaseEngineNode"};
        g_execViewerMap = new HashMap();
        g_mainThreadRequest = null;
        g_mainThreadResult = null;
        g_mainThreadWaitObject = null;
        g_mainThreadRequestWaitObject = null;
        m_isInBDL = false;
        m_isInBDLInit = false;
        m_errorBundle = new ResourceBundle(){

            public Object handleGetObject(String key) {
                return null;
            }

            public Enumeration getKeys() {
                return null;
            }
        };
    }

    private static class ActiveWorksheetAction
    extends AppAction {
        private JInternalFrame g_frame = null;

        public ActiveWorksheetAction(String title, JInternalFrame frame) {
            super(title, MinerApp.getIcon("plain_gray.gif"));
            this.g_frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            JDesktopPane desktop = MinerApp.getMainFrame().getDesktop();
            try {
                if (this.g_frame.isIcon()) {
                    this.g_frame.setMaximum(true);
                }
                desktop.getDesktopManager().activateFrame(this.g_frame);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public boolean canAct() {
            return true;
        }

        public JInternalFrame getFrame() {
            return this.g_frame;
        }
    }

    private static class RecentlySavedFileAction
    extends AppAction {
        private String path = null;

        public RecentlySavedFileAction(String title, String filepath) {
            super(title, MinerApp.getIcon("plain_gray.gif"));
            this.path = filepath;
        }

        public void actionPerformed(ActionEvent e) {
            File file = new File(this.path);
            new OpenFileThread(file).start();
        }

        public boolean canAct() {
            return true;
        }
    }

    private static class LocalToolbarButton
    extends JButton {
        public LocalToolbarButton() {
        }

        public LocalToolbarButton(Action action) {
            super(action);
        }

        public String getToolTipText(MouseEvent evt) {
            if (MinerApp.getMainFrame() == null || MinerApp.getMainFrame().getFocusOwner() == null) {
                return null;
            }
            return super.getToolTipText(evt);
        }
    }

    public static class GenericPrintThread
    extends Thread {
        private PrinterJob j;

        public GenericPrintThread(PrinterJob job) {
            this.j = job;
        }

        public void run() {
            try {
                this.j.print(MinerApp.getPrintAttributeSet());
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    private static class DeleteOrDisplayNodeCacheThread
    extends Thread {
        private String g_endStatus = null;
        private boolean g_delete = false;

        public DeleteOrDisplayNodeCacheThread(String endStatus, boolean delete) {
            this.g_endStatus = endStatus;
            this.g_delete = delete;
        }

        public void run() {
            Component comp = g_mainFrame.getGlassPane();
            Cursor oldCursor = comp.getCursor();
            comp.setCursor(Cursor.getPredefinedCursor(3));
            MouseAdapter ma = new MouseAdapter(){};
            KeyAdapter ka = new KeyAdapter(){};
            comp.addMouseListener(ma);
            comp.addKeyListener(ka);
            comp.setVisible(true);
            MinerApp.getMainFrame().setStatusText(MinerApp.getText("MinerFrame_statusbar_delete_nodes"));
            try {
                MinerApp.doDeleteOrDisplayNodeCache(this.g_delete);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            MinerApp.getMainFrame().setStatusText(this.g_endStatus);
            comp.removeMouseListener(ma);
            comp.removeKeyListener(ka);
            comp.setCursor(oldCursor);
            comp.setVisible(false);
        }
    }

    private static class InvalidateThread
    extends Thread {
        private String g_endStatus = null;

        public InvalidateThread(String endStatus) {
            this.g_endStatus = endStatus;
        }

        public void run() {
            Component comp = g_mainFrame.getGlassPane();
            Cursor oldCursor = comp.getCursor();
            comp.setCursor(Cursor.getPredefinedCursor(3));
            MouseAdapter ma = new MouseAdapter(){};
            KeyAdapter ka = new KeyAdapter(){};
            comp.addMouseListener(ma);
            comp.addKeyListener(ka);
            comp.setVisible(true);
            MinerApp.getMainFrame().setStatusText(MinerApp.getText("MinerFrame_statusbar_invalidate_nodes"));
            try {
                MinerApp.doInvalidateNode();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            MinerApp.getMainFrame().setStatusText(this.g_endStatus);
            comp.removeMouseListener(ma);
            comp.removeKeyListener(ka);
            comp.setCursor(oldCursor);
            comp.setVisible(false);
        }
    }

    private static class ValidateThread
    extends Thread {
        private WorksheetDocument g_doc = null;
        private boolean g_justValid = false;
        private String g_endStatus = null;
        private boolean g_deep = false;

        public ValidateThread(WorksheetDocument doc, boolean justValid, boolean deep, String endStatus) {
            this.g_justValid = justValid;
            this.g_endStatus = endStatus;
            this.g_deep = deep;
            this.g_doc = doc;
        }

        public void run() {
            Component comp = g_mainFrame.getGlassPane();
            Cursor oldCursor = comp.getCursor();
            comp.setCursor(Cursor.getPredefinedCursor(3));
            MouseAdapter ma = new MouseAdapter(){};
            KeyAdapter ka = new KeyAdapter(){};
            comp.addMouseListener(ma);
            comp.addKeyListener(ka);
            comp.setVisible(true);
            MinerApp.getMainFrame().setStatusText(MinerApp.getText("MinerFrame_statusbar_update_node_state"));
            boolean prevDeep = ActivityNodeState.isDeepMode();
            ActivityNodeState.setDeepMode(this.g_deep);
            try {
                MinerApp.updateNodeStatesFromEngine(this.g_doc, this.g_justValid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ActivityNodeState.setDeepMode(prevDeep);
            MinerApp.getMainFrame().setStatusText(this.g_endStatus);
            comp.removeMouseListener(ma);
            comp.removeKeyListener(ka);
            comp.setCursor(oldCursor);
            comp.setVisible(false);
        }
    }

    private static class OpenFileThread
    extends Thread {
        private File m_file = null;

        public OpenFileThread(File file) {
            this.m_file = file;
        }

        public void run() {
            MinerApp.openWorksheet(this.m_file);
        }
    }
}

