/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.AppAction;
import com.insightful.miner.BDLManager;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerDropTarget;
import com.insightful.miner.ModifyColumnsPanel;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NodeDialog
extends JDialog {
    private XTProps origProps;
    protected JTabbedPane tabbedPane;
    private ActivityNodeModel m_model;
    private Dimension minimumSize;
    private Dimension maximumSize;
    protected JPanel advancedPanel;
    protected RandomSeedPanel seedPanel;
    protected JTextField chunkTextField;
    protected JRadioButton[] chunkButtons = new JRadioButton[2];
    protected String rowsToChunk;
    protected String globalChunkDefault;
    protected JRadioButton[] cachingButtons = new JRadioButton[3];
    protected String[] cachingStrings = new String[]{"useCache", "no", "global"};
    protected JComboBox executeAfterComboBox = new JComboBox();
    protected Vector executeAfterVector = new Vector();
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton helpButton;
    protected JButton applyButton;
    protected JButton addButton;
    private static final String helpString = "NodeDialog_help";
    private static final String okString = "NodeDialog_ok";
    private static final String advancedString = "NodeDialog_advanced";
    private static final String cancelString = "NodeDialog_cancel";
    private static final String applyString = "NodeDialog_apply";
    private static final String addString = "NodeDialog_add";
    private static final String propertiesString = "NodeDialog_properties";
    protected static final String executionOptionsString = "NodeDialog_executionOptions";
    protected static final String rowsPerChunkString = "NodeDialog_rowsPerChunk";
    protected static final String cachingString = "NodeDialog_caching";
    protected static final String noCachingString = "NodeDialog_noCaching";
    protected static final String useGlobalCachingString = "NodeDialog_useGlobalCaching";
    static final String cannotRestorePropertiesString = "NodeDialog_cannotRestoreProperties";
    static final String propertiesNotRestoredString = "NodeDialog_propertiesNotRestored";
    private static final String advancedOptionsString = "NodeDialog_advancedOptions";
    protected static final String useGlobalString = "NodeDialog_useGlobal";
    private static final String specifyString = "NodeDialog_specify";
    private static final String okHotkeyString = "NodeDialog_okHotkey";
    private static final String helpHotkeyString = "NodeDialog_helpHotkey";
    private static final String cancelHotkeyString = "NodeDialog_cancelHotkey";
    private static final String applyHotkeyString = "NodeDialog_applyHotkey";
    private static final String addHotkeyString = "NodeDialog_addHotkey";
    protected static final String useGlobalHotkeyString = "NodeDialog_useGlobalHotkey";
    protected static final String specifyHotkeyString = "NodeDialog_specifyHotkey";
    protected static final String cachingHotkeyString = "NodeDialog_cachingHotkey";
    protected static final String noCachingHotkeyString = "NodeDialog_noCachingHotkey";
    protected static final String useGlobalCachingHotkeyString = "NodeDialog_useGlobalCachingHotkey";
    static final String USE_CACHE_ATTRIBUTE_TAG = "useCache";
    static final String YES_CACHING_ATTRIBUTE_TAG = "yes";
    static final String NO_CACHING_ATTRIBUTE_TAG = "no";
    static final String GLOBAL_CACHING_ATTRIBUTE_TAG = "global";
    static final String USE_GLOBAL_CACHING_ATTRIBUTE_TAG = "useGlobal";
    static final String SPECIFIED_ROWS_TO_CHUNK_ATTRIBUTE_TAG = "specifiedRowsToChunk";
    static final String ROWS_TO_CHUNK_ATTRIBUTE_TAG = "rowsToChunk";
    static final String RANDOM_SEED_ATTRIBUTE_TAG = "randomSeed";
    static final String ENTER_SEED_ATTRIBUTE_TAG = "enterSeed";
    static final String NEW_SEED_ATTRIBUTE_TAG = "newSeedEveryTime";
    static final String RANDOM_SEED_VALUE_ATTRIBUTE_TAG = "randomSeedValue";
    public static final int MIN_WIDTH = 450;
    public static final int MIN_HEIGHT = 475;
    protected AbstractAction useGlobalAction;
    protected AbstractAction specifyAction;
    protected AbstractAction helpAction;
    protected AbstractAction okAction;
    protected AbstractAction cancelAction;
    protected AbstractAction applyAction;
    protected AbstractAction addAction;
    private boolean m_firstTime;
    private static boolean m_dialogCancelled = false;
    static final DataFlavor ColumnInformationFlavor = new DataFlavor(ColumnInformationObject.class, null);
    private static final DateFormatListItem[] parseListItems = new DateFormatListItem[]{new DateFormatListItem("%m[/][.]%d[/][,]%y [%H[:%M[:%S[.%N]]]] [%p]  {General MDY}"), new DateFormatListItem("%d[/][.]%m[/][,]%y [%H[:%M[:%S[.%N]]]] [%p]  {General DMY}"), new DateFormatListItem("%d [-][.] %m [-][.] %y                      {14.03.98}"), new DateFormatListItem("%d [-][.] %m [-][.] %y                      {14-Mar-98}"), new DateFormatListItem("%d [-][.] %m [-][.] %y                      {14-Mar-1998}"), new DateFormatListItem("%d [-][.] %m [-][.] %y                      {14 March 1998}"), new DateFormatListItem("%w %m %d, %y                      {Saturday, March 14, 1998}")};
    private static final DateFormatListItem[] outputListItems = new DateFormatListItem[]{new DateFormatListItem("%02m/%02d/%Y %02H:%02M:%02S  {03/14/1998 13:30:45}"), new DateFormatListItem("%02d/%02m/%Y %02H:%02M:%02S  {14/03/1998 13:30:45}"), new DateFormatListItem("%m/%d/%y                     {3/14/98}"), new DateFormatListItem("%m/%d/%Y                     {3/14/1998}"), new DateFormatListItem("%02m/%02d/%Y                 {03/14/1998}"), new DateFormatListItem("%d/%m/%y                     {14/3/98}"), new DateFormatListItem("%d/%m/%Y                     {14/3/1998}"), new DateFormatListItem("%02d/%02m/%Y                 {14/03/1998}"), new DateFormatListItem("%02d.%02m.%y                 {14.03.98}"), new DateFormatListItem("%d-%b-%y                     {14-Mar-98}"), new DateFormatListItem("%d-%b-%Y                     {14-Mar-1998}"), new DateFormatListItem("%d %B %Y                     {14 March 1998}"), new DateFormatListItem("%B %d, %Y                    {March 14, 1998}"), new DateFormatListItem("%m/%d/%Y %I:%02M %p          {3/14/1998 1:30 pm}"), new DateFormatListItem("%m/%d/%Y %02H:%02M           {3/14/1998 13:30}"), new DateFormatListItem("%A, %B %d, %Y                {Saturday, March 14, 1998}"), new DateFormatListItem("%02m/%02d/%Y %02H:%02M:%02S.%03N {03/14/1998 13:30:45.000}")};

    public NodeDialog() {
        this("");
    }

    private NodeDialog(String title) {
        this((Frame)MinerApp.getMainFrame(), title);
    }

    private NodeDialog(Frame owner, String title) {
        super(owner, title, false);
        this.createActions();
        this.createLayout();
        this.setResizable(true);
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getOwner());
        this.setMinimumSize(this.getPreferredSize());
        this.maximumSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                if (event.getSource() instanceof JDialog) {
                    Dimension myDimensions = NodeDialog.this.getPermittedSize(NodeDialog.this.getSize());
                    NodeDialog.this.setSize(myDimensions);
                }
            }
        });
        MinerApp.getMainFrame().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NodeDialog.this.unmakeKindaModal();
                NodeDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NodeDialog.this.onCancel();
            }
        });
        this.m_firstTime = true;
    }

    public void show(ActivityNodeModel newModel) {
        m_dialogCancelled = false;
        this.setNodeModel(newModel);
        if (newModel != null) {
            this.origProps = (XTProps)this.getNodeModel().getXTProps().copy();
            this.setTitle(this.getNodeModel().getDefaultLabel());
        }
        this.tabbedPane.setSelectedIndex(0);
        this.restoreProperties();
        AppAction.updateAllActions();
        Component comp = this.tabbedPane.getComponentAt(0);
        while (comp instanceof Container) {
            Container cont = (Container)comp;
            Component tComp = null;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                tComp = cont.getComponent(i);
                if (tComp instanceof JLabel) continue;
                comp = tComp;
                break;
            }
            if (cont != comp) continue;
            break;
        }
        if (this.m_firstTime) {
            this.m_firstTime = false;
            this.pack();
            this.setSize(this.getMinimumSize());
        }
        comp.requestFocusInWindow();
        this.makeKindaModal();
        this.setLocationRelativeTo(this.getOwner());
        BDLManager.putDialogOnTop(this);
        this.setVisible(true);
    }

    public Dimension getMaximumSize() {
        return this.maximumSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public void setMaximumSize(Dimension maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.minimumSize = minimumSize = new Dimension(Math.max(minimumSize.width, 450), Math.max(minimumSize.height, 475));
    }

    public Dimension getPermittedSize(Dimension dimension) {
        double width = dimension.getWidth();
        double height = dimension.getHeight();
        double minHeight = -1.0;
        double maxHeight = -1.0;
        double minWidth = -1.0;
        double maxWidth = -1.0;
        if (this.minimumSize != null) {
            minHeight = this.minimumSize.getHeight();
            minWidth = this.minimumSize.getWidth();
        }
        if (this.maximumSize != null) {
            maxHeight = this.maximumSize.getHeight();
            maxWidth = this.maximumSize.getWidth();
        }
        if (maxWidth != -1.0 && width > maxWidth) {
            width = maxWidth;
        }
        if (minWidth != -1.0 && width < minWidth) {
            width = minWidth;
        }
        if (maxHeight != -1.0 && height > maxHeight) {
            height = maxHeight;
        }
        if (minHeight != -1.0 && height < minHeight) {
            height = minHeight;
        }
        return new Dimension((int)width, (int)height);
    }

    static void addKeyboardNavigation(JTable table) {
        table.addKeyListener(new KeyboardTableNavigator(table));
    }

    protected static FileFilter getFileFilter(final String[] exts, final String description) {
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < exts.length; ++i) {
                    if (!f.getName().toLowerCase().endsWith(exts[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return description;
            }
        };
        return ff;
    }

    protected static FileFilter getFileFilter(final String ext, final String description) {
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(ext);
            }

            public String getDescription() {
                return description;
            }
        };
        return ff;
    }

    public void restoreProperties() {
        this.restoreProperties(this.getNodeModel().getXTProps());
    }

    protected void restoreProperties(XTProps props) {
        this.globalChunkDefault = String.valueOf(MinerApp.getWorksheetPropertiesManager().getMaxRowsPerBlock());
        this.rowsToChunk = props.getValue(SPECIFIED_ROWS_TO_CHUNK_ATTRIBUTE_TAG, "");
        boolean usingGlobal = props.getBoolean(USE_GLOBAL_CACHING_ATTRIBUTE_TAG, true);
        this.chunkButtons[0].setSelected(usingGlobal);
        if (usingGlobal) {
            this.chunkButtons[0].doClick();
        } else {
            this.chunkButtons[1].doClick();
        }
        String cachingString = props.getValue(USE_CACHE_ATTRIBUTE_TAG, this.cachingStrings[2]);
        for (int i = 0; i < this.cachingStrings.length; ++i) {
            if (!cachingString.equals(this.cachingStrings[i])) continue;
            this.cachingButtons[i].setSelected(true);
            this.cachingButtons[i].doClick();
        }
        if (this.displaySeedPanel()) {
            this.seedPanel.restoreProperties(props);
        }
        if (this.getNodeModel() != null) {
            this.restoreExecuteAfterComboBox();
        }
    }

    public void saveProperties() throws DialogException {
        this.saveProperties(this.getNodeModel().getXTProps());
    }

    protected void saveProperties(XTProps props) throws DialogException {
        if (this.chunkButtons[0].isSelected()) {
            props.set(USE_GLOBAL_CACHING_ATTRIBUTE_TAG, true);
        } else {
            props.set(USE_GLOBAL_CACHING_ATTRIBUTE_TAG, false);
        }
        if (this.rowsToChunk.equals("")) {
            this.rowsToChunk = "0";
        }
        try {
            Integer.parseInt(this.rowsToChunk);
        }
        catch (Exception e) {
            throw new DialogException("Rows to chunk must be a valid Integer less than 2147483647.");
        }
        props.set(SPECIFIED_ROWS_TO_CHUNK_ATTRIBUTE_TAG, this.rowsToChunk);
        props.set(ROWS_TO_CHUNK_ATTRIBUTE_TAG, this.chunkTextField.getText());
        for (int i = 0; i < this.cachingStrings.length; ++i) {
            if (!this.cachingButtons[i].isSelected()) continue;
            props.set(USE_CACHE_ATTRIBUTE_TAG, this.cachingStrings[i]);
        }
        if (this.displaySeedPanel()) {
            this.seedPanel.saveProperties(props);
        }
        if (this.getNodeModel() != null) {
            this.saveExecuteAfterComboBox();
        }
    }

    public void createActions() {
        this.okAction = new AbstractAction(MinerApp.getText(okString)){

            public void actionPerformed(ActionEvent e) {
                NodeDialog.this.onOk();
            }
        };
        this.cancelAction = new AbstractAction(MinerApp.getText(cancelString)){

            public void actionPerformed(ActionEvent e) {
                NodeDialog.this.onCancel();
            }
        };
        this.applyAction = new AbstractAction(MinerApp.getText(applyString)){

            public void actionPerformed(ActionEvent e) {
                NodeDialog.this.onApply();
            }
        };
        this.addAction = new AbstractAction(MinerApp.getText(addString)){

            public void actionPerformed(ActionEvent e) {
                NodeDialog.this.onAdd();
            }
        };
        this.helpAction = new AbstractAction(MinerApp.getText(helpString)){

            public void actionPerformed(ActionEvent e) {
                NodeDialog.this.onHelp();
            }
        };
        this.createGlobalPanelActions();
    }

    private void createGlobalPanelActions() {
        this.useGlobalAction = new AbstractAction(MinerApp.getText(useGlobalString)){

            public void actionPerformed(ActionEvent e) {
                NodeDialog.this.chunkTextField.setText(NodeDialog.this.globalChunkDefault);
                NodeDialog.this.chunkTextField.setEnabled(false);
            }
        };
        this.specifyAction = new AbstractAction(MinerApp.getText(specifyString) + ":"){

            public void actionPerformed(ActionEvent e) {
                if (NodeDialog.this.rowsToChunk.equals("0")) {
                    NodeDialog.this.rowsToChunk = "";
                }
                NodeDialog.this.chunkTextField.setText(NodeDialog.this.rowsToChunk);
                NodeDialog.this.chunkTextField.setEnabled(true);
            }
        };
    }

    public void onOk() {
        try {
            this.saveProperties();
            this.unmakeKindaModal();
            this.setVisible(false);
            if (this.getNodeModel() != null) {
                XTProps newProps = new XTProps(this.getNodeModel().getXTProps());
                if (!this.getNodeModel().postDialogEqualityCheck(this.origProps, newProps)) {
                    this.getNodeModel().getDocument().setEngineNetworkDirty();
                    this.getNodeModel().getState().propertiesNotSame(this.getNodeModel());
                    AppAction.updateAllActions();
                }
            }
        }
        catch (DialogException e) {
            String msg = e.getMessage();
            if (msg.length() > 0) {
                AcceleratorOptionPane.showOKDialog(this, msg, MinerApp.getText("NodeDialog_dialogCannotBeSaved"), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCancel() {
        m_dialogCancelled = true;
        this.unmakeKindaModal();
        this.setVisible(false);
    }

    public static boolean getDialogCancelled() {
        return m_dialogCancelled;
    }

    public void onApply() {
        try {
            this.saveProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ActivityNodeModel curNodeModel = this.getNodeModel();
        if (!curNodeModel.isPropertiesValid()) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), "Node is not completely configured.  Check that all required\nrequired properties are set and all required inputs are linked.", "Cannot Perform Apply", 0);
        } else {
            MinerApp.getMainFrame().getRootPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getApplyButton().setEnabled(false);
            this.getAddButton().setEnabled(false);
            this.getOKButton().setEnabled(false);
            this.getCancelButton().setEnabled(false);
            boolean origRunToHereShowViewer = MinerApp.getGlobalOptions().getBoolean("runToHereShowViewer");
            MinerApp.getGlobalOptions().set("runToHereShowViewer", true);
            MinerApp.invalidateNode(Integer.toString(curNodeModel.getID()));
            MinerApp.getCurrentDoc().setEngineNetworkDirty();
            MinerApp.runToNode(new String[]{Integer.toString(curNodeModel.getID())}, false);
            this.origProps = (XTProps)this.getNodeModel().getXTProps().copy();
            new ResetAfterApplyThread(origRunToHereShowViewer).start();
        }
    }

    public void onAdd() {
        ActivityNodeModel curNodeModel = this.getNodeModel();
        ActivityNodeModel newNodeModel = null;
        try {
            this.saveProperties();
            newNodeModel = curNodeModel.copy();
            curNodeModel.setXTProps(this.origProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ActivityNodeArea newNodeArea = new ActivityNodeArea();
        newNodeArea.initialize(newNodeModel);
        newNodeArea.setVisible(true);
        WorksheetView view = MinerApp.getCurrentView();
        WorksheetDocument doc = view.getDoc();
        BaseNodeArea curNodeArea = doc.findNodeByID(curNodeModel.getID());
        view.copyFromExplorerPane(newNodeArea, curNodeArea.getSpotLocation(6));
        doc.addObjectAtTail((JGoObject)newNodeArea);
        Vector curInputPorts = curNodeArea.getInputPorts();
        Vector newInputPorts = newNodeArea.getInputPorts();
        JGoPort curPort = null;
        JGoListPosition listPos = null;
        JGoLink curLink = null;
        JGoPort curFromPort = null;
        BaseLink newLink = null;
        for (int i = 0; i < curInputPorts.size(); ++i) {
            curPort = (JGoPort)curInputPorts.elementAt(i);
            listPos = curPort.getFirstLinkPos();
            if (listPos == null) continue;
            curLink = curPort.getLinkAtPos(listPos);
            curFromPort = curLink.getFromPort();
            newLink = doc.newLink(curFromPort, (JGoPort)newInputPorts.elementAt(i), true);
            doc.setEngineNetworkDirty();
            newLink.setVisible(true);
        }
    }

    public void onHelp() {
        if (this.getNodeModel() != null) {
            this.getNodeModel().showHelp();
        } else {
            String str = this.getTitle();
            if (str == null || str.equals("")) {
                str = "Welcome";
            }
            MinerApp.getHelpManager().showTopic(str);
        }
    }

    public JButton getApplyButton() {
        return this.applyButton;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getOKButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    private void makeKindaModal() {
        MinerApp.getMainFrame().setEnabledFromDialog(false);
    }

    private void unmakeKindaModal() {
        MinerApp.getMainFrame().setEnabledFromDialog(true);
    }

    private void createLayout() {
        Vector panels;
        this.tabbedPane = new JTabbedPane();
        JPanel optionsPanel = this.createOptionsPanel();
        if (optionsPanel != null) {
            this.tabbedPane.addTab(MinerApp.getText(propertiesString), optionsPanel);
        }
        if ((panels = this.createOtherTabs()) != null) {
            for (int i = 0; i < panels.size(); ++i) {
                Object obj = panels.get(i);
                if (obj == null || !(obj instanceof JPanel)) continue;
                JPanel panel = (JPanel)obj;
                this.tabbedPane.addTab(panel.getName(), panel);
            }
        }
        this.advancedPanel = this.createAdvancedPanel();
        if (this.advancedPanel != null) {
            this.tabbedPane.addTab(MinerApp.getText(advancedString), this.advancedPanel);
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.tabbedPane, "Center");
        container.add((Component)this.createButtonPanel(), "South");
    }

    public JPanel createOptionsPanel() {
        return null;
    }

    public Vector createOtherTabs() {
        return null;
    }

    protected JPanel createAdvancedPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.createGlobalPanel());
        p.add(this.createSeedPanel());
        JPanel extraPanel = this.createNodePanel();
        if (extraPanel != null) {
            p.add(extraPanel);
        }
        return p;
    }

    private JPanel createGlobalPanel() {
        JPanel globalPanel = new JPanel(new GridBagLayout());
        globalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText(executionOptionsString)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        globalPanel.setPreferredSize(new Dimension(375, 275));
        JLabel rowsPerChunkLabel = new JLabel(MinerApp.getText(rowsPerChunkString));
        ButtonGroup chunkButtonGroup = new ButtonGroup();
        this.chunkButtons = new JRadioButton[2];
        JRadioButton useGlobalRadioButton = new JRadioButton(this.useGlobalAction);
        useGlobalRadioButton.setMnemonic(MinerApp.getText(useGlobalHotkeyString).charAt(0));
        chunkButtonGroup.add(useGlobalRadioButton);
        this.chunkButtons[0] = useGlobalRadioButton;
        JRadioButton specifyRadioButton = new JRadioButton(this.specifyAction);
        specifyRadioButton.setMnemonic(MinerApp.getText(specifyHotkeyString).charAt(0));
        chunkButtonGroup.add(specifyRadioButton);
        this.chunkButtons[1] = specifyRadioButton;
        this.chunkTextField = new JTextField(10);
        this.chunkTextField.setMinimumSize(this.chunkTextField.getPreferredSize());
        this.chunkTextField.setDocument(new InputPositiveIntegerDoc());
        this.chunkTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    JTextField textfield = (JTextField)e.getSource();
                    String val = textfield.getText();
                    try {
                        if (val.length() == 0 || Long.parseLong(val) == 0L) {
                            textfield.setText(NodeDialog.this.globalChunkDefault);
                        }
                        NodeDialog.this.rowsToChunk = textfield.getText();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        JLabel cachingLabel = new JLabel(MinerApp.getText(cachingString) + ":");
        JRadioButton cachingRadioButton = new JRadioButton(MinerApp.getText(cachingString));
        cachingRadioButton.setMnemonic(MinerApp.getText(cachingHotkeyString).charAt(0));
        buttonGroup.add(cachingRadioButton);
        this.cachingButtons[0] = cachingRadioButton;
        JRadioButton noCachingRadioButton = new JRadioButton(MinerApp.getText(noCachingString));
        noCachingRadioButton.setMnemonic(MinerApp.getText(noCachingHotkeyString).charAt(0));
        buttonGroup.add(noCachingRadioButton);
        this.cachingButtons[1] = noCachingRadioButton;
        JRadioButton useGlobalCachingRadioButton = new JRadioButton(MinerApp.getText(useGlobalCachingString));
        useGlobalCachingRadioButton.setMnemonic(MinerApp.getText(useGlobalCachingHotkeyString).charAt(0));
        buttonGroup.add(useGlobalCachingRadioButton);
        this.cachingButtons[2] = useGlobalCachingRadioButton;
        JLabel orderLabel = new JLabel(MinerApp.getText("NodeDialog_orderOperations"));
        JLabel executeAfterLabel = new JLabel(MinerApp.getText("NodeDialog_executeAfter"));
        this.executeAfterComboBox.setPreferredSize(this.chunkTextField.getPreferredSize());
        Insets none = new Insets(0, 0, 0, 0);
        Insets idnt = new Insets(0, 10, 0, 0);
        Insets v_idnt = new Insets(10, 0, 10, 0);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.insets = none;
        globalPanel.add((Component)rowsPerChunkLabel, constraints);
        ++constraints.gridy;
        constraints.insets = idnt;
        globalPanel.add((Component)useGlobalRadioButton, constraints);
        ++constraints.gridy;
        globalPanel.add((Component)specifyRadioButton, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        globalPanel.add((Component)this.chunkTextField, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = v_idnt;
        constraints.gridwidth = 0;
        globalPanel.add((Component)new JSeparator(), constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.insets = none;
        constraints.gridwidth = 1;
        globalPanel.add((Component)cachingLabel, constraints);
        ++constraints.gridy;
        constraints.insets = idnt;
        globalPanel.add((Component)cachingRadioButton, constraints);
        ++constraints.gridy;
        globalPanel.add((Component)noCachingRadioButton, constraints);
        ++constraints.gridy;
        globalPanel.add((Component)useGlobalCachingRadioButton, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.insets = v_idnt;
        constraints.gridwidth = 0;
        globalPanel.add((Component)new JSeparator(), constraints);
        ++constraints.gridy;
        constraints.insets = none;
        constraints.gridwidth = 1;
        globalPanel.add((Component)orderLabel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.insets = idnt;
        globalPanel.add((Component)executeAfterLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        globalPanel.add((Component)this.executeAfterComboBox, constraints);
        return globalPanel;
    }

    public JPanel createNodePanel() {
        return null;
    }

    private void restoreExecuteAfterComboBox() {
        String val = this.getNodeModel().getNodeInfo().executeAfter;
        int selection = 0;
        this.executeAfterComboBox.removeAllItems();
        this.executeAfterVector.removeAllElements();
        this.executeAfterVector.add("");
        this.executeAfterComboBox.addItem("");
        int current = 1;
        WorksheetDocument doc = this.getNodeModel().getDocument();
        JGoListPosition pos = doc.getFirstObjectPos();
        while (pos != null) {
            ActivityNodeModel testModel;
            JGoObject obj = doc.getObjectAtPos(pos);
            if (obj instanceof ActivityNodeArea && (testModel = ((ActivityNodeArea)obj).getNodeModel()) != this.getNodeModel() && !this.getNodeModel().isChild(testModel)) {
                this.executeAfterComboBox.addItem(testModel.getLabelText().replaceAll("\n", ""));
                String id = Integer.toString(testModel.getID());
                this.executeAfterVector.add(id);
                if (id.equals(val)) {
                    selection = current;
                }
                ++current;
            }
            pos = doc.getNextObjectPos(pos);
        }
        this.executeAfterComboBox.setSelectedIndex(selection);
    }

    private void saveExecuteAfterComboBox() {
        int sel = this.executeAfterComboBox.getSelectedIndex();
        if (sel > 0) {
            String orig;
            String val = (String)this.executeAfterVector.get(sel);
            if (!val.equals(orig = this.getNodeModel().getNodeInfo().executeAfter)) {
                this.getNodeModel().getDocument().setEngineNetworkDirty();
                this.getNodeModel().getNodeInfo().executeAfter = val;
                this.getNodeModel().getDocument().setModified(true);
            }
        } else {
            if (this.getNodeModel().getNodeInfo().executeAfter != null) {
                this.getNodeModel().getDocument().setEngineNetworkDirty();
                this.getNodeModel().getDocument().setModified(true);
            }
            this.getNodeModel().getNodeInfo().executeAfter = null;
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 10, 5));
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton(this.cancelAction);
        Dimension buttonSize = this.cancelButton.getPreferredSize();
        this.applyButton = new JButton(this.applyAction);
        this.applyButton.setPreferredSize(buttonSize);
        this.applyButton.setMnemonic(MinerApp.getText(applyHotkeyString).charAt(0));
        this.applyButton.setVisible(false);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.addButton = new JButton(this.addAction);
        this.addButton.setPreferredSize(buttonSize);
        this.addButton.setMnemonic(MinerApp.getText(addHotkeyString).charAt(0));
        this.addButton.setVisible(false);
        buttonPanel.add(this.addButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(Box.createGlue());
        this.okButton = new JButton(this.okAction);
        this.okButton.setPreferredSize(buttonSize);
        this.okButton.setMnemonic(MinerApp.getText(okHotkeyString).charAt(0));
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.setMnemonic(MinerApp.getText(cancelHotkeyString).charAt(0));
        buttonPanel.add(this.cancelButton);
        this.cancelButton.registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke("ESCAPE"), 2);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.helpButton = new JButton(this.helpAction);
        this.helpButton.setPreferredSize(buttonSize);
        this.helpButton.setMnemonic(MinerApp.getText(helpHotkeyString).charAt(0));
        buttonPanel.add(this.helpButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.helpButton.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke("F1"), 2);
        return buttonPanel;
    }

    public boolean displaySeedPanel() {
        return false;
    }

    private JPanel createSeedPanel() {
        this.seedPanel = new RandomSeedPanel(true);
        this.seedPanel.setEnabled(this.displaySeedPanel());
        return this.seedPanel;
    }

    public void setNodeModel(ActivityNodeModel model) {
        this.m_model = model;
    }

    public ActivityNodeModel getNodeModel() {
        return this.m_model;
    }

    protected static class DateOutputFormatComboBox
    extends DateFormatComboBox {
        public DateOutputFormatComboBox() {
            super(outputListItems);
        }
    }

    protected static class DateParseFormatComboBox
    extends DateFormatComboBox {
        public DateParseFormatComboBox() {
            super(parseListItems);
        }
    }

    protected static class DateFormatComboBox
    extends JComboBox {
        private DateFormatListItem[] listItems = null;
        private int popupColumnWidth;
        private int fontWidth = 7;
        private int maxWidth = -1;

        public DateFormatComboBox(DateFormatListItem[] list) {
            super(list);
            this.listItems = list;
            this.init();
        }

        public void init() {
            this.setUI(new SteppedComboBoxUI());
            Font font = new Font("Courier", 0, this.getFont().getSize());
            this.setFont(font);
            int myWidth = -1;
            for (int i = 0; i < this.listItems.length; ++i) {
                int width = this.listItems[i].toFullString().length();
                if (width <= myWidth) continue;
                myWidth = width;
            }
            this.popupColumnWidth = (myWidth + 1) * this.fontWidth;
            this.setEditable(true);
            this.setSelectedIndex(-1);
            this.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    String value;
                    int extraIndex;
                    if (DateFormatComboBox.this.getSelectedIndex() != -1 && (extraIndex = (value = DateFormatComboBox.this.getText()).indexOf("{")) != -1) {
                        DateFormatComboBox.this.setSelectedItem(value.substring(0, extraIndex).trim());
                    }
                }
            });
            DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSel, boolean hasFocus) {
                    String str = value instanceof DateFormatListItem ? ((DateFormatListItem)value).toFullString() : value.toString();
                    return super.getListCellRendererComponent((JList<?>)list, str, index, isSel, hasFocus);
                }
            };
            this.setRenderer(renderer);
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (this.maxWidth == -1) {
                for (int i = 0; i < this.listItems.length; ++i) {
                    int width = this.listItems[i].toString().length();
                    if (width <= this.maxWidth) continue;
                    this.maxWidth = width;
                }
            }
            dim.width = (this.maxWidth + 1) * this.fontWidth;
            return dim;
        }

        public void setText(String text) {
            this.setSelectedItem(text);
        }

        public String getText() {
            return this.getSelectedItem().toString();
        }

        public void setSelectedItem(Object obj) {
            if (obj instanceof String) {
                for (int i = 0; i < this.listItems.length; ++i) {
                    String str = this.listItems[i].toString();
                    if (!str.equals(obj)) continue;
                    obj = this.listItems[i];
                    break;
                }
            }
            super.setSelectedItem(obj);
            MinerApp.getMainFrame().requestFocus();
            this.requestFocus();
        }

        class SteppedComboBoxUI
        extends BasicComboBoxUI {
            SteppedComboBoxUI() {
            }

            protected ComboPopup createPopup() {
                BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                    public void show() {
                        Dimension popupSize = this.comboBox.getSize();
                        popupSize.width = Math.max(DateFormatComboBox.this.popupColumnWidth, popupSize.width);
                        popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                        this.scroller.setMaximumSize(popupBounds.getSize());
                        this.scroller.setPreferredSize(popupBounds.getSize());
                        this.scroller.setMinimumSize(popupBounds.getSize());
                        this.list.invalidate();
                        int selectedIndex = this.comboBox.getSelectedIndex();
                        if (selectedIndex == -1) {
                            this.list.clearSelection();
                        } else {
                            this.list.setSelectedIndex(selectedIndex);
                        }
                        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                        this.show(this.comboBox, popupBounds.x, popupBounds.y);
                    }
                };
                popup.getAccessibleContext().setAccessibleParent(this.comboBox);
                return popup;
            }
        }
    }

    protected static class DateFormatListItem {
        private String editString;
        private String fullString;

        public DateFormatListItem(String fString) {
            this.fullString = fString;
            int loc = fString.indexOf("{");
            this.editString = loc > 0 ? fString.substring(0, loc).trim() : fString;
        }

        public String toString() {
            return this.editString;
        }

        public String toFullString() {
            return this.fullString;
        }
    }

    protected static class LeftJustifiedStringRenderer
    implements TableCellRenderer,
    Serializable {
        protected JLabel rend = new JLabel();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            if (isSelected) {
                this.rend.setBackground(table.getSelectionBackground());
                this.rend.setForeground(table.getSelectionForeground());
            } else {
                this.rend.setBackground(table.getBackground());
                this.rend.setForeground(table.getForeground());
            }
            Color back = this.rend.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.rend.setOpaque(!colorMatch);
            this.rend.setText(" " + value.toString());
            this.rend.setHorizontalAlignment(2);
            return this.rend;
        }
    }

    protected static class RightJustifiedStringRenderer
    extends LeftJustifiedStringRenderer {
        protected RightJustifiedStringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.rend.setHorizontalAlignment(4);
            return this.rend;
        }
    }

    protected static class DNDList
    extends JList
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private DropTarget dropTarget = new MinerDropTarget(this, this);
        private DragSource dragSource = DragSource.getDefaultDragSource();
        private boolean isDragging = false;

        public DNDList(DefaultListModel model) {
            super(model);
            this.dropTarget.setActive(true);
            this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            this.isDragging = false;
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            ColumnInformationObject transferable;
            ListSelectionModel sm = this.getSelectionModel();
            int iMin = sm.getMinSelectionIndex();
            int iMax = sm.getMaxSelectionIndex();
            if (iMin >= 0 && iMax == iMin && (transferable = (ColumnInformationObject)this.getSelectedValue()) != null) {
                this.isDragging = true;
                dragGestureEvent.startDrag(null, transferable, this);
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.getDropAction() != 2) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            try {
                ColumnInformationObject object = (ColumnInformationObject)dropTargetDropEvent.getTransferable().getTransferData(ColumnInformationFlavor);
                object.init(object.columnName, object.dataType, object.role, object.interactionsFlag, object.index);
                if (object.isDataFlavorSupported(ColumnInformationFlavor) && ((DefaultListModel)this.getModel()).contains(object)) {
                    dropTargetDropEvent.acceptDrop(2);
                    int row = this.locationToIndex(dropTargetDropEvent.getLocation());
                    DefaultListModel model = (DefaultListModel)this.getModel();
                    if (row == -1) {
                        row = model.size() - 1;
                    }
                    model.removeElement(object);
                    model.insertElementAt(object, row);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (this.isDragging) {
                dropTargetDragEvent.acceptDrag(3);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this.isDragging) {
                dropTargetDragEvent.acceptDrag(3);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this.isDragging = false;
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    protected static class DNDListModel
    extends DefaultListModel {
        private ListDataListener[] listeners = null;

        public void removeListDataListeners() {
            this.listeners = this.getListDataListeners();
            for (int i = 0; i < this.listeners.length; ++i) {
                this.removeListDataListener(this.listeners[i]);
            }
        }

        public void undoRemoveListDataListeners() {
            if (this.listeners == null) {
                return;
            }
            for (int i = 0; i < this.listeners.length; ++i) {
                this.addListDataListener(this.listeners[i]);
            }
            this.listeners = null;
        }

        public void addElements(Object[] newElements) {
            int size = newElements.length - 1;
            if (size < 0) {
                return;
            }
            if (size > 20) {
                this.removeListDataListeners();
            }
            for (int i = 0; i < size; ++i) {
                this.addElement(newElements[i]);
            }
            if (size > 20) {
                this.undoRemoveListDataListeners();
            }
            this.addElement(newElements[size]);
        }

        public void removeElements(Object[] newElements) {
            int size = newElements.length - 1;
            if (size < 0) {
                return;
            }
            if (size > 20) {
                this.removeListDataListeners();
            }
            for (int i = size; i >= 1; --i) {
                this.removeElement(newElements[i]);
            }
            if (size > 20) {
                this.undoRemoveListDataListeners();
            }
            this.removeElement(newElements[0]);
        }

        public void removeElementsAt(int[] indices) {
            int size = indices.length - 1;
            if (size < 0) {
                return;
            }
            if (size > 20) {
                this.removeListDataListeners();
            }
            for (int i = size; i >= 1; --i) {
                this.removeElementAt(indices[i]);
            }
            if (size > 20) {
                this.undoRemoveListDataListeners();
            }
            this.removeElementAt(indices[0]);
        }

        public void listContentsChanged() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    protected static class TableMap
    extends AbstractTableModel
    implements TableModelListener {
        protected TableModel tableModel;

        protected TableMap() {
        }

        public TableModel getModel() {
            return this.tableModel;
        }

        public void setModel(TableModel tableModel) {
            this.tableModel = tableModel;
            tableModel.addTableModelListener(this);
        }

        public Object getValueAt(int aRow, int aColumn) {
            return this.tableModel.getValueAt(aRow, aColumn);
        }

        public void setValueAt(Object aValue, int aRow, int aColumn) {
            this.tableModel.setValueAt(aValue, aRow, aColumn);
        }

        public int getRowCount() {
            return this.tableModel == null ? 0 : this.tableModel.getRowCount();
        }

        public int getColumnCount() {
            return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
        }

        public String getColumnName(int aColumn) {
            return this.tableModel.getColumnName(aColumn);
        }

        public Class getColumnClass(int aColumn) {
            return this.tableModel.getColumnClass(aColumn);
        }

        public boolean isCellEditable(int row, int column) {
            return this.tableModel.isCellEditable(row, column);
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    protected static class TableSorter
    extends TableMap {
        int[] indexes = new int[0];
        Vector sortingColumns = new Vector();
        boolean ascending = true;
        int compares;

        public TableSorter() {
            this.indexes = new int[0];
        }

        public TableSorter(TableModel model) {
            this.setModel(model);
        }

        public void setModel(TableModel model) {
            super.setModel(model);
            this.reallocateIndexes();
        }

        public int compareRowsByColumn(int row1, int row2, int column) {
            Object v2;
            String s2;
            String s1;
            Class<?> type = this.tableModel.getColumnClass(column);
            TableModel data = this.tableModel;
            Object o1 = data.getValueAt(row1, column);
            Object o2 = data.getValueAt(row2, column);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            try {
                if (o1 instanceof String) {
                    DecimalFormat format = MinerApp.getWorksheetPropertiesManager().getViewerRoundingObject();
                    Double d1 = new Double(format.parse((String)o1).doubleValue());
                    Double d2 = new Double(format.parse((String)o2).doubleValue());
                    o1 = d1;
                    o2 = d2;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (type.getSuperclass() == Number.class) {
                Number n2;
                double d2;
                Number n1 = (Number)data.getValueAt(row1, column);
                double d1 = n1.doubleValue();
                if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
            if (type == Date.class) {
                Date d2;
                long n2;
                Date d1 = (Date)data.getValueAt(row1, column);
                long n1 = d1.getTime();
                if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                    return -1;
                }
                if (n1 > n2) {
                    return 1;
                }
                return 0;
            }
            if (type == String.class) {
                String s12 = (String)data.getValueAt(row1, column);
                String s22 = (String)data.getValueAt(row2, column);
                try {
                    int i1 = Integer.parseInt(s12);
                    int i2 = Integer.parseInt(s22);
                    if (i1 < i2) {
                        return -1;
                    }
                    if (i1 > i2) {
                        return 1;
                    }
                    return 0;
                }
                catch (NumberFormatException e) {
                    int result = s12.compareTo(s22);
                    if (result < 0) {
                        return -1;
                    }
                    if (result > 0) {
                        return 1;
                    }
                    return 0;
                }
            }
            if (type == Boolean.class) {
                Boolean bool2;
                boolean b2;
                Boolean bool1 = (Boolean)data.getValueAt(row1, column);
                boolean b1 = bool1;
                if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                    return 0;
                }
                if (b1) {
                    return 1;
                }
                return -1;
            }
            if (o1 instanceof JTextField) {
                JTextField textField2;
                String s23;
                JTextField textField1 = (JTextField)data.getValueAt(row1, column);
                s1 = textField1.getText();
                int result = s1.compareTo(s23 = (textField2 = (JTextField)data.getValueAt(row2, column)).getText());
                if (result < 0) {
                    return -1;
                }
                if (result > 0) {
                    return 1;
                }
                return 0;
            }
            if (o1 instanceof JComboBox) {
                JComboBox comboBox2;
                String s24;
                JComboBox comboBox1 = (JComboBox)data.getValueAt(row1, column);
                s1 = comboBox1.getSelectedItem().toString();
                int result = s1.compareTo(s24 = (comboBox2 = (JComboBox)data.getValueAt(row2, column)).getSelectedItem().toString());
                if (result < 0) {
                    return -1;
                }
                if (result > 0) {
                    return 1;
                }
                return 0;
            }
            if (o1 instanceof Double) {
                double d2;
                double d1 = (Double)o1;
                if (d1 < (d2 = ((Double)o2).doubleValue())) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
            if (o1 instanceof Integer) {
                int i2;
                int i1 = (Integer)o1;
                if (i1 < (i2 = ((Integer)o2).intValue())) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
            Object v1 = data.getValueAt(row1, column);
            s1 = v1.toString();
            int result = s1.compareTo(s2 = (v2 = data.getValueAt(row2, column)).toString());
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }

        public int compare(int row1, int row2) {
            ++this.compares;
            for (int level = 0; level < this.sortingColumns.size(); ++level) {
                Integer column = (Integer)this.sortingColumns.elementAt(level);
                int result = this.compareRowsByColumn(row1, row2, column);
                if (result == 0) continue;
                return this.ascending ? result : -result;
            }
            return 0;
        }

        public void reallocateIndexes() {
            int rowCount = this.tableModel.getRowCount();
            this.indexes = new int[rowCount];
            for (int row = 0; row < rowCount; ++row) {
                this.indexes[row] = row;
            }
        }

        public void tableChanged(TableModelEvent e) {
            this.reallocateIndexes();
            super.tableChanged(e);
        }

        public void checkModel() {
            if (this.indexes.length != this.tableModel.getRowCount()) {
                // empty if block
            }
        }

        public void sort(Object sender) {
            this.checkModel();
            this.compares = 0;
            this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        }

        public void n2sort() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = i + 1; j < this.getRowCount(); ++j) {
                    if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                    this.swap(i, j);
                }
            }
        }

        public void shuttlesort(int[] from, int[] to, int low, int high) {
            if (high - low < 2) {
                return;
            }
            int middle = (low + high) / 2;
            this.shuttlesort(to, from, low, middle);
            this.shuttlesort(to, from, middle, high);
            int p = low;
            int q = middle;
            if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
                for (int i = low; i < high; ++i) {
                    to[i] = from[i];
                }
                return;
            }
            for (int i = low; i < high; ++i) {
                to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            }
        }

        public void swap(int i, int j) {
            int tmp = this.indexes[i];
            this.indexes[i] = this.indexes[j];
            this.indexes[j] = tmp;
        }

        public Object getValueAt(int aRow, int aColumn) {
            this.checkModel();
            return this.tableModel.getValueAt(this.indexes[aRow], aColumn);
        }

        public void setValueAt(Object aValue, int aRow, int aColumn) {
            this.checkModel();
            this.tableModel.setValueAt(aValue, this.indexes[aRow], aColumn);
            this.fireTableChanged(new TableModelEvent(this, aRow, aRow, aColumn));
        }

        public void sortByColumn(int column) {
            this.sortByColumn(column, true);
        }

        public void sortByColumn(int column, boolean ascending) {
            this.ascending = ascending;
            this.sortingColumns.removeAllElements();
            this.sortingColumns.addElement(new Integer(column));
            this.sort(this);
            super.tableChanged(new TableModelEvent(this));
        }

        public void addMouseListenerToHeaderInTable(JTable table) {
            final TableSorter sorter = this;
            final JTable tableView = table;
            MouseAdapter listMouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    TableColumnModel columnModel = tableView.getColumnModel();
                    int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                    int column = tableView.convertColumnIndexToModel(viewColumn);
                    if (e.getClickCount() == 1 && column != -1) {
                        sorter.sortByColumn(column, sorter.ascending);
                        sorter.ascending = !sorter.ascending;
                    }
                }
            };
            JTableHeader th = tableView.getTableHeader();
            th.addMouseListener(listMouseListener);
        }
    }

    protected static class ComboBoxEditor
    extends DefaultCellEditor
    implements ItemListener,
    Serializable {
        private JComboBox comboBox;

        public ComboBoxEditor(JComboBox comboBox) {
            super(comboBox);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            this.comboBox = (JComboBox)value;
            this.comboBox.addItemListener(this);
            return (Component)value;
        }

        public Object getCellEditorValue() {
            this.comboBox.removeItemListener(this);
            return this.comboBox;
        }

        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    protected static class TextFieldEditor
    extends DefaultCellEditor
    implements Serializable {
        private JTextField textField;

        public TextFieldEditor(JTextField textfield) {
            super(textfield);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            this.textField = (JTextField)value;
            return (Component)value;
        }

        public Object getCellEditorValue() {
            return this.textField;
        }

        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    protected static class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        public RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    protected static class GeneralRenderer
    implements TableCellRenderer,
    Serializable {
        Color foregroundColor = new JLabel().getForeground();
        Color backgroundColor = Color.white;

        protected GeneralRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean sel, boolean hasFocus, int row, int col) {
            if (value == null) {
                return null;
            }
            JLabel label = new JLabel();
            Color back = this.backgroundColor;
            if (sel) {
                label.setForeground(table.getSelectionForeground());
                label.setBackground(table.getSelectionBackground());
                back = label.getBackground();
            } else {
                label.setForeground(this.foregroundColor);
                label.setBackground(this.backgroundColor);
            }
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            label.setOpaque(!colorMatch);
            label.setHorizontalAlignment(0);
            if (value instanceof JComboBox) {
                label.setText((String)((JComboBox)value).getSelectedItem());
            } else if (value instanceof JTextField) {
                label.setText(((JTextField)value).getText());
            } else if (value instanceof ImageIcon) {
                label.setIcon((ImageIcon)value);
            } else if (value instanceof String) {
                label.setText((String)value);
                label.setHorizontalAlignment(2);
                try {
                    double d = Double.parseDouble((String)value);
                    label.setHorizontalAlignment(4);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return label;
        }
    }

    protected static class SortingScrollPane
    extends JScrollPane {
        protected JList list;
        protected Comparator currentComparator = null;
        protected Comparator azSortCompare = null;
        protected Comparator zaSortCompare = null;

        public SortingScrollPane() {
            this(new JList());
        }

        public SortingScrollPane(JList list) {
            super(list);
            this.list = list;
            JPanel header = this.createHeader();
            this.setColumnHeaderView(header);
        }

        public void setList(JList list) {
            this.list = list;
            this.setViewportView(list);
        }

        public JList getList() {
            return this.list;
        }

        protected void setComparators() {
            this.azSortCompare = new azSortComparator();
            this.zaSortCompare = new zaSortComparator();
        }

        private JPanel createHeader() {
            JPanel header = new JPanel(new GridLayout(1, 3));
            this.setComparators();
            JButton originalButton = new JButton(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SortingScrollPane.this.currentComparator = null;
                    SortingScrollPane.this.sort();
                }
            });
            JButton azSortButton = new JButton(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SortingScrollPane.this.currentComparator = SortingScrollPane.this.azSortCompare;
                    SortingScrollPane.this.sort();
                }
            });
            JButton zaSortButton = new JButton(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    SortingScrollPane.this.currentComparator = SortingScrollPane.this.zaSortCompare;
                    SortingScrollPane.this.sort();
                }
            });
            originalButton.setIcon(MinerApp.getResourceManager().getIcon("simpleStar.gif"));
            azSortButton.setIcon(MinerApp.getResourceManager().getIcon("upArrow.gif"));
            zaSortButton.setIcon(MinerApp.getResourceManager().getIcon("downArrow.gif"));
            originalButton.setToolTipText("Default Order");
            azSortButton.setToolTipText("Sort a->z");
            zaSortButton.setToolTipText("Sort z->a");
            header.add(originalButton);
            header.add(azSortButton);
            header.add(zaSortButton);
            return header;
        }

        public void sort() {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            Object[] dataList = model.toArray();
            Arrays.sort(dataList, this.currentComparator);
            model.clear();
            for (int i = 0; i < dataList.length; ++i) {
                model.addElement(dataList[i]);
            }
            this.repaint();
        }

        private class zaSortComparator
        implements Comparator {
            zaSortComparator() {
            }

            public int compare(Object o1, Object o2) {
                if (o1 instanceof ColumnInformationObject && o2 instanceof ColumnInformationObject) {
                    int i2;
                    int i1 = ((ColumnInformationObject)o1).order();
                    if (i1 != (i2 = ((ColumnInformationObject)o2).order())) {
                        return i1 - i2;
                    }
                    i1 = ((ColumnInformationObject)o1).size();
                    if (i1 != (i2 = ((ColumnInformationObject)o2).size())) {
                        return i1 - i2;
                    }
                    String string = ((ColumnInformationObject)o1).getText();
                    String compareString = ((ColumnInformationObject)o2).getText();
                    return string.compareTo(compareString) * -1;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return false;
            }
        }

        private class azSortComparator
        implements Comparator {
            azSortComparator() {
            }

            public int compare(Object o1, Object o2) {
                if (o1 instanceof ColumnInformationObject && o2 instanceof ColumnInformationObject) {
                    int i2;
                    int i1 = ((ColumnInformationObject)o1).order();
                    if (i1 != (i2 = ((ColumnInformationObject)o2).order())) {
                        return i1 - i2;
                    }
                    i1 = ((ColumnInformationObject)o1).size();
                    if (i1 != (i2 = ((ColumnInformationObject)o2).size())) {
                        return i1 - i2;
                    }
                    String string = ((ColumnInformationObject)o1).getText();
                    String compareString = ((ColumnInformationObject)o2).getText();
                    return string.compareTo(compareString);
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return false;
            }
        }
    }

    public static class ColumnInformationRenderer
    extends JLabel
    implements ListCellRenderer {
        public ColumnInformationRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            ColumnInformationObject object = (ColumnInformationObject)value;
            this.setText(object.getText());
            this.setIcon(object.getIcon());
            this.setAlignmentX(1.0f);
            return this;
        }
    }

    protected static class ModelTerm
    extends ColumnInformationObject {
        protected ColumnInformationObject[] m_variables = null;
        protected int[] m_order = null;

        public ModelTerm(String varName, String dataType, String role, int index) {
            super(varName, dataType, role, false, index);
        }

        public ModelTerm(ColumnInformationObject[] variables, int[] order) {
            int n = variables.length;
            if (n <= 0) {
                return;
            }
            if (order.length != n) {
                return;
            }
            ColumnInformationObject obj = variables[0];
            String termName = obj.getText();
            String type = obj.getType();
            int ord = order[0];
            if (n == 1 && ord <= 1) {
                this.init(termName, type, obj.getRole(), false, 0);
                return;
            }
            this.m_variables = new ColumnInformationObject[n];
            this.m_order = new int[n];
            this.m_variables[0] = obj;
            this.m_order[0] = ord;
            if (ord > 1) {
                termName = termName + "^" + Integer.toString(ord);
            }
            for (int i = 1; i < n; ++i) {
                obj = variables[i];
                ord = obj.getType().equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG) ? order[i] : 1;
                this.m_variables[i] = obj;
                this.m_order[i] = ord;
                termName = termName + ":" + obj.getText();
                if (ord > 1) {
                    termName = termName + "^" + Integer.toString(ord);
                }
                if (!type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) || !obj.getType().equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) continue;
                type = XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
            }
            this.init(termName, type, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG, true, 0);
        }

        public int find(ColumnInformationObject variable) {
            if (this.m_variables == null) {
                return this.getText().equals(variable.getText()) ? 0 : -1;
            }
            String name = variable.getText();
            for (int i = 0; i < this.m_variables.length; ++i) {
                if (!name.equals(this.m_variables[i].getText())) continue;
                return i;
            }
            return -1;
        }

        public boolean contains(ColumnInformationObject variable) {
            return this.find(variable) >= 0;
        }

        public boolean contains(ModelTerm term) {
            if (term.order() > this.order()) {
                return false;
            }
            if (term.size() > this.size()) {
                return false;
            }
            ColumnInformationObject[] vars = term.getTermVariables();
            int[] ord = term.getTermVariablesOrder();
            int[] myord = this.getTermVariablesOrder();
            for (int i = 0; i < vars.length; ++i) {
                int j = this.find(vars[i]);
                if (j < 0) {
                    return false;
                }
                if (myord[j] >= ord[i]) continue;
                return false;
            }
            return true;
        }

        public int order() {
            if (this.m_variables == null) {
                return this.getText().length() > 0 ? 1 : 0;
            }
            int ord = 0;
            for (int i = 0; i < this.m_order.length; ++i) {
                ord += this.m_order[i];
            }
            return ord;
        }

        public int size() {
            if (this.m_variables == null) {
                return this.getText().length() > 0 ? 1 : 0;
            }
            return this.m_variables.length;
        }

        public ColumnInformationObject[] getTermVariables() {
            if (this.m_variables == null) {
                return new ColumnInformationObject[]{this};
            }
            return this.m_variables;
        }

        public int[] getTermVariablesOrder() {
            if (this.m_order == null) {
                return new int[]{1};
            }
            return this.m_order;
        }

        public boolean equals(ModelTerm term) {
            int n = term.size();
            if (this.size() != n) {
                return false;
            }
            if (this.order() != term.order()) {
                return false;
            }
            if (this.m_variables == null) {
                if (n > 1) {
                    return false;
                }
                return this.getText().equals(term.getText());
            }
            int[] ord = term.getTermVariablesOrder();
            for (int i = 0; i < n; ++i) {
                int k = term.find(this.m_variables[i]);
                if (k < 0) {
                    return false;
                }
                if (ord[k] == this.m_order[i]) continue;
                return false;
            }
            return true;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof ModelTerm)) {
                return 1;
            }
            return this.compareTo((ModelTerm)obj);
        }

        public int compareTo(ModelTerm obj) {
            int size;
            int myorder = this.order();
            int order = obj.order();
            if (myorder <= 1) {
                return super.compareTo(obj);
            }
            if (myorder != order) {
                return myorder - order;
            }
            int mysize = this.size();
            if (mysize != (size = obj.size())) {
                return mysize - size;
            }
            ColumnInformationObject[] vars = obj.getTermVariables();
            int k = 0;
            for (int i = 0; i < mysize && k == 0; ++i) {
                k = this.m_variables[i].compareTo(vars[i]);
            }
            return k;
        }
    }

    public static class ColumnInformationObject
    implements Transferable,
    Serializable,
    Comparable {
        private String columnName;
        private String dataType;
        private String role;
        private boolean interactionsFlag;
        private Integer index;
        private ImageIcon icon;
        private final DataFlavor[] flavors = new DataFlavor[]{ColumnInformationFlavor};

        public ColumnInformationObject() {
        }

        public ColumnInformationObject(String columnName, String dataType, String role, boolean interactionsFlag, int index) {
            this.init(columnName, dataType, role, interactionsFlag, index);
        }

        public void init(String columnName, String dataType, String role, boolean interactionsFlag, int index) {
            this.columnName = columnName;
            this.dataType = dataType;
            this.role = role;
            this.interactionsFlag = interactionsFlag;
            this.index = new Integer(index);
            this.icon = dataType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) ? (role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("categorical_independent.gif") : (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("categorical_dependent.gif") : MinerApp.getResourceManager().getIcon("categorical.gif"))) : (dataType.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG) ? (role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("continuous_independent.gif") : (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("continuous_dependent.gif") : MinerApp.getResourceManager().getIcon("continuous.gif"))) : (dataType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) ? (role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("string_independent.gif") : (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("string_dependent.gif") : MinerApp.getResourceManager().getIcon("string.gif"))) : (dataType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) ? (role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("dateTime_independent.gif") : (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("dateTime_dependent.gif") : MinerApp.getResourceManager().getIcon("dateTime.gif"))) : (role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("empty_independent.gif") : (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) ? MinerApp.getResourceManager().getIcon("empty_dependent.gif") : MinerApp.getResourceManager().getIcon("empty.gif"))))));
        }

        public boolean isInteraction() {
            return this.interactionsFlag;
        }

        public String getText() {
            return this.columnName;
        }

        public String getType() {
            return this.dataType;
        }

        public String getRole() {
            return this.role;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setIcon(ImageIcon icon) {
            this.icon = icon;
        }

        public Integer getIndex() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnInformationObject) {
                String compareString = ((ColumnInformationObject)obj).getText();
                return this.columnName.equals(compareString);
            }
            return false;
        }

        public int order() {
            return 1;
        }

        public int size() {
            return 1;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof ColumnInformationObject)) {
                return 0;
            }
            return this.compareTo((ColumnInformationObject)obj);
        }

        public int compareTo(ColumnInformationObject obj) {
            if (obj.order() > 1) {
                return -1;
            }
            if (obj.size() > 1) {
                return -1;
            }
            return this.index.compareTo(obj.getIndex());
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(ColumnInformationFlavor)) {
                return this;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(ColumnInformationFlavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }
    }

    public static class DialogException
    extends Exception {
        public DialogException() {
            this(MinerApp.getText("NodeDialog_dialogCannotBeSaved"));
        }

        public DialogException(String errorMessage) {
            super(errorMessage);
        }
    }

    protected static class DialogTable
    extends JTable {
        public DialogTable() {
            this.setTableHeader(new NonClearingTableHeader(this.getColumnModel()));
            NodeDialog.addKeyboardNavigation(this);
        }

        public DialogTable(TableModel dm) {
            super(dm);
            this.setTableHeader(new NonClearingTableHeader(this.getColumnModel()));
            NodeDialog.addKeyboardNavigation(this);
        }

        protected void paintComponent(Graphics g) {
            if (this.getParent() != null) {
                Rectangle clip = g.getClipBounds();
                g.setColor(this.getParent().getBackground());
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
            }
            super.paintComponent(g);
        }

        class NonClearingTableHeader
        extends JTableHeader {
            public NonClearingTableHeader() {
            }

            public NonClearingTableHeader(TableColumnModel tcm) {
                super(tcm);
            }

            public void columnMarginChanged(ChangeEvent e) {
                if (DialogTable.this.isEditing()) {
                    DialogTable.this.getCellEditor().stopCellEditing();
                }
                super.columnMarginChanged(e);
            }
        }
    }

    protected static class InputAllDoubleDoc
    extends PlainDocument {
        protected InputAllDoubleDoc() {
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            try {
                String pre = this.getText(0, offset);
                String post = this.getText(offset, this.getLength() - offset);
                String full = pre + s + post;
                if (!full.startsWith(XTNetwork.PARAMETER_DELIMITER)) {
                    Double.parseDouble(full + "1");
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            super.insertString(offset, s, attributeSet);
        }
    }

    protected static class InputDoubleDoc
    extends PlainDocument {
        protected InputDoubleDoc() {
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            try {
                String pre = this.getText(0, offset);
                String post = this.getText(offset, this.getLength() - offset);
                String full = pre + s + post;
                if (!full.startsWith(XTNetwork.PARAMETER_DELIMITER)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (Double.parseDouble(stringBuilder.append(full).append("1").toString()) < 0.0) {
                        return;
                    }
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            super.insertString(offset, s, attributeSet);
        }
    }

    protected static class InputPositiveIntegerDoc
    extends PlainDocument {
        protected InputPositiveIntegerDoc() {
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() == 0 && s.equals("0")) {
                return;
            }
            try {
                String pre = this.getText(0, offset);
                String post = this.getText(offset, this.getLength() - offset);
                String full = pre + s + post;
                if (!full.startsWith(XTNetwork.PARAMETER_DELIMITER)) {
                    int eIndex = full.indexOf(101);
                    if (eIndex == -1) {
                        eIndex = full.indexOf(69);
                    }
                    if (eIndex != -1) {
                        String longPart = full.substring(0, eIndex);
                        Long.parseLong(longPart);
                        Double.parseDouble(full + "1");
                    } else {
                        Long.parseLong(s);
                    }
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            super.insertString(offset, s, attributeSet);
        }
    }

    protected static class InputIntegerDoc
    extends PlainDocument {
        protected InputIntegerDoc() {
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            try {
                String pre = this.getText(0, offset);
                String post = this.getText(offset, this.getLength() - offset);
                String full = pre + s + post;
                if (!full.startsWith(XTNetwork.PARAMETER_DELIMITER)) {
                    int eIndex = full.indexOf(101);
                    if (eIndex == -1) {
                        eIndex = full.indexOf(69);
                    }
                    if (eIndex != -1) {
                        String longPart = full.substring(0, eIndex);
                        Long.parseLong(longPart);
                        Double.parseDouble(full + "1");
                    } else {
                        Long.parseLong(s);
                    }
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            super.insertString(offset, s, attributeSet);
        }
    }

    protected static class InputSingleCharDoc
    extends PlainDocument {
        protected InputSingleCharDoc() {
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            String text = this.getText(0, offset);
            if (!text.startsWith(XTNetwork.PARAMETER_DELIMITER) && text.length() > 0) {
                return;
            }
            super.insertString(offset, s, attributeSet);
        }
    }

    protected static class RandomSeedPanel
    extends JPanel {
        private long randomSeed = 0L;
        private JRadioButton[] m_randomSeedButtons;
        private JButton m_generateSeedButton;
        private JTextField m_newSeedTextField;

        public void setSeed(long seed) {
            this.m_newSeedTextField.setText(Long.toString(seed));
        }

        public long getSeed() throws DialogException {
            long val = 5L;
            try {
                val = Long.parseLong(this.m_newSeedTextField.getText());
            }
            catch (Exception e) {
                throw new DialogException("Seed must be a valid number.");
            }
            return val;
        }

        public void setEnterSeed(boolean enter) {
            int buttonToClick = enter ? 1 : 0;
            this.m_randomSeedButtons[buttonToClick].setSelected(true);
            this.m_randomSeedButtons[buttonToClick].doClick();
        }

        public boolean getEnterSeed() {
            return this.m_randomSeedButtons[1].isSelected();
        }

        public void restoreProperties(XTProps props) {
            String randomSeedString = props.getValue(NodeDialog.RANDOM_SEED_ATTRIBUTE_TAG, NodeDialog.NEW_SEED_ATTRIBUTE_TAG);
            boolean enterSeed = randomSeedString.equals(NodeDialog.ENTER_SEED_ATTRIBUTE_TAG);
            this.setEnterSeed(enterSeed);
            long val = 5L;
            try {
                String seedString = props.getValue(NodeDialog.RANDOM_SEED_VALUE_ATTRIBUTE_TAG, "5");
                val = Long.parseLong(seedString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            this.setSeed(val);
        }

        public void saveProperties(XTProps props) throws DialogException {
            props.set(NodeDialog.RANDOM_SEED_ATTRIBUTE_TAG, this.getEnterSeed() ? NodeDialog.ENTER_SEED_ATTRIBUTE_TAG : NodeDialog.NEW_SEED_ATTRIBUTE_TAG);
            props.set(NodeDialog.RANDOM_SEED_VALUE_ATTRIBUTE_TAG, Long.toString(this.getSeed()));
        }

        public void setEnabled(boolean bool) {
            this.m_randomSeedButtons[0].setEnabled(bool);
            this.m_randomSeedButtons[1].setEnabled(bool);
            this.m_generateSeedButton.setEnabled(bool);
            this.m_newSeedTextField.setEnabled(bool);
            this.m_newSeedTextField.setEditable(bool);
            if (bool) {
                if (this.m_randomSeedButtons[0].isSelected()) {
                    this.m_randomSeedButtons[0].doClick();
                } else {
                    this.m_randomSeedButtons[1].doClick();
                }
            }
        }

        public RandomSeedPanel(boolean border) {
            super(new GridBagLayout());
            if (border) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SampleRowsDialog_randomSeed")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            }
            ButtonGroup randomSeedGroup = new ButtonGroup();
            this.m_randomSeedButtons = new JRadioButton[2];
            JRadioButton newSeedRadioButton = new JRadioButton(new AbstractAction(MinerApp.getText("SampleRowsDialog_newSeedEveryTime") + ":"){

                public void actionPerformed(ActionEvent e) {
                    RandomSeedPanel.this.m_generateSeedButton.setEnabled(false);
                    RandomSeedPanel.this.m_newSeedTextField.setEnabled(false);
                    RandomSeedPanel.this.m_newSeedTextField.setEditable(false);
                }
            });
            newSeedRadioButton.setMnemonic('n');
            this.m_randomSeedButtons[0] = newSeedRadioButton;
            randomSeedGroup.add(newSeedRadioButton);
            Dimension buttonSize = new Dimension(100, 21);
            this.m_newSeedTextField = new JTextField(11);
            this.m_newSeedTextField.setMinimumSize(buttonSize);
            this.m_newSeedTextField.setPreferredSize(buttonSize);
            this.m_newSeedTextField.setDocument(new InputIntegerDoc());
            JRadioButton enterSeedRadioButton = new JRadioButton(new AbstractAction(MinerApp.getText("SampleRowsDialog_enterSeed") + ":"){

                public void actionPerformed(ActionEvent e) {
                    RandomSeedPanel.this.m_generateSeedButton.setEnabled(true);
                    RandomSeedPanel.this.m_newSeedTextField.setEnabled(true);
                    RandomSeedPanel.this.m_newSeedTextField.setEditable(true);
                }
            });
            enterSeedRadioButton.setMnemonic('e');
            randomSeedGroup.add(enterSeedRadioButton);
            this.m_randomSeedButtons[1] = enterSeedRadioButton;
            this.m_generateSeedButton = new JButton(new AbstractAction(MinerApp.getText("SampleRowsDialog_generateSeed")){

                public void actionPerformed(ActionEvent e) {
                    RandomSeedPanel.this.m_newSeedTextField.setText(String.valueOf((int)(System.currentTimeMillis() & 0xFFFFL)));
                }
            });
            this.m_generateSeedButton.setMnemonic('g');
            this.m_generateSeedButton.setPreferredSize(this.m_newSeedTextField.getPreferredSize());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            this.add((Component)newSeedRadioButton, constraints);
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(0, 15, 0, 0);
            this.add((Component)this.m_generateSeedButton, constraints);
            constraints.gridy = 1;
            constraints.gridx = 0;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)enterSeedRadioButton, constraints);
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(0, 15, 0, 0);
            this.add((Component)this.m_newSeedTextField, constraints);
        }
    }

    protected static class ExistingColumnInformationPanel
    extends JPanel {
        private DialogTable existVarTable;
        private ExistTableModel existVarTableModel;
        private TableSorter existSortingModel;
        private int existVarMapping = 0;
        static final int NONE_VARMAP = 0;
        static final int EXPRESSION_LANG_VARMAP = 1;
        static final int SPLUS_VARMAP = 2;
        final String alphaChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        final String digitChars = "0123456789";
        final String exprLangChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789._";
        final String splusChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.";

        public ExistingColumnInformationPanel() {
            this(true, 400, 100);
        }

        public ExistingColumnInformationPanel(boolean border, int width, int height) {
            this(border, width, height, 1);
        }

        public ExistingColumnInformationPanel(boolean border, int width, int height, int varMapping) {
            super(new GridBagLayout());
            this.existVarMapping = varMapping;
            int columnWidth = width / 3;
            this.existVarTableModel = new ExistTableModel();
            this.existVarTableModel.setColumnIdentifiers(new Object[]{MinerApp.getText("NodeDialog_name"), MinerApp.getText("NodeDialog_type"), MinerApp.getText("NodeDialog_role")});
            this.existSortingModel = new TableSorter(this.existVarTableModel);
            this.existVarTable = new DialogTable(this.existSortingModel);
            this.existSortingModel.addMouseListenerToHeaderInTable(this.existVarTable);
            this.existVarTable.getTableHeader().setReorderingAllowed(false);
            this.existVarTable.setRowSelectionAllowed(true);
            this.existVarTable.setRowHeight(25);
            JScrollPane scrollingExistVarTable = new JScrollPane(this.existVarTable);
            scrollingExistVarTable.setPreferredSize(new Dimension(width, height));
            int columnCount = this.existVarTableModel.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                TableColumn column = this.existVarTable.getColumnModel().getColumn(i);
                column.setPreferredWidth(columnWidth);
                if (i == 0) continue;
                column.setCellRenderer(new IconCellRenderer());
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            String inputVars = MinerApp.getText("NodeDialog_inputVariables");
            if (border) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(inputVars), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            } else {
                JPanel labelPanel = new JPanel();
                labelPanel.setLayout(new BoxLayout(labelPanel, 0));
                labelPanel.add(new JLabel(inputVars + ":"));
                labelPanel.add(Box.createGlue());
                constraints.insets = new Insets(0, 0, 5, 0);
                constraints.fill = 2;
                this.add((Component)labelPanel, constraints);
                constraints.gridy = 1;
            }
            constraints.weighty = 1.0;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.fill = 1;
            this.add((Component)scrollingExistVarTable, constraints);
        }

        public boolean allGoodChars(String str, String goodChars) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (goodChars.indexOf(str.charAt(i)) >= 0) continue;
                return false;
            }
            return true;
        }

        public String getMappedColumnName(String str) {
            switch (this.existVarMapping) {
                case 1: {
                    if (str.length() >= 1 && !this.allGoodChars(str.substring(0, 1), "0123456789") && this.allGoodChars(str, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789._")) break;
                    str = "get(\"" + str + "\")";
                    break;
                }
                case 2: {
                    if (str.length() < 1) {
                        str = "X1";
                    }
                    if (this.allGoodChars(str.substring(0, 1), "0123456789")) {
                        str = "X" + str;
                    }
                    if (this.allGoodChars(str, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.")) break;
                    StringBuffer buf = new StringBuffer(str);
                    for (int i = 0; i < buf.length(); ++i) {
                        if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.".indexOf(buf.charAt(i)) >= 0) continue;
                        buf.setCharAt(i, '.');
                    }
                    str = buf.toString();
                }
            }
            return str;
        }

        public void restoreProperties(XTMetaData md) {
            this.existVarTableModel.clearTable();
            Vector inputNames = md.getColumnNames();
            for (int colNum = 0; colNum < inputNames.size(); ++colNum) {
                String columnName = (String)inputNames.get(colNum);
                String mappedColumnName = this.getMappedColumnName(columnName);
                String columnType = md.getColumnType(columnName);
                if (md.isBlobColumn(columnName)) {
                    columnType = CNKBlobClassHandler.getDisplayClassName(md.getBlobDataFieldClassName(columnName));
                }
                String columnRole = md.getColumnRole(columnName);
                Object[] row = new Object[]{mappedColumnName, columnType, columnRole};
                this.existVarTableModel.addRow(row);
            }
        }

        private Object getIcon(String value) {
            return ModifyColumnsPanel.getIconForString(value);
        }

        private class IconCellRenderer
        extends GeneralRenderer {
            private IconCellRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int col) {
                if (value == null) {
                    return null;
                }
                if (value instanceof String) {
                    Object obj = ExistingColumnInformationPanel.this.getIcon((String)value);
                    return super.getTableCellRendererComponent(table, obj, isSel, hasFocus, row, col);
                }
                return super.getTableCellRendererComponent(table, value, isSel, hasFocus, row, col);
            }
        }

        private class ExistTableModel
        extends DefaultTableModel {
            private ExistTableModel() {
            }

            public void clearTable() {
                this.dataVector.removeAllElements();
                this.fireTableDataChanged();
            }

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        }
    }

    private class ResetAfterApplyThread
    extends Thread {
        boolean m_option = false;

        public ResetAfterApplyThread(boolean option) {
            this.m_option = option;
        }

        public void run() {
            while (MinerApp.isRunning()) {
                try {
                    Thread.yield();
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            MinerApp.getGlobalOptions().set("runToHereShowViewer", this.m_option);
            NodeDialog.this.getApplyButton().setEnabled(true);
            NodeDialog.this.getAddButton().setEnabled(true);
            NodeDialog.this.getOKButton().setEnabled(true);
            NodeDialog.this.getCancelButton().setEnabled(true);
            if (!NodeDialog.this.getNodeModel().getState().equals(ActivityNodeComputed.instance())) {
                AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), "An error occurred during Apply.\nSee the message pane for details.", "Error During Apply", 0);
            }
            MinerApp.getMainFrame().getRootPane().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private static class KeyboardTableNavigator
    extends KeyAdapter {
        private JTable table;

        public KeyboardTableNavigator(JTable t) {
            t.setCellSelectionEnabled(true);
            t.setRowSelectionAllowed(true);
            t.setColumnSelectionAllowed(true);
            this.table = t;
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                int col = this.table.getSelectedColumn();
                int row = this.table.getSelectedRow();
                if (col != this.table.getEditingColumn() || row != this.table.getEditingRow()) {
                    this.table.editCellAt(row, col, new EventObject(this.table));
                    Component eComp = this.table.getEditorComponent();
                    if (eComp != null) {
                        eComp.requestFocusInWindow();
                        this.table.updateUI();
                        e.consume();
                    }
                }
            }
        }
    }
}

