/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.ClassificationAssessmentEngineNode;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class RegressionAgreementEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String REGRESSION_AGREEMENT_CACHE = "agreement.cache";
    public static String MEAN_SQUARED_ERROR = "meanSquaredError";
    public static String MEAN_ABSOLUTE_ERROR = "meanAbsoluteError";
    public static String RELATIVE_SQUARED_ERROR = "relativeSquaredError";
    public static String FITTED_ATTRIBUTE_TAG = "fitted";
    private int m_numInputs = 0;
    private long[] m_rowCount = null;
    private double[] m_meanDepVal = null;
    private double[] m_meanSquareTotal = null;
    private double[] m_meanAbsoluteTotal = null;
    private double[] m_relativeSquareDenom = null;
    private int[] m_observedDepColumnNums = null;
    private int[] m_predictedColumnNums = null;
    private boolean[] m_residualsUsed = null;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        try {
            this.m_numInputs = this.getNumInputs();
            this.m_rowCount = new long[this.m_numInputs];
            this.m_meanDepVal = new double[this.m_numInputs];
            this.m_meanSquareTotal = new double[this.m_numInputs];
            this.m_meanAbsoluteTotal = new double[this.m_numInputs];
            this.m_relativeSquareDenom = new double[this.m_numInputs];
            this.m_observedDepColumnNums = new int[this.m_numInputs];
            this.m_predictedColumnNums = new int[this.m_numInputs];
            this.m_residualsUsed = new boolean[this.m_numInputs];
            String[] path = new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG, "", ""};
            XTProps props = this.getNodeProperties();
            Vector inputs = props.getSubProperties(ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG);
            for (int i = inputs.size(); i < this.m_numInputs; ++i) {
                inputs.add("NoData");
            }
            for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
                String inputNodeName = this.getInputNodeName(inputNum);
                String inputNodeID = (String)inputs.get(inputNum);
                XTMetaData md = this.getInputMetaData(inputNum);
                path[1] = inputNodeID;
                path[2] = ClassificationAssessmentEngineNode.USE_ROLE_INFO_ATTRIBUTE_TAG;
                boolean useRoles = props.getBoolean(path, true);
                String depName = "";
                if (useRoles) {
                    Vector depColumns = md.getDataFieldsWithRole(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
                    if (depColumns == null || depColumns.size() == 0) {
                        this.printlnWarning(this.getNodeName() + ": the dependent column was not found in input from " + inputNodeName + ".");
                        this.m_observedDepColumnNums[inputNum] = -1;
                        continue;
                    }
                    depName = (String)depColumns.get(0);
                    this.m_observedDepColumnNums[inputNum] = md.nameToOrdinal(depName);
                    this.m_predictedColumnNums[inputNum] = md.nameToOrdinal("PREDICT.fit");
                    if (this.m_observedDepColumnNums[inputNum] == -1) {
                        this.printlnWarning(this.getNodeName() + ": the dependent column was not found in input from " + inputNodeName + ".");
                        continue;
                    }
                    if (this.m_predictedColumnNums[inputNum] == -1) {
                        this.m_predictedColumnNums[inputNum] = md.nameToOrdinal("PREDICT.residuals");
                        this.m_residualsUsed[inputNum] = true;
                        if (this.m_predictedColumnNums[inputNum] == -1) {
                            this.printlnWarning(this.getNodeName() + ": no fitted values or residuals found in input from " + inputNodeName + ".");
                            continue;
                        }
                    } else {
                        this.m_residualsUsed[inputNum] = false;
                    }
                    this.m_meanDepVal[inputNum] = md.getColumnMean(depName);
                } else {
                    path[2] = ClassificationAssessmentEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG;
                    depName = props.getValue(path);
                    this.m_observedDepColumnNums[inputNum] = md.nameToOrdinal(depName);
                    this.m_meanDepVal[inputNum] = md.getColumnMean(depName);
                    if (this.m_observedDepColumnNums[inputNum] == -1) {
                        this.printlnWarning(this.getNodeName() + ": the dependent column was not found in input from " + inputNodeName + ".");
                        continue;
                    }
                    path[2] = ClassificationAssessmentEngineNode.EVAL_COLUMN_ATTRIBUTE_TAG;
                    String evalColumn = props.getValue(path);
                    this.m_predictedColumnNums[inputNum] = md.nameToOrdinal(evalColumn);
                    if (this.m_predictedColumnNums[inputNum] == -1) {
                        this.printlnWarning(this.getNodeName() + ": no fitted values or residuals found in input from " + inputNodeName + ".");
                        continue;
                    }
                    path[2] = FITTED_ATTRIBUTE_TAG;
                    this.m_residualsUsed[inputNum] = !props.getBoolean(path, false);
                }
                this.m_rowCount[inputNum] = md.getNumRows();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        boolean results = false;
        for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
            if (this.m_predictedColumnNums[inputNum] == -1 || this.m_observedDepColumnNums[inputNum] == -1) continue;
            results = true;
            double[] observed = proc.getChunkInputColumnData(inputNum, this.m_observedDepColumnNums[inputNum]);
            double[] predicted = proc.getChunkInputColumnData(inputNum, this.m_predictedColumnNums[inputNum]);
            int totalRows = proc.getChunkInputRows(inputNum);
            for (int rowNum = 0; rowNum < totalRows; ++rowNum) {
                double obs = observed[rowNum];
                double pred = predicted[rowNum];
                if (Double.isNaN(obs) || Double.isNaN(pred)) {
                    int n = inputNum;
                    this.m_rowCount[n] = this.m_rowCount[n] - 1L;
                    continue;
                }
                if (this.m_residualsUsed[inputNum]) {
                    pred = obs - pred;
                }
                int n = inputNum;
                this.m_meanSquareTotal[n] = this.m_meanSquareTotal[n] + (pred - obs) * (pred - obs);
                int n2 = inputNum;
                this.m_meanAbsoluteTotal[n2] = this.m_meanAbsoluteTotal[n2] + Math.abs(pred - obs);
                int n3 = inputNum;
                this.m_relativeSquareDenom[n3] = this.m_relativeSquareDenom[n3] + (obs - this.m_meanDepVal[inputNum]) * (obs - this.m_meanDepVal[inputNum]);
            }
        }
        if (proc.getChunkInputPosition(0) == 0L && !results) {
            proc.setError("no regression data was found in input.");
        }
    }

    public void procExtractResults(CNKProc proc) {
        try {
            XTProps props = new XTProps();
            for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
                String inputNumStr = ClassificationAssessmentEngineNode.INPUT_PREFIX_TAG + Integer.toString(inputNum);
                if (this.m_predictedColumnNums[inputNum] == -1 || this.m_observedDepColumnNums[inputNum] == -1) {
                    props.set(inputNumStr, "");
                    continue;
                }
                props.set(inputNumStr, ClassificationAssessmentEngineNode.TITLE_ATTRIBUTE_TAG, this.getInputNodeName(inputNum));
                String[] path = new String[]{inputNumStr, MEAN_SQUARED_ERROR};
                double val = this.m_meanSquareTotal[inputNum] / (double)this.m_rowCount[inputNum];
                props.set(path, Double.toString(val));
                path[1] = MEAN_ABSOLUTE_ERROR;
                val = this.m_meanAbsoluteTotal[inputNum] / (double)this.m_rowCount[inputNum];
                props.set(path, Double.toString(val));
                path[1] = RELATIVE_SQUARED_ERROR;
                val = this.m_meanSquareTotal[inputNum] / this.m_relativeSquareDenom[inputNum];
                props.set(path, Double.toString(val));
            }
            this.setNodeCache(REGRESSION_AGREEMENT_CACHE, props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

