/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcTree;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.model.TreeCollection;
import com.insightful.miner.tree.model.TreePredictor;
import java.io.File;
import java.util.Vector;

public class RegressionTreeEngineNode
extends EngineNode {
    private String m_xmlFileName = null;
    private boolean m_xmlFileOK = false;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public void procExtractResults(CNKProc proc) {
        if (proc instanceof CNKProcTree) {
            if (this.m_xmlFileName == null) {
                return;
            }
            this.setNodeCache("model", null);
            File fil = new File(this.m_xmlFileName);
            if (!fil.exists()) {
                this.printlnDebug("tree xml file " + this.m_xmlFileName + " doesn't exist");
                return;
            }
            long totalBytes = fil.length();
            this.printlnInformation("reading tree model xml file " + this.m_xmlFileName + " (" + totalBytes + " bytes)");
            XMLTree xt = null;
            try {
                xt = XMLTree.readFromFile(this.m_xmlFileName);
                this.m_xmlFileOK = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.printlnError("error reading tree model xml file " + this.m_xmlFileName + ": " + ex);
            }
            this.setNodeCache("model", xt);
        }
    }

    public void procDelete(CNKProc proc) {
        if (proc instanceof CNKProcTree && this.m_xmlFileName != null) {
            File fl = new File(this.m_xmlFileName);
            if (fl.exists()) {
                this.printlnDebug("deleting tree model xml file " + this.m_xmlFileName);
                fl.delete();
            } else {
                this.printlnDebug("deleting tree model xml file " + this.m_xmlFileName + " (non-existant)");
            }
        }
        if (proc != null) {
            proc.destroyCNKObj();
        }
    }

    public Vector getOutputSpecs() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depVar = this.getDepVar(props, md);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        Vector outputSpecs = PredictEngineNode.getOutputSpecs(md, props, depVar, indepVars);
        return outputSpecs;
    }

    public boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        return this.executeTreeProc(false);
    }

    public String getDataDictionaryAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        Vector varNames = PredictEngineNode.getIndependentVars(props, md);
        String depCol = this.getDepVar(props, md);
        Vector allNames = varNames;
        allNames.add(depCol);
        String weights = props.getValue("weightedColumn");
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            allNames.add(weights);
        }
        XTMetaData mdModel = md.selectiveClone(allNames);
        for (int i = 0; i < varNames.size(); ++i) {
            mdModel.setDataFieldRole((String)varNames.get(i), "independent");
        }
        mdModel.setDataFieldRole(depCol, "dependent");
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            mdModel.setDataFieldRole(weights, "weights");
        }
        return mdModel.writeToString();
    }

    protected String getDepVar(XTProps props, XTMetaData md) {
        return PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
    }

    public boolean executeTreeProc(boolean doClassification) throws Exception {
        XTMetaData md;
        boolean ok = true;
        XTProps props = this.getNodeProperties();
        String depVar = this.getDepVar(props, md = this.getInputMetaData(0));
        if (depVar == null) {
            throw new Exception("can't create tree: no dependent variable");
        }
        String depVarType = this.getInputMetaData(0).getColumnType(depVar);
        if (doClassification && !XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG.equals(depVarType)) {
            throw new Exception("can't create classification tree: dependent variable " + depVar + " not categorical!");
        }
        if (!doClassification && !XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG.equals(depVarType)) {
            throw new Exception("can't create regression tree: dependent variable " + depVar + " not continuous!");
        }
        this.setNodeCache("model", null);
        String modelXML = this.getDataDictionaryAsString();
        File tempFile = this.createWorkspaceTempFile("tree", ".xml");
        this.m_xmlFileName = tempFile.getPath();
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Building model...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        CNKProcTree proc1 = new CNKProcTree();
        int minSize = props.getInt("min.size", 10);
        int minCut = props.getInt("min.cut", 5);
        int nMax = props.getInt("max.rows", 0);
        double minDev = props.getDouble("min.dev", 0.01);
        proc1.setTreeProperties(modelXML, minSize, minCut, nMax, minDev);
        proc1.setFile(this.m_xmlFileName);
        this.printlnVerbose("creating tree model");
        this.m_xmlFileOK = false;
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc1);
        this.procDelete(proc1);
        if (!ok || !this.m_xmlFileOK) {
            return false;
        }
        Vector outputSpecs = this.getOutputSpecs();
        PredictEngineNode.isConflictingIO(outputSpecs, this);
        if (outputSpecs.size() < 1) {
            return ok;
        }
        str = origText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        XMLTree tree = this.getNodeCache("model");
        if (tree == null) {
            this.printlnError("no tree model for prediction!");
            return false;
        }
        TreeCollection treeColl = new TreeCollection(tree, this.getInputMetaData(0), Integer.parseInt(this.getNodeID()), this.getNetworkManager().getWorksheetID());
        TreePredictor treePredictor = new TreePredictor(treeColl);
        treePredictor.setOutputSpecs(outputSpecs);
        treePredictor.initExecute();
        CNKProcJavaTransform proc2 = new CNKProcJavaTransform();
        proc2.setExecObject(treePredictor);
        this.printlnVerbose("generating prediction from training data.");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc2);
        this.procDelete(proc2);
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return ok;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        return null;
    }
}

