/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Random;
import java.util.Vector;

public class SampleRowsEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    protected int m_numColumns;
    private boolean[] m_useCopyData;
    private XTMetaData m_metaData;
    private String m_sampleMethod;
    private long[] m_numToDraw;
    private long m_numTotal;
    private long m_curRowNum;
    private long[] m_curNumDrawn;
    private Random m_random;
    private boolean m_lastChunkFinished;
    private boolean m_firstTime;
    private String m_stratifiedType;
    private int m_stratifiedColumn;
    private int[] m_numCopies;
    private long[] m_numPasses;
    private long[] m_totalLevelCount;
    private long[] m_curLevelCount;
    private long m_curRowSel;
    private long m_resumeCopy;
    private long m_resumeRow;
    private boolean m_oversampleWarning;
    public static String SAMPLE_METHOD_ATTRIBUTE_TAG = "samplingMethod";
    public static String SAMPLE_SIZE_ATTRIBUTE_TAG = "sampleSize";
    public static String PERCENTAGE_ATTRIBUTE_TAG = "percentage";
    public static String PERCENTAGE_SAMPLE_SIZE_ATTRIBUTE_TAG = "percentageSampleSize";
    public static String ROWS_SAMPLE_SIZE_ATTRIBUTE_TAG = "numRowsSampleSize";
    public static String STRATIFIED_ATTRIBUTE_TAG = "stratified";
    public static String STRATIFIED_SAMPLE_ATTRIBUTE_TAG = "stratifiedSampling";
    public static String STRATIFIED_COLUMN_ATTRIBUTE_TAG = "stratifiedColumn";
    public static String EQUAL_SIZE_ATTRIBUTE_TAG = "equalSize";
    public static String PROPORTIONAL_ATTRIBUTE_TAG = "proportional";
    public static String NUM_ROWS_ATTRIBUTE_TAG = "numRows";
    public static String SIMPLE_ATTRIBUTE_TAG = "simple";
    public static String EVERY_N_ROWS_ATTRIBUTE_TAG = "everyNRows";
    public static String FIRST_N_ROWS_ATTRIBUTE_TAG = "firstNRows";
    public static int PERCENTAGE_SAMPLE_SIZE_DEFAULT = 10;
    public static String ROWS_SAMPLE_SIZE_DEFAULT = "1000";
    public static String RANDOM_SEED_VALUE_DEFAULT = "5";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void procSetProperties(CNKProc proc) {
        int nlevels;
        Vector levels;
        String colName;
        long numToDraw;
        block18: {
            int i;
            block17: {
                block15: {
                    block16: {
                        this.m_firstTime = true;
                        this.m_metaData = this.getInputMetaData(0);
                        this.m_oversampleWarning = false;
                        this.m_lastChunkFinished = true;
                        this.m_numTotal = this.m_metaData.getNumRows();
                        this.m_curRowNum = 0L;
                        this.m_numColumns = this.m_metaData.getNumColumns();
                        this.m_useCopyData = new boolean[this.m_numColumns];
                        for (int col = 0; col < this.m_numColumns; ++col) {
                            this.m_useCopyData[col] = this.m_metaData.isStringColumn(col) || this.m_metaData.isBlobColumn(col) || this.m_metaData.isDateTimeColumn(col);
                        }
                        XTProps props = this.getNodeProperties();
                        this.m_sampleMethod = props.getValue(SAMPLE_METHOD_ATTRIBUTE_TAG, SIMPLE_ATTRIBUTE_TAG);
                        this.m_random = this.getRandomGenerator();
                        String type = props.getValue(SAMPLE_SIZE_ATTRIBUTE_TAG, PERCENTAGE_ATTRIBUTE_TAG);
                        if (type.equals(PERCENTAGE_ATTRIBUTE_TAG) || type.length() == 0) {
                            String pct = props.getValue(PERCENTAGE_SAMPLE_SIZE_ATTRIBUTE_TAG, "10");
                            numToDraw = (long)Math.ceil((double)this.m_numTotal * (Double.parseDouble(pct) / 100.0));
                        } else {
                            numToDraw = Long.parseLong(props.getValue(ROWS_SAMPLE_SIZE_ATTRIBUTE_TAG, "1000"));
                        }
                        if (numToDraw > this.m_numTotal) {
                            this.printlnWarning("Cannot sample " + numToDraw + " rows from the " + this.m_numTotal + " available rows.  Sampling " + this.m_numTotal + " rows.");
                            numToDraw = this.m_numTotal;
                        }
                        if (numToDraw == 0L) {
                            this.m_sampleMethod = SIMPLE_ATTRIBUTE_TAG;
                        }
                        if (!this.m_sampleMethod.equals(STRATIFIED_ATTRIBUTE_TAG)) break block15;
                        this.m_stratifiedType = props.getValue(STRATIFIED_SAMPLE_ATTRIBUTE_TAG, "");
                        colName = props.getValue(STRATIFIED_COLUMN_ATTRIBUTE_TAG);
                        this.m_stratifiedColumn = this.m_metaData.nameToOrdinal(colName);
                        levels = this.m_metaData.getCategoricalDataFieldLevels(colName);
                        nlevels = levels.size();
                        this.m_numToDraw = new long[nlevels];
                        this.m_curNumDrawn = new long[nlevels];
                        this.m_totalLevelCount = new long[nlevels];
                        this.m_curLevelCount = new long[nlevels];
                        this.m_numPasses = new long[nlevels];
                        if (!this.m_stratifiedType.equals(EQUAL_SIZE_ATTRIBUTE_TAG)) break block16;
                        long equalCounts = numToDraw / (long)nlevels;
                        for (i = 0; i < nlevels; ++i) {
                            this.m_totalLevelCount[i] = Long.parseLong(this.m_metaData.getLevelCount(colName, (String)levels.get(i)));
                            this.m_numToDraw[i] = equalCounts;
                            this.m_curNumDrawn[i] = 0L;
                            this.m_curLevelCount[i] = 0L;
                        }
                        if (equalCounts * (long)nlevels != numToDraw) {
                            int index = 0;
                            for (int amountToAllocate = (int)(numToDraw - equalCounts * (long)nlevels); amountToAllocate > 0; --amountToAllocate) {
                                int n = index;
                                this.m_numToDraw[n] = this.m_numToDraw[n] + 1L;
                                index = (index + 1) % nlevels;
                            }
                        }
                        break block17;
                    }
                    if (!this.m_stratifiedType.equals(PROPORTIONAL_ATTRIBUTE_TAG)) {
                        if (!this.m_stratifiedType.equals(NUM_ROWS_ATTRIBUTE_TAG)) return;
                        return;
                    }
                    break block18;
                }
                this.m_numToDraw = new long[1];
                this.m_numToDraw[0] = numToDraw;
                this.m_curNumDrawn = new long[1];
                this.m_curNumDrawn[0] = 0L;
                return;
            }
            i = 0;
            while (i < nlevels) {
                double passes;
                this.m_numPasses[i] = this.m_totalLevelCount[i] < this.m_numToDraw[i] ? (Math.floor(passes = (double)this.m_numToDraw[i] / (double)this.m_totalLevelCount[i]) < passes ? (long)((int)passes + 1) : (long)((int)passes)) : 1L;
                ++i;
            }
            return;
        }
        double[] percentages = new double[nlevels];
        int[] percentageRanks = new int[nlevels];
        double adjustedTotalCount = this.m_metaData.getColumnRowCount(colName);
        long proportionalSum = 0L;
        int i = 0;
        while (true) {
            if (i >= nlevels) break;
            this.m_totalLevelCount[i] = Long.parseLong(this.m_metaData.getLevelCount(colName, (String)levels.get(i)));
            percentages[i] = (double)this.m_totalLevelCount[i] / adjustedTotalCount;
            this.m_numToDraw[i] = (int)((double)numToDraw * percentages[i]);
            proportionalSum += this.m_numToDraw[i];
            this.m_curNumDrawn[i] = 0L;
            this.m_curLevelCount[i] = 0L;
            this.m_numPasses[i] = 1L;
            percentageRanks[i] = 0;
            for (int j = 0; j < i; ++j) {
                if (percentages[j] <= percentages[i]) {
                    int n = j;
                    percentageRanks[n] = percentageRanks[n] + 1;
                    continue;
                }
                int n = i;
                percentageRanks[n] = percentageRanks[n] + 1;
            }
            ++i;
        }
        if (proportionalSum == numToDraw) return;
        int rank = 0;
        int index = 0;
        while (proportionalSum < numToDraw) {
            for (index = 0; index < nlevels && percentageRanks[index] != rank; ++index) {
            }
            int n = index;
            this.m_numToDraw[n] = this.m_numToDraw[n] + 1L;
            ++proportionalSum;
            rank = (rank + 1) % nlevels;
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        boolean stratified = this.m_sampleMethod.equals(STRATIFIED_ATTRIBUTE_TAG);
        if (this.isDoneEarly() && !stratified) {
            proc.setChunkOutputReleaseRows(0, 0);
            proc.setChunkInputReleaseAll(0);
            return;
        }
        if (stratified) {
            this.executeStratifiedSample(proc);
            return;
        }
        int nrowBlock = proc.getChunkInputRows(0);
        boolean[] keepRow = new boolean[nrowBlock];
        int numKept = 0;
        if (this.m_sampleMethod.equals(SIMPLE_ATTRIBUTE_TAG)) {
            for (int i = 0; i < nrowBlock; ++i) {
                if (this.m_random.nextDouble() * (double)(this.m_numTotal - this.m_curRowNum) < (double)(this.m_numToDraw[0] - this.m_curNumDrawn[0])) {
                    keepRow[i] = true;
                    ++numKept;
                    this.m_curNumDrawn[0] = this.m_curNumDrawn[0] + 1L;
                }
                ++this.m_curRowNum;
            }
        } else if (this.m_sampleMethod.equals(EVERY_N_ROWS_ATTRIBUTE_TAG)) {
            long blockSize = this.m_numTotal / this.m_numToDraw[0];
            if (blockSize == 1L && this.m_curNumDrawn[0] == 0L) {
                String msg = "Every N Rows algorithm cannot be used for sampling greater than 50% (sampling " + Long.toString(this.m_numToDraw[0]) + " rows out of " + Long.toString(this.m_numTotal) + ").";
                proc.setError(msg);
            }
            if (this.m_firstTime) {
                double rndmDbl = this.m_random.nextDouble();
                this.m_curRowSel = (long)((double)blockSize * rndmDbl);
                this.m_firstTime = false;
            }
            for (int i = 0; i < nrowBlock; ++i) {
                long adjustedRowIndex = this.m_curRowNum % blockSize;
                if (adjustedRowIndex == this.m_curRowSel) {
                    keepRow[i] = true;
                    ++numKept;
                    this.m_curNumDrawn[0] = this.m_curNumDrawn[0] + 1L;
                }
                ++this.m_curRowNum;
            }
        } else if (this.m_sampleMethod.equals(FIRST_N_ROWS_ATTRIBUTE_TAG)) {
            for (int i = 0; i < nrowBlock; ++i) {
                if (this.m_curRowNum < this.m_numToDraw[0]) {
                    keepRow[i] = true;
                    ++numKept;
                    this.m_curNumDrawn[0] = this.m_curNumDrawn[0] + 1L;
                }
                ++this.m_curRowNum;
            }
        }
        this.outputResults(proc, keepRow);
        this.releaseOutputRows(proc, numKept);
    }

    public void executeStratifiedSample(CNKProcJavaTransform proc) {
        int startCopy;
        int startRow;
        int nrowBlock = proc.getChunkInputRows(0);
        if (this.m_lastChunkFinished) {
            this.m_numCopies = new int[nrowBlock];
            double[] inbuf = proc.getChunkInputColumnData(0, this.m_stratifiedColumn);
            for (int i = 0; i < nrowBlock; ++i) {
                if (Double.isNaN(inbuf[i])) continue;
                int levelIndex = (int)inbuf[i];
                long totalLevelsToBeVisited = this.m_totalLevelCount[levelIndex] * this.m_numPasses[levelIndex];
                int j = 0;
                while ((long)j < this.m_numPasses[levelIndex]) {
                    double randVal = this.m_random.nextDouble();
                    if (randVal * (double)(totalLevelsToBeVisited - this.m_curLevelCount[levelIndex]) < (double)(this.m_numToDraw[levelIndex] - this.m_curNumDrawn[levelIndex])) {
                        int n = i;
                        this.m_numCopies[n] = this.m_numCopies[n] + 1;
                        int n2 = levelIndex;
                        this.m_curNumDrawn[n2] = this.m_curNumDrawn[n2] + 1L;
                    }
                    int n = levelIndex;
                    this.m_curLevelCount[n] = this.m_curLevelCount[n] + 1L;
                    ++j;
                }
                if (this.m_oversampleWarning || this.m_numCopies[i] <= 1) continue;
                this.printlnInformation("Sampling with replacement is taking place to get the desired proportions.");
                this.m_oversampleWarning = true;
            }
        }
        int outIndex = 0;
        if (!this.m_lastChunkFinished) {
            startRow = (int)this.m_resumeRow;
            startCopy = (int)this.m_resumeCopy;
            this.m_lastChunkFinished = true;
        } else {
            startCopy = 0;
            startRow = 0;
        }
        int tempStorageForStartCopy = startCopy;
        double[] ibuf = null;
        double[] obuf = null;
        for (int i = 0; i < this.m_numColumns; ++i) {
            outIndex = 0;
            if (!this.m_useCopyData[i]) {
                ibuf = proc.getChunkInputColumnData(0, i);
                obuf = proc.getChunkOutputColumnData(0, i);
            }
            startCopy = tempStorageForStartCopy;
            for (int j = startRow; j < nrowBlock; ++j) {
                for (int k = startCopy; k < this.m_numCopies[j]; ++k) {
                    if (outIndex < nrowBlock) {
                        int colNum = i;
                        int inRow = j;
                        int outRow = outIndex;
                        if (this.m_useCopyData[i]) {
                            proc.copyColumnData(0, colNum, outRow, 0, colNum, inRow, 1);
                        } else {
                            obuf[outRow] = ibuf[inRow];
                        }
                        ++outIndex;
                        continue;
                    }
                    if (!this.m_lastChunkFinished) continue;
                    this.m_resumeRow = j;
                    this.m_resumeCopy = k;
                    this.m_lastChunkFinished = false;
                }
                startCopy = 0;
            }
        }
        if (!this.m_lastChunkFinished) {
            proc.setChunkInputReleaseRows(0, 0);
            proc.setChunkOutputReleaseRows(0, outIndex);
            return;
        }
        this.m_lastChunkFinished = true;
        proc.setChunkOutputReleaseRows(0, outIndex);
    }

    protected boolean isDoneEarly() {
        return this.m_numToDraw[0] != 0L && this.m_numToDraw[0] == this.m_curNumDrawn[0];
    }

    protected void releaseOutputRows(CNKProcJavaTransform proc, int numKept) {
        proc.setChunkOutputReleaseRows(0, numKept);
    }

    protected void outputResults(CNKProcJavaTransform proc, boolean[] keepRow) {
        int nrowBlock = proc.getChunkInputRows(0);
        double[] ibuf = null;
        double[] obuf = null;
        for (int i = 0; i < this.m_numColumns; ++i) {
            if (!this.m_useCopyData[i]) {
                obuf = proc.getChunkOutputColumnData(0, i);
                ibuf = proc.getChunkInputColumnData(0, i);
            }
            int outIndex = 0;
            for (int j = 0; j < nrowBlock; ++j) {
                if (!keepRow[j]) continue;
                int colNum = i;
                int inRow = j;
                int outRow = outIndex;
                if (this.m_useCopyData[i]) {
                    proc.copyColumnData(0, colNum, outRow, 0, colNum, inRow, 1);
                } else {
                    obuf[outRow] = ibuf[inRow];
                }
                ++outIndex;
            }
        }
    }
}

