/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.File;
import java.util.Vector;

public class SortEngineNode
extends EngineNode {
    public static String COLUMN_TO_SORT_ATTRIBUTE_TAG = "columnsToSort";
    public static String ASCENDING_ATTRIBUTE_TAG = "ascending";
    public static String NAN_ATTRIBUTE_TAG = "nAn";
    public static String ALPHABETICAL_ATTRIBUTE_TAG = "alphabeticalSort";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        File sortedFile;
        XTMetaData md = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        Vector columnNames = props.getSubProperties(new String[]{COLUMN_TO_SORT_ATTRIBUTE_TAG});
        int columnCount = columnNames.size();
        String[] sortColumnOrder = new String[columnCount];
        boolean[] sortAscending = new boolean[columnCount];
        boolean[] sortNAatTop = new boolean[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            sortColumnOrder[i] = (String)columnNames.get(i);
            String[] path = new String[]{COLUMN_TO_SORT_ATTRIBUTE_TAG, sortColumnOrder[i], ""};
            path[2] = ASCENDING_ATTRIBUTE_TAG;
            String test = props.getValue(path);
            sortAscending[i] = test.equals("true");
            path[2] = NAN_ATTRIBUTE_TAG;
            test = props.getValue(path);
            sortNAatTop[i] = test.equals("true");
        }
        boolean alphabetical = props.getBoolean(ALPHABETICAL_ATTRIBUTE_TAG, true);
        int rowChunkSize = this.getMaxRowsPerBlock();
        File unsortedFile = new File(this.getInputDataCacheFileName(0));
        boolean ok = SortAndShuffle.sort(unsortedFile, sortedFile = new File(this.getOutputDataCacheFileName(0)), md, (EngineNode)this, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, true);
        if (ok) {
            String inputBlobFile = this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), 0);
            String outputBlobFile = this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0);
            this.getNetworkManager().copyFile(inputBlobFile, outputBlobFile);
        }
        return ok;
    }
}

