/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.SortEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class UnivariateEngineNode
extends EngineNode {
    public static final String N_ATTRIBUTE_TAG = "n";
    public static final String NMISS_ATTRIBUTE_TAG = "nmiss";
    public static final String MIN_ATTRIBUTE_TAG = "min";
    public static final String MAX_ATTRIBUTE_TAG = "max";
    public static final String RANGE_ATTRIBUTE_TAG = "range";
    public static final String Q3_ATTRIBUTE_TAG = "q3";
    public static final String Q2_ATTRIBUTE_TAG = "median";
    public static final String Q1_ATTRIBUTE_TAG = "q1";
    public static final String Q_RANGE_ATTRIBUTE_TAG = "iqr";
    public static final String QUANTILES_ATTRIBUTE_TAG = "quantiles";
    public static final String MEAN_ATTRIBUTE_TAG = "mean";
    public static final String MODE_ATTRIBUTE_TAG = "mode";
    public static final String SUM_ATTRIBUTE_TAG = "sum";
    public static final String SUM_WEIGHTS_ATTRIBUTE_TAG = "sum.weights";
    public static final String USS_ATTRIBUTE_TAG = "uss";
    public static final String CSS_ATTRIBUTE_TAG = "css";
    public static final String VAR_ATTRIBUTE_TAG = "var";
    public static final String COVARIANCE_ATTRIBUTE_TAG = "covariance";
    public static final String STDEV_ATTRIBUTE_TAG = "stdev";
    public static final String STDERR_ATTRIBUTE_TAG = "stderr";
    public static final String CV_ATTRIBUTE_TAG = "cv";
    public static final String SKEWNESS_ATTRIBUTE_TAG = "skewness";
    public static final String KURTOSIS_ATTRIBUTE_TAG = "kurtosis";
    public static final String T_ATTRIBUTE_TAG = "t";
    public static final String PR_T_ATTRIBUTE_TAG = "pr.t";
    public static final String M_SIGN_ATTRIBUTE_TAG = "msign";
    public static final String PR_M_ATTRIBUTE_TAG = "pr.msign";
    public static final String SIGN_RANK_ATTRIBUTE_TAG = "sign.rank";
    public static final String PR_S_ATTRIBUTE_TAG = "pr.sign.rank";
    public static final String NORMAL_ATTRIBUTE_TAG = "normal";
    public static final String PR_N_ATTRIBUTE_TAG = "pr.normal";
    public static final String BY_COLUMNS_ATTRIBUTE_TAG = "byColumns";
    public static final String MU_ATTRIBUTE_TAG = "mu";
    public static final String FIRST_PASS_ATTRIBUTE_TAG = "needFirstPass";
    public static final String SECOND_PASS_ATTRIBUTE_TAG = "needSecondPass";
    public static final String CACHE_FILENAME = "univariate";
    private UnivariateStats[] m_us = null;
    private String[][] m_strQuantiles = null;
    private static boolean m_useOldSort = false;
    private static int m_maxColumnsToExtract = 10;
    private Vector m_tempFiles = new Vector();

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public void procSetProperties(CNKProc proc) throws Exception {
    }

    public static boolean getUseOldSort() {
        return m_useOldSort;
    }

    public static void setUseOldSort(boolean val) {
        m_useOldSort = val;
    }

    public static int getMaxColumnsToExtract() {
        return m_maxColumnsToExtract;
    }

    public static void setMaxColumnsToExtract(int val) {
        m_maxColumnsToExtract = val;
    }

    public boolean executeDataCacheProc() throws Exception {
        boolean ok = false;
        try {
            ok = m_useOldSort ? this.oldExecuteDataCacheProc() : this.newExecuteDataCacheProc();
        }
        catch (Exception ex) {
            this.deleteAllTempFiles();
            throw ex;
        }
        this.deleteAllTempFiles();
        return ok;
    }

    private File createTempFile() throws Exception {
        File f = this.createWorkspaceTempFile("univar", "tmp");
        this.m_tempFiles.add(f);
        return f;
    }

    private void deleteTempFile(File f) {
        try {
            if (f.exists()) {
                f.delete();
            }
            this.m_tempFiles.remove(f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void deleteAllTempFiles() {
        Vector files = new Vector(this.m_tempFiles);
        for (int i = 0; i < files.size(); ++i) {
            File f = (File)files.get(i);
            this.deleteTempFile(f);
        }
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean oldExecuteDataCacheProc() throws Exception {
        XTProps props = this.getNodeProperties();
        File specialSortFile = this.createWorkspaceTempFile("univar", "tmp");
        File signedRankFile = this.createWorkspaceTempFile("univar", "tmp");
        Vector columnNames = props.getSubProperties(new String[]{SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG});
        int columnCount = columnNames.size();
        XTMetaData md = this.getInputMetaData(0);
        Vector preservedCols = new Vector(columnNames);
        XTMetaData filteredMD = md.selectiveClone(preservedCols);
        String[] sortColumnOrder = new String[columnCount];
        int[] sortColumnNumbers = new int[columnCount];
        boolean[] sortAscending = new boolean[columnCount];
        boolean[] sortNAatTop = new boolean[columnCount];
        double[] columnMu = new double[columnCount];
        int[] in2out = new int[columnCount];
        this.m_strQuantiles = new String[columnCount][];
        boolean secondPass = props.getBoolean(SECOND_PASS_ATTRIBUTE_TAG, false);
        this.m_us = new UnivariateStats[columnCount];
        String[] qPath = new String[]{QUANTILES_ATTRIBUTE_TAG, ""};
        String[] muPath = new String[]{SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG, "", MU_ATTRIBUTE_TAG};
        for (int i = 0; i < columnCount; ++i) {
            sortColumnOrder[i] = (String)columnNames.get(i);
            sortColumnNumbers[i] = md.nameToOrdinal(sortColumnOrder[i]);
            sortAscending[i] = true;
            sortNAatTop[i] = true;
            in2out[i] = filteredMD.nameToOrdinal(sortColumnOrder[i]);
            muPath[1] = qPath[1] = sortColumnOrder[i];
            double mu = props.getDouble(muPath, Double.NaN);
            columnMu[i] = Double.isNaN(mu) ? 0.0 : mu;
            Vector strQuantNames = props.getSubPropertyValues(qPath);
            double[] quantNames = new double[strQuantNames.size()];
            this.m_strQuantiles[i] = new String[quantNames.length];
            for (int q = 0; q < this.m_strQuantiles[i].length; ++q) {
                this.m_strQuantiles[i][q] = (String)strQuantNames.get(q);
                quantNames[q] = Double.parseDouble(this.m_strQuantiles[i][q]);
            }
            int cn = sortColumnNumbers[i];
            this.m_us[i] = new UnivariateStats(md.getNumRows(), md.getColumnMean(cn), md.getColumnMin(cn), md.getColumnMax(cn), (long)md.getColumnMissingCount(cn), md.getColumnStandardDeviation(cn), quantNames, mu);
        }
        if (columnCount < 1) {
            throw new Exception("no columns specified");
        }
        int rowChunkSize = this.getMaxRowsPerBlock();
        boolean ok = SortAndShuffle.columnSort(new File(this.getInputDataCacheFileName(0)), specialSortFile, md, (EngineNode)this, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, false, false);
        if (!ok) {
            return false;
        }
        DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(specialSortFile)));
        DataCacheRowBuf buf = new DataCacheRowBuf(filteredMD);
        DataOutputStream signedRankOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(signedRankFile)));
        DataCacheRowBuf signedRankBuf = new DataCacheRowBuf(filteredMD);
        boolean done = false;
        try {
            buf.readRowUnsafe(inputStream);
        }
        catch (Exception e) {
            done = true;
        }
        while (!done) {
            byte[] rowData = buf.getDataBytes();
            signedRankBuf.setData(rowData, 0);
            for (int i = 0; i < columnCount; ++i) {
                int colNum = in2out[i];
                double val = buf.getDouble(colNum);
                this.m_us[i].update(val);
                if (!secondPass) continue;
                signedRankBuf.setDouble(colNum, val - columnMu[i]);
            }
            if (secondPass) {
                signedRankBuf.writeRow(signedRankOutputStream);
            }
            try {
                buf.readRowUnsafe(inputStream);
            }
            catch (Exception e) {
                done = true;
            }
        }
        for (int i = 0; i < columnCount; ++i) {
            this.m_us[i].finishMode();
        }
        inputStream.close();
        signedRankOutputStream.close();
        specialSortFile.delete();
        if (secondPass) {
            ok = SortAndShuffle.columnSort(signedRankFile, specialSortFile, filteredMD, (EngineNode)this, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, false, true);
            if (!ok) {
                return false;
            }
            inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(specialSortFile)));
            buf = new DataCacheRowBuf(md);
            done = false;
            try {
                buf.readRowUnsafe(inputStream);
            }
            catch (Exception e) {
                done = true;
            }
            while (!done) {
                for (int i = 0; i < columnCount; ++i) {
                    int colNum = sortColumnNumbers[i];
                    double val = buf.getDouble(colNum);
                    this.m_us[i].updateSignRank(val);
                }
                try {
                    buf.readRowUnsafe(inputStream);
                }
                catch (Exception e) {
                    done = true;
                }
            }
            for (int i = 0; i < columnCount; ++i) {
                this.m_us[i].finishSignedRank();
            }
            inputStream.close();
            specialSortFile.delete();
        }
        signedRankFile.delete();
        this.procExtractResults();
        return ok;
    }

    public boolean newExecuteDataCacheProc() throws Exception {
        int i;
        boolean ok = false;
        XTMetaData md = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        long numRows = md.getNumRows();
        XTMetaData oneDoubleMD = new XTMetaData();
        oneDoubleMD.appendContinousDataField("x");
        oneDoubleMD.setNumRows(numRows);
        int rowChunkSize = this.getNetworkManager().limitRowsPerChunk(this.getNodeID(), DataCacheRowBuf.getDCFBytesPerRow(oneDoubleMD));
        props.set("rowsToChunk", rowChunkSize);
        boolean firstPass = props.getBoolean(FIRST_PASS_ATTRIBUTE_TAG, true);
        boolean secondPass = props.getBoolean(SECOND_PASS_ATTRIBUTE_TAG, false);
        Vector columnNames = props.getSubProperties(new String[]{SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG});
        int numberColumns = columnNames.size();
        int[] inputColumnNumbers = new int[numberColumns];
        double[] columnMu = new double[numberColumns];
        this.m_strQuantiles = new String[numberColumns][];
        this.m_us = new UnivariateStats[numberColumns];
        String[] qPath = new String[]{QUANTILES_ATTRIBUTE_TAG, ""};
        String[] muPath = new String[]{SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG, "", MU_ATTRIBUTE_TAG};
        for (i = 0; i < numberColumns; ++i) {
            String colName = (String)columnNames.get(i);
            inputColumnNumbers[i] = md.nameToOrdinal(colName);
            muPath[1] = qPath[1] = colName;
            double mu = props.getDouble(muPath, Double.NaN);
            columnMu[i] = Double.isNaN(mu) ? 0.0 : mu;
            Vector strQuantNames = props.getSubPropertyValues(qPath);
            double[] quantNames = new double[strQuantNames.size()];
            this.m_strQuantiles[i] = new String[quantNames.length];
            for (int q = 0; q < this.m_strQuantiles[i].length; ++q) {
                this.m_strQuantiles[i][q] = (String)strQuantNames.get(q);
                quantNames[q] = Double.parseDouble(this.m_strQuantiles[i][q]);
            }
            int cn = inputColumnNumbers[i];
            this.m_us[i] = new UnivariateStats(md.getNumRows(), md.getColumnMean(cn), md.getColumnMin(cn), md.getColumnMax(cn), (long)md.getColumnMissingCount(cn), md.getColumnStandardDeviation(cn), quantNames, mu);
        }
        if (!firstPass) {
            for (i = 0; i < numberColumns; ++i) {
                this.m_us[i].setN(this.m_us[i].getTotal() - this.m_us[i].getNMiss());
            }
            this.procExtractResults();
            return true;
        }
        File originalDataFile = new File(this.getInputDataCacheFileName(0));
        if (numberColumns == 1 && md.getNumColumns() == 1 && inputColumnNumbers[0] == 0 && md.isContinuousColumn(0)) {
            ok = this.processOneColumnData(originalDataFile, oneDoubleMD, rowChunkSize, secondPass, columnMu[0], this.m_us[0]);
            if (!ok) {
                return false;
            }
            this.procExtractResults();
            return true;
        }
        for (int extractCol = 0; extractCol < numberColumns; extractCol += m_maxColumnsToExtract) {
            int numToExtract = Math.min(m_maxColumnsToExtract, numberColumns - extractCol);
            int[] inputColNumsToExtract = new int[numToExtract];
            for (int i2 = 0; i2 < numToExtract; ++i2) {
                inputColNumsToExtract[i2] = inputColumnNumbers[extractCol + i2];
            }
            File[] extractedFiles = this.extractColumnFiles(originalDataFile, md, inputColNumsToExtract, oneDoubleMD);
            if (extractedFiles == null) {
                return false;
            }
            for (int i3 = 0; i3 < numToExtract; ++i3) {
                int colNum = extractCol + i3;
                ok = this.processOneColumnData(extractedFiles[i3], oneDoubleMD, rowChunkSize, secondPass, columnMu[colNum], this.m_us[colNum]);
                this.deleteTempFile(extractedFiles[i3]);
                if (ok) continue;
                return false;
            }
        }
        this.procExtractResults();
        return true;
    }

    public File[] extractColumnFiles(File inputDataFile, XTMetaData inputMD, int[] colNums, XTMetaData oneDoubleMD) throws Exception {
        long numRows = inputMD.getNumRows();
        int numOutputs = colNums.length;
        File[] outFiles = new File[numOutputs];
        DataOutputStream[] outStreams = new DataOutputStream[numOutputs];
        DataInputStream inputStream = null;
        boolean ok = false;
        try {
            inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(inputDataFile)));
            DataCacheRowBuf inbuf = new DataCacheRowBuf(inputMD);
            DataCacheRowBuf outbuf = new DataCacheRowBuf(oneDoubleMD);
            for (int i = 0; i < numOutputs; ++i) {
                outFiles[i] = this.createTempFile();
                outStreams[i] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFiles[i])));
            }
            for (long row = 0L; row < numRows; ++row) {
                inbuf.readRowUnsafe(inputStream);
                for (int outNum = 0; outNum < numOutputs; ++outNum) {
                    outbuf.setDouble(0, inbuf.getDouble(colNums[outNum]));
                    outbuf.writeRow(outStreams[outNum]);
                }
            }
            ok = true;
        }
        catch (Throwable ex) {
            // empty catch block
        }
        this.closeInputStream(inputStream);
        for (int i = 0; i < numOutputs; ++i) {
            this.closeOutputStream(outStreams[i]);
            if (ok) continue;
            this.deleteTempFile(outFiles[i]);
        }
        if (!ok) {
            return null;
        }
        return outFiles;
    }

    public boolean processOneColumnData(File columnDataFile, XTMetaData md, int rowChunkSize, boolean secondPass, double mu, UnivariateStats us) throws Exception {
        long numRows = md.getNumRows();
        String colName = md.ordinalToName(0);
        File sortedColumnDataFile = this.createTempFile();
        boolean ok = SortAndShuffle.sort(columnDataFile, sortedColumnDataFile, md, (EngineNode)this, rowChunkSize, new String[]{colName}, new boolean[]{true}, new boolean[]{true}, false, true);
        if (!ok) {
            return false;
        }
        DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(sortedColumnDataFile)));
        DataCacheRowBuf buf = new DataCacheRowBuf(md);
        File signedRankFile = null;
        DataOutputStream signedRankOutputStream = null;
        DataCacheRowBuf signedRankBuf = null;
        if (secondPass) {
            signedRankFile = this.createTempFile();
            signedRankOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(signedRankFile)));
            signedRankBuf = new DataCacheRowBuf(md);
        }
        ok = false;
        try {
            for (long row = 0L; row < numRows; ++row) {
                buf.readRowUnsafe(inputStream);
                double val = buf.getDouble(0);
                us.update(val);
                if (!secondPass) continue;
                signedRankBuf.setDouble(0, val - mu);
                signedRankBuf.writeRow(signedRankOutputStream);
            }
            us.finishMode();
            ok = true;
        }
        catch (Throwable ex) {
            // empty catch block
        }
        this.closeInputStream(inputStream);
        this.closeOutputStream(signedRankOutputStream);
        this.deleteTempFile(sortedColumnDataFile);
        if (!ok) {
            return false;
        }
        if (secondPass) {
            File sortedRankFile = this.createTempFile();
            ok = SortAndShuffle.sortBase(signedRankFile, sortedRankFile, md, (EngineNode)this, rowChunkSize, new String[]{colName}, new boolean[]{true}, new boolean[]{true}, false, true, true);
            this.deleteTempFile(signedRankFile);
            if (!ok) {
                return false;
            }
            inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(sortedRankFile)));
            buf = new DataCacheRowBuf(md);
            ok = false;
            try {
                for (long row = 0L; row < numRows; ++row) {
                    buf.readRowUnsafe(inputStream);
                    double val = buf.getDouble(0);
                    us.updateSignRank(val);
                }
                us.finishSignedRank();
                ok = true;
            }
            catch (Throwable ex) {
                // empty catch block
            }
            this.closeInputStream(inputStream);
            this.deleteTempFile(sortedRankFile);
            if (!ok) {
                return false;
            }
        }
        return true;
    }

    public void procExtractResults() {
        XTProps output = this.getResults();
        if (output != null) {
            this.setNodeCache(CACHE_FILENAME, output);
        }
    }

    protected XTProps getResults() {
        try {
            String cnkmisc_file = CNKProc.getLibraryFileName("cnkmisc");
            Runtime.getRuntime().load(cnkmisc_file);
            XTProps outputCache = new XTProps();
            if (this.m_us == null || this.m_strQuantiles == null) {
                return outputCache;
            }
            Vector columnNames = this.getNodeProperties().getSubProperties(new String[]{SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG});
            int columnCount = columnNames.size();
            String[] path = new String[]{"", ""};
            String[] qPath = new String[]{"", "", ""};
            for (int i = 0; i < columnCount; ++i) {
                qPath[0] = path[0] = (String)columnNames.get(i);
                path[1] = N_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getN()));
                path[1] = NMISS_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getNMiss()));
                path[1] = MIN_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getMin()));
                path[1] = MAX_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getMax()));
                path[1] = RANGE_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getRange()));
                path[1] = Q3_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getQ3()));
                path[1] = Q2_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getMedian()));
                path[1] = Q1_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getQ1()));
                path[1] = Q_RANGE_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getQRange()));
                qPath[1] = QUANTILES_ATTRIBUTE_TAG;
                double[] qVals = this.m_us[i].getQuantiles();
                for (int j = 0; j < this.m_strQuantiles[i].length; ++j) {
                    qPath[2] = this.m_strQuantiles[i][j];
                    outputCache.set(qPath, Double.toString(qVals[j]));
                }
                path[1] = MEAN_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getMean()));
                path[1] = MODE_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getMode()));
                path[1] = SUM_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getSum()));
                path[1] = SUM_WEIGHTS_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getSumWeights()));
                path[1] = USS_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getUss()));
                path[1] = CSS_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getCss()));
                path[1] = VAR_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getVar()));
                path[1] = STDEV_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getStdev()));
                path[1] = STDERR_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getStderr()));
                path[1] = CV_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getCv()));
                path[1] = SKEWNESS_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getSkewness()));
                path[1] = KURTOSIS_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getKurtosis()));
                path[1] = T_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getT()));
                path[1] = PR_T_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getPrST()));
                path[1] = M_SIGN_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getSignStatistic()));
                path[1] = PR_M_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getPrSS()));
                path[1] = SIGN_RANK_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getSignedRank()));
                path[1] = PR_S_ATTRIBUTE_TAG;
                outputCache.set(path, Double.toString(this.m_us[i].getPrSR()));
            }
            return outputCache;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static native double getPrStudentT(double var0, double var2);

    private static native double getPrSignedRank(double var0, double var2, double var4, double var6, long var8, long var10);

    private static native double getPrSignStat(double var0, double var2);

    private static native double getPrNormality(double var0);

    private class UnivariateStats {
        private long total = 0L;
        private long n = 0L;
        private long nmiss = 0L;
        private double min = Double.NaN;
        private double max = Double.NaN;
        private double q3Val = Double.NaN;
        private double q3Count = Double.NaN;
        private double q2Val = Double.NaN;
        private double q2Count = Double.NaN;
        private double q1Val = Double.NaN;
        private double q1Count = Double.NaN;
        private double[] quantileCounts = null;
        private double[] quantileVals = null;
        private double mean = Double.NaN;
        private double mode = Double.NaN;
        private long modeCount = 0L;
        private double newMode = Double.NaN;
        private long newModeCount = 0L;
        private double sum = Double.NaN;
        private double weightedSum = Double.NaN;
        private double sumWeights = Double.NaN;
        private double uss = Double.NaN;
        private double css = Double.NaN;
        private double var = Double.NaN;
        private double covariance = Double.NaN;
        private double stdev = Double.NaN;
        private double stderr = Double.NaN;
        private double cv = Double.NaN;
        private double skewness = Double.NaN;
        private double kurtosis = Double.NaN;
        private double t = Double.NaN;
        private double prT = Double.NaN;
        private double msign = Double.NaN;
        private double prM = Double.NaN;
        private double signRank = Double.NaN;
        private double prS = Double.NaN;
        private double normal = Double.NaN;
        private double prN = Double.NaN;
        private double sumZ3 = Double.NaN;
        private double sumZ4 = Double.NaN;
        private double vCorrection = Double.NaN;
        private long numTies = 1L;
        private double rankVal = Double.NaN;
        private double lastRankVal = Double.NaN;
        private long numZeroes = 0L;
        private double mu = Double.NaN;
        private boolean noMu = false;
        private long currentSignRank = 0L;
        private long sumSignRanks = 0L;
        private long gtMu = 0L;
        private long ltMu = 0L;
        private long allTies = 0L;
        private boolean firstTime = true;

        public UnivariateStats(long length, double mean, double min, double max, long missing, double stdev, double[] quants, double mu) {
            this.total = length;
            this.quantileCounts = new double[quants.length];
            this.quantileVals = new double[quants.length];
            for (int i = 0; i < quants.length; ++i) {
                this.quantileVals[i] = this.initQuantileVal(quants[i], length, missing, min, max);
                this.quantileCounts[i] = this.initQuantileCount(quants[i], length, missing, min, max);
            }
            this.q1Val = this.initQuantileVal(25.0, length, missing, min, max);
            this.q1Count = this.initQuantileCount(25.0, length, missing, min, max);
            this.q2Val = this.initQuantileVal(50.0, length, missing, min, max);
            this.q2Count = this.initQuantileCount(50.0, length, missing, min, max);
            this.q3Val = this.initQuantileVal(75.0, length, missing, min, max);
            this.q3Count = this.initQuantileCount(75.0, length, missing, min, max);
            this.mode = Double.NaN;
            this.modeCount = 0L;
            this.newMode = Double.NaN;
            this.newModeCount = 0L;
            this.min = min;
            this.max = max;
            this.nmiss = missing;
            this.mean = mean;
            this.stdev = stdev;
            this.mu = mu;
            this.noMu = Double.isNaN(mu);
        }

        private double initQuantileVal(double quantile, long totalCount, long missingCount, double min, double max) {
            long goodCount = totalCount - missingCount;
            if (goodCount < 1L) {
                return Double.NaN;
            }
            if (goodCount == 1L) {
                return min;
            }
            if (quantile <= 0.0) {
                return min;
            }
            if (quantile >= 100.0) {
                return max;
            }
            return Double.NaN;
        }

        private double initQuantileCount(double quantile, long totalCount, long missingCount, double min, double max) {
            long goodCount = totalCount - missingCount;
            if (goodCount < 1L) {
                return -1.0;
            }
            if (goodCount == 1L) {
                return -1.0;
            }
            if (quantile <= 0.0) {
                return -1.0;
            }
            if (quantile >= 100.0) {
                return -1.0;
            }
            double count = (double)(goodCount - 1L) * quantile / 100.0;
            return count;
        }

        private double updateQuantileVal(double val, double oldQuantileVal, long n, double quantileCount) {
            if (quantileCount < 0.0) {
                return oldQuantileVal;
            }
            if ((double)(n + 1L) <= quantileCount) {
                return oldQuantileVal;
            }
            if ((double)(n - 1L) >= quantileCount) {
                return oldQuantileVal;
            }
            double quantileCountFloor = Math.floor(quantileCount);
            if ((double)n == quantileCountFloor) {
                return val;
            }
            if ((double)(n - 1L) == quantileCountFloor) {
                if (quantileCount == quantileCountFloor) {
                    return oldQuantileVal;
                }
                if (oldQuantileVal == val) {
                    return oldQuantileVal;
                }
                double frac = quantileCount - quantileCountFloor;
                double interpVal = oldQuantileVal * (1.0 - frac) + val * frac;
                return interpVal;
            }
            return oldQuantileVal;
        }

        private void newModeVal(double val) {
            if (this.newModeCount > this.modeCount) {
                this.modeCount = this.newModeCount;
                this.mode = this.newMode;
            }
            this.newMode = val;
            this.newModeCount = 1L;
        }

        private void updateMode(double val) {
            if (!Double.isNaN(val)) {
                if (val == this.newMode) {
                    ++this.newModeCount;
                } else {
                    this.newModeVal(val);
                }
            }
        }

        private void updateVCorrection(double count) {
            double v = count * (count * count - 1.0);
            this.vCorrection = Double.isNaN(this.vCorrection) ? v : (this.vCorrection += v);
        }

        private void newSRValue(double val) {
            if (this.numTies > 1L) {
                this.updateVCorrection(this.numTies);
            }
            if (this.rankVal > 0.0 && !Double.isNaN(this.rankVal) && (Double.isNaN(this.lastRankVal) || this.lastRankVal != this.rankVal)) {
                double groupRankVal = (double)this.currentSignRank - (double)(this.numTies - 1L) / 2.0;
                double groupRankVals = (double)this.numTies * groupRankVal;
                this.sumSignRanks = (long)((double)this.sumSignRanks + groupRankVals);
                this.lastRankVal = this.rankVal;
            }
            if (val == 0.0) {
                ++this.numZeroes;
            } else if (val > 0.0) {
                this.rankVal = Math.abs(val);
            }
            ++this.currentSignRank;
            this.numTies = 1L;
        }

        private void updateSignRank(double val) {
            if (!Double.isNaN(val)) {
                if (Math.abs(val) == this.rankVal) {
                    ++this.currentSignRank;
                    ++this.numTies;
                    ++this.allTies;
                } else {
                    this.newSRValue(val);
                }
            }
        }

        public void finishMode() {
            this.newModeVal(1.0);
        }

        public void finishSignedRank() {
            this.newSRValue(1.0);
        }

        public void update(double val) {
            this.update(val, Double.NaN);
        }

        public void update(double val, double weight) {
            if (!Double.isNaN(val)) {
                for (int i = 0; i < this.quantileCounts.length; ++i) {
                    this.quantileVals[i] = this.updateQuantileVal(val, this.quantileVals[i], this.n, this.quantileCounts[i]);
                }
                this.q1Val = this.updateQuantileVal(val, this.q1Val, this.n, this.q1Count);
                this.q2Val = this.updateQuantileVal(val, this.q2Val, this.n, this.q2Count);
                this.q3Val = this.updateQuantileVal(val, this.q3Val, this.n, this.q3Count);
                ++this.n;
            }
            this.updateMode(val);
            if (Double.isNaN(val)) {
                return;
            }
            double z = (val - this.mean) / this.stdev;
            double z3 = z * z * z;
            if (this.firstTime) {
                this.firstTime = false;
                this.sumZ3 = z3;
                this.sumZ4 = z3 * z;
                if (!Double.isNaN(weight)) {
                    this.weightedSum = val * weight;
                    this.sumWeights = weight;
                    this.uss = val * val * weight;
                    this.css = (val - this.mean) * (val - this.mean) * weight;
                } else {
                    this.weightedSum = val * 1.0;
                    this.uss = val * val * 1.0;
                    this.css = (val - this.mean) * (val - this.mean) * 1.0;
                }
            } else {
                this.sumZ3 += z3;
                this.sumZ4 += z3 * z;
                if (!Double.isNaN(weight)) {
                    this.weightedSum += val * weight;
                    this.sumWeights += weight;
                    this.uss += val * val * weight;
                    this.css += (val - this.mean) * (val - this.mean) * weight;
                } else {
                    this.weightedSum += val * 1.0;
                    this.uss += val * val * 1.0;
                    this.css += (val - this.mean) * (val - this.mean) * 1.0;
                }
            }
            if (this.noMu) {
                if (val < this.mean) {
                    ++this.ltMu;
                } else if (val > this.mean) {
                    ++this.gtMu;
                }
            } else if (val < this.mu) {
                ++this.ltMu;
            } else if (val > this.mu) {
                ++this.gtMu;
            }
        }

        public long getTotal() {
            return this.total;
        }

        public void setN(long val) {
            this.n = val;
        }

        public long getN() {
            return this.n;
        }

        public long getNMiss() {
            return this.nmiss;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getRange() {
            return this.max - this.min;
        }

        public double getSum() {
            return this.weightedSum;
        }

        public double getSumWeights() {
            return this.sumWeights;
        }

        public double getUss() {
            return this.uss;
        }

        public double getCss() {
            return this.css;
        }

        public double getVar() {
            return Math.sqrt(this.stdev);
        }

        public double getStdev() {
            return this.stdev;
        }

        public double getStderr() {
            return this.stdev / Math.sqrt(this.n);
        }

        public double getCv() {
            return 100.0 * this.getStderr();
        }

        public double getSkewness() {
            return this.sumZ3 * (double)this.n / (((double)this.n - 1.0) * ((double)this.n - 2.0));
        }

        public double getKurtosis() {
            double n2minusn3 = (this.n - 2L) * (this.n - 3L);
            return this.sumZ4 * (double)this.n * ((double)this.n + 1.0) / (((double)this.n - 1.0) * n2minusn3) - 3.0 * ((double)this.n - 1.0) * ((double)this.n - 1.0) / n2minusn3;
        }

        public double getT() {
            double m = this.noMu ? 0.0 : this.mu;
            return (this.mean - m) * Math.sqrt(this.n) / this.stdev;
        }

        public double getMedian() {
            return this.q2Val;
        }

        public double getQ3() {
            return this.q3Val;
        }

        public double getQ1() {
            return this.q1Val;
        }

        public double getQRange() {
            return this.q3Val - this.q1Val;
        }

        public double[] getQuantiles() {
            return this.quantileVals;
        }

        public double getMode() {
            return this.mode;
        }

        public double getMean() {
            return this.mean;
        }

        public double getSignStatistic() {
            return 0.5 * ((double)this.gtMu - (double)this.ltMu);
        }

        public double getSignedRank() {
            double n = this.getN();
            double numerator = n * (n + 1.0);
            return (double)this.sumSignRanks - numerator / 4.0;
        }

        public double getPrSS() {
            return UnivariateEngineNode.getPrSignStat(this.gtMu, this.ltMu);
        }

        public double getPrSR() {
            double n = this.getN();
            double v = 0.0;
            if (!Double.isNaN(this.vCorrection)) {
                double firstHalf = n * (n + 1.0) * (2.0 * n + 1.0);
                v = (firstHalf -= (double)(this.numZeroes * (this.numZeroes + 1L) * (2L * this.numZeroes + 1L))) / 24.0 - this.vCorrection / 48.0;
            }
            return UnivariateEngineNode.getPrSignedRank(this.getSignedRank(), this.sumSignRanks, n, v, this.allTies, this.numZeroes);
        }

        public double getPrST() {
            return UnivariateEngineNode.getPrStudentT(this.getT(), (double)this.getN() - 1.0);
        }
    }
}

