/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.CompiledStatement;
import com.insightful.miner.sql.lib.IntKeyHashMap;
import com.insightful.miner.sql.lib.IntKeyIntValueHashMap;
import com.insightful.miner.sql.lib.IntValueHashMap;
import com.insightful.miner.sql.lib.Iterator;

final class CompiledStatementManager {
    IntValueHashMap sqlMap = new IntValueHashMap();
    IntKeyHashMap sqlLookup = new IntKeyHashMap();
    IntKeyHashMap csidMap = new IntKeyHashMap();
    IntKeyHashMap sessionMap = new IntKeyHashMap();
    IntKeyIntValueHashMap useMap = new IntKeyIntValueHashMap();
    private int next_cs_id = 0;

    CompiledStatementManager() {
    }

    synchronized void reset() {
        this.sqlMap.clear();
        this.sqlLookup.clear();
        this.csidMap.clear();
        this.sessionMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0;
    }

    synchronized void resetStatements() {
        Iterator it = this.csidMap.keySet().iterator();
        while (it.hasNext()) {
            int key = it.nextInt();
            this.csidMap.put(key, null);
        }
    }

    private int nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    synchronized int getStatementID(String sql) {
        return this.sqlMap.get((Object)sql, -1);
    }

    synchronized CompiledStatement getStatement(int csid) {
        return (CompiledStatement)this.csidMap.get(csid);
    }

    synchronized String getSql(int csid) {
        return (String)this.sqlLookup.get(csid);
    }

    synchronized void linkSession(int csid, int sid) {
        IntKeyIntValueHashMap scsMap = (IntKeyIntValueHashMap)this.sessionMap.get(sid);
        if (scsMap == null) {
            scsMap = new IntKeyIntValueHashMap();
            this.sessionMap.put(sid, scsMap);
        }
        int count = scsMap.get(csid, 0);
        scsMap.put(csid, count + 1);
        if (count == 0) {
            this.useMap.put(csid, this.useMap.get(csid, 0) + 1);
        }
    }

    synchronized int registerStatement(int csid, CompiledStatement cs) {
        if (csid < 0) {
            csid = this.nextID();
            this.sqlMap.put(cs.sql, csid);
            this.sqlLookup.put(csid, cs.sql);
        }
        this.csidMap.put(csid, cs);
        return csid;
    }

    synchronized void freeStatement(int csid, int sid) {
        IntKeyIntValueHashMap scsMap = (IntKeyIntValueHashMap)this.sessionMap.get(sid);
        int count = scsMap.get(csid) - 1;
        if (count != 0) {
            scsMap.put(csid, count);
        } else {
            scsMap.remove(csid);
            int usecount = this.useMap.get(csid, 1) - 1;
            if (usecount == 0) {
                String sql = (String)this.sqlLookup.remove(csid);
                this.sqlMap.remove(sql);
                this.csidMap.remove(csid);
                this.useMap.remove(csid);
            } else {
                this.useMap.put(csid, usecount);
            }
        }
    }

    synchronized void removeSession(int sid) {
        IntKeyIntValueHashMap scsMap = (IntKeyIntValueHashMap)this.sessionMap.remove(sid);
        if (scsMap == null) {
            return;
        }
        Iterator i = scsMap.keySet().iterator();
        while (i.hasNext()) {
            int csid = i.nextInt();
            int usecount = this.useMap.get(csid, 1) - 1;
            if (usecount == 0) {
                String sql = (String)this.sqlLookup.remove(csid);
                this.sqlMap.remove(sql);
                this.csidMap.remove(csid);
                this.useMap.remove(csid);
                continue;
            }
            this.useMap.put(csid, usecount);
        }
    }
}

