/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Binary;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.lib.HashMap;
import com.insightful.miner.sql.lib.ValuePool;
import java.io.Serializable;
import java.lang.reflect.Method;

final class DIProcedureInfo {
    static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";
    static final String conClsName = "java.sql.Connection";
    static final int procedureResultUnknown = 0;
    static final int procedureNoResult = 1;
    static final int procedureReturnsResult = 2;
    static final int procedureColumnUnknown = 0;
    static final int procedureColumnIn = 1;
    static final int procedureColumnInOut = 2;
    static final int procedureColumnResult = 3;
    static final int procedureColumnOut = 4;
    static final int procedureColumnReturn = 5;
    static final int procedureNoNulls = 0;
    static final int procedureNullable = 1;
    static final int procedureNullableUnknown = 2;
    private Class clazz;
    private Class[] colClasses;
    private int[] colTypes;
    private int colOffset;
    private int colCount;
    private boolean colsResolved;
    private String fqn;
    private String specificName;
    private int hnd_remarks;
    private Method method;
    private String sig;
    private final HashMap typeMap = new HashMap();

    private int colOffset() {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colOffset;
    }

    Class getColClass(int i) {
        return this.colClasses[i + this.colOffset()];
    }

    int getColCount() {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colCount;
    }

    Integer getColDataType(int i) {
        return ValuePool.getInt(this.getColTypeCode(i));
    }

    Integer getColLen(int i) {
        int size;
        int type = this.getColTypeCode(i);
        switch (type) {
            case -4: 
            case -3: 
            case -2: {
                size = Integer.MAX_VALUE;
                break;
            }
            case -5: 
            case 6: 
            case 8: 
            case 91: 
            case 92: {
                size = 8;
                break;
            }
            case 93: {
                size = 12;
                break;
            }
            case 4: 
            case 7: {
                size = 4;
                break;
            }
            case 5: {
                size = 2;
                break;
            }
            case -6: 
            case 16: {
                size = 1;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size == 0 ? null : ValuePool.getInt(size);
    }

    String getColName(int i) {
        return PCOL_PREFIX + (i + this.colOffset());
    }

    Integer getColNullability(int i) {
        int cn = this.getColClass(i).isPrimitive() ? 0 : 1;
        return ValuePool.getInt(cn);
    }

    String getColRemark(int i) {
        return "";
    }

    int getColSequence(int i) {
        return i + this.colOffset() == 0 ? this.colCount : i;
    }

    int getColTypeCode(int i) {
        return this.colTypes[i += this.colOffset()];
    }

    Integer getColUsage(int i) {
        switch (i + this.colOffset()) {
            case 0: {
                return ValuePool.getInt(3);
            }
        }
        return ValuePool.getInt(1);
    }

    Class getDeclaringClass() {
        return this.clazz;
    }

    String getFQN() {
        if (this.fqn == null) {
            StringBuffer sb = new StringBuffer();
            this.fqn = sb.append(this.clazz.getName()).append('.').append(this.method.getName()).toString();
        }
        return this.fqn;
    }

    String getSpecificName() {
        if (this.specificName == null) {
            this.specificName = this.clazz.getName() + "." + this.getSignature();
        }
        return this.specificName;
    }

    Integer getInputParmCount() {
        return ValuePool.getInt(this.method.getParameterTypes().length);
    }

    Method getMethod() {
        return this.method;
    }

    Integer getOutputParmCount() {
        return ValuePool.getInt(0);
    }

    String getRemark() {
        return "";
    }

    Integer getResultSetCount() {
        return this.method.getReturnType() == Void.TYPE ? ValuePool.getInt(0) : ValuePool.getInt(1);
    }

    Integer getResultType(String origin) {
        int type = !"ROUTINE".equals(origin) ? 0 : (this.method.getReturnType() == Void.TYPE ? 1 : 2);
        return ValuePool.getInt(type);
    }

    String getSignature() {
        if (this.sig == null) {
            this.sig = DIProcedureInfo.getSignature(this.method);
        }
        return this.sig;
    }

    static String getSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        Class<?>[] parmTypes = method.getParameterTypes();
        int len = parmTypes.length;
        int last = len - 1;
        sb.append(method.getName()).append('(');
        for (int i = 0; i < len; ++i) {
            sb.append(parmTypes[i].getName());
            if (i >= last) continue;
            sb.append(',');
        }
        sb.append(')');
        String signature = sb.toString();
        return signature;
    }

    private void resolveCols() {
        Class<?> rType = this.method.getReturnType();
        Class<?>[] pTypes = this.method.getParameterTypes();
        int ptlen = pTypes.length;
        boolean isFPCON = ptlen > 0 && pTypes[0].getName().equals(conClsName);
        int pclen = 1 + ptlen - (isFPCON ? 1 : 0);
        this.colClasses = new Class[pclen];
        this.colTypes = new int[pclen];
        this.colClasses[0] = rType;
        this.colTypes[0] = this.typeForClass(rType);
        int i = isFPCON ? 1 : 0;
        int idx = 1;
        while (i < ptlen) {
            Class<?> clazz;
            this.colClasses[idx] = clazz = pTypes[i];
            this.colTypes[idx] = this.typeForClass(clazz);
            ++i;
            ++idx;
        }
        this.colOffset = rType == Void.TYPE ? 1 : 0;
        this.colCount = pclen - this.colOffset;
    }

    void setMethod(Method m) {
        this.method = m;
        this.clazz = this.method.getDeclaringClass();
        this.fqn = null;
        this.specificName = null;
        this.sig = null;
        this.colsResolved = false;
        String remarkKey = this.clazz.getName().replace('.', '_');
        this.hnd_remarks = 0;
    }

    int typeForClass(Class c) {
        Class<?> to;
        Integer type = (Integer)this.typeMap.get(c);
        if (type != null) {
            return type;
        }
        if (c.isArray() && !c.getComponentType().isArray()) {
            return 2003;
        }
        try {
            to = Class.forName("java.sql.Array");
            if (to.isAssignableFrom(c)) {
                return 2003;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Number.class.isAssignableFrom(c)) {
            return 2;
        }
        try {
            to = Class.forName("java.sql.Timestamp");
            if (to.isAssignableFrom(c)) {
                return 93;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Time");
            if (to.isAssignableFrom(c)) {
                return 93;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Date");
            if (to.isAssignableFrom(c)) {
                return 91;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Blob");
            if (to.isAssignableFrom(c)) {
                return 2004;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Clob");
            if (to.isAssignableFrom(c)) {
                return 2005;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Ref");
            if (to.isAssignableFrom(c)) {
                return 2006;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            to = Class.forName("java.sql.Struct");
            if (to.isAssignableFrom(c)) {
                return 2002;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Binary.class.isAssignableFrom(c)) {
            return -4;
        }
        try {
            to = Class.forName("java.lang.CharSequence");
            if (to.isAssignableFrom(c)) {
                return -1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Serializable.class.isAssignableFrom(c)) {
            return 1111;
        }
        return 2000;
    }
}

