/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Column;
import com.insightful.miner.sql.Expression;
import com.insightful.miner.sql.GroupedResult;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.HsqlInternalException;
import com.insightful.miner.sql.HsqlNameManager;
import com.insightful.miner.sql.Result;
import com.insightful.miner.sql.TableFilter;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.lib.HashMap;
import com.insightful.miner.sql.lib.HashSet;
import com.insightful.miner.sql.lib.HsqlArrayList;
import com.insightful.miner.sql.lib.Iterator;

class Select {
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    HashSet groupColumnNames;
    TableFilter[] tFilter;
    Expression limitCondition;
    Expression queryCondition;
    Expression havingCondition;
    Expression[] exprColumns;
    int iResultLen;
    int iGroupLen;
    int iHavingIndex = -1;
    int iOrderLen;
    int[] sortOrder;
    int[] sortDirection;
    Select sUnion;
    HsqlNameManager.HsqlName sIntoTable;
    boolean isIntoTableQuoted;
    int iUnionType;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    private int limitStart;
    private int limitCount;
    Result.ResultMetaData resultMetaData;
    boolean isResolved = false;

    Select() {
    }

    HashMap getColumnAliases() {
        HashMap aliasMap = new HashMap();
        for (int i = 0; i < this.iResultLen; ++i) {
            String alias = this.exprColumns[i].getAlias();
            if (alias == null) continue;
            aliasMap.put(alias, this.exprColumns[i]);
        }
        return aliasMap;
    }

    void resolve() throws HsqlException {
        this.resolveTables();
        this.resolveTypes();
        this.setFilterConditions();
    }

    void resolveTables() throws HsqlException {
        int len = this.tFilter.length;
        for (int i = 0; i < len; ++i) {
            this.resolveTables(this.tFilter[i]);
        }
    }

    void resolveTypes() throws HsqlException {
        int len = this.exprColumns.length;
        for (int i = 0; i < len; ++i) {
            this.exprColumns[i].resolveTypes();
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes();
        }
    }

    void resolveTables(TableFilter f) throws HsqlException {
        int len = this.exprColumns.length;
        for (int i = 0; i < len; ++i) {
            this.exprColumns[i].resolveTables(f);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTables(f);
        }
    }

    private void setFilterConditions() throws HsqlException {
        if (this.queryCondition == null) {
            return;
        }
        for (int i = 0; i < this.tFilter.length; ++i) {
            this.tFilter[i].setConditions(this.queryCondition);
        }
    }

    boolean checkResolved(boolean check) throws HsqlException {
        boolean result = true;
        int len = this.exprColumns.length;
        for (int i = 0; i < len; ++i) {
            result = result && this.exprColumns[i].checkResolved(check);
        }
        if (this.queryCondition != null) {
            result = result && this.queryCondition.checkResolved(check);
        }
        return result;
    }

    Object getValue(int type) throws HsqlException {
        this.resolve();
        Result r = this.getResult(2);
        int size = r.getSize();
        int len = r.getColumnCount();
        if (size == 1 && len == 1) {
            Object o = r.rRoot.data[0];
            return r.metaData.colType[0] == type ? o : Column.convertObject(o, type);
        }
        HsqlException e = Trace.error(17);
        if (size == 0 && len == 1) {
            throw new HsqlInternalException(e);
        }
        throw e;
    }

    void prepareResult() throws HsqlException {
        int i;
        this.resolveAll(true);
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            for (int i2 = this.iResultLen; i2 < this.iResultLen + this.iGroupLen; ++i2) {
                this.exprColumns[i2].collectColumnName(this.groupColumnNames);
            }
        }
        int len = this.exprColumns.length;
        Result.ResultMetaData rmd = this.resultMetaData = new Result.ResultMetaData(len);
        int groupByStart = this.iResultLen;
        int groupByEnd = groupByStart + this.iGroupLen;
        int orderByStart = this.iHavingIndex >= 0 ? this.iHavingIndex + 1 : groupByEnd;
        int orderByEnd = orderByStart + this.iOrderLen;
        for (i = 0; i < len; ++i) {
            Expression e = this.exprColumns[i];
            rmd.colType[i] = e.getDataType();
            rmd.colSize[i] = e.getColumnSize();
            rmd.colScale[i] = e.getColumnScale();
            if (e.isAggregate()) {
                this.isAggregated = true;
            }
            if (i >= groupByStart && i < groupByEnd && !this.exprColumns[i].canBeInGroupBy()) {
                Trace.error(68, this.exprColumns[i]);
            }
            if (i == this.iHavingIndex && !this.exprColumns[i].isConditional()) {
                Trace.error(69, this.exprColumns[i]);
            }
            if (i >= orderByStart || i >= orderByEnd || this.exprColumns[i].canBeInOrderBy()) {
                Trace.error(70, this.exprColumns[i]);
            }
            if (i >= this.iResultLen) continue;
            rmd.sLabel[i] = e.getAlias();
            rmd.isLabelQuoted[i] = e.isAliasQuoted();
            rmd.sTable[i] = e.getTableName();
            rmd.sName[i] = e.getColumnName();
            if (rmd.isTableColumn(i)) {
                rmd.nullability[i] = e.nullability;
                rmd.isIdentity[i] = e.isIdentity;
                rmd.isWritable[i] = e.isWritable;
            }
            rmd.sClassName[i] = e.getValueClassName();
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        if (this.iHavingIndex >= 0) {
            this.checkAggregateOrGroupByColumns(this.iHavingIndex, this.iHavingIndex + 1);
        }
        this.checkAggregateOrGroupByColumns(orderByStart, orderByEnd);
        if (this.isDistinctSelect) {
            for (i = orderByStart; i < orderByEnd; ++i) {
                Trace.check(this.isSimilarIn(this.exprColumns[i], 0, this.iResultLen), 71, this.exprColumns[i]);
            }
        }
        this.prepareSort();
    }

    private int getLimitCount(int maxrows) throws HsqlException {
        this.limitStart = this.limitCondition == null ? 0 : (Integer)this.limitCondition.getArg().getValue();
        int n = this.limitCount = this.limitCondition == null ? 0 : (Integer)this.limitCondition.getArg2().getValue();
        if (maxrows == 0) {
            maxrows = this.limitCount;
        } else if (this.limitCount == 0) {
            this.limitCount = maxrows;
        } else {
            this.limitCount = maxrows > this.limitCount ? this.limitCount : maxrows;
            maxrows = this.limitCount;
        }
        boolean issimplemaxrows = false;
        if (maxrows != 0 && !this.isDistinctSelect && !this.isGrouped && this.sUnion == null && this.iOrderLen == 0) {
            issimplemaxrows = true;
        }
        return issimplemaxrows ? this.limitStart + maxrows : Integer.MAX_VALUE;
    }

    Result getResult(int maxrows) throws HsqlException {
        if (this.resultMetaData == null) {
            this.prepareResult();
        }
        Result r = this.buildResult(this.getLimitCount(maxrows));
        if (this.isDistinctSelect) {
            r.removeDuplicates(this.iResultLen);
        }
        if (this.sUnion != null) {
            Result x = this.sUnion.getResult(0);
            switch (this.iUnionType) {
                case 1: {
                    r.append(x);
                    r.removeDuplicates(this.iResultLen);
                    break;
                }
                case 2: {
                    r.append(x);
                    break;
                }
                case 3: {
                    r.removeDifferent(x, this.iResultLen);
                    break;
                }
                case 4: {
                    r.removeSecond(x, this.iResultLen);
                }
            }
        }
        this.sortResult(r);
        r.setColumnCount(this.iResultLen);
        r.trimResult(this.limitStart, this.limitCount);
        return r;
    }

    private void prepareSort() {
        if (this.iOrderLen == 0) {
            return;
        }
        this.sortOrder = new int[this.iOrderLen];
        this.sortDirection = new int[this.iOrderLen];
        int startCol = this.iHavingIndex > 0 ? this.iHavingIndex + 1 : this.iResultLen + (this.isGrouped ? this.iGroupLen : 0);
        int i = startCol;
        for (int j = 0; j < this.iOrderLen; ++j) {
            int colindex = i;
            if (this.exprColumns[i].orderColumnIndex != -1) {
                colindex = this.exprColumns[i].orderColumnIndex;
            }
            this.sortOrder[j] = colindex;
            this.sortDirection[j] = this.exprColumns[i].isDescending() ? -1 : 1;
            ++i;
        }
    }

    private void sortResult(Result r) throws HsqlException {
        if (this.iOrderLen == 0) {
            return;
        }
        r.sortResult(this.sortOrder, this.sortDirection);
    }

    private void checkAggregateOrGroupByColumns(int start, int end) throws HsqlException {
        if (start < end) {
            int i;
            HsqlArrayList colExps = new HsqlArrayList();
            for (i = start; i < end; ++i) {
                this.exprColumns[i].collectInGroupByExpressions(colExps);
            }
            int size = colExps.size();
            for (i = 0; i < size; ++i) {
                Expression exp = (Expression)colExps.get(i);
                Trace.check(this.inAggregateOrGroupByClause(exp), 67, exp);
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression exp) {
        if (this.isGrouped) {
            return this.isSimilarIn(exp, this.iResultLen, this.iResultLen + this.iGroupLen) || Select.allColumnsAreDefinedIn(exp, this.groupColumnNames);
        }
        if (this.isAggregated) {
            return exp.canBeInAggregate();
        }
        return true;
    }

    private boolean isSimilarIn(Expression exp, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!exp.similarTo(this.exprColumns[i])) continue;
            return true;
        }
        return false;
    }

    static boolean allColumnsAreDefinedIn(Expression exp, HashSet definedColumns) {
        HashSet colNames = new HashSet();
        exp.collectAllColumnNames(colNames);
        if (colNames.size() > 0 && definedColumns == null) {
            return false;
        }
        Iterator i = colNames.iterator();
        while (i.hasNext()) {
            if (definedColumns.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    private Result buildResult(int limitcount) throws HsqlException {
        int i;
        GroupedResult gResult = new GroupedResult(this, this.resultMetaData);
        int len = this.exprColumns.length;
        int level = 0;
        while (level >= 0) {
            if (this.queryCondition != null && !this.queryCondition.test()) continue;
            try {
                Object[] row = new Object[len];
                for (i = gResult.groupBegin; i < gResult.groupEnd; ++i) {
                    row[i] = this.exprColumns[i].getValue();
                }
                row = gResult.getRow(row);
                for (i = 0; i < gResult.groupBegin; ++i) {
                    row[i] = this.isAggregated && this.exprColumns[i].isAggregate() ? this.exprColumns[i].updateAggregatingValue(row[i]) : this.exprColumns[i].getValue();
                }
                for (i = gResult.groupEnd; i < len; ++i) {
                    row[i] = this.isAggregated && this.exprColumns[i].isAggregate() ? this.exprColumns[i].updateAggregatingValue(row[i]) : this.exprColumns[i].getValue();
                }
                gResult.addRow(row);
                if (gResult.size() < limitcount) continue;
                break;
            }
            catch (HsqlInternalException e) {
            }
        }
        if (this.isAggregated && !this.isGrouped && gResult.size() == 0) {
            Object[] row = new Object[len];
            for (int i2 = 0; i2 < len; ++i2) {
                row[i2] = this.exprColumns[i2].isAggregate() ? null : this.exprColumns[i2].getValue();
            }
            gResult.addRow(row);
        }
        Iterator it = gResult.iterator();
        while (it.hasNext()) {
            Object[] row = (Object[])it.next();
            if (this.isAggregated) {
                for (i = 0; i < len; ++i) {
                    if (!this.exprColumns[i].isAggregate()) continue;
                    row[i] = this.exprColumns[i].getAggregatedValue(row[i]);
                }
            }
            if (this.iHavingIndex < 0 || ((Boolean)row[this.iHavingIndex]).booleanValue()) continue;
            it.remove();
        }
        return gResult.getResult();
    }

    public StringBuffer getDDL() throws HsqlException {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(' ');
        for (i = 0; i < this.iResultLen; ++i) {
            sb.append(this.exprColumns[i].getDDL());
            if (i >= this.iResultLen - 1) continue;
            sb.append(',');
        }
        sb.append("FROM");
        sb.append(' ').append("WHERE").append(' ');
        sb.append(' ').append("GROUP").append(' ');
        for (i = this.iResultLen; i < this.iResultLen + this.iGroupLen; ++i) {
            sb.append(this.exprColumns[i].getDDL());
            if (i >= this.iResultLen + this.iGroupLen - 1) continue;
            sb.append(',');
        }
        sb.append(' ').append("HAVING").append(' ');
        for (i = this.iHavingIndex; i < this.iHavingIndex + this.exprColumns.length; ++i) {
            sb.append(this.exprColumns[i].getDDL());
            if (i >= this.iResultLen + this.iGroupLen - 1) continue;
            sb.append(',');
        }
        if (this.sUnion != null) {
            switch (this.iUnionType) {
                case 4: {
                    sb.append(' ').append("EXCEPT").append(' ');
                    break;
                }
                case 3: {
                    sb.append(' ').append("INTERSECT").append(' ');
                    break;
                }
                case 1: {
                    sb.append(' ').append("UNION").append(' ');
                    break;
                }
                case 2: {
                    sb.append(' ').append("UNION").append(' ').append("ALL").append(' ');
                }
            }
        }
        int groupByEnd = this.iResultLen + this.iGroupLen;
        int orderByStart = this.iHavingIndex >= 0 ? this.iHavingIndex + 1 : groupByEnd;
        int orderByEnd = orderByStart + this.iOrderLen;
        sb.append(' ').append("ORDER").append("BY").append(' ');
        for (int i2 = orderByStart; i2 < orderByEnd; ++i2) {
            sb.append(this.exprColumns[i2].getDDL());
            if (i2 >= this.iResultLen + this.iGroupLen - 1) continue;
            sb.append(',');
        }
        return sb;
    }

    boolean resolveAll(boolean check) throws HsqlException {
        boolean result = true;
        if (this.isResolved) {
            return true;
        }
        this.resolve();
        boolean bl = result = result && this.checkResolved(check);
        if (this.sUnion != null) {
            if (this.sUnion.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            this.sUnion.resolveAll(check);
        }
        this.isResolved = result;
        return result;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String toString() {
        this.preProcess();
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            sb.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        if (this.limitCondition != null) {
            sb.append("start=[").append(this.limitCondition.getArg()).append("]\n");
            sb.append("limit=[").append(this.limitCondition.getArg2()).append("]\n");
        }
        sb.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        sb.append("isGrouped=[").append(this.isGrouped).append("]\n");
        sb.append("isAggregated=[").append(this.isAggregated).append("]\n");
        sb.append("columns=[");
        int columns = this.exprColumns.length - this.iOrderLen;
        for (int i = 0; i < columns; ++i) {
            sb.append(this.exprColumns[i]);
        }
        sb.append("\n]\n");
        sb.append("eCondition=[").append(this.queryCondition).append("]\n");
        sb.append("havingCondition=[").append(this.havingCondition).append("]\n");
        sb.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.sUnion != null) {
            switch (this.iUnionType) {
                case 4: {
                    sb.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    sb.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    sb.append(" UNION ");
                    break;
                }
                case 2: {
                    sb.append(" UNION ALL ");
                    break;
                }
                default: {
                    sb.append(" UNKNOWN SET OPERATION ");
                }
            }
            sb.append("[\n").append(this.sUnion).append("]\n");
        }
        return sb.toString();
    }

    private void preProcess() {
        try {
            this.getResult(1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    Result describeResult() {
        Result r = new Result(3, this.iResultLen);
        Result.ResultMetaData rmd = r.metaData;
        for (int i = 0; i < this.iResultLen; ++i) {
            Expression e = this.exprColumns[i];
            rmd.colType[i] = e.getDataType();
            rmd.colSize[i] = e.getColumnSize();
            rmd.colScale[i] = e.getColumnScale();
            rmd.sLabel[i] = e.getAlias();
            rmd.isLabelQuoted[i] = e.isAliasQuoted();
            rmd.sTable[i] = e.getTableName();
            rmd.sName[i] = e.getColumnName();
            if (!rmd.isTableColumn(i)) continue;
            rmd.nullability[i] = e.nullability;
            rmd.isIdentity[i] = e.isIdentity;
            rmd.isWritable[i] = e.isWritable;
        }
        return r;
    }
}

